/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GenericSQLGeoDecoder.cc
    \brief Implementation of the Template class GenericSQLGeoDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Thu 6-May-2004
    
    Changes:
    
*/

#include "GenericSQLGeoDecoder.h"
#include "Timer.h"
#include "Title.h"

using namespace magics;


GenericSQLGeoDecoder::GenericSQLGeoDecoder() 
{ 
}

GenericSQLGeoDecoder::~GenericSQLGeoDecoder() 
{
}


/*!
 Class information are given to the output-stream.
*/		
void GenericSQLGeoDecoder::print(ostream& out)  const
{
	out << "GenericSQLGeoDecoder[";
	out << "]";
}
 
void GenericSQLGeoDecoder::decode()
{
   if ( !sql_) {
        decode();  
        odb_execute(sql_);
    }
    
    
    const double* v = 0;
    while (   (v = odb_fetch_row(sql_)) ) {
     	push_back(GeoPoint(v[columns_[longitude_]], 
                                v[columns_[latitude_]], 
                                v[columns_[observation_]], 
                                v[1]));
        back().colour(v[columns_["colour"]]);
    	back().size(v[columns_["height"]]);
    	back().marker(v[columns_["marker"]]);
    }

}

void GenericSQLGeoDecoder::visit(TitleBase& title)
{
    Log::debug() <<  "GenericSQLDecoderRD::visit() to create a title ... " << "\n";
   
    
    title.push_back(new TitleEntry("GenericSQL:" + database_));
    title.push_back(new TitleEntry(query_));
     
}


static SimpleObjectMaker<GenericSQLGeoDecoder, BaseSceneObject> genericSQLdecoder("sql");
static SimpleObjectMaker<GenericSQLGeoDecoder, BaseSceneObject> pgenericSQLdecoder("psql");
