/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GribInterpretor.h
    \brief Definition of the Template class GribInterpretor.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 18-Apr-2005
    
    Changes:
    
*/

#ifndef GribInterpretor_H
#define GribInterpretor_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "GeoPoint.h"


namespace magics {

class GribDecoder;
class Matrix;
template <class P> class RasterData;

class GribInterpretor  {

public:
	GribInterpretor() {}
	virtual ~GribInterpretor() {}
	
	virtual void interpretAsMatrix(const GribDecoder&, Matrix**) const {}
    virtual void interpretAsVectors(const GribDecoder&, Matrix**, Matrix**) const {}
    virtual void interpretAsRaster(const GribDecoder&, RasterData<GeoPoint>&) const {}
    virtual void scaling(const GribDecoder&, Matrix**) const;
    

    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const { out <<  "GribInterpretor" << endl; }

private:
    //! Copy constructor - No copy allowed
	GribInterpretor(const GribInterpretor&);
    //! Overloaded << operator to copy - No copy allowed
	GribInterpretor& operator=(const GribInterpretor&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const GribInterpretor& p)
		{ p.print(s); return s; }

};

template<>
class Translator<string, GribInterpretor> { 
public:
	MAGICS_NO_EXPORT GribInterpretor* operator()(const string& val )
	{
		 return SimpleObjectMaker<GribInterpretor>::create(val);
	}     
	MAGICS_NO_EXPORT GribInterpretor* magics(const string& param)
	{
		GribInterpretor* object;
		ParameterManager::update(param, object);
		return object;
	}
};


} // namespace magics
#endif
