/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file FontMap.h
    \brief Definition of Fontmap.
    \author Graphics Section, ECMWF

    Started: May 2009
*/


#ifndef _FontMap_H
#define _FontMap_H

#include <magics.h>
#include <BaseDriver.h>
#include <Label.h>

using namespace std;

namespace magics 
{

class FontMap
{
public:	
	~FontMap() {};
	static FontMap* instance();
	void ttfFileName(const MagFont&,string&);
	bool hasFonts() {return hasFonts_;}

protected:
	FontMap() {};

private:
	static void readFonts();

	static FontMap* instance_;
	static std::map<string, magFont, RuntimeStringCompare> fonts_;
	static bool hasFonts_;

	typedef std::map<string, magFont, RuntimeStringCompare>::const_iterator FontIterator;
};

}


#endif
