
/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenBox.cc
    \brief Implementation of the OpenGLBox class.
    \author Graphics Section, ECMWF

    Started: June 2009
*/

#include <OpenGLBox.h>

using namespace magics;

bool OpenGLBox::checkPointInBox(float x, float y) 
{
	return (x>= x_ && x<= x_+width_ && 
			y >= y_ && y<= y_+height_);
}

//Check if box "b" has a valid section with the box
bool OpenGLBox::checkBoxSection(OpenGLBox *b)
{		
	return !(b->x()+b->width() < x_ ||
		b->x()> x_+width_ ||
		b->y()+b->height() < y_ ||
		b->y() > y_+height_);
}

//Check if box "b" is contained by the  box
bool OpenGLBox::checkBoxContained(OpenGLBox *b)
{
	//R1 in R2
	return (b->x() >= x_ && b->x()+b->width() <= x_+width_  &&
		b->y() >= y_ && b->y()+b->height() <= y_+height_);
}

//Check if box "b" has a valid section with the box, then compute the section
//and put the result into box "s". 
bool OpenGLBox::computeBoxSection(OpenGLBox *b, OpenGLBox *s)
{
	if(checkBoxSection(b) == false)
	{
		return false;
	}
	
	//R1 in R2
	if(checkBoxContained(b))
	{
		s->set(b);
		return true;
	}
	//R2 in R1
	else if(b->checkBoxContained(this))
	{
		s->set(this);
		return true;
	}
	else
	{
		//
		//     3  ------ 2 
		//     |         |
		//     0  ------ 1
		//
		
		vector<OpenGLPoint> cp(4);

		cp[0].x(b->x());
		cp[0].y(b->y());
		cp[1].x(b->x()+b->width());
		cp[1].y(b->y());
		cp[2].x(b->x()+b->width());
		cp[2].y(b->y()+b->height());
		cp[3].x(b->x());
		cp[3].y(b->y()+b->height());	

		vector<bool> cps(4);	

		for(int i=0 ;i < 4; i++)
		{
			cps[i] =checkPointInBox(cp[i].x(),cp[i].y());
		}
				
		if( !cps[0] && cps[1] && !cps[2] && !cps[3])
		{		
			s->set(x_,cp[0].y(),cp[1].x()-x_,y_+height_-cp[1].y());
		}	
		else if( !cps[0] && cps[1] && cps[2] && !cps[3])
		{		
			s->set(x_,cp[0].y(),cp[1].x()-x_,b->height());
		}	
		else if( !cps[0] && !cps[1] && cps[2] && !cps[3])
		{		
			s->set(x_,y_,cp[1].x()-x_,b->y()+b->height()-y_);
		}	
		else if( !cps[0] && !cps[1] && cps[2] && cps[3])
		{		
			s->set(cp[0].x(),y_,b->width(),b->y()+b->height()-y_);
		}	
		else if( !cps[0] && !cps[1] && !cps[2] && cps[3])
		{		
			s->set(cp[0].x(),y_,x_+width_-cp[0].x(),b->y()+b->height()-y_);
		}
		else if( cps[0] && !cps[1] && !cps[2] && cps[3])
		{		
			s->set(cp[0].x(),cp[0].y(),x_+width_-cp[0].x(),b->height());
		}
		else if( cps[0] && !cps[1] && !cps[2] && !cps[3])
		{		
			s->set(cp[0].x(),cp[0].y(),x_+width_-cp[0].x(),y_+height_-cp[1].y());
		}
		else if( cps[0] && cps[1] && !cps[2] && !cps[3])
		{		
			s->set(cp[0].x(),cp[0].y(),b->width(),y_+height_-cp[1].y());
		}
		else
		{
			return false;
		}
		return true;
		
	}
}