/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLDplManager.h
    \brief Definition of OpenGLDplManager.
    \author Graphics Section, ECMWF

    Started: May 2008
*/


#include <OpenGLDplManager.h>

using namespace magics; 


OpenGLDplItem::~OpenGLDplItem()
{
	clear();
	if(text_) delete text_;
}

void OpenGLDplItem::create()
{
	if(glIsList(dpl_) == GL_FALSE) 
	{
		dpl_=glGenLists(1);
	}
	status_=M_DPL_CREATED;
}

void OpenGLDplItem::clear(set<mglDplType> &rule)
{
	if(rule.count(type_) != 0) clear();
}


void OpenGLDplItem::clear()
{
	if(status_ != M_DPL_EMPTY)
	{
		glDeleteLists(dpl_,1);
		dpl_=0;
		status_=M_DPL_EMPTY;
	}
}	

bool OpenGLDplItem::compileStart()
{
	if(status_ == M_DPL_EMPTY)
	{
		create();
	}

	if(status_ == M_DPL_CREATED || status_ == M_DPL_COMPILED)
	{
		glNewList(dpl_,GL_COMPILE);
		//Log::debug() << "Display List: glNewList!!" << endl;
		status_=M_DPL_BEING_COMPILED;
		return true;
	}
	else
	{
		//Log::warning()  << "Attempt to compile a display list that is not created " <<
		//		" or still being compiled!" << endl;
		return false;
	}

}

bool OpenGLDplItem::compileEnd()
{	
	if(status_ == M_DPL_BEING_COMPILED)
	{
		//Log::debug() << "Display List: glEndist!!" << endl;
		glEndList();
		status_=M_DPL_COMPILED;
		return true;
	}
	else
	{
		//Log::warning()  << "Attempt to finish the compilation of a display list that " <<
		//		   "was not being compiled!" << endl;
		return false;
	}	
}

void OpenGLDplItem::call(set<mglDplType> &rule)
{
	if(status_ == M_DPL_COMPILED && rule.count(type_) != 0)
	{
		glCallList(dpl_);
	}
}

void OpenGLDplItem::call()
{
	if(status_ == M_DPL_COMPILED)
	{
		glCallList(dpl_);
	}
}


OpenGLDplManager::~OpenGLDplManager()
{	
	for(DplIterator it=begin(); it != end(); it++)
	{		
		delete *it;
	}
}


void OpenGLDplManager::clearDplContent(set<mglDplType> &rule)
{
	for(DplIterator it=begin(); it != end(); it++)
	{
		(*it)->clear(rule);
	}
}

void OpenGLDplManager::clearDplContent()
{
	for(DplIterator it=begin(); it != end(); it++)
	{
		(*it)->clear();
	}
}

void OpenGLDplManager::erase()
{
	for(DplIterator it=begin(); it != end(); it++)
	{
		delete *it;
	}
	clear();
}


OpenGLDplItem* OpenGLDplManager::add(mglDplType type)
{
	push_back(new OpenGLDplItem(type));
	return back();
}


void OpenGLDplManager::call(set<mglDplType> &rule)
{
	for(DplIterator it=begin(); it != end(); it++)
	{
		(*it)->call(rule);
	}
}

void OpenGLDplManager::call()
{	
	for(DplIterator it=begin(); it != end(); it++)
	{
		(*it)->call();
	}
}
