/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLPushButtonWidget.cc
    \brief Implementation of the OpenGLPushButtonWidget class.
    \author Graphics Section, ECMWF

    Started: July 2008
*/

#include <OpenGLLabelWidget.h>
#include <OpenGLTextureItem.h>
#include <OpenGLDriver.h>

#include <Log.h>
#include <OpenGLPainter.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#define PNG_DEBUG 3
#include <png.h>


OpenGLLabelWidget::OpenGLLabelWidget(OpenGLDriver* driver,string name,int x, int y, int width, int height)
			: OpenGLBaseWidget(driver,0,name,x,y,width,height)
{	
	type_= MGLW_LabelPixmap;
	fontSize_=10;	
	labelItemOnly_=false;	
	pixmapTex_=0;
	fitPixmapToWidget_=false;	
}	

OpenGLLabelWidget::~OpenGLLabelWidget()
{
	if(pixmapTex_) delete pixmapTex_;
}

void OpenGLLabelWidget::setPixmap(string name,string type)
{
	pixmap_ = name;
	if(type == "png")
	{		
		pixmapTex_= new OpenGLTextureItem;
		if(pixmapTex_->generateFromPng(name.c_str()) !=0)
		{
			delete pixmapTex_;
			pixmapTex_=0;
		}		
	}	 
}

void OpenGLLabelWidget::setPixmapFading(bool fading)
{
	if(type_ == MGLW_LabelPixmap && pixmapTex_ != 0)
	{
		if(fading==true)
		{
			pixmapTex_->setFading(true);
		}
		else
		{
			pixmapTex_->setFading(false);
		}
	}
}		
			
void OpenGLLabelWidget::setText(string t)
{
	text_=t;
}

void OpenGLLabelWidget::setFontSize(int px)
{
	fontSize_=px;
}

void OpenGLLabelWidget::render()
{	
	//Render pixmap
	switch(type_)
	{
	case MGLW_LabelPixmap:
		renderPixmap();
		break;		
	case MGLW_LabelText:
		renderText();
		break;
	case MGLW_LabelArea:
		renderArea();
		break;

	default:
		break;		
	}
}


void OpenGLLabelWidget::renderPixmap()
{	
	if(pixmapTex_) 
	{
		if(fitPixmapToWidget_ == false)
		{
			int pw=pixmapTex_->width();
			int ph=pixmapTex_->height();

			int dx1=0, dy1=0, dx2=0 ,dy2=0;
			

			if(pw > 0 && pw <= width_ &&
			   ph > 0 && ph <= height_)
			{
				dx1=static_cast<float>(width_-pw)/2.;
				dy1=static_cast<float>(height_-ph)/2.;	
				dx2=width_-pw-dx1;
				dy2=height_-ph-dy1;	
			}

			pixmapTex_->mapTexture(x_+dx1,y_+dy1,x_+width_-dx2-1,y_+height_-dy2-1);	
		}	
		else
		{
			pixmapTex_->mapTexture(x_,y_,x_+width_,y_+height_);
		}	
	}
}	

void OpenGLLabelWidget::renderText()
{
	//If background has to be rendered
	if(!labelItemOnly_)
	{
		glPushAttrib(GL_POLYGON_BIT);
	
		//Only front sides are rendered
		glFrontFace(GL_CCW);
		glEnable(GL_CULL_FACE);	
		glCullFace(GL_BACK);	

		//Fill the area occupied by the object		
		glPolygonMode(GL_FRONT,GL_FILL);
	
		glPolygonMode(GL_FRONT,GL_FILL);
		Colour col=Colour(211./255.,215./255.,223./255.);
		glColor3f(col.red(),col.blue(),col.green());
		glRectf(x_-1,y_-1,x_+width_+1,y_+height_+1);

		col=background_;	
		Colour col1=col;
		col1.scaleLight(1.2);
	
		glShadeModel(GL_SMOOTH);
	
		glBegin(GL_QUADS);
						
		glColor3f(col.red(),col.green(),col.blue());
		glVertex2f(x_,y_+height_);
		glVertex2f(x_,y_);
									
		glColor3f(col1.red(),col1.green(),col1.blue());
		glVertex2f(x_+width_,y_);
		glVertex2f(x_+width_,y_+height_);
				
		glEnd();	
	
		glShadeModel(GL_FLAT);

		glPolygonMode(GL_FRONT,GL_LINE);
		col=borderColour_;		
		glColor3f(col.red(),col.green(),col.blue());
		glRectf(x_,y_,x_+width_,y_+height_);

		glPopAttrib();
	}

	int x=x_+5;
	int y=y_+10;

	Text text;
	PaperPoint pp(x,y);		
	text.push_back(pp);
	
	text.addText(text_,Colour(0.,0.,0.),fontSize_*2.54/75.); //75 dpi
	text.setJustification(MLEFT);
	text.setVerticalAlign(MBASE);
	//text.setAngle(0.);	

	painter_->renderText(&text);

}


void OpenGLLabelWidget::renderArea()
{
	Colour col=background_;	
	painter_->renderFilledRoundedRect(x_,y_,x_+width_,y_+height_,5,col);

	col=borderColour_;
	painter_->renderRoundedRect(x_,y_,x_+width_,y_+height_,5,borderColour_,1,true);

	/*glPushAttrib(GL_POLYGON_BIT);
	
	//Only front sides are rendered
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);	
	glCullFace(GL_BACK);	

	//Fill the area occupied by the object		
	glPolygonMode(GL_FRONT,GL_FILL);
	
	Colour col=background_;	
	glColor3f(col.red(),col.green(),col.blue());

	glRectf(x_,y_, x_+width_,y_+height_);

	//outline
	glPolygonMode(GL_FRONT,GL_LINE);

	col=borderColour_;
	glColor3f(col.red(),col.green(),col.blue());

	glRectf(x_,y_, x_+width_,y_+height_);

	glPopAttrib();*/
}
