/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLLayerNode.h
    \brief Definition of OpenGLLayerNode.
    \author Graphics Section, ECMWF

    Started: November 2008
*/

#ifndef _OpenGLLayerNode_H
#define _OpenGLLayerNode_H

#include <magics.h>
#include <Layer.h>

#include <OpenGLNode.h>

namespace magics {


class OpenGLLayerNode : public OpenGLNode 
{
public:	
	OpenGLLayerNode(string name,const Layer &layer) : OpenGLNode(name), layer_(layer), 
							  visible_(true), alpha_(1.) 
							{classType_="OpenGLLayerNode";} ;
	~OpenGLLayerNode() {};
	
	const Layer& layer() {return layer_;};
	void  setAlpha(float alpha) {alpha_=alpha;} 
        void  setTransparency(float t) {alpha_=1.-t;} 
	void  setVisible(bool visible) {visible_=visible;} 	
	float alpha() {return alpha_;} 
	float transparency() {return 1.-alpha_;}
	bool  visible() {return visible_;}

protected:
	const Layer& layer_;
	bool visible_;
	float alpha_;		
};


}

#endif
