/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLLayoutNode.h
    \brief Definition of OpenGLLayoutNode.
    \author Graphics Section, ECMWF

    Started: November 2008
*/

#ifndef _OpenGLLayoutNode_H
#define _OpenGLLayoutNode_H

#include <magics.h>
//#include <Box.h>
#include <Layout.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include <OpenGLNode.h>
//#include <OpenGLBoxRenderObject.h>

namespace magics {

class OpenGLAreaGroup;

class OpenGLLayoutNode : public OpenGLNode//, public list<OpenGLBoxRenderObject*>
{
public:
	//OpenGLLayoutNode();
	OpenGLLayoutNode(string,const Layout &);
	~OpenGLLayoutNode();
	
	virtual const Layout& layout() {return layout_;};

	void  coordRatioX(float f) {coordRatioX_=f;};	 
	void  coordRatioY(float f) {coordRatioY_=f;};
	float coordRatioX() {return coordRatioX_;};	 
	float coordRatioY() {return coordRatioY_;};

	void  dimensionX(float f) {dimensionX_=f;};	 
	void  dimensionY(float f) {dimensionY_=f;};
	float dimensionX() {return dimensionX_;};	 
	float dimensionY() {return dimensionY_;};

	float projectedMinX() {return projectedMinX_;}
	void  projectedMinX(float f) {projectedMinX_=f;}
	float projectedMinY() {return projectedMinY_;}
	void  projectedMinY(float f) {projectedMinY_=f;}

	float projectedMaxX() {return projectedMaxX_;}
	void  projectedMaxX(float f) {projectedMaxX_=f;}
	float projectedMaxY() {return projectedMaxY_;}
	void  projectedMaxY(float f) {projectedMaxY_=f;}

	bool  layoutCoordToWinCoord(float,float,float&,float&);
	bool  winCoordToLayoutCoord(float,float,float&,float&);
	bool  winCoordToLayoutCoordByFitting(float,float,float&,float&);
	bool  winAreaToLayoutArea(float, float, float, float, vector<PaperPoint>&);
	void  winSizeToLayoutSize(float, float &,bool);

	OpenGLAreaGroup* createAreaGroup(int nx=10, int ny=10);
	OpenGLAreaGroup* areaGroup() {return areaGroup_;}
	void  deleteAreaGroup() {if(areaGroup_!=0) delete areaGroup_;}

	//AnimationRules* animationRules() {return animationRules_;};
	//void animationRules(AnimationRules *anr) {animationRules_=anr;};

	//OpenGLBoxRenderObject* getBox(const string&);
	//void addBox(OpenGLBoxRenderObject*);

	//OpenGLBoxRenderObject* getEditableBox(int, int);
	//OpenGLBoxRenderObject* getEditableBox();

	//LayoutMode mode() {return layout_->mode();};

protected:
	const Layout& layout_;

	float coordRatioX_;
	float coordRatioY_;
	
	float dimensionX_;	
	float dimensionY_;

	float projectedMinX_;
	float projectedMinY_;
	float projectedMaxX_;
	float projectedMaxY_;

	OpenGLAreaGroup *areaGroup_;	
	//AnimationRules *animationRules_;			
};

class OpenGLPreviewLayoutNode : public OpenGLLayoutNode
{
public:
	//OpenGLPreviewLayoutNode() : OpenGLLayoutNode() 
	//		{classType_="OpenGLPreviewLayoutNode";};
	OpenGLPreviewLayoutNode(string n,const Layout &l) : OpenGLLayoutNode(n,l) 
			{classType_="OpenGLPreviewLayoutNode";};

};

class OpenGLMagnifierLayoutNode : public OpenGLLayoutNode
{
public:
	//OpenGLPreviewLayoutNode() : OpenGLLayoutNode() 
	//		{classType_="OpenGLPreviewLayoutNode";};
	OpenGLMagnifierLayoutNode(string n,const Layout &l) : OpenGLLayoutNode(n,l) 
			{classType_="OpenGLMagnifierLayoutNode";};

	const MagnifierLayout& layout() {return (MagnifierLayout&) layout_;};


};


}


#endif
