
/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLMagnifierButton.cc
    \brief Implementation of OpenGLMagnifierButton.
    \author Graphics Section, ECMWF

    Started: August 2008

*/
#include <Colour.h>
#include <OpenGLMagnifierButton.h>
#include <OpenGLMagnifier.h>
#include <OpenGLPainter.h>

#include <MtInputEvent.h>

#include <math.h>

using namespace magics;

OpenGLMagnifierButton::OpenGLMagnifierButton(OpenGLMagnifier *m)
{
	magnifier_=m;	

	height_=13.;
	width_=20.;
	outlineColour_=Colour(0.2,0.2,0.2);	
	selectionLineWidth_=1.5;	
	outlineColour_=Colour(0.,0.,0.);
	topFillColour_=Colour(0.95,0.95,0.95);
	bottomFillColour_=Colour(0.7,0.7,0.7);
	borderSize_=10.; 	

}

void OpenGLMagnifierButton::set(float san, float ean,float r1,float r2)
{
	startAngle_=san;
	endAngle_=ean;

	radIn_=r1;
	radOut_=r2;	
}

void OpenGLMagnifierButton::set(float r)
{	
	radIn_=r;

	angleSize_=width_/r;
	
	startAngle_=PI/2.-angleSize_/2.;
	endAngle_=startAngle_+angleSize_;

	float r1=r;
	float r2=r+height_;

	radIn_=r1;
	radOut_=r2;
}

bool OpenGLMagnifierButton::checkPoint(float dx, float dy)
{
        float dist=sqrt(dx*dx+dy*dy);       
        return checkPoint(dist,dx,dy);
}

bool OpenGLMagnifierButton::checkPoint(float dist, float dx, float dy)
{
	float rad1=radIn_+1;
	float rad2=radIn_+height_;
		
	if(dist >=  rad1 && dist <= rad2 )
	{
		float angle=atan2f(dy,dx);
		if(angle >= startAngle_  && angle <= endAngle_)
		{
			return true;
		}
	}	

	return false;		
}


void OpenGLMagnifierButton::render()
{
	glPushAttrib(GL_ENABLE_BIT | GL_LINE_BIT);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_LINE_SMOOTH);
	glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);	

	renderButton();

	glPopAttrib();
}

void OpenGLMagnifierButton::renderButton()
{
	float rad1, rad2;
	float ap, ap_next, dal;
	float xx, yy;

	int i;

	//-------------------------------------
	// Render (fill) the factor cell area
	//-------------------------------------			
		
	rad1=radIn_;
	rad2=radOut_;
									
	ap=startAngle_;
	//ap_next=ap-cellAngleSize_-cellAngleGap_;
				
	glPolygonMode(GL_FRONT,GL_FILL); 
		
	glShadeModel(GL_SMOOTH);
		
	dal=angleSize_;

	float tcol=topFillColour_.red();
	float bcol=bottomFillColour_.red();

	
		glBegin(GL_QUADS);
		
		glColor3f(tcol,tcol,tcol);		
		xx=cos(ap)*rad2;
		yy=sin(ap)*rad2;
		glVertex2f(xx,yy);
		
		glColor3f(tcol,tcol,tcol);
		xx=cos(ap+dal)*rad2;
		yy=sin(ap+dal)*rad2;
		glVertex2f(xx,yy);
			
		glColor3f(bcol,bcol,bcol);
		xx=cos(ap+dal)*rad1;
		yy=sin(ap+dal)*rad1;
		glVertex2f(xx,yy);
			
		glColor3f(bcol,bcol,bcol);
		xx=cos(ap)*rad1;
		yy=sin(ap)*rad1;
		glVertex2f(xx,yy);
			
		glEnd();
			
		
	glShadeModel(GL_FLAT);	


		//text
		xx=cos(ap)*radIn_;
		yy=sin(ap)*radIn_;
		float angle=0;

		string sst("Mode: Data");
		
		Colour ctext=Colour(0.,0.,0.);
				
		OpenGLPainter::instance()->renderText(xx,yy,ctext,7,sst);	
}

//--------------------------------------------------
// Event handling
//--------------------------------------------------

void OpenGLMagnifierButton::event(MtInputEvent *event,float xcent, float ycent)
{	
	int x,y,motion_state;
		
	switch(event->type())
	{
	/*
	case M_GL_ButtonPress:
		
		x=event->button_.x()-xcent;
		y=event->button_.y()-ycent;
		
		if(event->button_.button() == 1) // left  mouse button
		{			
			input(x,y);									
		}
		
		break;
	*/
	default:
		break;
	
	}
	
}

//----------------------------------------
// Button1 press event
//----------------------------------------

void OpenGLMagnifierButton::input(int x,int y)
{
	//If slider selected then start slider drag
	if(checkPoint(x,y) == true)
	{		
		magnifier_->changeMagnifierMode();
		//Log::dev()<< "Button press" << endl; //"magnifier_->callback();
		return;
	}		
}
