/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLPushButtonWidget.cc
    \brief Implementation of the OpenGLPushButtonWidget class.
    \author Graphics Section, ECMWF

    Started: July 2008
*/

#include <OpenGLPushButtonWidget.h>
#include <OpenGLPainter.h>

#include <MtInputEvent.h>

OpenGLPushButtonWidget::OpenGLPushButtonWidget(OpenGLDriver *driver,OpenGLBaseWidget *parent,
                         string name,int x,int y,int width,int height) :
			 OpenGLLabelWidget(driver,name,x,y,width,height)
{
	parent_=parent;
	pressed_=false;
	enabled_=true;
	border_=false;
	cornerSize_=2;
	background_=Colour(0.95,0.95,0.95);

}	
void OpenGLPushButtonWidget::setEnabled(bool b)
{
	enabled_=b;
	if(enabled_)
	{
		setPixmapFading(false);
	}
	else
	{
		setPixmapFading(true);
	}
}

void OpenGLPushButtonWidget::render()
{			
	glPolygonMode(GL_FRONT,GL_FILL);
	Colour col=Colour(211./255.,215./255.,223./255.);
	glColor3f(col.red(),col.green(),col.blue());
	glRectf(x_-1,y_-1,x_+width_+1,y_+width_+1);

	/*if(!enabled_)
	{
		col=Colour(0.2,0.2,0.2);
		painter_->renderFilledRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                  col);
	}*/
	if(!pressed_)
	{
		col=background_;

		if(focused_)
		{
			col=Colour(0.85,0.85,0.85);
		}
		

		painter_->renderFilledRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                  col);
	}
	else
	{
		col=Colour(0.75,0.75,0.75);
		painter_->renderFilledRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                  col);
	}

	//renderRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                  //col,true,true,col);*/
	
	/*//Render background
	if(type_ == MGLW_LabelText || 
	   pixmapTex_ == 0 )
	{	
		Colour col;
		if(pressed_)
		{
			col=foreground_;
		}
		else
		{
			col=Colour(0.6,0.6,0.6);
		}
		renderRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                  col,true,true,col);
	}
	
	renderRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                  background_,true,false,foreground_);*/	

	if(focused_)
	{
		//Render border                                
		col=Colour(0.2,0.2,0.2); //borderColour_;
		//col=Colour(0.6,0.6,0.6) 
	}
	else
	{
		col=Colour(0.4,0.4,0.4) ;
	}

	/*glPolygonMode(GL_FRONT,GL_LINE);
	
	glPushAttrib(GL_ENABLE_BIT | GL_LINE_BIT);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_LINE_SMOOTH);
	glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);		

	glLineWidth(1);*/

	if(border_)
	{
		painter_->renderRoundedRect(x_, y_, x_+width_,y_+height_,cornerSize_,
	                 col,1,false);
	}	
	//glPopAttrib();

	OpenGLLabelWidget::render();			
}

//--------------------------------------------------
// Event handling
//--------------------------------------------------

void OpenGLPushButtonWidget::event(MtInputEvent *event)
{
	if(enabled_==false) return;

	int x,y;
	MtMouseEvent *mev; 
		
	switch(event->type())
	{
	
	case Mt::MousePressEvent:
		mev = (MtMouseEvent *) event;
		x=mev->x();
		y=mev->y();
		
		if(mev->button() & Mt::LeftButton) // left  mouse button
		{			
			input(x,y);									
		}
		
		break;
		
	case Mt::MouseReleaseEvent:
		mev = (MtMouseEvent *) event;
		x=mev->x();
		y=mev->y();
		
		if(mev->button() & Mt::LeftButton) // left  mouse button
		{			
			release(x,y);									
		}
		
		break;
	
	case Mt::MouseMoveEvent:
		mev = (MtMouseEvent *) event;					
		x=mev->x();
		y=mev->y();
		focus(x,y);	
				
		break;	

	default:
		break;
	
	}
	
}

//----------------------------------------
// Button1 press event
//----------------------------------------

void OpenGLPushButtonWidget::input(int x,int y)
{		
	pressed_=false;
	if(checkPointInWidget(x,y) == true)
	{
		pressed_=true;		
		//parent_->reRenderChild(this);		
	}	
}

void OpenGLPushButtonWidget::release(int x,int y)
{		
	
	if(checkPointInWidget(x,y) == true)
	{
		pressed_=false;
		//parent_->reRenderChild(this);
		executeCallback(OpenGLWidget::ActivateCallback);	
	}	
}

void OpenGLPushButtonWidget::focus(int x,int y)
{		
	active_=false;
	bool orival=focused_;
	if(checkPointInWidget(x,y) == true)
	{
		focused_=true;
	}
	else
	{
		focused_=false;
	}
	if(orival != focused_)
	{
		active_=true;
		//parent_->reRenderChild(this);
	}
}

bool OpenGLPushButtonWidget::active()
{
	return active_ || pressed_ ;
}
