/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLSymbolManager.h
    \brief Definition of OpenGLSymbolManager.
    \author Graphics Section, ECMWF

    Started: May 2009
*/


#include <OpenGLSymbolManager.h>

using namespace magics; 

//====================================
//
//  Item
//
//====================================

bool OpenGLSymbolItem::equal(const string id,const float size)
{
	return id == id_ && size == size_;
} 

//====================================
//
//  Manager
//
//====================================

OpenGLSymbolManager::~OpenGLSymbolManager()
{	
	for(SymbolIterator it=begin(); it != end(); it++)
	{		
		delete *it;
	}
}

OpenGLSymbolItem* OpenGLSymbolManager::getSymbol(const string id,const float size)
{	
	for(SymbolIterator it=begin(); it != end(); it++) 
	{
		if( (*it)->equal(id,size) == true)
		{
			return (*it);
		}
	}
	
	return 0;		
}


OpenGLSymbolItem* OpenGLSymbolManager::addSymbol(const string id,const float size)
{
	OpenGLSymbolItem *sym = getSymbol(id,size);
	
	if(sym) 
	{
		return sym;
	}
	else
	{	
		sym=new OpenGLSymbolItem(id,size);
		push_back(sym);
	}
	
	return sym;
}

void OpenGLSymbolManager::deleteSymbol(const string id,const float size)	
{	
	for(SymbolIterator it=begin(); it != end(); it++)
	{
		if( (*it)->equal(id,size) == true)
		{
			delete *it;
			erase(it);
			return;
		}	
	}
}	


/*void OpenGLSymbolManager::deleteAll()	
{	
	for(SymbolIterator it=begin(); it != end(); it++)
	{	
		delete *it;
	}
	clear();		
}*/	


void OpenGLSymbolManager::print(ostream &out)
{
	out << "OpenGL symbols in use: " << endl;
 	for(SymbolIterator it=begin(); it != end(); it++)
	{	
	 	//(*it)->print(out);
	}	
} 