/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotBoxBorderAttributes.cc
    \brief Implemtation of BoxPlotBoxBorder Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Oct 26 20:27:36 2009
*/    

#include "BoxPlotBoxBorderAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotBoxBorderAttributes::BoxPlotBoxBorderAttributes():
	colour_(Translator<string, Colour>().magics("boxplot_box_border_colour")),
	thickness_(ParameterManager::getInt("boxplot_box_border_thickness")),
	style_(Translator<string, LineStyle>().magics("boxplot_box_border_line_style"))
{
} 



BoxPlotBoxBorderAttributes::~BoxPlotBoxBorderAttributes()
{
}

    
void BoxPlotBoxBorderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "boxplot_box_border";
	prefix[1] = "boxplot";

	setAttribute(prefix, "boxplot_box_border_colour", colour_, params);
	setAttribute(prefix, "boxplot_box_border_thickness", thickness_, params);
	setAttribute(prefix, "boxplot_box_border_line_style", style_, params);
}

void BoxPlotBoxBorderAttributes::copy(const BoxPlotBoxBorderAttributes& other)
{
	setColour(other.colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
} 


bool BoxPlotBoxBorderAttributes::accept(const string& node)
{	
	if ( magCompare(node, "box_border")  )
		return true;
	return false;
}

void BoxPlotBoxBorderAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "box_border") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void BoxPlotBoxBorderAttributes::print(ostream& out)  const
{
	out << "BoxPlotBoxBorderAttributes[";
	out << "colour = " << *colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << "]" << "\n";
}


void BoxPlotBoxBorderAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tboxplot_box_border_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tboxplot_box_border_thickness = \'" << thickness_ << "\'\n";
	out << tab << "\tboxplot_box_border_line_style = \'" << style_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> boxplot_box_border_colour("boxplot_box_border_colour", "navy", "");
static MagicsParameter<int> boxplot_box_border_thickness("boxplot_box_border_thickness", 1, "");
static MagicsParameter<string> boxplot_box_border_line_style("boxplot_box_border_line_style", "solid", "");
