/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file 
.cc
    \brief Implementation of the Template class CountSelectionType.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 9-Mar-2004
    
    Changes:
    
*/

 
#include "CountSelectionType.h"
#include "PointsHandler.h"
#include "GeoPoint.h"

using namespace magics;


CountSelectionType::CountSelectionType() 
{
}


void CountSelectionType::calculate(double min, double max, bool)
{
	clear();
        double maxi = (max_ > 1000000000 ) ? max : max_;
        double mini = (min_ <   -1000000000) ? min : min_;
        int i = 0;

        i += ( max_ >  1000000000) ? 1 : 0;
        i += ( min_ < -1000000000) ? 1 : 0;
        
        double nb = (levelCount_-1) + i;
        double step = (maxi - mini)/nb;
        
        if (step == 0) {
        	// Only one isoline!
        	push_back(mini);
        	return;
        } 

        double log = log10(step);
        double istep = pow(10., int(log));	
        double inc = ceil(step/istep)*istep;
        double first = floor(mini/inc)*inc;
  
        while ( first > mini ) 
        	first -=inc;
        
        push_back(mini);
        first += inc;
       
        for (double val = first; val < maxi; val += inc) {         
            push_back(val);                
        }
	
        push_back(maxi);
	int si = static_cast<int>(size());

        if ( si - i < levelCount_ - tolerance_ || si - i > levelCount_ + tolerance_ ) {
            Log::debug() << "Not using nice levels[" << levelCount_ << ", " << tolerance_ << "]-->" << size()  << endl;
            clear();
            step = (maxi - mini)/(levelCount_-1);
            double val = mini;
            while ( 1 ) {
                push_back(val);
                if ( same(val, maxi) || val > maxi) break; 
                val += step;
            } 
            Log::debug() << "New size-->" << size() << endl;
        } 
  
        Log::debug() << "count=" << levelCount_ << ", tolerance=" << tolerance_ << ", result=" << size() << endl;

        ostringstream level;
        for (const_iterator l = begin(); l != end(); ++l) 
            level << *l << " ";
 
        Log::debug() << level.str() << endl;
}


CountSelectionType::~CountSelectionType() 
{
}

/*!
 Class information are given to the output-stream.
*/
void CountSelectionType::print(ostream& out)  const
{
	out << "CountSelectionType[";
	out << "]";
}

void CountSelectionType::set(const LevelSelectionInterface& from) 
{
    setLevelCount(from.getCount());
    setTolerance(from.getTolerance());
    setReference(from.getReference());
    setMin(from.getMin());
    setMax(from.getMax());
}
