%module (docstring="This is a Python interface to Magics++") Magics

%{
#define SWIG_FILE_WITH_INIT
/* Includes the header in the wrapper code */
#include "Magics_interface.cc"
#include "numpy/arrayobject.h"
%}

%typemap(in) (char** data, int dim) {
  /* Check if is a list */
  if (PyList_Check($input)) {
    int size = PyList_Size($input);
    $2 = size;
    int i = 0;
    $1 = (char **) malloc((size+1)*sizeof(char *));
    for (i = 0; i < size; i++) {
      PyObject *o = PyList_GetItem($input,i);
      if (PyString_Check(o))
	$1[i] = PyString_AsString(PyList_GetItem($input,i));
      else {
	PyErr_SetString(PyExc_TypeError,"list must contain strings");
	free($1);
	return NULL;
      }
    }
    $1[i] = 0;
  } else {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return NULL;
  }
}


%typemap(in) (double *data, int dim) {
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }
  $2 = PyList_Size($input); 
  double *temp=new double[$2];
  for (i = 0; i < $2; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      temp[i] = PyFloat_AsDouble(o);
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");     
      return NULL;
    }
  }
  $1=temp;
}

%typemap(in) (int *data, int dim) {
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }
  $2 = PyList_Size($input); 
  int *temp=new int[$2];
  for (i = 0; i < $2; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      temp[i] = (int)PyInt_AsLong(o);
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");     
      return NULL;
    }
  }
  $1=temp;
}

/* A R R A Y S */

%init %{
        import_array();
%}

// Interface from a Numeric 2D int array, to plain unsigned short*.  
%typemap(in) (int *data, int dim1, int dim2) {
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.int32");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 2)
       {
           PyErr_SetString(PyExc_TypeError,"Numeric array must be two dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_INT)
       {
           PyErr_SetString(PyExc_TypeError,"Numeric array must be INT type.");
           return NULL;
       }
       $1 = (int*)array->data;
       $2 = array->dimensions[1];
       $3 = array->dimensions[0];
 }

 // Interface from a Numeric 3D int array, to plain unsigned short*.  
%typemap(in) (int *data, int dim1, int dim2, int dim3) {
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.int32");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 3)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be three dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_INT)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be INT type.");
           return NULL;
       }
       $1 = (int*)array->data;
       $2 = array->dimensions[2];
       $3 = array->dimensions[1];
       $4 = array->dimensions[0];
 }

// Interface from a Numeric 2D int array, to plain unsigned short*.  
%typemap(in) (double *data, int dim1, int dim2) {
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.float64");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 2)
       {
           PyErr_SetString(PyExc_TypeError,"Numeric array must be two dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_DOUBLE)
       {
           PyErr_SetString(PyExc_TypeError,"Numeric array must be DOUBLE type.");
           return NULL;
       }
       $1 = (double*)array->data;
       $2 = array->dimensions[1];
       $3 = array->dimensions[0];
 }
 
// Interface from a Numeric 3D int array, to plain unsigned short*.  
%typemap(in) (double *data, int dim1, int dim2, int dim3) {
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.float64");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 3)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be three dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_DOUBLE)
       {
           PyErr_SetString(PyExc_TypeError,"Numpyc array must be DOUBLE type.");
           return NULL;
       }
       $1 = (double*)array->data;
       $2 = array->dimensions[2];
       $3 = array->dimensions[1];
       $4 = array->dimensions[0];
 }

/* Parse the header file to generate wrappers */
%include "Magics_interface.cc"
