/* This file is part of the KDE project

   Copyright (C) 2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef ATTACHMENTWIDGET_H
#define ATTACHMENTWIDGET_H

#include <QWidget>
#include <QListView>

class KUrl;
class QDropEvent;
class QStandardItemModel;
class QStandardItem;

namespace Mailody
{

/**
 * @class ComposerTextEdit
 * This class is a KTextEdit, which emits a signal when a file is dropped
 * on it.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class AttachmentWidget : public QWidget
{
    Q_OBJECT

public:
    /**
     * Constructor
     * @param parent the parent widget
     */
    explicit AttachmentWidget( QWidget *parent );
    void addAttachment( const KUrl &, const QString& name=QString() );
    QHash<KUrl, QString> attachments();

protected:
    /**
     * Reimplemented to signal the addition of an attachment.
     */
    void dropEvent( QDropEvent *e );

private slots:
    void slotOpen( const QModelIndexList & );
    void slotRemove( const QModelIndexList & );

private:
    QStandardItemModel *m_model;
    QHash<QStandardItem*, KUrl> allItems;

signals:
    void noAttachmentsLeft();
};

class AttachmentView : public QListView
{
    Q_OBJECT

public:
    AttachmentView( QWidget *parent );

protected:
    void contextMenuEvent( QContextMenuEvent * e );
    void mouseDoubleClickEvent( QMouseEvent * );

signals:
    void removeItems( const QModelIndexList& );
    void openItems( const QModelIndexList& );
};
}

#endif
