/* This file is part of the KDE project
   Copyright (C) 2007 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "searchline.h"
#include "headerproxy.h"

#include <QHBoxLayout>
#include <QLabel>
#include <QTimer>

#include <KColorScheme>
#include <KLineEdit>
#include <KLocale>

using namespace Mailody;

SearchLine::SearchLine( QWidget* parent )
        : QWidget( parent )
{
    QLabel *label = new QLabel( i18n( "S&earch:" ), this );
    label->setObjectName( QLatin1String( "kde toolbar widget" ) );

    m_searchLine = new KLineEdit( this );
    m_searchLine->setClearButtonShown( true );

    label->setBuddy( m_searchLine );
    label->show();

    QHBoxLayout* layout = new QHBoxLayout( this );
    layout->setSpacing( 5 );
    layout->setMargin( 0 );
    layout->addWidget( label );
    layout->addWidget( m_searchLine );

    connect( m_searchLine, SIGNAL( textChanged( const QString& ) ),
             SLOT( slotSearchLineChange( const QString& ) ) );
}

SearchLine::~SearchLine()
{
}

void SearchLine::slotSearchLineChange( const QString& )
{
    static QTimer* timer = new QTimer( this );
    static bool first = true;
    if ( first ) {
        timer->setSingleShot( true );
        connect( timer, SIGNAL( timeout() ), SLOT( slotSearchLineActivate() ) );
        first=false;
    }
    timer->start( 300 );
}

void SearchLine::slotSearchLineActivate()
{
    if ( !m_proxy )
        return;

    m_proxy->setFilterKeyColumn( -1 );
    m_proxy->setFilterCaseSensitivity( Qt::CaseInsensitive );
    m_proxy->setFilterRegExp( m_searchLine->text() );
}

void SearchLine::update()
{
    if ( m_searchLine->text().isEmpty() )
        return;

    slotSearchLineActivate();

    QPalette normal;
    normal.setColor( QPalette::Normal, QPalette::Base,
                     KColorScheme( QPalette::Active, KColorScheme::Selection ).background().color() );
    normal.setColor( QPalette::Normal, QPalette::Text,
                     KColorScheme( QPalette::Active, KColorScheme::Selection ).foreground().color() );
    m_searchLine->setPalette( normal );

    QTimer::singleShot( 500, this, SLOT( slotSearchLineUpdateClear() ) );
}

void SearchLine::slotSearchLineUpdateClear()
{
    QPalette normal;
    normal.setColor( QPalette::Normal, QPalette::Base,
                     KColorScheme( QPalette::Active, KColorScheme::View ).background().color() );
    normal.setColor( QPalette::Normal, QPalette::Text,
                     KColorScheme( QPalette::Active, KColorScheme::View ).foreground().color() );
    m_searchLine->setPalette( normal );
}

#include "searchline.moc"
