/* This file is part of the KDE project

   Copyright (C) 2006-2007 Omat Holding B.V. <info@omat.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301,USA.
*/

#ifndef SENDMESSAGE_H
#define SENDMESSAGE_H

#include <mailtransport/transport.h>
#include <kmime/kmime_message.h>

#include <akonadi/collection.h>

#include <QObject>
#include <QStringList>
#include <KJob>

namespace Mailody
{

/**
 * @class Composer
 * This is het main class for the composer...
 * @author Tom Albers <tomalbers@kde.nl>
 */
class SendMessage : public QObject
{
    Q_OBJECT

public:
    /**
     * Contructor
     * @param mb the mailbox where the resulting message will be stored.
     * @param identity the identity to use
     */
    explicit SendMessage( QObject* parent );

    ~SendMessage();

    enum SendType { Draft, Final };

    void send( const Akonadi::Collection& folder, int identity,
               const int transportId, const QString& plain, const QString& html );
    KMime::Message* compileMessage( SendType send,
                                    int identity, const QString& plain, const QString& html );

    void addTo( const QString& To ) {
        m_tos.append( To );
    };
    void addCc( const QString& Cc ) {
        m_ccs.append( Cc );
    };
    void addBcc( const QString& Bcc ) {
        m_bccs.append( Bcc );
    };
    void addAttachments( const QHash<KUrl, QString> &Attachment ) {
        m_attachments = Attachment ;
    };
    void setSubject( const QString& Subject ) {
        m_subject = Subject;
    };
    void setIRT( const QString& irt ) {
        m_irt = irt;
    };

private:
    const char * encoding( const QString& data );
    QStringList m_tos, m_ccs, m_bccs;
    QHash<KUrl, QString> m_attachments;
    QString m_subject, m_irt;

private slots:
    void slotResult( KJob * job );

signals:
    void sendError( const QString& );
    void finished();
};

}

#endif
