/* This file is part of the KDE project
   Copyright (C) 2008 Omat Holding B.V. <info@omat.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "systemtray.h"

#include <QEvent>
#include <QFont>
#include <QFontMetrics>
#include <QPainter>

#include <KColorScheme>
#include <KDebug>
#include <KIcon>
#include <KIconEffect>
#include <KSystemTrayIcon>
#include <KGlobalSettings>

using namespace Mailody;

SystemTray::SystemTray( QWidget *parent )
        : KSystemTrayIcon( parent )
{
    m_defaultIcon = KIcon( "mailody" ).pixmap( 22 );
    m_lightIconImage = m_defaultIcon.toImage();
    KIconEffect::deSaturate( m_lightIconImage, .60f );
    setIcon( m_defaultIcon );
}

SystemTray::~SystemTray()
{
}

bool SystemTray::event( QEvent * event )
{
    if ( event->type() == QEvent::ToolTip ) {
        kDebug() << "Show new emails here...";
        return true;
    }
    return false;
}

void SystemTray::unreadCountChanged( int unread )
{
    kDebug() << "Unread count is now " << unread;
    if ( unread == m_unread )
        return;

    m_unread=unread;

    if ( unread <= 0 ) {
        setIcon( m_defaultIcon );
    } else {
        // adapted from KMSystemTray::updateCount()
        int oldWidth = m_lightIconImage.size().width();

        if ( oldWidth == 0 )
            return;

        QString countStr = QString::number( unread );
        QFont f = KGlobalSettings::generalFont();
        f.setBold( true );

        float pointSize = f.pointSizeF();
        QFontMetrics fm( f );
        int w = fm.width( countStr );
        if ( w > ( oldWidth ) ) {
            pointSize *= float( oldWidth ) / float( w );
            f.setPointSizeF( pointSize );
        }

        // overlay
        QImage overlayImg = m_lightIconImage.copy();
        QPainter p( &overlayImg );
        p.setFont( f );
        KColorScheme scheme( QPalette::Active, KColorScheme::Window );
        p.setPen( scheme.foreground( KColorScheme::LinkText ).color() );
        p.drawText( overlayImg.rect(), Qt::AlignCenter, countStr );

        setIcon( QPixmap::fromImage( overlayImg ) );
    }
}

#include "systemtray.moc"
