#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c)2004, Matthias A. Benkard.
 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from core.common import _, path
from core import maxima
import wxgui.common
from wxgui import *
#from wxgui import InfoDialog, AlgebraSheet

import logging
import sys
import wx
from wx import xrc

log = logging.getLogger("gui.mainwindow")

class MainWindow(wx.Frame):
	def __init__(self, parent, id, title):
		wx.Frame.__init__(self, parent, id, title)
		wxgui.common.res.LoadOnFrame(self, parent, "main_window")
		self.widgets = XRCWidgets(self)
		self.Create(parent, id, title)
	
	def Create(self, parent, id, title):
		signal_autoconnect(self)
	
	def quit(self, *args):
		wxgui.common.app.ExitMainLoop()
	
	def on_session_quit_menu(self, *args):
		self.quit()
	
	def on_quit_tool_tool(self, *args):
		self.quit()
	
	def on_equation_toolmenu_button_clicked(self, *args):
		self.show_hide_menu("equation")
	
	def on_function_toolmenu_button_clicked(self, *args):
		self.show_hide_menu("function")
	
	def on_term_toolmenu_button_clicked(self, *args):
		self.show_hide_menu("term")
	
	def do_deep(self, obj, method):
		for x in obj.GetChildren():
			self.do_deep(x, method)
		method(obj)
	
	def vanish(self, control):
		control.GetParent().GetSizer().Show(control, False)
		control.GetParent().Layout()
	
	def appear(self, control):
		control.GetParent().GetSizer().Show(control, True)
		control.GetParent().Layout()
	
	def show_hide_menu(self, menu_name):
		toolmenu = xrc.XRCCTRL(self, "%s_toolmenu" % menu_name)
		print toolmenu
		if toolmenu.IsShown():
			log.debug(_("Hiding %s menu.") % menu_name)
			
			self.do_deep(toolmenu, self.vanish)
			toolmenu.Hide()
			self.widgets.toolmenu.Layout()
		else:
			log.debug(_("Showing %s menu.") % menu_name)
			
			self.do_deep(toolmenu, self.appear)
			toolmenu.Show()
			self.widgets.toolmenu.Layout()
		self.Layout()
		self.Fit()
	
