/**
 * kunittest.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "kunittest.h"

#include "sampletest.h"

#include "qtester.h"
#include "tester.h"

#include <qapplication.h>
#include <qtimer.h>

#include <iostream>
using namespace std;

void KUnitTest::registerTests()
{
#if 1
    ADD_TEST( EqualityTest );
    ADD_TEST( CoordsShiftDownTest );
    ADD_TEST( CoordsShiftUpTest );
    ADD_TEST( InsertInsertTest1 );
    ADD_TEST( InsertInsertTest2 );
    ADD_TEST( InsertInsertTest3 );
    ADD_TEST( InsertDeleteTest1 );
    ADD_TEST( InsertDeleteTest2 );
    ADD_TEST( InsertDeleteTest3 );
    ADD_TEST( InsertDeleteTest4 );
    ADD_TEST( DeleteDeleteTest1 );
    ADD_TEST( DeleteDeleteTest2 );
    ADD_TEST( DeleteDeleteTest3 );
    ADD_TEST( MessageCoordsShiftUpTest );
    ADD_TEST( MessageCoordsShiftDownTest );
    ADD_TEST( DocumentTest1 );
    ADD_TEST( DocumentTest2 );
    ADD_TEST( TestDD1_1 );
    ADD_TEST( TestDD4_1 );
    ADD_TEST( TestDD1_2 );
    ADD_TEST( TestDD4_2 );
    ADD_TEST( TestDD2_1 );
    ADD_TEST( TestDD3_1 );
    ADD_TEST( TestDD5_1 );
    ADD_TEST( TestDD6_1 );
    ADD_TEST( TestDD7_1 );
    ADD_TEST( TestDD8_1 );
    ADD_TEST( TestII1_1 );
    ADD_TEST( TestII2_1 );
    ADD_TEST( TestII3_1 );
    ADD_TEST( TestII4_1 );
    ADD_TEST( TestII5_1 );
    ADD_TEST( TestII6_1 );
    ADD_TEST( TestII7_1 );
    ADD_TEST( TestII8_1 );
    ADD_TEST( TestID1_1 );
    ADD_TEST( TestID2_1 );
    ADD_TEST( TestID3_1 );
    ADD_TEST( TestID4_1 );
    ADD_TEST( TestID5_1 );
    ADD_TEST( TestID6_1 );
    ADD_TEST( TestID7_1 );
    ADD_TEST( TestID8_1 );
    ADD_TEST( TestDI1_1 );
    ADD_TEST( TestDI2_1 );
    ADD_TEST( TestDI3_1 );
    ADD_TEST( TestDI4_1 );
    ADD_TEST( TestDI5_1 );
    ADD_TEST( TestDI6_1 );
    ADD_TEST( TestDI7_1 );
    ADD_TEST( TestDI8_1 );
#endif
    ADD_TEST( ChalksTest1_1 );
    ADD_TEST( ChalksTest1_2 );
    ADD_TEST( ChalksTest1_3 );
    ADD_TEST( ChalksTest2_1 );
    ADD_TEST( ChalksTest2_2 );
    ADD_TEST( ChalksTest2_3 );
    ADD_TEST( ImineEtAlTest1_1 );
    ADD_TEST( ImineEtAlTest1_2 );
    ADD_TEST( ImineEtAlTest1_3 );
}

KUnitTest::KUnitTest()
{
    QTimer::singleShot( 0, this, SLOT(checkRun()) );

    m_tests.setAutoDelete( TRUE );
    m_qtests.setAutoDelete( TRUE );

    registerTests();
}

void KUnitTest::checkRun()
{
    if ( m_qtests.isEmpty() )
        qApp->exit();
}

int KUnitTest::runTests()
{
    int globalSteps = 0;
    int globalPasses = 0;
    int globalFails = 0;
    int globalXFails = 0;
    int globalXPasses = 0;
    int globalSkipped = 0;

    cout << "# Running normal tests... #" << endl << endl;
    QAsciiDictIterator<Tester> it( m_tests );

    for( ; it.current(); ++it ) {
        Tester* test = it.current();
        test->allTests();
	cout << it.currentKey() << " - ";
	int numPass = test->testsFinished() - ( test->errorList().count() + test->xfailList().count() + test->skipList().count() );
	int numFail = test->errorList().count() + test->xfailList().count();
	int numXFail = test->xfailList().count();
	int numXPass = test->xpassList().count();
	int numSkip = test->skipList().count();

	globalSteps += test->testsFinished();
	globalPasses += numPass;
	globalFails += numFail;
	globalXFails += numXFail;
	globalXPasses += numXPass;
	globalSkipped += numSkip;

	cout << numPass << " test" << ( ( 1 == numPass )?"":"s") << " passed";
	if ( 0 < test->xpassList().count() ) {
	    cout << " (" << numXPass << " unexpected pass" << ( ( 1 == numXPass )?"":"es") << ")";
	}
	cout << ", " << numFail << " test" << ( ( 1 == numFail )?"":"s") << " failed";
	if ( 0 < numXFail  ) {
	    cout << " (" << numXFail << " expected failure" << ( ( 1 == numXFail )?"":"s") << ")";
	}
	if ( 0 < numSkip ) {
	    cout << "; also " << numSkip << " skipped";
	}
	cout  << endl;

	if ( 0 < numXPass  ) {
	  cout << "    Unexpected pass" << ( ( 1 == numXPass )?"":"es") << ":" << endl;
	  QStringList list = test->xpassList();
	  for ( QStringList::Iterator itr = list.begin(); itr != list.end(); ++itr ) {
	    cout << "\t" << (*itr).latin1() << endl;
	  }
	}
	if ( 0 < (numFail - numXFail) ) {
	  cout << "    Unexpected failure" << ( ( 1 == numFail )?"":"s") << ":" << endl;
	  QStringList list = test->errorList();
	  for ( QStringList::Iterator itr = list.begin(); itr != list.end(); ++itr ) {
	    cout << "\t" << (*itr).latin1() << endl;
	  }
	}
	if ( 0 < numXFail ) {
	  cout << "    Expected failure" << ( ( 1 == numXFail)?"":"s") << ":" << endl;
	  QStringList list = test->xfailList();
	  for ( QStringList::Iterator itr = list.begin(); itr != list.end(); ++itr ) {
	    cout << "\t" << (*itr).latin1() << endl;
	  }
	}
	if ( 0 < numSkip ) {
	    cout << "    Skipped test" << ( ( 1 == numSkip )?"":"s") << ":" << endl;
	    QStringList list = test->skipList();
	    for ( QStringList::Iterator itr = list.begin(); itr != list.end(); ++itr ) {
		cout << "\t" << (*itr).latin1() << endl;
	    }
	}
	cout << endl;
    }

    cout << "# Done with normal tests:" << endl;
    cout << "  Total test cases: " << m_tests.count() << endl;
    cout << "  Total test steps                                 : " << globalSteps << endl;
    cout << "    Total passed test steps (including unexpected) : " << globalPasses << endl;
    cout << "      Total unexpected passed test steps           :  " << globalXPasses << endl;
    cout << "    Total failed test steps (including expected)   :  " << globalFails << endl;
    cout << "      Total expected failed test steps             :  " << globalXFails << endl;
    cout << "    Total skipped test steps                       :  " << globalSkipped << endl;

    return m_tests.count();
}

void KUnitTest::addTester( QTester *test )
{
    m_qtests.insert( test, test );
    connect( test, SIGNAL(destroyed(QObject*)),
             SLOT(qtesterDone(QObject* )) );
}

void KUnitTest::qtesterDone( QObject *obj )
{
    m_qtests.remove( obj );
    if ( m_qtests.isEmpty() )
        qApp->quit();
}

// #include "kunittest.moc"
