(* Logic system *)

inductive Imply (A,B:CProp) : CProp ≝
| Imply_intro: (A → B) → Imply A B.
 
definition Imply_elim ≝ λA,B.λf:Imply A B. λa:A.
  match f with [ Imply_intro g ⇒ g a].

inductive And (A,B:CProp) : CProp ≝
| And_intro: A → B → And A B.

definition And_elim_l ≝ λA,B.λc:And A B.
  match c with [ And_intro a b ⇒ a ].

definition And_elim_r ≝ λA,B.λc:And A B.
  match c with [ And_intro a b ⇒ b ].

inductive Or (A,B:CProp) : CProp ≝
| Or_intro_l: A → Or A B
| Or_intro_r: B → Or A B. 
 
definition Or_elim ≝ λA,B,C:CProp.λc:Or A B.λfa: A → C.λfb: B → C.
  match c with 
  [ Or_intro_l a ⇒ fa a 
  | Or_intro_r b ⇒ fb b].

inductive Top : CProp := 
| Top_intro : Top.

inductive Bot : CProp := .

definition Bot_elim ≝ λP:CProp.λx:Bot.
  match x in Bot return λx.P with []. 

definition Not := λA:CProp.Imply A Bot.

definition Not_intro : ∀A.(A → Bot) → Not A ≝  λA. 
  Imply_intro A Bot.

definition Not_elim : ∀A.Not A → A → Bot ≝ λA. 
  Imply_elim ? Bot.  

definition Discharge := λA:CProp.λa:A.
  a.

axiom Raa : ∀A.(Not A → Bot) → A.

axiom sort : Type.

inductive Exists (A:Type) (P:A→CProp) : CProp ≝
  Exists_intro: ∀w:A. P w → Exists A P.

definition Exists_elim ≝
  λA:Type.λP:A→CProp.λC:CProp.λc:Exists A P.λH:(Πx.P x → C).
   match c with [ Exists_intro w p ⇒ H w p ].

inductive Forall (A:Type) (P:A→CProp) : CProp ≝
 Forall_intro: (∀n:A. P n) → Forall A P.

definition Forall_elim ≝
 λA:Type.λP:A→CProp.λn:A.λf:Forall A P.match f with [ Forall_intro g ⇒ g n ].

(* Dummy proposition *)
axiom unit : CProp.

(* Notations *)
notation "hbox(a break ⇒ b)" right associative with precedence 20 
for @{ 'Imply $a $b }.
interpretation "Imply" 'Imply a b = (Imply a b).
interpretation "constructive or" 'or x y = (Or x y).
interpretation "constructive and" 'and x y = (And x y).
notation "⊤" non associative with precedence 90 for @{'Top}.
interpretation "Top" 'Top = Top.
notation "⊥" non associative with precedence 90 for @{'Bot}.
interpretation "Bot" 'Bot = Bot.
interpretation "Not" 'not a = (Not a).
notation "✶" non associative with precedence 90 for @{'unit}.
interpretation "dummy prop" 'unit = unit.
notation > "\exists list1 ident x sep , . term 19 Px" with precedence 20
for ${ fold right @{$Px} rec acc @{'myexists (λ${ident x}.$acc)} }.
notation < "hvbox(\exists ident i break . p)" with precedence 20
for @{ 'myexists (\lambda ${ident i} : $ty. $p) }.
interpretation "constructive ex" 'myexists \eta.x = (Exists sort x).
notation > "\forall ident x.break term 19 Px" with precedence 20
for @{ 'Forall (λ${ident x}.$Px) }.
notation < "\forall ident x.break term 19 Px" with precedence 20
for @{ 'Forall (λ${ident x}:$tx.$Px) }.
interpretation "Forall" 'Forall \eta.Px = (Forall _ Px).
 
(* Variables *)
axiom A : CProp.
axiom B : CProp.
axiom C : CProp.
axiom D : CProp.
axiom E : CProp.
axiom F : CProp.
axiom G : CProp.
axiom H : CProp.
axiom I : CProp.
axiom J : CProp.
axiom K : CProp.
axiom L : CProp.
axiom M : CProp.
axiom N : CProp.
axiom O : CProp.
axiom  x: sort.
axiom  y: sort.
axiom  z: sort.
axiom  w: sort.

(* Every formula user provided annotates its proof:
   `A` becomes `(show A ?)` *)
definition show : ΠA.A→A ≝ λA:CProp.λa:A.a.

(* When something does not fit, this daemon is used *)
axiom cast: ΠA,B:CProp.B → A.

(* begin a proof: draws the root *)
notation > "'prove' p" non associative with precedence 19 
for @{ 'prove $p }.
interpretation "prove KO" 'prove p = (cast _ _ (show p _)).
interpretation "prove OK" 'prove p = (show p _).

(* Leaves *)
notation < "\infrule (t\atop ⋮) a ?" with precedence 19
for @{ 'leaf_ok $a $t }.
interpretation "leaf OK" 'leaf_ok a t = (show a t).
notation < "\infrule (t\atop ⋮) mstyle color #ff0000 (a) ?" with precedence 19 
for @{ 'leaf_ko $a $t }.
interpretation "leaf KO" 'leaf_ko a t = (cast _ _ (show a t)).

(* discharging *)
notation < "[ a ] \sup mstyle color #ff0000 (H)" with precedence 19 
for @{ 'discharge_ko_1 $a $H }.
interpretation "discharge_ko_1" 'discharge_ko_1 a H = 
  (show a (cast _ _ (Discharge _ H))).
notation < "[ mstyle color #ff0000 (a) ] \sup mstyle color #ff0000 (H)" with precedence 19 
for @{ 'discharge_ko_2 $a $H }.
interpretation "discharge_ko_2" 'discharge_ko_2 a H = 
  (cast _ _ (show a (cast _ _ (Discharge _ H)))).

notation < "[ a ] \sup H" with precedence 19 
for @{ 'discharge_ok_1 $a $H }.
interpretation "discharge_ok_1" 'discharge_ok_1 a H = 
  (show a (Discharge _ H)).
notation < "[ mstyle color #ff0000 (a) ] \sup H" with precedence 19 
for @{ 'discharge_ok_2 $a $H }.
interpretation "discharge_ok_2" 'discharge_ok_2 a H = 
  (cast _ _ (show a (Discharge _ H))).

notation > "'discharge' [H]" with precedence 19 
for @{ 'discharge $H }.
interpretation "discharge KO" 'discharge H = (cast _ _ (Discharge _ H)).
interpretation "discharge OK" 'discharge H = (Discharge _ H).

(* ⇒ introduction *)
notation < "\infrule hbox(\emsp b \emsp) ab (mstyle color #ff0000 (⇒\sub\i \emsp) ident H) " with precedence 19
for @{ 'Imply_intro_ko_1 $ab (λ${ident H}:$p.$b) }.
interpretation "Imply_intro_ko_1" 'Imply_intro_ko_1 ab \eta.b = 
  (show ab (cast _ _ (Imply_intro _ _ b))).

notation < "\infrule hbox(\emsp b \emsp) mstyle color #ff0000 (ab) (mstyle color #ff0000 (⇒\sub\i \emsp) ident H) " with precedence 19
for @{ 'Imply_intro_ko_2 $ab (λ${ident H}:$p.$b) }.
interpretation "Imply_intro_ko_2" 'Imply_intro_ko_2 ab \eta.b = 
  (cast _ _ (show ab (cast _ _ (Imply_intro _ _ b)))).

notation < "\infrule hbox(\emsp b \emsp) ab (⇒\sub\i \emsp ident H) " with precedence 19
for @{ 'Imply_intro_ok_1 $ab (λ${ident H}:$p.$b) }.
interpretation "Imply_intro_ok_1" 'Imply_intro_ok_1 ab \eta.b = 
  (show ab (Imply_intro _ _ b)).

notation < "\infrule hbox(\emsp b \emsp) mstyle color #ff0000 (ab) (⇒\sub\i \emsp ident H) " with precedence 19
for @{ 'Imply_intro_ok_2 $ab (λ${ident H}:$p.$b) }.
interpretation "Imply_intro_ok_2" 'Imply_intro_ok_2 ab \eta.b = 
  (cast _ _ (show ab (Imply_intro _ _ b))).

notation > "⇒_'i' [ident H] term 90 b" with precedence 19
for @{ 'Imply_intro $b (λ${ident H}.show $b ?) }.
interpretation "Imply_intro KO" 'Imply_intro b pb = 
  (cast _ (Imply unit b) (Imply_intro _ b pb)).
interpretation "Imply_intro OK" 'Imply_intro b pb = 
  (Imply_intro _ b pb).

(* ⇒ elimination *)
notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) b mstyle color #ff0000 (⇒\sub\e) " with precedence 19
for @{ 'Imply_elim_ko_1 $ab $a $b }.
interpretation "Imply_elim_ko_1" 'Imply_elim_ko_1 ab a b = 
  (show b (cast _ _ (Imply_elim _ _ (cast _ _ ab) (cast _ _ a)))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) mstyle color #ff0000 (b) mstyle color #ff0000 (⇒\sub\e) " with precedence 19 
for @{ 'Imply_elim_ko_2 $ab $a $b }.
interpretation "Imply_elim_ko_2" 'Imply_elim_ko_2 ab a b = 
  (cast _ _ (show b (cast _ _ (Imply_elim _ _ (cast _ _ ab) (cast _ _ a))))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) b (⇒\sub\e) " with precedence 19 
for @{ 'Imply_elim_ok_1 $ab $a $b }.
interpretation "Imply_elim_ok_1" 'Imply_elim_ok_1 ab a b = 
  (show b (Imply_elim _ _ ab a)).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) mstyle color #ff0000 (b) (⇒\sub\e) " with precedence 19 
for @{ 'Imply_elim_ok_2 $ab $a $b }.
interpretation "Imply_elim_ok_2" 'Imply_elim_ok_2 ab a b = 
  (cast _ _ (show b (Imply_elim _ _ ab a))).

notation > "⇒_'e' term 90 ab term 90 a" with precedence 19 
for @{ 'Imply_elim (show $ab ?) (show $a ?) }.
interpretation "Imply_elim KO" 'Imply_elim ab a = 
  (cast _ _ (Imply_elim _ _ (cast (Imply unit unit) _ ab) (cast unit _ a))).
interpretation "Imply_elim OK" 'Imply_elim ab a = 
  (Imply_elim _ _ ab a). 

(* ∧ introduction *)
notation < "\infrule hbox(\emsp a \emsp\emsp\emsp b \emsp) ab mstyle color #ff0000 (∧\sub\i)" with precedence 19 
for @{ 'And_intro_ko_1 $a $b $ab }.
interpretation "And_intro_ko_1" 'And_intro_ko_1 a b ab = 
  (show ab (cast _ _ (And_intro _ _ a b))).

notation < "\infrule hbox(\emsp a \emsp\emsp\emsp b \emsp) mstyle color #ff0000 (ab) mstyle color #ff0000 (∧\sub\i)" with precedence 19 
for @{ 'And_intro_ko_2 $a $b $ab }.
interpretation "And_intro_ko_2" 'And_intro_ko_2 a b ab = 
  (cast _ _ (show ab (cast _ _ (And_intro _ _ a b)))).

notation < "\infrule hbox(\emsp a \emsp\emsp\emsp b \emsp) ab (∧\sub\i)" with precedence 19 
for @{ 'And_intro_ok_1 $a $b $ab }.
interpretation "And_intro_ok_1" 'And_intro_ok_1 a b ab = 
  (show ab (And_intro _ _ a b)).

notation < "\infrule hbox(\emsp a \emsp\emsp\emsp b \emsp) mstyle color #ff0000 (ab) (∧\sub\i)" with precedence 19 
for @{ 'And_intro_ok_2 $a $b $ab }.
interpretation "And_intro_ok_2" 'And_intro_ok_2 a b ab = 
  (cast _ _ (show ab (And_intro _ _ a b))).

notation > "∧_'i' term 90 a term 90 b" with precedence 19 
for @{ 'And_intro (show $a ?) (show $b ?) }.
interpretation "And_intro KO" 'And_intro a b = (cast _ _ (And_intro _ _ a b)).
interpretation "And_intro OK" 'And_intro a b = (And_intro _ _ a b).

(* ∧ elimination *)
notation < "\infrule hbox(\emsp ab \emsp) a mstyle color #ff0000 (∧\sub(\e_\l))" with precedence 19 
for @{ 'And_elim_l_ko_1 $ab $a }.
interpretation "And_elim_l_ko_1" 'And_elim_l_ko_1 ab a = 
  (show a (cast _ _ (And_elim_l _ _ (cast _ _ ab)))).

notation < "\infrule hbox(\emsp ab \emsp) mstyle color #ff0000 (a) mstyle color #ff0000 (∧\sub(\e_\l))" with precedence 19 
for @{ 'And_elim_l_ko_2 $ab $a }.
interpretation "And_elim_l_ko_2" 'And_elim_l_ko_2 ab a = 
  (cast _ _ (show a (cast _ _ (And_elim_l _ _ (cast _ _ ab))))).

notation < "\infrule hbox(\emsp ab \emsp) a (∧\sub(\e_\l))" with precedence 19 
for @{ 'And_elim_l_ok_1 $ab $a }.
interpretation "And_elim_l_ok_1" 'And_elim_l_ok_1 ab a = 
  (show a (And_elim_l _ _ ab)).

notation < "\infrule hbox(\emsp ab \emsp) mstyle color #ff0000 (a) (∧\sub(\e_\l))" with precedence 19 
for @{ 'And_elim_l_ok_2 $ab $a }.
interpretation "And_elim_l_ok_2" 'And_elim_l_ok_2 ab a = 
  (cast _ _ (show a (And_elim_l _ _ ab))).

notation > "∧_'e_l' term 90 ab" with precedence 19
for @{ 'And_elim_l (show $ab ?) }.
interpretation "And_elim_l KO" 'And_elim_l a = (cast _ _ (And_elim_l _ _ (cast (And unit unit) _ a))).
interpretation "And_elim_l OK" 'And_elim_l a = (And_elim_l _ _ a).

notation < "\infrule hbox(\emsp ab \emsp) a mstyle color #ff0000 (∧\sub(\e_\r))" with precedence 19 
for @{ 'And_elim_r_ko_1 $ab $a }.
interpretation "And_elim_r_ko_1" 'And_elim_r_ko_1 ab a = 
  (show a (cast _ _ (And_elim_r _ _ (cast _ _ ab)))).

notation < "\infrule hbox(\emsp ab \emsp) mstyle color #ff0000 (a) mstyle color #ff0000 (∧\sub(\e_\r))" with precedence 19 
for @{ 'And_elim_r_ko_2 $ab $a }.
interpretation "And_elim_r_ko_2" 'And_elim_r_ko_2 ab a = 
  (cast _ _ (show a (cast _ _ (And_elim_r _ _ (cast _ _ ab))))).

notation < "\infrule hbox(\emsp ab \emsp) a (∧\sub(\e_\r))" with precedence 19 
for @{ 'And_elim_r_ok_1 $ab $a }.
interpretation "And_elim_r_ok_1" 'And_elim_r_ok_1 ab a = 
  (show a (And_elim_r _ _ ab)).

notation < "\infrule hbox(\emsp ab \emsp) mstyle color #ff0000 (a) (∧\sub(\e_\r))" with precedence 19 
for @{ 'And_elim_r_ok_2 $ab $a }.
interpretation "And_elim_r_ok_2" 'And_elim_r_ok_2 ab a = 
  (cast _ _ (show a (And_elim_r _ _ ab))).

notation > "∧_'e_r' term 90 ab" with precedence 19
for @{ 'And_elim_r (show $ab ?) }.
interpretation "And_elim_r KO" 'And_elim_r a = (cast _ _ (And_elim_r _ _ (cast (And unit unit) _ a))).
interpretation "And_elim_r OK" 'And_elim_r a = (And_elim_r _ _ a).

(* ∨ introduction *)
notation < "\infrule hbox(\emsp a \emsp) ab mstyle color #ff0000 (∨\sub(\i_\l))" with precedence 19 
for @{ 'Or_intro_l_ko_1 $a $ab }.
interpretation "Or_intro_l_ko_1" 'Or_intro_l_ko_1 a ab = 
  (show ab (cast _ _ (Or_intro_l _ _ a))).

notation < "\infrule hbox(\emsp a \emsp) mstyle color #ff0000 (ab) mstyle color #ff0000 (∨\sub(\i_\l))" with precedence 19 
for @{ 'Or_intro_l_ko_2 $a $ab }.
interpretation "Or_intro_l_ko_2" 'Or_intro_l_ko_2 a ab = 
  (cast _ _ (show ab (cast _ _ (Or_intro_l _ _ a)))).

notation < "\infrule hbox(\emsp a \emsp) ab (∨\sub(\i_\l))" with precedence 19 
for @{ 'Or_intro_l_ok_1 $a $ab }.
interpretation "Or_intro_l_ok_1" 'Or_intro_l_ok_1 a ab = 
  (show ab (Or_intro_l _ _ a)).

notation < "\infrule hbox(\emsp a \emsp) mstyle color #ff0000 (ab) (∨\sub(\i_\l))" with precedence 19 
for @{ 'Or_intro_l_ok_2 $a $ab }.
interpretation "Or_intro_l_ok_2" 'Or_intro_l_ok_2 a ab = 
  (cast _ _ (show ab (Or_intro_l _ _ a))).

notation > "∨_'i_l' term 90 a" with precedence 19
for @{ 'Or_intro_l (show $a ?) }.
interpretation "Or_intro_l KO" 'Or_intro_l a = (cast _ (Or _ unit) (Or_intro_l _ _ a)).
interpretation "Or_intro_l OK" 'Or_intro_l a = (Or_intro_l _ _ a). 
  
notation < "\infrule hbox(\emsp a \emsp) ab mstyle color #ff0000 (∨\sub(\i_\r))" with precedence 19 
for @{ 'Or_intro_r_ko_1 $a $ab }.
interpretation "Or_intro_r_ko_1" 'Or_intro_r_ko_1 a ab = 
  (show ab (cast _ _ (Or_intro_r _ _ a))).

notation < "\infrule hbox(\emsp a \emsp) mstyle color #ff0000 (ab) mstyle color #ff0000 (∨\sub(\i_\r))" with precedence 19 
for @{ 'Or_intro_r_ko_2 $a $ab }.
interpretation "Or_intro_r_ko_2" 'Or_intro_r_ko_2 a ab = 
  (cast _ _ (show ab (cast _ _ (Or_intro_r _ _ a)))).

notation < "\infrule hbox(\emsp a \emsp) ab (∨\sub(\i_\r))" with precedence 19 
for @{ 'Or_intro_r_ok_1 $a $ab }.
interpretation "Or_intro_r_ok_1" 'Or_intro_r_ok_1 a ab = 
  (show ab (Or_intro_r _ _ a)).

notation < "\infrule hbox(\emsp a \emsp) mstyle color #ff0000 (ab) (∨\sub(\i_\r))" with precedence 19 
for @{ 'Or_intro_r_ok_2 $a $ab }.
interpretation "Or_intro_r_ok_2" 'Or_intro_r_ok_2 a ab = 
  (cast _ _ (show ab (Or_intro_r _ _ a))).

notation > "∨_'i_r' term 90 a" with precedence 19
for @{ 'Or_intro_r (show $a ?) }.
interpretation "Or_intro_r KO" 'Or_intro_r a = (cast _ (Or unit _) (Or_intro_r _ _ a)).
interpretation "Or_intro_r OK" 'Or_intro_r a = (Or_intro_r _ _ a). 

(* ∨ elimination *)
notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp ac \emsp\emsp\emsp bc \emsp) c (mstyle color #ff0000 (∨\sub\e \emsp) ident Ha \emsp ident Hb)" with precedence 19
for @{ 'Or_elim_ko_1 $ab $c (λ${ident Ha}:$ta.$ac) (λ${ident Hb}:$tb.$bc) }.
interpretation "Or_elim_ko_1" 'Or_elim_ko_1 ab c \eta.ac \eta.bc = 
  (show c (cast _ _ (Or_elim _ _ _ (cast _ _ ab) (cast _ _ ac) (cast _ _ bc)))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp ac \emsp\emsp\emsp bc \emsp) mstyle color #ff0000 (c) (mstyle color #ff0000 (∨\sub\e) \emsp ident Ha \emsp ident Hb)" with precedence 19
for @{ 'Or_elim_ko_2 $ab (λ${ident Ha}:$ta.$ac) (λ${ident Hb}:$tb.$bc) $c }.
interpretation "Or_elim_ko_2" 'Or_elim_ko_2 ab \eta.ac \eta.bc c = 
  (cast _ _ (show c (cast _ _ (Or_elim _ _ _ (cast _ _ ab) (cast _ _ ac) (cast _ _ bc))))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp ac \emsp\emsp\emsp bc \emsp) c (∨\sub\e \emsp ident Ha \emsp ident Hb)" with precedence 19
for @{ 'Or_elim_ok_1 $ab (λ${ident Ha}:$ta.$ac) (λ${ident Hb}:$tb.$bc) $c }.
interpretation "Or_elim_ok_1" 'Or_elim_ok_1 ab \eta.ac \eta.bc c = 
  (show c (Or_elim _ _ _ ab ac bc)).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp ac \emsp\emsp\emsp bc \emsp) mstyle color #ff0000 (c) (∨\sub\e \emsp ident Ha \emsp ident Hb)" with precedence 19
for @{ 'Or_elim_ok_2 $ab (λ${ident Ha}:$ta.$ac) (λ${ident Hb}:$tb.$bc) $c }.
interpretation "Or_elim_ok_2" 'Or_elim_ok_2 ab \eta.ac \eta.bc c = 
  (cast _ _ (show c (Or_elim _ _ _ ab ac bc))).

definition unit_to ≝ λx:CProp.unit → x.

notation > "∨_'e' term 90 ab [ident Ha] term 90 cl [ident Hb] term 90 cr" with precedence 19
for @{ 'Or_elim (show $ab ?) (λ${ident Ha}.show $cl ?) (λ${ident Hb}.show $cr ?) }.
interpretation "Or_elim KO" 'Or_elim ab ac bc = 
  (cast _ _ (Or_elim _ _ _ 
    (cast (Or unit unit) _ ab) 
    (cast (unit_to unit) (unit_to _) ac) 
    (cast (unit_to unit) (unit_to _) bc))).
interpretation "Or_elim OK" 'Or_elim ab ac bc = (Or_elim _ _ _ ab ac bc).

(* ⊤ introduction *)
notation < "\infrule \nbsp ⊤ mstyle color #ff0000 (⊤\sub\i)" with precedence 19 
for @{'Top_intro_ko_1}.
interpretation "Top_intro_ko_1" 'Top_intro_ko_1 = 
  (show _ (cast _ _ Top_intro)).

notation < "\infrule \nbsp mstyle color #ff0000 (⊤) mstyle color #ff0000 (⊤\sub\i)" with precedence 19 
for @{'Top_intro_ko_2}.
interpretation "Top_intro_ko_2" 'Top_intro_ko_2 = 
  (cast _ _ (show _ (cast _ _ Top_intro))).

notation < "\infrule \nbsp ⊤ (⊤\sub\i)" with precedence 19 
for @{'Top_intro_ok_1}.
interpretation "Top_intro_ok_1" 'Top_intro_ok_1 = (show _ Top_intro).

notation < "\infrule \nbsp ⊤ (⊤\sub\i)" with precedence 19 
for @{'Top_intro_ok_2 }.
interpretation "Top_intro_ok_2" 'Top_intro_ok_2 = (cast _ _ (show _ Top_intro)).

notation > "⊤_'i'" with precedence 19 for @{ 'Top_intro }.
interpretation "Top_intro KO" 'Top_intro = (cast _ _ Top_intro).
interpretation "Top_intro OK" 'Top_intro = Top_intro.

(* ⊥ introduction *)
notation < "\infrule b a mstyle color #ff0000 (⊥\sub\e)" with precedence 19 
for @{'Bot_elim_ko_1 $a $b}.
interpretation "Bot_elim_ko_1" 'Bot_elim_ko_1 a b = 
  (show a (Bot_elim _ (cast _ _ b))).

notation < "\infrule b mstyle color #ff0000 (a) mstyle color #ff0000 (⊥\sub\e)" with precedence 19 
for @{'Bot_elim_ko_2 $a $b}.
interpretation "Bot_elim_ko_2" 'Bot_elim_ko_2 a b = 
  (cast _ _ (show a (Bot_elim _ (cast _ _ b)))).

notation < "\infrule b a (⊥\sub\e)" with precedence 19 
for @{'Bot_elim_ok_1 $a $b}.
interpretation "Bot_elim_ok_1" 'Bot_elim_ok_1 a b = 
  (show a (Bot_elim _ b)).

notation < "\infrule b mstyle color #ff0000 (a) (⊥\sub\e)" with precedence 19 
for @{'Bot_elim_ok_2 $a $b}.
interpretation "Bot_elim_ok_2" 'Bot_elim_ok_2 a b = 
  (cast _ _ (show a (Bot_elim _ b))).

notation > "⊥_'e' term 90 b" with precedence 19 
for @{ 'Bot_elim (show $b ?) }.
interpretation "Bot_elim KO" 'Bot_elim a = (Bot_elim _ (cast _ _ a)).  
interpretation "Bot_elim OK" 'Bot_elim a = (Bot_elim _ a).

(* ¬ introduction *)
notation < "\infrule hbox(\emsp b \emsp) ab (mstyle color #ff0000 (\lnot\sub(\emsp\i)) \emsp ident H)" with precedence 19
for @{ 'Not_intro_ko_1 $ab (λ${ident H}:$p.$b) }.
interpretation "Not_intro_ko_1" 'Not_intro_ko_1 ab \eta.b = 
  (show ab (cast _ _ (Not_intro _ (cast _ _ b)))).

notation < "\infrule hbox(\emsp b \emsp) mstyle color #ff0000 (ab) (mstyle color #ff0000 (\lnot\sub(\emsp\i)) \emsp ident H)" with precedence 19
for @{ 'Not_intro_ko_2 $ab (λ${ident H}:$p.$b) }.
interpretation "Not_intro_ko_2" 'Not_intro_ko_2 ab \eta.b = 
  (cast _ _ (show ab (cast _ _ (Not_intro _ (cast _ _ b))))).

notation < "\infrule hbox(\emsp b \emsp) ab (\lnot\sub(\emsp\i) \emsp ident H) " with precedence 19
for @{ 'Not_intro_ok_1 $ab (λ${ident H}:$p.$b) }.
interpretation "Not_intro_ok_1" 'Not_intro_ok_1 ab \eta.b = 
  (show ab (Not_intro _ b)).

notation < "\infrule hbox(\emsp b \emsp) mstyle color #ff0000 (ab) (\lnot\sub(\emsp\i) \emsp ident H) " with precedence 19
for @{ 'Not_intro_ok_2 $ab (λ${ident H}:$p.$b) }.
interpretation "Not_intro_ok_2" 'Not_intro_ok_2 ab \eta.b = 
  (cast _ _ (show ab (Not_intro _ b))).

notation > "¬_'i' [ident H] term 90 b" with precedence 19
for @{ 'Not_intro (λ${ident H}.show $b ?) }.
interpretation "Not_intro KO" 'Not_intro a = (cast _ _ (Not_intro _ (cast _ _ a))).
interpretation "Not_intro OK" 'Not_intro a = (Not_intro _ a).

(* ¬ elimination *)
notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) b mstyle color #ff0000 (\lnot\sub(\emsp\e)) " with precedence 19 
for @{ 'Not_elim_ko_1 $ab $a $b }.
interpretation "Not_elim_ko_1" 'Not_elim_ko_1 ab a b = 
  (show b (cast _ _ (Not_elim _ (cast _ _ ab) (cast _ _ a)))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) mstyle color #ff0000 (b) mstyle color #ff0000 (\lnot\sub(\emsp\e)) " with precedence 19 
for @{ 'Not_elim_ko_2 $ab $a $b }.
interpretation "Not_elim_ko_2" 'Not_elim_ko_2 ab a b = 
  (cast _ _ (show b (cast _ _ (Not_elim _ (cast _ _ ab) (cast _ _ a))))).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) b (\lnot\sub(\emsp\e)) " with precedence 19 
for @{ 'Not_elim_ok_1 $ab $a $b }.
interpretation "Not_elim_ok_1" 'Not_elim_ok_1 ab a b = 
  (show b (Not_elim _ ab a)).

notation < "\infrule hbox(\emsp ab \emsp\emsp\emsp a\emsp) mstyle color #ff0000 (b) (\lnot\sub(\emsp\e)) " with precedence 19 
for @{ 'Not_elim_ok_2 $ab $a $b }.
interpretation "Not_elim_ok_2" 'Not_elim_ok_2 ab a b = 
  (cast _ _ (show b (Not_elim _ ab a))).

notation > "¬_'e' term 90 ab term 90 a" with precedence 19
for @{ 'Not_elim (show $ab ?) (show $a ?) }.
interpretation "Not_elim KO" 'Not_elim ab a = 
  (cast _ _ (Not_elim unit (cast _ _ ab) (cast _ _ a))).
interpretation "Not_elim OK" 'Not_elim ab a = 
  (Not_elim _ ab a).

(* RAA *)
notation < "\infrule hbox(\emsp Px \emsp) Pn (mstyle color #ff0000 (\RAA) \emsp ident x)" with precedence 19
for @{ 'RAA_ko_1 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "RAA_ko_1" 'RAA_ko_1 Px Pn = 
  (show Pn (cast _ _ (Raa _ (cast _ _ Px)))).

notation < "\infrule hbox(\emsp Px \emsp) mstyle color #ff0000 (Pn) (mstyle color #ff0000 (\RAA) \emsp ident x)" with precedence 19
for @{ 'RAA_ko_2 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "RAA_ko_2" 'RAA_ko_2 Px Pn = 
  (cast _ _ (show Pn (cast _ _ (Raa _ (cast _ _ Px))))).

notation < "\infrule hbox(\emsp Px \emsp) Pn (\RAA \emsp ident x)" with precedence 19
for @{ 'RAA_ok_1 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "RAA_ok_1" 'RAA_ok_1 Px Pn = 
  (show Pn (Raa _ Px)).

notation < "\infrule hbox(\emsp Px \emsp) mstyle color #ff0000 (Pn) (\RAA \emsp ident x)" with precedence 19
for @{ 'RAA_ok_2 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "RAA_ok_2" 'RAA_ok_2 Px Pn = 
  (cast _ _ (show Pn (Raa _ Px))).

notation > "'RAA' [ident H] term 90 b" with precedence 19 
for @{ 'Raa (λ${ident H}.show $b ?) }. 
interpretation "RAA KO" 'Raa p = (cast _ unit (Raa _ (cast _ (unit_to _) p))).
interpretation "RAA OK" 'Raa p = (Raa _ p).

(* ∃ introduction *)
notation < "\infrule hbox(\emsp Pn \emsp) Px mstyle color #ff0000 (∃\sub\i)" with precedence 19
for @{ 'Exists_intro_ko_1 $Pn $Px }.
interpretation "Exists_intro_ko_1" 'Exists_intro_ko_1 Pn Px = 
  (show Px (cast _ _ (Exists_intro _ _ _ (cast _ _ Pn)))).

notation < "\infrule hbox(\emsp Pn \emsp) mstyle color #ff0000 (Px) mstyle color #ff0000 (∃\sub\i)" with precedence 19
for @{ 'Exists_intro_ko_2 $Pn $Px }.
interpretation "Exists_intro_ko_2" 'Exists_intro_ko_2 Pn Px = 
  (cast _ _ (show Px (cast _ _ (Exists_intro _ _ _ (cast _ _ Pn))))).

notation < "\infrule hbox(\emsp Pn \emsp) Px (∃\sub\i)" with precedence 19
for @{ 'Exists_intro_ok_1 $Pn $Px }.
interpretation "Exists_intro_ok_1" 'Exists_intro_ok_1 Pn Px = 
  (show Px (Exists_intro _ _ _ Pn)).

notation < "\infrule hbox(\emsp Pn \emsp) mstyle color #ff0000 (Px) (∃\sub\i)" with precedence 19
for @{ 'Exists_intro_ok_2 $Pn $Px }.
interpretation "Exists_intro_ok_2" 'Exists_intro_ok_2 Pn Px = 
  (cast _ _ (show Px (Exists_intro _ _ _ Pn))).

notation >"∃_'i' {term 90 t} term 90 Pt" non associative with precedence 19
for @{'Exists_intro $t (λw.? w) (show $Pt ?)}. 
interpretation "Exists_intro KO" 'Exists_intro t P Pt =
 (cast _ _ (Exists_intro sort P t (cast _ _ Pt))).
interpretation "Exists_intro OK" 'Exists_intro t P Pt =
 (Exists_intro sort P t Pt).
 
(* ∃ elimination *)
notation < "\infrule hbox(\emsp ExPx \emsp\emsp\emsp Pc \emsp) c (mstyle color #ff0000 (∃\sub\e) \emsp ident n \emsp ident HPn)" with precedence 19
for @{ 'Exists_elim_ko_1 $ExPx (λ${ident n}:$tn.λ${ident HPn}:$Pn.$Pc) $c }.
interpretation "Exists_elim_ko_1" 'Exists_elim_ko_1 ExPx Pc c =
    (show c (cast _ _ (Exists_elim _ _ _ (cast _ _ ExPx) (cast _ _ Pc)))).

notation < "\infrule hbox(\emsp ExPx \emsp\emsp\emsp Pc \emsp) mstyle color #ff0000 (c) (mstyle color #ff0000 (∃\sub\e) \emsp ident n \emsp ident HPn)" with precedence 19
for @{ 'Exists_elim_ko_2 $ExPx (λ${ident n}:$tn.λ${ident HPn}:$Pn.$Pc) $c }.
interpretation "Exists_elim_ko_2" 'Exists_elim_ko_2 ExPx Pc c =
    (cast _ _ (show c (cast _ _ (Exists_elim _ _ _ (cast _ _ ExPx) (cast _ _ Pc))))).

notation < "\infrule hbox(\emsp ExPx \emsp\emsp\emsp Pc \emsp) c (∃\sub\e \emsp ident n \emsp ident HPn)" with precedence 19
for @{ 'Exists_elim_ok_1 $ExPx (λ${ident n}:$tn.λ${ident HPn}:$Pn.$Pc) $c }.
interpretation "Exists_elim_ok_1" 'Exists_elim_ok_1 ExPx Pc c =
    (show c (Exists_elim _ _ _ ExPx Pc)).

notation < "\infrule hbox(\emsp ExPx \emsp\emsp\emsp Pc \emsp) mstyle color #ff0000 (c) (∃\sub\e \emsp ident n \emsp ident HPn)" with precedence 19
for @{ 'Exists_elim_ok_2 $ExPx (λ${ident n}:$tn.λ${ident HPn}:$Pn.$Pc) $c }.
interpretation "Exists_elim_ok_2" 'Exists_elim_ok_2 ExPx Pc c =
    (cast _ _ (show c (Exists_elim _ _ _ ExPx Pc))).

definition ex_concl := λx:sort → CProp.∀y:sort.unit → x y.
definition ex_concl_dummy := ∀y:sort.unit → unit.
definition fake_pred := λx:sort.unit.

notation >"∃_'e' term 90 ExPt {ident t} [ident H] term 90 c" non associative with precedence 19
for @{'Exists_elim (λx.? x) (show $ExPt ?) (λ${ident t}:sort.λ${ident H}.show $c ?)}. 
interpretation "Exists_elim KO" 'Exists_elim P ExPt c =
 (cast _ _ (Exists_elim sort P _ 
   (cast (Exists _ P)  _ ExPt) 
   (cast ex_concl_dummy (ex_concl _) c))).
interpretation "Exists_elim OK" 'Exists_elim P ExPt c =
 (Exists_elim sort P _ ExPt c).

(* ∀ introduction *)

notation < "\infrule hbox(\emsp Px \emsp) Pn (mstyle color #ff0000 (∀\sub\i) \emsp ident x)" with precedence 19
for @{ 'Forall_intro_ko_1 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "Forall_intro_ko_1" 'Forall_intro_ko_1 Px Pn = 
  (show Pn (cast _ _ (Forall_intro _ _ (cast _ _ Px)))).

notation < "\infrule hbox(\emsp Px \emsp) mstyle color #ff0000(Pn) (mstyle color #ff0000 (∀\sub\i) \emsp ident x)" with precedence 19
for @{ 'Forall_intro_ko_2 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "Forall_intro_ko_2" 'Forall_intro_ko_2 Px Pn = 
  (cast _ _ (show Pn (cast _ _ (Forall_intro _ _ (cast _ _ Px))))).

notation < "\infrule hbox(\emsp Px \emsp) Pn (∀\sub\i \emsp ident x)" with precedence 19
for @{ 'Forall_intro_ok_1 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "Forall_intro_ok_1" 'Forall_intro_ok_1 Px Pn = 
  (show Pn (Forall_intro _ _ Px)).

notation < "\infrule hbox(\emsp Px \emsp) mstyle color #ff0000 (Pn) (∀\sub\i \emsp ident x)" with precedence 19
for @{ 'Forall_intro_ok_2 (λ${ident x}:$tx.$Px) $Pn }.
interpretation "Forall_intro_ok_2" 'Forall_intro_ok_2 Px Pn = 
  (cast _ _ (show Pn (Forall_intro _ _ Px))).

notation > "∀_'i' {ident y} term 90 Px" non associative with precedence 19
for @{ 'Forall_intro (λ_.?) (λ${ident y}.show $Px ?) }. 
interpretation "Forall_intro KO" 'Forall_intro P Px =
  (cast _ _ (Forall_intro sort P (cast _ _ Px))). 
interpretation "Forall_intro OK" 'Forall_intro P Px =
  (Forall_intro sort P Px). 

(* ∀ elimination *)
notation < "\infrule hbox(\emsp Px \emsp) Pn (mstyle color #ff0000 (∀\sub\e))" with precedence 19
for @{ 'Forall_elim_ko_1 $Px $Pn }.
interpretation "Forall_elim_ko_1" 'Forall_elim_ko_1 Px Pn = 
  (show Pn (cast _ _ (Forall_elim _ _ _ (cast _ _ Px)))).

notation < "\infrule hbox(\emsp Px \emsp) mstyle color #ff0000(Pn) (mstyle color #ff0000 (∀\sub\e))" with precedence 19
for @{ 'Forall_elim_ko_2 $Px $Pn }.
interpretation "Forall_elim_ko_2" 'Forall_elim_ko_2 Px Pn = 
  (cast _ _ (show Pn (cast _ _ (Forall_elim _ _ _ (cast _ _ Px))))).

notation < "\infrule hbox(\emsp Px \emsp) Pn (∀\sub\e)" with precedence 19
for @{ 'Forall_elim_ok_1 $Px $Pn }.
interpretation "Forall_elim_ok_1" 'Forall_elim_ok_1 Px Pn = 
  (show Pn (Forall_elim _ _ _ Px)).

notation < "\infrule hbox(\emsp Px \emsp) mstyle color #ff0000 (Pn) (∀\sub\e)" with precedence 19
for @{ 'Forall_elim_ok_2 $Px $Pn }.
interpretation "Forall_elim_ok_2" 'Forall_elim_ok_2 Px Pn = 
  (cast _ _ (show Pn (Forall_elim _ _ _ Px))).

notation > "∀_'e' {term 90 t} term 90 Pn" non associative with precedence 19
for @{ 'Forall_elim (λ_.?) $t (show $Pn ?) }. 
interpretation "Forall_elim KO" 'Forall_elim P t Px =
  (cast _ unit (Forall_elim sort P t (cast _ _ Px))). 
interpretation "Forall_elim OK" 'Forall_elim P t Px =
  (Forall_elim sort P t Px). 

(* already proved lemma *)
definition hide_args : ∀A:Type.∀a:A.A := λA:Type.λa:A.a.
notation < "t" non associative with precedence 90 for @{'hide_args $t}.
interpretation "hide 0 args"  'hide_args t = (hide_args _ t).
interpretation "hide 1 args"  'hide_args t = (hide_args _ t _).
interpretation "hide 2 args"  'hide_args t = (hide_args _ t _ _).
interpretation "hide 3 args"  'hide_args t = (hide_args _ t _ _ _).
interpretation "hide 4 args"  'hide_args t = (hide_args _ t _ _ _ _). 
interpretation "hide 5 args"  'hide_args t = (hide_args _ t _ _ _ _ _).
interpretation "hide 6 args"  'hide_args t = (hide_args _ t _ _ _ _ _ _).
interpretation "hide 7 args"  'hide_args t = (hide_args _ t _ _ _ _ _ _ _).

(* more args crashes the pattern matcher *)

(* already proved lemma, 0 assumptions *)
definition Lemma : ΠA.A→A ≝ λA:CProp.λa:A.a.

notation < "\infrule 
         (\infrule 
             (\emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma_ko_1 $p ($H : $_) }.
interpretation "lemma_ko_1" 'lemma_ko_1 p H = 
  (show p (cast _ _ (Lemma _ (cast _ _ H)))). 

notation < "\infrule 
         (\infrule 
             (\emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma_ko_2 $p ($H : $_) }.
interpretation "lemma_ko_2" 'lemma_ko_2 p H = 
  (cast _ _ (show p (cast _ _ 
    (Lemma _ (cast _ _ H))))). 


notation < "\infrule 
         (\infrule 
             (\emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma_ok_1 $p ($H : $_) }.
interpretation "lemma_ok_1" 'lemma_ok_1 p H = 
  (show p (Lemma _ H)). 

notation < "\infrule 
         (\infrule 
             (\emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma_ok_2 $p ($H : $_) }.
interpretation "lemma_ok_2" 'lemma_ok_2 p H = 
  (cast _ _ (show p (Lemma _ H))). 

notation > "'lem' 0 term 90 l" non associative with precedence 19
for @{ 'Lemma (hide_args ? $l : ?) }.
interpretation "lemma KO" 'Lemma l = 
  (cast _ _ (Lemma unit (cast unit _ l))). 
interpretation "lemma OK" 'Lemma l = (Lemma _ l).


(* already proved lemma, 1 assumption *)
definition Lemma1 : ΠA,B. (A ⇒ B) → A → B ≝ 
 λA,B:CProp.λf:A⇒B.λa:A.
  Imply_elim A B f a.

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma1_ko_1 $a $p ($H : $_) }.
interpretation "lemma1_ko_1" 'lemma1_ko_1 a p H = 
  (show p (cast _ _ (Lemma1 _ _ (cast _ _ H) (cast _ _ a)))). 

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma1_ko_2 $a $p ($H : $_) }.
interpretation "lemma1_ko_2" 'lemma1_ko_2 a p H = 
  (cast _ _ (show p (cast _ _ 
    (Lemma1 _ _ (cast _ _ H) (cast _ _ a))))). 


notation < "\infrule 
         (\infrule 
             (\emsp a \emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma1_ok_1 $a $p ($H : $_) }.
interpretation "lemma1_ok_1" 'lemma1_ok_1 a p H = 
  (show p (Lemma1 _ _ H a)). 

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma1_ok_2 $a $p ($H : $_) }.
interpretation "lemma1_ok_2" 'lemma1_ok_2 a p H = 
  (cast _ _ (show p (Lemma1 _ _ H a))). 


notation > "'lem' 1 term 90 l term 90 p" non associative with precedence 19
for @{ 'Lemma1 (hide_args ? $l : ?) (show $p ?) }.
interpretation "lemma 1 KO" 'Lemma1 l p = 
  (cast _ _ (Lemma1 unit unit (cast (Imply unit unit) _ l) (cast unit _ p))). 
interpretation "lemma 1 OK" 'Lemma1 l p = (Lemma1 _ _ l p).

(* already proved lemma, 2 assumptions *)
definition Lemma2 : ΠA,B,C. (A ⇒ B ⇒ C) → A → B → C ≝ 
 λA,B,C:CProp.λf:A⇒B⇒C.λa:A.λb:B.
  Imply_elim B C (Imply_elim A (B⇒C) f a) b.

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma2_ko_1 $a $b $p ($H : $_) }.
interpretation "lemma2_ko_1" 'lemma2_ko_1 a b p H = 
  (show p (cast _ _ (Lemma2 _ _ _ (cast _ _ H) (cast _ _ a) (cast _ _ b)))). 

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma2_ko_2 $a $b $p ($H : $_) }.
interpretation "lemma2_ko_2" 'lemma2_ko_2 a b p H = 
  (cast _ _ (show p (cast _ _ 
    (Lemma2 _ _ _ (cast _ _ H) (cast _ _ a) (cast _ _ b))))). 


notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma2_ok_1 $a $b $p ($H : $_) }.
interpretation "lemma2_ok_1" 'lemma2_ok_1 a b p H = 
  (show p (Lemma2 _ _ _ H a b)). 

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma2_ok_2 $a $b $p ($H : $_) }.
interpretation "lemma2_ok_2" 'lemma2_ok_2 a b p H = 
  (cast _ _ (show p (Lemma2 _ _ _ H a b))). 

notation > "'lem' 2 term 90 l term 90 p term 90 q" non associative with precedence 19
for @{ 'Lemma2 (hide_args ? $l : ?) (show $p ?) (show $q ?) }.
interpretation "lemma 2 KO" 'Lemma2 l p q = 
  (cast _ _ (Lemma2 unit unit unit (cast (Imply unit (Imply unit unit)) _ l) (cast unit _ p) (cast unit _ q))). 
interpretation "lemma 2 OK" 'Lemma2 l p q = (Lemma2 _ _ _ l p q).

(* already proved lemma, 3 assumptions *)
definition Lemma3 : ΠA,B,C,D. (A ⇒ B ⇒ C ⇒ D) → A → B → C → D ≝ 
 λA,B,C,D:CProp.λf:A⇒B⇒C⇒D.λa:A.λb:B.λc:C.
  Imply_elim C D (Imply_elim B (C⇒D) (Imply_elim A (B⇒C⇒D) f a) b) c.

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp\emsp\emsp c \emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma3_ko_1 $a $b $c $p ($H : $_) }.
interpretation "lemma3_ko_1" 'lemma3_ko_1 a b c p H = 
  (show p (cast _ _ 
   (Lemma3 _ _ _ _ (cast _ _ H) (cast _ _ a) (cast _ _ b) (cast _ _ c)))). 

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp\emsp\emsp c \emsp) 
             (╲ mstyle mathsize normal (mstyle color #ff0000 (H)) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma3_ko_2 $a $b $c $p ($H : $_) }.
interpretation "lemma3_ko_2" 'lemma3_ko_2 a b c p H = 
  (cast _ _ (show p (cast _ _ 
    (Lemma3 _ _ _ _ (cast _ _ H) (cast _ _ a) (cast _ _ b) (cast _ _ c))))). 


notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp\emsp\emsp c \emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         p \nbsp" 
non associative with precedence 19
for @{ 'lemma3_ok_1 $a $b $c $p ($H : $_) }.
interpretation "lemma3_ok_1" 'lemma3_ok_1 a b c p H = 
  (show p (Lemma3 _ _ _ _ H a b c)). 

notation < "\infrule 
         (\infrule 
             (\emsp a \emsp\emsp\emsp b \emsp\emsp\emsp c \emsp) 
             (╲ mstyle mathsize normal (H) ╱) \nbsp) 
         mstyle color #ff0000 (p) \nbsp" 
non associative with precedence 19
for @{ 'lemma3_ok_2 $a $b $c $p ($H : $_) }.
interpretation "lemma3_ok_2" 'lemma3_ok_2 a b c p H = 
  (cast _ _ (show p (Lemma3 _ _ _ _ H a b c))). 

notation > "'lem' 3 term 90 l term 90 p term 90 q term 90 r" non associative with precedence 19
for @{ 'Lemma3 (hide_args ? $l : ?) (show $p ?) (show $q ?) (show $r ?) }.
interpretation "lemma 3 KO" 'Lemma3 l p q r = 
  (cast _ _ (Lemma3 unit unit unit unit (cast (Imply unit (Imply unit (Imply unit unit))) _ l) (cast unit _ p) (cast unit _ q) (cast unit _ r))). 
interpretation "lemma 3 OK" 'Lemma3 l p q r = (Lemma3 _ _ _ _ l p q r).
