/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>
#include "maxemumtvguide.h"
//-----------------------------------------------------------------------------------------------------------------------
static KCmdLineOptions options[] = { KCmdLineLastOption };
//-----------------------------------------------------------------------------------------------------------------------
class MTVG : public KUniqueApplication {
public:
	MTVG() : mMainWin(0) { }
	int newInstance();
private:
	MaxemumTVGuide *mMainWin;
};
//-----------------------------------------------------------------------------------------------------------------------
int MTVG::newInstance()
{
	if(isRestored()) {
		if(KMainWindow::canBeRestored(1)) {
			mMainWin = new MaxemumTVGuide(this);
			setMainWidget(mMainWin);
			mMainWin->restore(1, false);
			mMainWin->hide();
		}
	} else {
		mMainWin = new MaxemumTVGuide(this);
		setMainWidget(mMainWin);
		mMainWin->show();
	}
	return KUniqueApplication::newInstance();
}
//-----------------------------------------------------------------------------------------------------------------------
int main(int argc, char **argv)
{
	KAboutData about("maxemumtvguide", I18N_NOOP("Maxemum TV-Guide"), 0, I18N_NOOP("A KDE TV-Guide."),
		KAboutData::License_GPL, "(C) %{YEAR} Robert Maxe", 0, 0, "robmax-1@student.ltu.se");
	about.addAuthor("Robert Maxe", I18N_NOOP("Author"), "robmax-1@student.ltu.se");
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);
	KUniqueApplication::addCmdLineOptions();
	KApplication::addCmdLineOptions();

	if(!MTVG::start()) {
//		KMessageBox::sorry(0, "Maxemum TV-Guide is already started.\nCheck the tray.", "Application Already Running");
		kdError() << "Maxemum TV-Guide is already started. Check the system tray.\n";
		return(0);
	}

	MTVG app;
	return(app.exec());
}
//-----------------------------------------------------------------------------------------------------------------------
