/*
  $Id: Pattern.h 9077 2011-03-23 10:11:02Z sloot $
  $URL: https://ilk.uvt.nl/svn/trunk/sources/Mbt3/include/mbt/Pattern.h $

  Copyright (c) 1998 - 2011
  ILK   - Tilburg University
  CLiPS - University of Antwerp
 
  This file is part of mbt

  mbt is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  mbt is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, see <http://www.gnu.org/licenses/>.

  For questions and suggestions, see:
      http://ilk.uvt.nl/software.html
  or send mail to:
      timbl@uvt.nl
*/
#ifndef PATTERN_H
#define PATTERN_H

class PatTemplate {
 public:
  std::string templatestring;
  std::string word_templatestring;
  size_t tlen;
  size_t numslots;
  size_t wordslots;
  int focuspos;
  int word_focuspos;
  int skipfocus;
  int numsuffix;
  int numprefix;
  int hyphen;
  int capital;
  int numeric;
  int compensation;
  int wordfocus;
  
  // todo:
  // int Cap1 : Cap1, CAPH, CAP1H
  // int non_alfanum
  // int num

  // int wordlength
  // 

  PatTemplate();
  ~PatTemplate(){;}

  int totalslots() const;
  int word_totalslots() const;
  bool set( const std::string& );
  size_t sprint( std::string& ) const;
};

#endif
