/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

med_err 
MEDscalaireInfo(med_idt fid,int indice,char *scalaire,
		med_type_champ *type,char *desc)
{
  med_err ret=0;
  med_idt gid;
  char chemin[MED_TAILLE_NUM_DATA+MED_TAILLE_NOM+1];
  int num;
  med_int typechamp;

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On recupere le nom du scalaire
   */
  num = indice - 1;
  strcpy(chemin,MED_NUM_DATA);
  if ((ret = _MEDobjetIdentifier(fid,chemin,num,scalaire)) < 0)
    return -1;


  /* 
   * Si le Groupe HDF "scalaire" n'existe pas => erreur
   */
  strcat(chemin,scalaire);
  if ((gid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    return -1;


  /*
   * La liste des attributs
   */
  if ((ret = _MEDattrEntierLire(gid,MED_NOM_TYP, & typechamp)) < 0)
    return -1;
  *type = (med_type_champ) typechamp;

  if ((ret = _MEDattrStringLire(gid,MED_NOM_DES,MED_TAILLE_DESC,
				desc)) < 0)
    return -1;

  /*
   * On ferme tout
   */
  if ((ret = _MEDdatagroupFermer(gid)) < 0)
    return -1; 

  return ret;
}
