/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/


/******************************************************************************
 * - Nom du fichier : test21.c
 *
 * - Description : ecriture de valeurs scalaires numeriques dans un fichier MED
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>

int main ()
{
  med_err ret;
  med_idt fid;
  char nom_scalaire1[MED_TAILLE_NOM+1] = "VariableEntiere";
  char description1[MED_TAILLE_DESC+1] = "Une premiere description";
  char nom_scalaire2[MED_TAILLE_NOM+1] = "VariableFlottante";
  char description2[MED_TAILLE_DESC+1] = "Une seconde description";
  med_int vali1 = 56;
  med_int vali2 = -789;
  med_float valr1 = 67.98;
 
  /* Creation du fichier test21.med */
  if ((fid = MEDouvrir("test21.med",MED_CREATION)) < 0) {
    MESSAGE("Erreur a la creation du fichier test21.med");
    return -1;
  }
 
  /* Creation d'un variable scalaire entiere */
  if (MEDscalaireCr(fid,nom_scalaire1,MED_INT,description1) < 0) {
    MESSAGE("Erreur a la creation d'une variable scalaire entire");
    return -1;
  }
  printf("Creation d'une variable scalaire entiere \n");

  /* Ecriture d'un valeur sans pas de temps et sans numero d'ordre*/
  if (MEDscalaireEntierEcr(fid,nom_scalaire1,vali1,MED_NOPDT,"",0.0,MED_NONOR) < 0) {
    MESSAGE("Erreur a l'ecriture d'une valeur entiere");
    return -1;
  }
  printf("Ecriture d'une valeur entiere sans pas de temps \n");

  /* Ecriture d'une valeur entiere avec 1 pas de temps et sans numero d'ordre */
  if (MEDscalaireEntierEcr(fid,nom_scalaire1,vali2,1,"ms",5.5,MED_NONOR) < 0) {
    MESSAGE("Erreur a l'ecriture d'une valeur entiere");
    return -1;
  }
  printf("Ecriture d'une valeur entiere avec pas de temps \n");

  /* Creation d'un variable scalaire flottante */
  if (MEDscalaireCr(fid,nom_scalaire2,MED_FLOAT64,description2) < 0) {
    MESSAGE("Erreur a la creation d'une variable scalaire flottante");
    return -1;
  }
  printf("Creation d'une variable scalaire flottante \n");

  /* Ecriture d'une valeur reelle avec 1 pas de temps et 1 numero d'ordre */
  if (MEDscalaireFlottantEcr(fid,nom_scalaire2,valr1,1,"ms",5.5,2) < 0) {
    MESSAGE("Erreur a l'ecriture d'une valeur flottante");
    return -1;
  }
  printf("Ecriture d'une valeur reelle avec pas de temps et numero d'ordre \n");
  
  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }

  return 0;
}
