/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

/*
 * - Nom de la fonction : MEDlienEcrire
 * - Description : Ecrit le chemin d'accs  un maillage distant
 * - Parametres :
 *   - fid     (IN) : ID du fichier HDF courant
 *   - lienval (IN) : le chemin d'accs au fichier contenant le maillage distant
 *   - maa     (IN) : le nom du maillage distant
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 

med_err
MEDlienEcr(med_idt fid, char *lienval, char *maa)
{
  med_idt gid=0, chid=0, did=0;
  med_size dimd[1];
  med_err ret=-1;
  char chemin[MED_TAILLE_LIENS+1];
  med_int n ;
  
  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /* 
   * Si le groupe "LIENS" n'existe pas, on le cree
   */
  strncpy(chemin,MED_LIENS,MED_TAILLE_LIENS-1);
  chemin[MED_TAILLE_LIENS-1] = '\0';
  if ((gid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((gid = _MEDdatagroupCreer(fid,chemin)) < 0) {
      MESSAGE("Impossible de creer le groupe MED_LIENS : ");
      SSCRUTE(chemin); goto ERROR;
    }

  /*
   * Si le groupe "maa" n'existe pas, on le cree
   * Sinon => erreur
   */
  NOFINALBLANK(maa,ERROR);
  if ((chid = _MEDdatagroupOuvrir(gid,maa)) < 0) 
    if ((chid = _MEDdatagroupCreer(gid,maa)) < 0) {
      MESSAGE("Erreur  la cration du lien au maillage : ");
      SSCRUTE(maa);
      goto ERROR;
    }

  /*
   * On stocke "n" sous forme d'attribut
   */
  n = strlen(lienval);
  if ((ret = _MEDattrEntierEcrire(chid,MED_NOM_NBR,&n)) < 0) {
    MESSAGE("Erreur  l'criture de l'attribut n : ");
    ISCRUTE(n); goto ERROR;
  }

  /*
   * On stocke le lienval dans un dataset
   */
  dimd[0] = n;
  if ((ret = _MEDdatasetStringEcrire(chid,MED_NOM_LIE,dimd,lienval))<0) {
    MESSAGE("Impossible d'ecrire le dataset lienval de taille  : ");
    ISCRUTE(n); goto ERROR;
  }

  /*
   * On ferme tout
   */
  ret =0;
 ERROR:
  if (chid>0)     if (_MEDdatagroupFermer(chid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(chid);ret=-1; 
  }
  
  if (gid>0)     if (_MEDdatagroupFermer(gid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(gid);ret=-1;
  }

  return ret;
}
