/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test12.c
 *
 * - Description : ecriture d'une equivalence dans un maillage MED 
 *
 *****************************************************************************/

#include <med.h>
#define MESGERR
#include <med_utils.h>

#ifdef DEF_LECT_ECR
#define MODE_ACCES MED_LECTURE_ECRITURE
#elif DEF_LECT_AJOUT
#define MODE_ACCES MED_LECTURE_AJOUT
#else
#define MODE_ACCES MED_CREATION
#endif

int main (int argc, char **argv)


{
  med_idt fid;
  char maa[MED_TAILLE_NOM+1]= "maa1";
  char equ[MED_TAILLE_NOM+1] = "equivalence";
  char des[MED_TAILLE_DESC+1] = "equivalence sur les mailles MED_TRIA3";
  med_int mdim = 3;
  med_int ncor = 3;
  med_int cor[6] = {1,2,3,4,5,6};

  /* Creation du fichier "test12.med" */
  if ((fid = MEDouvrir("test12.med",MODE_ACCES)) < 0) {
    MESSAGE("Erreur a la creation du fichier test12.med");
    return -1;
  }
  
  /* Creation du maillage */
  if (MEDmaaCr(fid,maa,3,MED_NON_STRUCTURE,
		   "Un maillage pour test12") < 0) {
    MESSAGE("Erreur a la creation du maillage");
    return -1;
  }
  
  /* Creation de l'equivalence */
  if (MEDequivCr(fid,maa,equ,des) < 0) {
    MESSAGE("Erreur a la creation de l'equivalence");
    return -1;
  }

  /* Ecriture des sur les mailles MED_TRIA3 */
  if (MEDequivEcr(fid,maa,equ,cor,ncor,MED_MAILLE,MED_TRIA3) < 0) {
    MESSAGE("Erreur a l'ecriture du tableau des correspondances");
    return -1;
  }

  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }

  return 0;
}




