/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package mediathek.gui.dialoge;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import mediathek.Konstanten;
import mediathek.daten.Daten;

public class DialogHinweis extends javax.swing.JDialog {

    private Daten daten;
    private String url;
    private int check = Konstanten.SYSTEM_HINWEIS_ANZEIGEN_NR;
    private String text = "";

    /** Creates new form HilfeDialog
     * @param parent
     * @param modal
     * @param ddaten
     * @param ttext
     * @param uurl
     */
    public DialogHinweis(java.awt.Frame parent, boolean modal, Daten ddaten, String ttext, String uurl) {
        super(parent, modal);
        url = uurl;
        daten = ddaten;
        text = ttext;
        initComponents();
        this.setTitle("Hilfe");
        initBeob();
    }

    /**
     * 
     * @param parent
     * @param modal
     * @param ddaten
     * @param ttext
     * @param uurl
     * @param ttextCheck
     * @param ccheck
     * @param dialogTitel
     */
    public DialogHinweis(java.awt.Frame parent, boolean modal, Daten ddaten, String ttext, String uurl, String ttextCheck, int ccheck,
                         String dialogTitel) {
        super(parent, modal);
        url = uurl;
        check = ccheck;
        daten = ddaten;
        text = ttext;
        this.setTitle(dialogTitel);
        initComponents();
        jCheckBoxHinweis.setText(ttextCheck);
        jCheckBoxHinweis.setSelected(Boolean.parseBoolean(daten.system[check]));
        initBeob();
    }

    private void initBeob() {
        jButtonOk.addActionListener(new BeobBeenden());
        jCheckBoxHinweis.addActionListener(new BeobHinweis());
        jTextArea1.setText(text);
        if (!url.equals("")) {
            jButtonUrl.setText(url);
            jButtonUrl.addActionListener(new BeobUrl());
        } else {
            jButtonUrl.setVisible(false);
        }
    }

    private void beenden() {
        this.dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jButtonOk = new javax.swing.JButton();
        jCheckBoxHinweis = new javax.swing.JCheckBox();
        jButtonUrl = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setRows(5);
        jTextArea1.setText("\n\n");
        jScrollPane1.setViewportView(jTextArea1);

        jButtonOk.setText("OK");

        jCheckBoxHinweis.setSelected(true);
        jCheckBoxHinweis.setText("Hinweise anzeigen");

        jButtonUrl.setText("Url");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 636, Short.MAX_VALUE)
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jButtonUrl, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 632, Short.MAX_VALUE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jCheckBoxHinweis)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 375, Short.MAX_VALUE)
                                .addComponent(jButtonOk, javax.swing.GroupLayout.PREFERRED_SIZE, 97, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(16, 16, 16))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
                .addGap(8, 8, 8)
                .addComponent(jButtonUrl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButtonOk)
                    .addComponent(jCheckBoxHinweis))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonOk;
    private javax.swing.JButton jButtonUrl;
    private javax.swing.JCheckBox jCheckBoxHinweis;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

    private class BeobUrl implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Desktop.isDesktopSupported()) {
                Desktop d = Desktop.getDesktop();
                try {
                    if (d.isSupported(Desktop.Action.BROWSE)) {
                        d.browse(new URI(url));
                    }
                } catch (Exception ex) {
                }
            }
        }

    }

    private class BeobBeenden implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            beenden();
        }

    }

    private class BeobHinweis implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.system[check] = Boolean.toString(jCheckBoxHinweis.isSelected());
            daten.setGeaendertSofort();
        }

    }

}
