"""
Hook to log changesets pushed and pulled
"""

from mercurial.i18n import _
import mercurial.util
import mercurial.node

import os
import time
from mercurialserver import ruleset, changes

def hook(ui, repo, hooktype, node=None, source=None, **kwargs):
    if hooktype == 'changegroup':
        op = "push"
    elif hooktype == 'outgoing':
        op = "pull"
    else:
        raise mercurial.util.Abort(_('servelog installed as wrong hook type,'
            ' must be changegroup or outgoing but is %s') % hooktype)
    t = time.strftime("%Y-%m-%d_%H:%M:%S", time.gmtime())
    user = ruleset.rules.get('user')
    # FIXME: lock it
    log = open(repo.join("serve-log"), "a+")
    try:
        for ctx in changes.changes(repo, node):
            log.write("%s %s key=%s changeset=%s\n" % 
                (t, op, user, mercurial.node.hex(ctx.node())))
    finally:
        log.close()
