/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

//*********************************************************************************************
//
// File:		MEStatusDlg.h
//
// Description:		Interface for MEStatusDlg class - The GUI of the MEStatus application.
//
//**********************************************************************************************

#ifndef _ME_STATUS_DLG_H
#define _ME_STATUS_DLG_H

#include <gtk/gtkversion.h>
#if (!GTK_CHECK_VERSION(2,10,0))
#include <igtkxmm/statusicon.h>
#include <igtkxmm/linkbutton.h>
#endif
#include <gtkmm.h>
#include <libglademm.h>
#include <string>
#include "IMEGuiNotifications.h"

class IMEGuiCommands;

/* MEStatusDlg: This class is the main application window. It gets displayed when the 
 * application is loaded (configuration-dependant), when the user clicks the status
 * icon, or when the user chooses "Show status" from the status icon's popup menu.
 */
class MEStatusDlg: public Gtk::Window, public IMEGuiNotifications
{
public:
  //ctor
  MEStatusDlg(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
  //dtor
  virtual ~MEStatusDlg();
  /*Init: Initialize the dialog. pMEGuiCommands is a pointer to the commands object, which must
    already be initialized. strError is a reference to a string that will hold an error message
    in case initialization fails.*/
  bool Init(IMEGuiCommands *pMEGuiCommands, Glib::ustring &strError);

  /*SetEnablement sets the enablement state in the GUI: In the staus icon, and in the status label.*/
  void SetEnablement(IPCAMTStatus::Enablement enablement);

  //Overriden from Gtk::Widget
  virtual void on_show();

protected:
  /*From IMEGuiNotifications*/

  //Notification of enablement change from IMEGuiNotifications
  virtual void OnAMTChangeEnablement(IPCAMTStatus::Enablement enablement);

  //Notification from IMEGuiNotifications that we should now display the popup
  virtual void OnAMTEnablementPopup(IPCAMTStatus::Enablement enablement);

  /*Signal handlers*/
  //Main window Ok button was clicked
  virtual void OnOkButton();
  //"Browser not found" message dialog's Ok button was clicked
  virtual void OnBrowserNotFoundOkButton();
  //The "click here" link button was clicked
  virtual void OnLinkButton();
  //The "show status" option from the popup menu was selected
  virtual void OnMenuShowStatus();
  //The "exit" option from the popup menu was selected
  virtual void OnMenuExit();

  //Init fail dialog's Ok button was clicked
  static void OnInitFailOkButton(GtkDialog *dialog,
                                 gint       arg1,
                                 gpointer   user_data);

  //The status icon was clicked
  static void OnStatusIconClicked(GtkStatusIcon* icon, 
				  gpointer func_data);

  //The status icon was right-clicked
  static void OnStatusIconPopupMenu(GtkStatusIcon *status_icon,
				    guint          button,
				    guint          activate_time,
				    gpointer       user_data);

  /*Implementation member functions*/
  //Get the popup preference for the current user
  bool GetPopupForCurrentUser() const;
  //Set the popup preference for the current user
  void SetPopupForCurrentUser(bool bPopup);
  //Get the OEM configured Url for the "click here" link button
  std::string GetOEMUrl() const;

  //Get default OEM Url for the "click here" link button
  std::string GetDefaultOEMUrl() const;

  //Invoke specified web browser with specified url. 
  //Returns true on success, false otherwise.
  bool InvokeBrowser(const std::string &browser, const std::string &url);

  //Data members:
private:
  //Pointer to GUI commands that do the actual work
  IMEGuiCommands *m_pMEGuiCommands; 

  Glib::RefPtr<Gnome::Glade::Xml> m_refGlade; //Glade object - contains resources
  Glib::RefPtr<Gdk::Pixbuf> m_iconOn; //"on" Icon for status icon
  Glib::RefPtr<Gdk::Pixbuf> m_iconOff; //"off" Icon for status icon
  Glib::RefPtr<Gdk::Pixbuf> m_iconUnknown; //"unknown" Icon for status icon
  Glib::RefPtr<Gtk::StatusIcon> m_statusIcon; //The status icon object
  Glib::RefPtr<Gtk::UIManager> m_refUIManager; //UI manager - needed for popup menu
  Glib::RefPtr<Gtk::ActionGroup> m_refActionGroup; //Action group - needed for popup menu

  Gtk::MessageDialog::MessageDialog* m_pInitFailMsgDlg; //Initialization failed message dialog
  Gtk::Window* m_pBrowserNotFoundDlg; //Browser not found dialog
  Gtk::Button* m_pBrowserNotFoundOk; //Ok button of Browser not found dialog
  Gtk::Button* m_pOkButton; //Ok button of main dialog
  Gtk::Label* m_pAMTStatusLabel; //AMT Status label - shows Enabled/Disabled/Unknown.
  Gtk::HButtonBox* m_pLinkButtonBox; //The box that contains the link button
  Gtk::LinkButton* m_pLinkButton; //The "click here" link button
  Gtk::Menu* m_pMenuPopup; //The popup menu
  Gtk::CheckButton* m_pDontShowMsgChk; //The "don't show this message again" check box
  Gtk::CheckButton* m_pRenotifyChk; //The "Reactivate notification" check box
};

#endif //_ME_STATUS_DLG_H
