#include "temporary.h"
#include "constants.h"

static QList<QTemporaryFile*> tempfiles;
#ifdef Q_WS_X11
static QString userName;
#endif

Temporary::Temporary() { }

QString Temporary::filename() {

    QTemporaryFile *tempfile = new QTemporaryFile(QDir::tempPath() + "/" + Constants::UNIX_NAME + "-XXXXXX");

    tempfiles << tempfile;

    if (tempfiles.size() > 1) {
        QTemporaryFile *removedFile = tempfiles.takeFirst();
        delete removedFile;
    }

    tempfile->open();
    return tempfile->fileName();
}

void Temporary::deleteAll() {
    foreach(QTemporaryFile *tempfile, tempfiles) {
        delete tempfile;
    }
}
