/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 1997-2000 by the German Cancer Research Center (Deutsches
 *   Krebsforschungszentrum, DKFZ Heidelberg) and Bastien Chevreux
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

// 	$Id$	


#ifndef _mira_assout_h_
#define _mira_assout_h_


#include "mira/assembly_info.H"
#include "mira/contig.H"
#include "mira/readpool.H"


namespace assout {

/*************************************************************************
 *
 *
 *
 *
 *************************************************************************/

  typedef map<int32, string> strainid2name_t;
  typedef strainid2name_t::value_type s_idname_pair_t;

  void saveContigReadList(list<Contig> & clist, 
			  const string & filename,
			  bool deleteoldfile);
  void saveContigReadList(Contig & con, 
			  const string & filename,
			  bool deleteoldfile);
  void saveStatistics(list<Contig> & clist, 
		      const string & filename,
		      bool deleteoldfile);
  void saveStatistics(Contig & con,
		      const string & filename,
		      bool deleteoldfile);
  void saveAssemblyInfo(AssemblyInfo & asi,
		      const string & filename,
		      bool deleteoldfile);
  void saveReadTagList(list<Contig> & clist,
		       const string & filename,
		       bool deleteoldfile);
  void saveReadTagList(Contig & con, 
		       const string & filename,
		       bool deleteoldfile);
  void saveConsensusTagList(list<Contig> & clist,
			    const string & filename,
			    bool deleteoldfile);
  void saveConsensusTagList(Contig & con, 
			    const string & filename,
			    bool deleteoldfile);
  void getPreviousLocusTag(const list<gbfsummary_t> & gbfs,
			   list<gbfsummary_t>::const_iterator gbfsI, 
			   string & locustag, 
			   string & gene);
  void getNextLocusTag(const list<gbfsummary_t> & gbfs,
		       list<gbfsummary_t>::const_iterator gbfsI, 
		       string & locustag, 
		       string & gene);
  void saveSNPList(list<Contig> & clist,
		   const string & filename,
		   bool deleteoldfile);
  void saveSNPSurroundingAsHTML(list<Contig> & clist, 
				const string & filename, 
				bool deleteoldfile);
  void makeAllStrainGenomes(Contig & contigI, 
			    base_quality_t minqual,
			    string & consseq,
			    vector<base_quality_t> & consqual, 
			    vector<string> & strain_consseq, 
			    vector< vector<base_quality_t> > & strain_consqual,
			    strainid2name_t & strainnames_in_contig,
			    bool fillholesinstraingenomes);
  void saveFeatureAnalysis(list<Contig> & clist, 
			   ReadPool & rpool, 
			   const string & faname,
			   const string & fsname,
			   const string & fcname,
			   bool deleteoldfile);
  void adjustCaseOfSequences(string & reference, 
			     vector<string> & mutants);

  void saveStrainsAsFASTAQ(list<Contig> & clist, 
			   const ReadPool & rp,
			   const string & paddedfilename,
			   bool asfastq,
			   uint32 mincoverage=0,
			   base_quality_t minqual=0,
			   bool deleteoldfile=false,
			   bool fillholesinstrain=false);

  void saveStrainsAsGBF(list<Contig> & clist,
			const ReadPool & rp,
			const string & paddedfilename,
			base_quality_t minqual,
			bool fillholesinstraingenomes,
			bool deleteoldfile);
	  
  void saveAs_TYPE(list<Contig> & clist, 
		   const string & filename, 
		   const uint8 type,
		   bool deleteoldfile);
  void saveAs_TYPE(Contig & con, 
		   const string & filename, 
		   const uint8 type,
		   bool deleteoldfile);
  inline void saveAsTCS(list<Contig> & clist, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(clist,filename,Contig::AS_TCS, deleteoldfile);
  };
  inline void saveAsTCS(Contig & con, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(con,filename,Contig::AS_TCS, deleteoldfile);
  };
  inline void saveAsCAF(list<Contig> & clist, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(clist,filename,Contig::AS_CAF, deleteoldfile);
  };
  inline void saveAsCAF(Contig & con, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(con,filename,Contig::AS_CAF,deleteoldfile);
  };
  inline void saveAsMAF(list<Contig> & clist, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(clist,filename,Contig::AS_MAF, deleteoldfile);
  };
  inline void saveAsMAF(Contig & con, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(con,filename,Contig::AS_MAF,deleteoldfile);
  };
  inline void saveAsTXT(list<Contig> & clist,
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(clist,filename,Contig::AS_TEXT,deleteoldfile);
  };
  inline void saveAsTXT(Contig & con, 
			const string & filename,
			bool deleteoldfile){
    saveAs_TYPE(con,filename,Contig::AS_TEXT, deleteoldfile);
  };
  void saveAsGAP4DA(list<Contig> & clist, 
		    const string & dirname,
		    bool deleteoldfile);
  void saveAsGAP4DA(Contig & con,
		    const string & dirname,
		    bool deleteoldfile);
  void saveAsFASTA(list<Contig> & clist,
		   const string & filename, 
		   const string & paddedfilename,
		   bool deleteoldfile);
  void saveAsFASTA(Contig & con,
		   const string & filename, 
		   const string & paddedfilename,
		   bool deleteoldfile);
  void saveAsACE(list<Contig> & clist, 
		 const string & filename,
		 bool deleteoldfile);
  void saveAsACE(Contig & con, 
		 const string & filename,
		 bool deleteoldfile);
  void saveAsWiggle(list<Contig> & clist, 
		   const string & filename, 
		   bool deleteoldfile);
  void saveAsWiggle(Contig & con, 
		    const string & filename, 
		    bool deleteoldfile);


  void dumpContigs(list<Contig> & clist, ostream & fout);
  inline void dumpAsTCS(list<Contig> & clist, ostream & fout){
    Contig::setCoutType(Contig::AS_TCS);
    dumpContigs(clist,fout);
  };
  inline void dumpAsTCS(Contig & con, ostream & fout){
    Contig::setCoutType(Contig::AS_TCS);
    fout << con;
  };
  inline void dumpAsCAF(list<Contig> & clist, ostream & fout){
    Contig::setCoutType(Contig::AS_CAF);
    dumpContigs(clist,fout);
  };
  inline void dumpAsCAF(Contig & con, ostream & fout){
    Contig::setCoutType(Contig::AS_CAF);
    fout << con;
  };
  inline void dumpAsTXT(list<Contig> & clist, ostream & fout){
    Contig::setCoutType(Contig::AS_TEXT);
    dumpContigs(clist,fout);
  };
  inline void dumpAsTXT(Contig & con, ostream & fout){
    Contig::setCoutType(Contig::AS_TEXT);
    fout << con;
  };
  void dumpAsACE(list<Contig> & clist, ostream & fout);


  void dumpHTMLHeader(const string & projectname, ostream & htmlout);
  void dumpContigListAsHTML(list<Contig> & clist,
			    const string & filename, 
			    bool deleteoldfile, 
			    const string & projectname);
  void dumpContigAsHTML(Contig & con,
			const string & filename, 
			bool deleteoldfile, 
			const string & projectname);


  // ---------------------- internals
  bool openFileForAppend(const string & filename, 
			 ofstream & fout,
			 bool deleteanyway);
  void dumpSequenceAsGBF_priv(const string & seqname,
			      const string & strainname,
			      string & seq,
			      const string & consseq,
			      const list<gbfsummary_t> & featurelist, 
			      ostream & fout);
  void dumpTextAsGBFValueLine_priv(const string & key, 
				   const string & value,
				   ostream & fout);

  void saveAsACE_openACE(fstream & fio, 
			 const string & filename, 
			 bool deleteoldfile,
			 uint32 & numcontigs,
			 uint32 & numreads);
  void saveAsACE_rewriteHeader(fstream & fio, const uint32 numcontigs, const uint32 numreads);

}

#endif
