/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 1997-2000 by the German Cancer Research Center (Deutsches
 *   Krebsforschungszentrum, DKFZ Heidelberg) and Bastien Chevreux
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

enum { MP_bla=1000,
       MP_ed_automatic_contig_editing,
       MP_ed_strict,
       MP_ed_confirmation_threshold,

       MP_sp_est_startstep=1100,

       MP_as_projectname=1200,
       MP_as_projectname_in,
       MP_as_projectname_out,
       MP_as_numthreads,
       MP_as_automemmanagement,
       MP_as_amm_keeppercentfree,
       MP_as_amm_maxprocesssize,
       MP_as_nodateoutput,
       MP_as_readnaming_scheme,
       MP_as_plen,
       MP_as_perrors,
       MP_as_minimum_readlength,
       MP_as_minimum_readspercontig,
       MP_as_infile_loadjob,
       MP_as_merge_xmltraceinfo,
       MP_as_load_sequencedata,
       MP_as_loadSOLEXA_solexa_scores_in_qual_files,
       MP_as_fastq_qualoffset,
       MP_as_enforce_qualsinreads,
       MP_as_wants_qualityfile,
       MP_as_numpasses,
       MP_as_skimeachpass,
       MP_as_numrmbbreakloops,
       MP_as_maxcontigsperpass,
       MP_as_mark_repeats,
       MP_as_mark_repeats_only_in_result,
       MP_as_spoiler_detection,
       MP_as_sd_lastpassonly,
       MP_as_automatic_repeat_detection,
       MP_as_ard_multicopythreshold,
       MP_as_ard_multicopyminlen,
       MP_as_ard_multicopygrace,
       MP_as_uniform_read_distribution,
       MP_as_urd_startinpass,
       MP_as_urd_cutoffmultiplier,
       MP_as_keep_long_repeats_separated,
       MP_as_cleanup_tmp_files,
       MP_as_external_quality,
       MP_as_external_quality_override,
       MP_as_discard_read_on_eq_error,
       MP_as_assignreaddefaultqual,
       MP_as_basedefaultqual,
       MP_as_keepcontigsinmem,
       MP_as_savesimplesingletsinproject,
       MP_as_savetaggedsingletsinproject,
       MP_as_buntify_reads,

       MP_as_output_tmp_html,
       MP_as_output_tmp_text,
       MP_as_output_tmp_tcs,
       MP_as_output_tmp_ace,
       MP_as_output_tmp_caf,
       MP_as_output_tmp_maf,
       MP_as_output_tmp_gap4da,
       MP_as_output_tmp_fasta,
       MP_as_output_exttmp_html,
       MP_as_output_exttmp_ace,
       MP_as_output_exttmp_caf,
       MP_as_output_exttmp_gap4da,
       MP_as_output_exttmp_fasta,
       MP_as_output_exttmp_alsosinglets,
       MP_as_output_html,
       MP_as_output_text,
       MP_as_output_ace,
       MP_as_output_gff3,
       MP_as_output_wiggle,
       MP_as_output_caf,
       MP_as_output_maf,
       MP_as_output_tcs,
       MP_as_output_gap4da,
       MP_as_output_fasta,
       MP_as_output_removerollovertmps,
       MP_as_output_removetmpdir,

       MP_as_filecheck_only,
       MP_as_loadstraindata,
       MP_as_assign_defaultstrain,
       MP_as_default_strainname,
       MP_as_use_template_information,
       MP_as_clip_skimchimeradetection,
       MP_as_clip_skimjunkdetection,
       MP_as_clip_proposeendclips,
       MP_as_clip_pec_basesperhash,
       MP_as_clip_pec_sxaggcxg,
       MP_as_clip_badsolexaends,
       MP_as_clip_knownadaptorsright,
       MP_as_clip_possible_vectors,
       MP_as_clip_vector_maxlenallowed,
       MP_as_clip_quality_minthreshold,
       MP_as_clip_quality_numminthreshold,
       MP_as_clip_quality,
       MP_as_clip_quality_minqual,
       MP_as_clip_quality_winlen,
       MP_as_clip_badstretchquality,
       MP_as_clip_badstretchquality_minqual,
       MP_as_clip_badstretchquality_winlen,
       MP_as_clip_maskedbases,
       MP_as_clip_maskedbases_gapsize,
       MP_as_clip_maskedbases_maxfrontgap,
       MP_as_clip_maskedbases_maxendgap,
       MP_as_clip_lowercase,
       MP_as_clip_ensureminimumleftclip,
       MP_as_clip_minimumleftcliprequired,
       MP_as_clip_setminimumleftclip,
       MP_as_clip_ensureminimumrightclip,
       MP_as_clip_minimumrightcliprequired,
       MP_as_clip_setminimumrightclip,
       MP_as_clip_mergessahavectorscreen,
       MP_as_clip_ssahamerge_gapsize,
       MP_as_clip_ssahamerge_maxfrontgap,
       MP_as_clip_ssahamerge_maxendgap,
       MP_as_clip_ssahamerge_strictfrontclip,
       MP_as_clip_ssahamerge_strictendclip,
       MP_as_clip_polyat,
       MP_as_clip_polyat_keeppolysignal,
       MP_as_clip_polyat_len,
       MP_as_clip_polyat_maxerrors,
       MP_as_clip_polyat_maxgap,
       MP_as_clip_3ppolybase,
       MP_as_clip_3ppolybase_keeppolysignal,
       MP_as_clip_3ppolybase_len,
       MP_as_clip_3ppolybase_maxerrors,
       MP_as_clip_3ppolybase_maxgap,

       MP_as_extend_reads,
       MP_as_readextension_window_len,
       MP_as_readextension_window_maxerrors,
       MP_as_readextension_firstpassnum,
       MP_as_readextension_lastpassnum,
       MP_as_loadbackbone,
       MP_as_backbone_loadjob,
       MP_as_backbone_raillength,
       MP_as_backbone_railoverlap,
       MP_as_backbone_basequals,
       MP_as_backbone_outlen,
       MP_as_backbone_strainname,
       MP_as_backbone_strainname_forceforall,
       MP_as_backbone_rail_fromstrain,
       MP_as_startbackboneusage_inpass,
       MP_as_backbone_alsobuildnewcontigs,

       MP_sk_numthreads=5000,
       MP_sk_basesperhash,
       MP_sk_hashsavestepping,
       MP_sk_percentrequired,
       MP_sk_maxhitsperread,
       MP_sk_maxhashesinmemory,
       MP_sk_memcaphitreduction,
       MP_sk_maxmegahubratio,
       MP_sk_masknastyrepeats,
       MP_sk_alsoskimrevcomp,
       MP_sk_swcheckonbackbones,

       MP_sk_freqest_minnormal,
       MP_sk_freqest_maxnormal,
       MP_sk_freqest_repeat,
       MP_sk_freqest_heavyrepeat,
       MP_sk_freqest_crazyrepeat,
       MP_sk_nastyrepeatratio,
       MP_sk_repeatlevel_in_infofile,

       MP_al_bip=5500,
       MP_al_bmax,
       MP_al_bmin,
       MP_al_min_overlap,
       MP_al_min_score,
       MP_al_min_relscore,
       MP_al_solexahack_maxerrors,

       MP_ads_extra_gap_penalty=5700,
       MP_ads_gp_level,
       MP_ads_max_gppercent,
//       MP_ads_extra_mismatch_penalty,
//       MP_ads_emp_windowlen,
//       MP_ads_emp_maxmismatches,

       MP_paf_use_emergency_blacklist=6000,
       MP_paf_use_emergency_search_stop,
       MP_paf_ess_partnerdepth,
       MP_paf_use_max_contig_buildtime,
       MP_paf_use_genomic_pathfinder,
       MP_paf_buildtime_inseconds,
       MP_paf_max_startcache_filltime,
       MP_paf_skip_whole_contig_scan,
       MP_paf_use_quick_rule,
       MP_paf_quickrule_minlen1,
       MP_paf_quickrule_minsim1,
       MP_paf_quickrule_minlen2,
       MP_paf_quickrule_minsim2,
       MP_paf_bbquickoverlap_minlen,

       MP_con_name_prefix=6300,
       MP_con_analyse_mode,
       MP_con_val_am_none,
       MP_con_val_am_text,
       MP_con_val_am_string,
       MP_con_rodirs,
       MP_con_danger_max_error_rate,
       MP_con_assume_snp_insteadof_rmb,
//       MP_con_num_rmb_zone_trigger,
       MP_con_min_readspergroup,
       MP_con_min_rmb_neighbourqual,
       MP_con_min_groupqual_for_rmb_tagging,
//       MP_con_min_groupqual_for_wrmbsrmb_change,
       MP_con_endread_mark_exclusion_area,
       MP_con_emea_setzero_on_clipping_pec,
       MP_con_also_mark_gap_bases,
       MP_con_also_mark_gap_bases_evenmc,
       MP_con_also_mark_gap_bases_needbothstrands,
       MP_con_insertsize_minimum,
       MP_con_insertsize_maximum,
       MP_con_template_build_direction,
       MP_con_output_fasta_cpl,
       MP_con_output_html_cpl,
       MP_con_output_text_cpl,
       MP_con_output_html_gapfill,
       MP_con_output_text_gapfill,
       MP_con_force_nonIUPACconsensus_perseqtype,
       MP_con_force_nonIUPACconsensus_amongseqtypes,
       MP_con_mergeshortreads,
       MP_con_msr_keependsunmapped,
       MP_con_gap_override_ratio,

       MP_mi_stoponnfs=7700,
       MP_mi_extendedlog,
       MP_mi_as_largecontigsize,
       MP_mi_as_largecontigsize4stats,
       MP_mi_stop_maxreadnamelength,

       MP_fn_cafin=7800,
       MP_fn_cafout,
       MP_fn_fofnexpin,
       MP_fn_fofnphdin,
       MP_fn_fastqin,
       MP_fn_fastain,
       MP_fn_fastaqualin,
       MP_fn_phdin,
       MP_fn_straindatain,
       MP_fn_xmltraceinfoin,
       MP_fn_ssahavectorscreenin,
       MP_fn_smaltvectorscreenin,
       MP_fn_backbonein,

       MP_dir_cwd=8000,
       MP_dir_tmp,
       MP_dir_tmp_redirectedto,
       MP_dir_exp,
       MP_dir_scf,
       MP_dir_fasta,
       MP_dir_gap4da,

       MP_quickmode_borg=8200,
       MP_quickmode_fastq,
       MP_quickmode_fastqname,
       MP_quickmode_fasta,
       MP_quickmode_fastaname,
       MP_quickmode_phd,
       MP_quickmode_phdname,
       MP_quickmode_caf,
       MP_quickmode_cafname,
       MP_quickmode_loadparam,
       MP_quickmode_clippinglight,
       MP_quickmode_clippingmedium,
       MP_quickmode_clippingheavy,
       MP_quickmode_noquality_all,
       MP_quickmode_noclipping_all,
       MP_quickmode_noclipping_sanger,
       MP_quickmode_noclipping_454,
       MP_quickmode_noclipping_iontor,
       MP_quickmode_noclipping_pacbio,
       MP_quickmode_noclipping_solexa,
       MP_quickmode_noclipping_solid,
       MP_quickmode_highlyrepetitive,
       MP_quickmode_highqualitydata,
       MP_quickmode_lowqualitydata,
       MP_quickmode_notraceinfo,

       MP_jobdefstart=8300,
       MP_jobdef_draft,
       MP_jobdef_normal,
       MP_jobdef_accurate,
       MP_jobdef_genome,
       MP_jobdef_est,
       MP_jobdef_estsnppipeline1,
       MP_jobdef_estsnppipeline2,
       MP_jobdef_estsnppipeline3,
       MP_jobdef_denovo,
       MP_jobdef_mapping,
       MP_jobdef_sanger,
       MP_jobdef_454,
       MP_jobdef_iontor,
       MP_jobdef_pacbio,
       MP_jobdef_solexa,
       MP_jobdef_solid,   
       MP_jobdefend,

       MP_params_for_common=8400,
       MP_params_for_sanger,
       MP_params_for_454,
       MP_params_for_iontor,
       MP_params_for_pacbio,
       MP_params_for_solexa,
       MP_params_for_solid,
       MP_silentparams_for_common,
       MP_silentparams_for_sanger,
       MP_silentparams_for_454,
       MP_silentparams_for_iontor,
       MP_silentparams_for_pacbio,
       MP_silentparams_for_solexa,
       MP_silentparams_for_solid,

       MP_ANID=9000,
       MP_FLOAT,
       MP_INT,
       MP_PARSING_SECTIONCHANGE,
       MP_PARSING_SECTIONRESET,

       MP_ERROR=10000,
       MP_ERROR_DASHES,
       MP_UNRECOGNISED_STRING
};

// Local Variables: 
// mode: C++
// End: 
