; Mixxx.nsi
;
; Mixxx NSI install script. 
; has uninstall support and (optionally) installs start menu shortcuts.
;
; By Tue Haste Andersen <haste@diku.dk>, June 2004.
;
;Include Modern UI
!include "MUI.nsh"

; The name of the installer
Name "Mixxx"

; Disable the Nullsoft Installer branding text at the bottom.
BrandingText " "

; The file to write
OutFile "mixxx-1.6.0-win.exe"

; The default installation directory
InstallDir $PROGRAMFILES\Mixxx

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\NSIS_Mixxx" "Install_Dir"

;Interface Settings
!define MUI_ABORTWARNING

; Pages
!insertmacro MUI_PAGE_LICENSE "LICENSE"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
  
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

;Languages
!insertmacro MUI_LANGUAGE "English"

;--------------------------------

; The stuff to install
Section "Mixxx (required)" SecMixxx

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put binary files there
  File "dist\mixxx.exe"
  File "dist\*.dll"
;  File "..\mixxx-winlib\msvcm80.dll"
;  File "..\mixxx-winlib\msvcp80.dll"
;  File "..\mixxx-winlib\msvcr80.dll"
  File "..\mixxx-winlib\Microsoft.VC80.CRT.manifest"

  ; And documentation, licence etc.
  File "Mixxx-Manual.pdf"
  File "LICENSE"
  File "README"
  File "COPYING"

  SetOutPath $INSTDIR\midi
  File "dist\midi\*.xml"

  ;Disabled for initial 1.6.0 release
  ;SetOutPath $INSTDIR\promo
  ;File "dist\promo\*"

  SetOutPath $INSTDIR\keyboard
  File "src\keyboard\Standard.kbd.cfg"
  File "src\keyboard\Old.kbd.cfg"

  SetOutPath "$INSTDIR\skins"
  File "src\skins\cross.png"

  SetOutPath "$INSTDIR\skins\Collusion (1280)"
  File "src\skins\Collusion (1280)\*"

  SetOutPath "$INSTDIR\skins\Collusion (1280-WS)"
  File "src\skins\Collusion (1280-WS)\*"

  SetOutPath $INSTDIR\skins\outline
  File "src\skins\outline\back-off-Ch1.png"
  File "src\skins\outline\back-off-Ch2.png"
  File "src\skins\outline\back-on-Ch1.png"
  File "src\skins\outline\back-on-Ch2.png"
  File "src\skins\outline\crosshandle-off-.png"
  File "src\skins\outline\crosshandle-on-.png"
  File "src\skins\outline\crossslider-off-.png"
  File "src\skins\outline\crossslider-on-.png"
  File "src\skins\outline\cue-off-Ch1.png"
  File "src\skins\outline\cue-off-Ch2.png"
  File "src\skins\outline\cue-on-Ch1.png"
  File "src\skins\outline\cue-on-Ch2.png"
  File "src\skins\outline\endoftrack-loop-ch1.png"
  File "src\skins\outline\endoftrack-loop-ch2.png"
  File "src\skins\outline\endoftrack-next-ch1.png"
  File "src\skins\outline\endoftrack-next-ch2.png"
  File "src\skins\outline\endoftrack-ping-ch1.png"
  File "src\skins\outline\endoftrack-ping-ch2.png"
  File "src\skins\outline\endoftrack-stop-ch1.png"
  File "src\skins\outline\endoftrack-stop-ch2.png"
  File "src\skins\outline\flanger-off-Ch1.png"
  File "src\skins\outline\flanger-off-Ch2.png"
  File "src\skins\outline\flanger-on-Ch1.png"
  File "src\skins\outline\flanger-on-Ch2.png"
  File "src\skins\outline\fwd-off-Ch1.png"
  File "src\skins\outline\fwd-off-Ch2.png"
  File "src\skins\outline\fwd-on-Ch1.png"
  File "src\skins\outline\fwd-on-Ch2.png"
  File "src\skins\outline\head-off-Ch1.png"
  File "src\skins\outline\head-off-Ch2.png"
  File "src\skins\outline\head-on-Ch1.png"
  File "src\skins\outline\head-on-Ch2.png"
  File "src\skins\outline\knob0.png"
  File "src\skins\outline\knob1.png"
  File "src\skins\outline\knob10.png"
  File "src\skins\outline\knob11.png"
  File "src\skins\outline\knob12.png"
  File "src\skins\outline\knob13.png"
  File "src\skins\outline\knob14.png"
  File "src\skins\outline\knob15.png"
  File "src\skins\outline\knob16.png"
  File "src\skins\outline\knob17.png"
  File "src\skins\outline\knob18.png"
  File "src\skins\outline\knob19.png"
  File "src\skins\outline\knob2.png"
  File "src\skins\outline\knob20.png"
  File "src\skins\outline\knob21.png"
  File "src\skins\outline\knob22.png"
  File "src\skins\outline\knob23.png"
  File "src\skins\outline\knob24.png"
  File "src\skins\outline\knob25.png"
  File "src\skins\outline\knob26.png"
  File "src\skins\outline\knob27.png"
  File "src\skins\outline\knob28.png"
  File "src\skins\outline\knob29.png"
  File "src\skins\outline\knob3.png"
  File "src\skins\outline\knob30.png"
  File "src\skins\outline\knob31.png"
  File "src\skins\outline\knob32.png"
  File "src\skins\outline\knob33.png"
  File "src\skins\outline\knob34.png"
  File "src\skins\outline\knob35.png"
  File "src\skins\outline\knob36.png"
  File "src\skins\outline\knob37.png"
  File "src\skins\outline\knob38.png"
  File "src\skins\outline\knob39.png"
  File "src\skins\outline\knob4.png"
  File "src\skins\outline\knob40.png"
  File "src\skins\outline\knob41.png"
  File "src\skins\outline\knob42.png"
  File "src\skins\outline\knob43.png"
  File "src\skins\outline\knob44.png"
  File "src\skins\outline\knob5.png"
  File "src\skins\outline\knob6.png"
  File "src\skins\outline\knob7.png"
  File "src\skins\outline\knob8.png"
  File "src\skins\outline\knob9.png"
  File "src\skins\outline\knobg0.png"
  File "src\skins\outline\knobg1.png"
  File "src\skins\outline\knobg10.png"
  File "src\skins\outline\knobg11.png"
  File "src\skins\outline\knobg12.png"
  File "src\skins\outline\knobg13.png"
  File "src\skins\outline\knobg14.png"
  File "src\skins\outline\knobg15.png"
  File "src\skins\outline\knobg16.png"
  File "src\skins\outline\knobg17.png"
  File "src\skins\outline\knobg18.png"
  File "src\skins\outline\knobg19.png"
  File "src\skins\outline\knobg2.png"
  File "src\skins\outline\knobg20.png"
  File "src\skins\outline\knobg21.png"
  File "src\skins\outline\knobg22.png"
  File "src\skins\outline\knobg23.png"
  File "src\skins\outline\knobg24.png"
  File "src\skins\outline\knobg25.png"
  File "src\skins\outline\knobg26.png"
  File "src\skins\outline\knobg27.png"
  File "src\skins\outline\knobg28.png"
  File "src\skins\outline\knobg29.png"
  File "src\skins\outline\knobg3.png"
  File "src\skins\outline\knobg30.png"
  File "src\skins\outline\knobg31.png"
  File "src\skins\outline\knobg32.png"
  File "src\skins\outline\knobg33.png"
  File "src\skins\outline\knobg34.png"
  File "src\skins\outline\knobg35.png"
  File "src\skins\outline\knobg36.png"
  File "src\skins\outline\knobg37.png"
  File "src\skins\outline\knobg38.png"
  File "src\skins\outline\knobg39.png"
  File "src\skins\outline\knobg4.png"
  File "src\skins\outline\knobg40.png"
  File "src\skins\outline\knobg41.png"
  File "src\skins\outline\knobg42.png"
  File "src\skins\outline\knobg43.png"
  File "src\skins\outline\knobg44.png"
  File "src\skins\outline\knobg5.png"
  File "src\skins\outline\knobg6.png"
  File "src\skins\outline\knobg7.png"
  File "src\skins\outline\knobg8.png"
  File "src\skins\outline\knobg9.png"
  File "src\skins\outline\knobl0.png"
  File "src\skins\outline\knobl1.png"
  File "src\skins\outline\knobl10.png"
  File "src\skins\outline\knobl11.png"
  File "src\skins\outline\knobl12.png"
  File "src\skins\outline\knobl13.png"
  File "src\skins\outline\knobl14.png"
  File "src\skins\outline\knobl15.png"
  File "src\skins\outline\knobl16.png"
  File "src\skins\outline\knobl17.png"
  File "src\skins\outline\knobl18.png"
  File "src\skins\outline\knobl19.png"
  File "src\skins\outline\knobl2.png"
  File "src\skins\outline\knobl20.png"
  File "src\skins\outline\knobl21.png"
  File "src\skins\outline\knobl22.png"
  File "src\skins\outline\knobl23.png"
  File "src\skins\outline\knobl24.png"
  File "src\skins\outline\knobl25.png"
  File "src\skins\outline\knobl26.png"
  File "src\skins\outline\knobl27.png"
  File "src\skins\outline\knobl28.png"
  File "src\skins\outline\knobl29.png"
  File "src\skins\outline\knobl3.png"
  File "src\skins\outline\knobl30.png"
  File "src\skins\outline\knobl31.png"
  File "src\skins\outline\knobl32.png"
  File "src\skins\outline\knobl33.png"
  File "src\skins\outline\knobl34.png"
  File "src\skins\outline\knobl35.png"
  File "src\skins\outline\knobl36.png"
  File "src\skins\outline\knobl37.png"
  File "src\skins\outline\knobl38.png"
  File "src\skins\outline\knobl39.png"
  File "src\skins\outline\knobl4.png"
  File "src\skins\outline\knobl40.png"
  File "src\skins\outline\knobl41.png"
  File "src\skins\outline\knobl42.png"
  File "src\skins\outline\knobl43.png"
  File "src\skins\outline\knobl44.png"
  File "src\skins\outline\knobl5.png"
  File "src\skins\outline\knobl6.png"
  File "src\skins\outline\knobl7.png"
  File "src\skins\outline\knobl8.png"
  File "src\skins\outline\knobl9.png"
  File "src\skins\outline\knobm0.png"
  File "src\skins\outline\knobm1.png"
  File "src\skins\outline\knobm10.png"
  File "src\skins\outline\knobm11.png"
  File "src\skins\outline\knobm12.png"
  File "src\skins\outline\knobm13.png"
  File "src\skins\outline\knobm14.png"
  File "src\skins\outline\knobm15.png"
  File "src\skins\outline\knobm16.png"
  File "src\skins\outline\knobm17.png"
  File "src\skins\outline\knobm18.png"
  File "src\skins\outline\knobm19.png"
  File "src\skins\outline\knobm2.png"
  File "src\skins\outline\knobm20.png"
  File "src\skins\outline\knobm21.png"
  File "src\skins\outline\knobm22.png"
  File "src\skins\outline\knobm23.png"
  File "src\skins\outline\knobm24.png"
  File "src\skins\outline\knobm25.png"
  File "src\skins\outline\knobm26.png"
  File "src\skins\outline\knobm27.png"
  File "src\skins\outline\knobm28.png"
  File "src\skins\outline\knobm29.png"
  File "src\skins\outline\knobm3.png"
  File "src\skins\outline\knobm30.png"
  File "src\skins\outline\knobm31.png"
  File "src\skins\outline\knobm32.png"
  File "src\skins\outline\knobm33.png"
  File "src\skins\outline\knobm34.png"
  File "src\skins\outline\knobm35.png"
  File "src\skins\outline\knobm36.png"
  File "src\skins\outline\knobm37.png"
  File "src\skins\outline\knobm38.png"
  File "src\skins\outline\knobm39.png"
  File "src\skins\outline\knobm4.png"
  File "src\skins\outline\knobm40.png"
  File "src\skins\outline\knobm41.png"
  File "src\skins\outline\knobm42.png"
  File "src\skins\outline\knobm43.png"
  File "src\skins\outline\knobm44.png"
  File "src\skins\outline\knobm5.png"
  File "src\skins\outline\knobm6.png"
  File "src\skins\outline\knobm7.png"
  File "src\skins\outline\knobm8.png"
  File "src\skins\outline\knobm9.png"
  File "src\skins\outline\knobr0.png"
  File "src\skins\outline\knobr1.png"
  File "src\skins\outline\knobr10.png"
  File "src\skins\outline\knobr11.png"
  File "src\skins\outline\knobr12.png"
  File "src\skins\outline\knobr13.png"
  File "src\skins\outline\knobr14.png"
  File "src\skins\outline\knobr15.png"
  File "src\skins\outline\knobr16.png"
  File "src\skins\outline\knobr17.png"
  File "src\skins\outline\knobr18.png"
  File "src\skins\outline\knobr19.png"
  File "src\skins\outline\knobr2.png"
  File "src\skins\outline\knobr20.png"
  File "src\skins\outline\knobr21.png"
  File "src\skins\outline\knobr22.png"
  File "src\skins\outline\knobr23.png"
  File "src\skins\outline\knobr24.png"
  File "src\skins\outline\knobr25.png"
  File "src\skins\outline\knobr26.png"
  File "src\skins\outline\knobr27.png"
  File "src\skins\outline\knobr28.png"
  File "src\skins\outline\knobr29.png"
  File "src\skins\outline\knobr3.png"
  File "src\skins\outline\knobr30.png"
  File "src\skins\outline\knobr31.png"
  File "src\skins\outline\knobr32.png"
  File "src\skins\outline\knobr33.png"
  File "src\skins\outline\knobr34.png"
  File "src\skins\outline\knobr35.png"
  File "src\skins\outline\knobr36.png"
  File "src\skins\outline\knobr37.png"
  File "src\skins\outline\knobr38.png"
  File "src\skins\outline\knobr39.png"
  File "src\skins\outline\knobr4.png"
  File "src\skins\outline\knobr40.png"
  File "src\skins\outline\knobr41.png"
  File "src\skins\outline\knobr42.png"
  File "src\skins\outline\knobr43.png"
  File "src\skins\outline\knobr44.png"
  File "src\skins\outline\knobr5.png"
  File "src\skins\outline\knobr6.png"
  File "src\skins\outline\knobr7.png"
  File "src\skins\outline\knobr8.png"
  File "src\skins\outline\knobr9.png"
  File "src\skins\outline\play-off-Ch1.png"
  File "src\skins\outline\play-off-Ch2.png"
  File "src\skins\outline\play-on-Ch1.png"
  File "src\skins\outline\play-on-Ch2.png"
  File "src\skins\outline\playpos-marker1.png"
  File "src\skins\outline\playpos-marker2.png"
  File "src\skins\outline\playpos-slider.png"
  File "src\skins\outline\ratedown-off-Ch1.png"
  File "src\skins\outline\ratedown-off-Ch2.png"
  File "src\skins\outline\ratedown-on-Ch1.png"
  File "src\skins\outline\ratedown-on-Ch2.png"
  File "src\skins\outline\ratehandle-off-Ch1.png"
  File "src\skins\outline\ratehandle-off-Ch2.png"
  File "src\skins\outline\ratehandle-on-Ch1.png"
  File "src\skins\outline\ratehandle-on-Ch2.png"
  File "src\skins\outline\rateslider-off-Ch1.png"
  File "src\skins\outline\rateslider-off-Ch2.png"
  File "src\skins\outline\rateslider-on-Ch1.png"
  File "src\skins\outline\rateslider-on-Ch2.png"
  File "src\skins\outline\rateup-off-Ch1.png"
  File "src\skins\outline\rateup-off-Ch2.png"
  File "src\skins\outline\rateup-on-Ch1.png"
  File "src\skins\outline\rateup-on-Ch2.png"
  File "src\skins\outline\rev-off-Ch1.png"
  File "src\skins\outline\rev-off-Ch2.png"
  File "src\skins\outline\rev-on-Ch1.png"
  File "src\skins\outline\rev-on-Ch2.png"
  File "src\skins\outline\scene.png"
  File "src\skins\outline\skin.xml"
  File "src\skins\outline\sync-off-Ch1.png"
  File "src\skins\outline\sync-off-Ch2.png"
  File "src\skins\outline\sync-on-Ch1.png"
  File "src\skins\outline\sync-on-Ch2.png"
  File "src\skins\outline\volhandle-off-Ch1.png"
  File "src\skins\outline\volhandle-off-Ch2.png"
  File "src\skins\outline\volhandle-on-Ch1.png"
  File "src\skins\outline\volhandle-on-Ch2.png"
  File "src\skins\outline\volslider-off-Ch1.png"
  File "src\skins\outline\volslider-off-Ch2.png"
  File "src\skins\outline\volslider-on-Ch1.png"
  File "src\skins\outline\volslider-on-Ch2.png"
  File "src\skins\outline\vumeter-off-.png"
  File "src\skins\outline\vumeter-off-Ch1.png"
  File "src\skins\outline\vumeter-off-Ch2.png"
  File "src\skins\outline\vumeter-on-.png"
  File "src\skins\outline\vumeter-on-Ch1.png"
  File "src\skins\outline\vumeter-on-Ch2.png"
  File "src\skins\outline\peak-indicator-on.png"
  File "src\skins\outline\peak-indicator-off.png"

  SetOutPath $INSTDIR\skins\outlineClose
  File "src\skins\outlineClose\back-off-Ch1.png"
  File "src\skins\outlineClose\back-off-Ch2.png"
  File "src\skins\outlineClose\back-on-Ch1.png"
  File "src\skins\outlineClose\back-on-Ch2.png"
  File "src\skins\outlineClose\crosshandle-off-.png"
  File "src\skins\outlineClose\crosshandle-on-.png"
  File "src\skins\outlineClose\crossslider-off-.png"
  File "src\skins\outlineClose\crossslider-on-.png"
  File "src\skins\outlineClose\cue-off-Ch1.png"
  File "src\skins\outlineClose\cue-off-Ch2.png"
  File "src\skins\outlineClose\cue-on-Ch1.png"
  File "src\skins\outlineClose\cue-on-Ch2.png"
  File "src\skins\outlineClose\endoftrack-loop-ch1.png"
  File "src\skins\outlineClose\endoftrack-loop-ch2.png"
  File "src\skins\outlineClose\endoftrack-next-ch1.png"
  File "src\skins\outlineClose\endoftrack-next-ch2.png"
  File "src\skins\outlineClose\endoftrack-ping-ch1.png"
  File "src\skins\outlineClose\endoftrack-ping-ch2.png"
  File "src\skins\outlineClose\endoftrack-stop-ch1.png"
  File "src\skins\outlineClose\endoftrack-stop-ch2.png"
  File "src\skins\outlineClose\flanger-off-Ch1.png"
  File "src\skins\outlineClose\flanger-off-Ch2.png"
  File "src\skins\outlineClose\flanger-on-Ch1.png"
  File "src\skins\outlineClose\flanger-on-Ch2.png"
  File "src\skins\outlineClose\fwd-off-Ch1.png"
  File "src\skins\outlineClose\fwd-off-Ch2.png"
  File "src\skins\outlineClose\fwd-on-Ch1.png"
  File "src\skins\outlineClose\fwd-on-Ch2.png"
  File "src\skins\outlineClose\head-off-Ch1.png"
  File "src\skins\outlineClose\head-off-Ch2.png"
  File "src\skins\outlineClose\head-on-Ch1.png"
  File "src\skins\outlineClose\head-on-Ch2.png"
  File "src\skins\outlineClose\knob0.png"
  File "src\skins\outlineClose\knob1.png"
  File "src\skins\outlineClose\knob10.png"
  File "src\skins\outlineClose\knob11.png"
  File "src\skins\outlineClose\knob12.png"
  File "src\skins\outlineClose\knob13.png"
  File "src\skins\outlineClose\knob14.png"
  File "src\skins\outlineClose\knob15.png"
  File "src\skins\outlineClose\knob16.png"
  File "src\skins\outlineClose\knob17.png"
  File "src\skins\outlineClose\knob18.png"
  File "src\skins\outlineClose\knob19.png"
  File "src\skins\outlineClose\knob2.png"
  File "src\skins\outlineClose\knob20.png"
  File "src\skins\outlineClose\knob21.png"
  File "src\skins\outlineClose\knob22.png"
  File "src\skins\outlineClose\knob23.png"
  File "src\skins\outlineClose\knob24.png"
  File "src\skins\outlineClose\knob25.png"
  File "src\skins\outlineClose\knob26.png"
  File "src\skins\outlineClose\knob27.png"
  File "src\skins\outlineClose\knob28.png"
  File "src\skins\outlineClose\knob29.png"
  File "src\skins\outlineClose\knob3.png"
  File "src\skins\outlineClose\knob30.png"
  File "src\skins\outlineClose\knob31.png"
  File "src\skins\outlineClose\knob32.png"
  File "src\skins\outlineClose\knob33.png"
  File "src\skins\outlineClose\knob34.png"
  File "src\skins\outlineClose\knob35.png"
  File "src\skins\outlineClose\knob36.png"
  File "src\skins\outlineClose\knob37.png"
  File "src\skins\outlineClose\knob38.png"
  File "src\skins\outlineClose\knob39.png"
  File "src\skins\outlineClose\knob4.png"
  File "src\skins\outlineClose\knob40.png"
  File "src\skins\outlineClose\knob41.png"
  File "src\skins\outlineClose\knob42.png"
  File "src\skins\outlineClose\knob43.png"
  File "src\skins\outlineClose\knob44.png"
  File "src\skins\outlineClose\knob5.png"
  File "src\skins\outlineClose\knob6.png"
  File "src\skins\outlineClose\knob7.png"
  File "src\skins\outlineClose\knob8.png"
  File "src\skins\outlineClose\knob9.png"
  File "src\skins\outlineClose\knobg0.png"
  File "src\skins\outlineClose\knobg1.png"
  File "src\skins\outlineClose\knobg10.png"
  File "src\skins\outlineClose\knobg11.png"
  File "src\skins\outlineClose\knobg12.png"
  File "src\skins\outlineClose\knobg13.png"
  File "src\skins\outlineClose\knobg14.png"
  File "src\skins\outlineClose\knobg15.png"
  File "src\skins\outlineClose\knobg16.png"
  File "src\skins\outlineClose\knobg17.png"
  File "src\skins\outlineClose\knobg18.png"
  File "src\skins\outlineClose\knobg19.png"
  File "src\skins\outlineClose\knobg2.png"
  File "src\skins\outlineClose\knobg20.png"
  File "src\skins\outlineClose\knobg21.png"
  File "src\skins\outlineClose\knobg22.png"
  File "src\skins\outlineClose\knobg23.png"
  File "src\skins\outlineClose\knobg24.png"
  File "src\skins\outlineClose\knobg25.png"
  File "src\skins\outlineClose\knobg26.png"
  File "src\skins\outlineClose\knobg27.png"
  File "src\skins\outlineClose\knobg28.png"
  File "src\skins\outlineClose\knobg29.png"
  File "src\skins\outlineClose\knobg3.png"
  File "src\skins\outlineClose\knobg30.png"
  File "src\skins\outlineClose\knobg31.png"
  File "src\skins\outlineClose\knobg32.png"
  File "src\skins\outlineClose\knobg33.png"
  File "src\skins\outlineClose\knobg34.png"
  File "src\skins\outlineClose\knobg35.png"
  File "src\skins\outlineClose\knobg36.png"
  File "src\skins\outlineClose\knobg37.png"
  File "src\skins\outlineClose\knobg38.png"
  File "src\skins\outlineClose\knobg39.png"
  File "src\skins\outlineClose\knobg4.png"
  File "src\skins\outlineClose\knobg40.png"
  File "src\skins\outlineClose\knobg41.png"
  File "src\skins\outlineClose\knobg42.png"
  File "src\skins\outlineClose\knobg43.png"
  File "src\skins\outlineClose\knobg44.png"
  File "src\skins\outlineClose\knobg5.png"
  File "src\skins\outlineClose\knobg6.png"
  File "src\skins\outlineClose\knobg7.png"
  File "src\skins\outlineClose\knobg8.png"
  File "src\skins\outlineClose\knobg9.png"
  File "src\skins\outlineClose\knobl0.png"
  File "src\skins\outlineClose\knobl1.png"
  File "src\skins\outlineClose\knobl10.png"
  File "src\skins\outlineClose\knobl11.png"
  File "src\skins\outlineClose\knobl12.png"
  File "src\skins\outlineClose\knobl13.png"
  File "src\skins\outlineClose\knobl14.png"
  File "src\skins\outlineClose\knobl15.png"
  File "src\skins\outlineClose\knobl16.png"
  File "src\skins\outlineClose\knobl17.png"
  File "src\skins\outlineClose\knobl18.png"
  File "src\skins\outlineClose\knobl19.png"
  File "src\skins\outlineClose\knobl2.png"
  File "src\skins\outlineClose\knobl20.png"
  File "src\skins\outlineClose\knobl21.png"
  File "src\skins\outlineClose\knobl22.png"
  File "src\skins\outlineClose\knobl23.png"
  File "src\skins\outlineClose\knobl24.png"
  File "src\skins\outlineClose\knobl25.png"
  File "src\skins\outlineClose\knobl26.png"
  File "src\skins\outlineClose\knobl27.png"
  File "src\skins\outlineClose\knobl28.png"
  File "src\skins\outlineClose\knobl29.png"
  File "src\skins\outlineClose\knobl3.png"
  File "src\skins\outlineClose\knobl30.png"
  File "src\skins\outlineClose\knobl31.png"
  File "src\skins\outlineClose\knobl32.png"
  File "src\skins\outlineClose\knobl33.png"
  File "src\skins\outlineClose\knobl34.png"
  File "src\skins\outlineClose\knobl35.png"
  File "src\skins\outlineClose\knobl36.png"
  File "src\skins\outlineClose\knobl37.png"
  File "src\skins\outlineClose\knobl38.png"
  File "src\skins\outlineClose\knobl39.png"
  File "src\skins\outlineClose\knobl4.png"
  File "src\skins\outlineClose\knobl40.png"
  File "src\skins\outlineClose\knobl41.png"
  File "src\skins\outlineClose\knobl42.png"
  File "src\skins\outlineClose\knobl43.png"
  File "src\skins\outlineClose\knobl44.png"
  File "src\skins\outlineClose\knobl5.png"
  File "src\skins\outlineClose\knobl6.png"
  File "src\skins\outlineClose\knobl7.png"
  File "src\skins\outlineClose\knobl8.png"
  File "src\skins\outlineClose\knobl9.png"
  File "src\skins\outlineClose\knobm0.png"
  File "src\skins\outlineClose\knobm1.png"
  File "src\skins\outlineClose\knobm10.png"
  File "src\skins\outlineClose\knobm11.png"
  File "src\skins\outlineClose\knobm12.png"
  File "src\skins\outlineClose\knobm13.png"
  File "src\skins\outlineClose\knobm14.png"
  File "src\skins\outlineClose\knobm15.png"
  File "src\skins\outlineClose\knobm16.png"
  File "src\skins\outlineClose\knobm17.png"
  File "src\skins\outlineClose\knobm18.png"
  File "src\skins\outlineClose\knobm19.png"
  File "src\skins\outlineClose\knobm2.png"
  File "src\skins\outlineClose\knobm20.png"
  File "src\skins\outlineClose\knobm21.png"
  File "src\skins\outlineClose\knobm22.png"
  File "src\skins\outlineClose\knobm23.png"
  File "src\skins\outlineClose\knobm24.png"
  File "src\skins\outlineClose\knobm25.png"
  File "src\skins\outlineClose\knobm26.png"
  File "src\skins\outlineClose\knobm27.png"
  File "src\skins\outlineClose\knobm28.png"
  File "src\skins\outlineClose\knobm29.png"
  File "src\skins\outlineClose\knobm3.png"
  File "src\skins\outlineClose\knobm30.png"
  File "src\skins\outlineClose\knobm31.png"
  File "src\skins\outlineClose\knobm32.png"
  File "src\skins\outlineClose\knobm33.png"
  File "src\skins\outlineClose\knobm34.png"
  File "src\skins\outlineClose\knobm35.png"
  File "src\skins\outlineClose\knobm36.png"
  File "src\skins\outlineClose\knobm37.png"
  File "src\skins\outlineClose\knobm38.png"
  File "src\skins\outlineClose\knobm39.png"
  File "src\skins\outlineClose\knobm4.png"
  File "src\skins\outlineClose\knobm40.png"
  File "src\skins\outlineClose\knobm41.png"
  File "src\skins\outlineClose\knobm42.png"
  File "src\skins\outlineClose\knobm43.png"
  File "src\skins\outlineClose\knobm44.png"
  File "src\skins\outlineClose\knobm5.png"
  File "src\skins\outlineClose\knobm6.png"
  File "src\skins\outlineClose\knobm7.png"
  File "src\skins\outlineClose\knobm8.png"
  File "src\skins\outlineClose\knobm9.png"
  File "src\skins\outlineClose\knobr0.png"
  File "src\skins\outlineClose\knobr1.png"
  File "src\skins\outlineClose\knobr10.png"
  File "src\skins\outlineClose\knobr11.png"
  File "src\skins\outlineClose\knobr12.png"
  File "src\skins\outlineClose\knobr13.png"
  File "src\skins\outlineClose\knobr14.png"
  File "src\skins\outlineClose\knobr15.png"
  File "src\skins\outlineClose\knobr16.png"
  File "src\skins\outlineClose\knobr17.png"
  File "src\skins\outlineClose\knobr18.png"
  File "src\skins\outlineClose\knobr19.png"
  File "src\skins\outlineClose\knobr2.png"
  File "src\skins\outlineClose\knobr20.png"
  File "src\skins\outlineClose\knobr21.png"
  File "src\skins\outlineClose\knobr22.png"
  File "src\skins\outlineClose\knobr23.png"
  File "src\skins\outlineClose\knobr24.png"
  File "src\skins\outlineClose\knobr25.png"
  File "src\skins\outlineClose\knobr26.png"
  File "src\skins\outlineClose\knobr27.png"
  File "src\skins\outlineClose\knobr28.png"
  File "src\skins\outlineClose\knobr29.png"
  File "src\skins\outlineClose\knobr3.png"
  File "src\skins\outlineClose\knobr30.png"
  File "src\skins\outlineClose\knobr31.png"
  File "src\skins\outlineClose\knobr32.png"
  File "src\skins\outlineClose\knobr33.png"
  File "src\skins\outlineClose\knobr34.png"
  File "src\skins\outlineClose\knobr35.png"
  File "src\skins\outlineClose\knobr36.png"
  File "src\skins\outlineClose\knobr37.png"
  File "src\skins\outlineClose\knobr38.png"
  File "src\skins\outlineClose\knobr39.png"
  File "src\skins\outlineClose\knobr4.png"
  File "src\skins\outlineClose\knobr40.png"
  File "src\skins\outlineClose\knobr41.png"
  File "src\skins\outlineClose\knobr42.png"
  File "src\skins\outlineClose\knobr43.png"
  File "src\skins\outlineClose\knobr44.png"
  File "src\skins\outlineClose\knobr5.png"
  File "src\skins\outlineClose\knobr6.png"
  File "src\skins\outlineClose\knobr7.png"
  File "src\skins\outlineClose\knobr8.png"
  File "src\skins\outlineClose\knobr9.png"
  File "src\skins\outlineClose\play-off-Ch1.png"
  File "src\skins\outlineClose\play-off-Ch2.png"
  File "src\skins\outlineClose\play-on-Ch1.png"
  File "src\skins\outlineClose\play-on-Ch2.png"
  File "src\skins\outlineClose\playpos-marker1.png"
  File "src\skins\outlineClose\playpos-marker2.png"
  File "src\skins\outlineClose\playpos-slider.png"
  File "src\skins\outlineClose\ratedown-off-Ch1.png"
  File "src\skins\outlineClose\ratedown-off-Ch2.png"
  File "src\skins\outlineClose\ratedown-on-Ch1.png"
  File "src\skins\outlineClose\ratedown-on-Ch2.png"
  File "src\skins\outlineClose\ratehandle-off-Ch1.png"
  File "src\skins\outlineClose\ratehandle-off-Ch2.png"
  File "src\skins\outlineClose\ratehandle-on-Ch1.png"
  File "src\skins\outlineClose\ratehandle-on-Ch2.png"
  File "src\skins\outlineClose\rateslider-off-Ch1.png"
  File "src\skins\outlineClose\rateslider-off-Ch2.png"
  File "src\skins\outlineClose\rateslider-on-Ch1.png"
  File "src\skins\outlineClose\rateslider-on-Ch2.png"
  File "src\skins\outlineClose\rateup-off-Ch1.png"
  File "src\skins\outlineClose\rateup-off-Ch2.png"
  File "src\skins\outlineClose\rateup-on-Ch1.png"
  File "src\skins\outlineClose\rateup-on-Ch2.png"
  File "src\skins\outlineClose\rev-off-Ch1.png"
  File "src\skins\outlineClose\rev-off-Ch2.png"
  File "src\skins\outlineClose\rev-on-Ch1.png"
  File "src\skins\outlineClose\rev-on-Ch2.png"
  File "src\skins\outlineClose\scene.png"
  File "src\skins\outlineClose\skin.xml"
  File "src\skins\outlineClose\sync-off-Ch1.png"
  File "src\skins\outlineClose\sync-off-Ch2.png"
  File "src\skins\outlineClose\sync-on-Ch1.png"
  File "src\skins\outlineClose\sync-on-Ch2.png"
  File "src\skins\outlineClose\volhandle-off-Ch1.png"
  File "src\skins\outlineClose\volhandle-off-Ch2.png"
  File "src\skins\outlineClose\volhandle-on-Ch1.png"
  File "src\skins\outlineClose\volhandle-on-Ch2.png"
  File "src\skins\outlineClose\volslider-off-Ch1.png"
  File "src\skins\outlineClose\volslider-off-Ch2.png"
  File "src\skins\outlineClose\volslider-on-Ch1.png"
  File "src\skins\outlineClose\volslider-on-Ch2.png"
  File "src\skins\outlineClose\vumeter-off-.png"
  File "src\skins\outlineClose\vumeter-off-Ch1.png"
  File "src\skins\outlineClose\vumeter-off-Ch2.png"
  File "src\skins\outlineClose\vumeter-on-.png"
  File "src\skins\outlineClose\vumeter-on-Ch1.png"
  File "src\skins\outlineClose\vumeter-on-Ch2.png"
  
  SetOutPath $INSTDIR\skins\outlineSmall
  File "src\skins\outlineSmall\back-off-Ch1.png"
  File "src\skins\outlineSmall\back-off-Ch2.png"
  File "src\skins\outlineSmall\back-on-Ch1.png"
  File "src\skins\outlineSmall\back-on-Ch2.png"
  File "src\skins\outlineSmall\crosshandle-off-.png"
  File "src\skins\outlineSmall\crosshandle-on-.png"
  File "src\skins\outlineSmall\crossslider-off-.png"
  File "src\skins\outlineSmall\crossslider-on-.png"
  File "src\skins\outlineSmall\cue-off-Ch1.png"
  File "src\skins\outlineSmall\cue-off-Ch2.png"
  File "src\skins\outlineSmall\cue-on-Ch1.png"
  File "src\skins\outlineSmall\cue-on-Ch2.png"
  File "src\skins\outlineSmall\endoftrack-loop-ch1.png"
  File "src\skins\outlineSmall\endoftrack-loop-ch2.png"
  File "src\skins\outlineSmall\endoftrack-next-ch1.png"
  File "src\skins\outlineSmall\endoftrack-next-ch2.png"
  File "src\skins\outlineSmall\endoftrack-ping-ch1.png"
  File "src\skins\outlineSmall\endoftrack-ping-ch2.png"
  File "src\skins\outlineSmall\endoftrack-stop-ch1.png"
  File "src\skins\outlineSmall\endoftrack-stop-ch2.png"
  File "src\skins\outlineSmall\flanger-off-Ch1.png"
  File "src\skins\outlineSmall\flanger-off-Ch2.png"
  File "src\skins\outlineSmall\flanger-on-Ch1.png"
  File "src\skins\outlineSmall\flanger-on-Ch2.png"
  File "src\skins\outlineSmall\fwd-off-Ch1.png"
  File "src\skins\outlineSmall\fwd-off-Ch2.png"
  File "src\skins\outlineSmall\fwd-on-Ch1.png"
  File "src\skins\outlineSmall\fwd-on-Ch2.png"
  File "src\skins\outlineSmall\head-off-Ch1.png"
  File "src\skins\outlineSmall\head-off-Ch2.png"
  File "src\skins\outlineSmall\head-on-Ch1.png"
  File "src\skins\outlineSmall\head-on-Ch2.png"
  File "src\skins\outlineSmall\knob0.png"
  File "src\skins\outlineSmall\knob1.png"
  File "src\skins\outlineSmall\knob10.png"
  File "src\skins\outlineSmall\knob11.png"
  File "src\skins\outlineSmall\knob12.png"
  File "src\skins\outlineSmall\knob13.png"
  File "src\skins\outlineSmall\knob14.png"
  File "src\skins\outlineSmall\knob15.png"
  File "src\skins\outlineSmall\knob16.png"
  File "src\skins\outlineSmall\knob17.png"
  File "src\skins\outlineSmall\knob18.png"
  File "src\skins\outlineSmall\knob19.png"
  File "src\skins\outlineSmall\knob2.png"
  File "src\skins\outlineSmall\knob20.png"
  File "src\skins\outlineSmall\knob21.png"
  File "src\skins\outlineSmall\knob22.png"
  File "src\skins\outlineSmall\knob23.png"
  File "src\skins\outlineSmall\knob24.png"
  File "src\skins\outlineSmall\knob25.png"
  File "src\skins\outlineSmall\knob26.png"
  File "src\skins\outlineSmall\knob27.png"
  File "src\skins\outlineSmall\knob28.png"
  File "src\skins\outlineSmall\knob29.png"
  File "src\skins\outlineSmall\knob3.png"
  File "src\skins\outlineSmall\knob30.png"
  File "src\skins\outlineSmall\knob31.png"
  File "src\skins\outlineSmall\knob32.png"
  File "src\skins\outlineSmall\knob33.png"
  File "src\skins\outlineSmall\knob34.png"
  File "src\skins\outlineSmall\knob35.png"
  File "src\skins\outlineSmall\knob36.png"
  File "src\skins\outlineSmall\knob37.png"
  File "src\skins\outlineSmall\knob38.png"
  File "src\skins\outlineSmall\knob39.png"
  File "src\skins\outlineSmall\knob4.png"
  File "src\skins\outlineSmall\knob40.png"
  File "src\skins\outlineSmall\knob41.png"
  File "src\skins\outlineSmall\knob42.png"
  File "src\skins\outlineSmall\knob43.png"
  File "src\skins\outlineSmall\knob44.png"
  File "src\skins\outlineSmall\knob5.png"
  File "src\skins\outlineSmall\knob6.png"
  File "src\skins\outlineSmall\knob7.png"
  File "src\skins\outlineSmall\knob8.png"
  File "src\skins\outlineSmall\knob9.png"
  File "src\skins\outlineSmall\knobg0.png"
  File "src\skins\outlineSmall\knobg1.png"
  File "src\skins\outlineSmall\knobg10.png"
  File "src\skins\outlineSmall\knobg11.png"
  File "src\skins\outlineSmall\knobg12.png"
  File "src\skins\outlineSmall\knobg13.png"
  File "src\skins\outlineSmall\knobg14.png"
  File "src\skins\outlineSmall\knobg15.png"
  File "src\skins\outlineSmall\knobg16.png"
  File "src\skins\outlineSmall\knobg17.png"
  File "src\skins\outlineSmall\knobg18.png"
  File "src\skins\outlineSmall\knobg19.png"
  File "src\skins\outlineSmall\knobg2.png"
  File "src\skins\outlineSmall\knobg20.png"
  File "src\skins\outlineSmall\knobg21.png"
  File "src\skins\outlineSmall\knobg22.png"
  File "src\skins\outlineSmall\knobg23.png"
  File "src\skins\outlineSmall\knobg24.png"
  File "src\skins\outlineSmall\knobg25.png"
  File "src\skins\outlineSmall\knobg26.png"
  File "src\skins\outlineSmall\knobg27.png"
  File "src\skins\outlineSmall\knobg28.png"
  File "src\skins\outlineSmall\knobg29.png"
  File "src\skins\outlineSmall\knobg3.png"
  File "src\skins\outlineSmall\knobg30.png"
  File "src\skins\outlineSmall\knobg31.png"
  File "src\skins\outlineSmall\knobg32.png"
  File "src\skins\outlineSmall\knobg33.png"
  File "src\skins\outlineSmall\knobg34.png"
  File "src\skins\outlineSmall\knobg35.png"
  File "src\skins\outlineSmall\knobg36.png"
  File "src\skins\outlineSmall\knobg37.png"
  File "src\skins\outlineSmall\knobg38.png"
  File "src\skins\outlineSmall\knobg39.png"
  File "src\skins\outlineSmall\knobg4.png"
  File "src\skins\outlineSmall\knobg40.png"
  File "src\skins\outlineSmall\knobg41.png"
  File "src\skins\outlineSmall\knobg42.png"
  File "src\skins\outlineSmall\knobg43.png"
  File "src\skins\outlineSmall\knobg44.png"
  File "src\skins\outlineSmall\knobg5.png"
  File "src\skins\outlineSmall\knobg6.png"
  File "src\skins\outlineSmall\knobg7.png"
  File "src\skins\outlineSmall\knobg8.png"
  File "src\skins\outlineSmall\knobg9.png"
  File "src\skins\outlineSmall\knobl0.png"
  File "src\skins\outlineSmall\knobl1.png"
  File "src\skins\outlineSmall\knobl10.png"
  File "src\skins\outlineSmall\knobl11.png"
  File "src\skins\outlineSmall\knobl12.png"
  File "src\skins\outlineSmall\knobl13.png"
  File "src\skins\outlineSmall\knobl14.png"
  File "src\skins\outlineSmall\knobl15.png"
  File "src\skins\outlineSmall\knobl16.png"
  File "src\skins\outlineSmall\knobl17.png"
  File "src\skins\outlineSmall\knobl18.png"
  File "src\skins\outlineSmall\knobl19.png"
  File "src\skins\outlineSmall\knobl2.png"
  File "src\skins\outlineSmall\knobl20.png"
  File "src\skins\outlineSmall\knobl21.png"
  File "src\skins\outlineSmall\knobl22.png"
  File "src\skins\outlineSmall\knobl23.png"
  File "src\skins\outlineSmall\knobl24.png"
  File "src\skins\outlineSmall\knobl25.png"
  File "src\skins\outlineSmall\knobl26.png"
  File "src\skins\outlineSmall\knobl27.png"
  File "src\skins\outlineSmall\knobl28.png"
  File "src\skins\outlineSmall\knobl29.png"
  File "src\skins\outlineSmall\knobl3.png"
  File "src\skins\outlineSmall\knobl30.png"
  File "src\skins\outlineSmall\knobl31.png"
  File "src\skins\outlineSmall\knobl32.png"
  File "src\skins\outlineSmall\knobl33.png"
  File "src\skins\outlineSmall\knobl34.png"
  File "src\skins\outlineSmall\knobl35.png"
  File "src\skins\outlineSmall\knobl36.png"
  File "src\skins\outlineSmall\knobl37.png"
  File "src\skins\outlineSmall\knobl38.png"
  File "src\skins\outlineSmall\knobl39.png"
  File "src\skins\outlineSmall\knobl4.png"
  File "src\skins\outlineSmall\knobl40.png"
  File "src\skins\outlineSmall\knobl41.png"
  File "src\skins\outlineSmall\knobl42.png"
  File "src\skins\outlineSmall\knobl43.png"
  File "src\skins\outlineSmall\knobl44.png"
  File "src\skins\outlineSmall\knobl5.png"
  File "src\skins\outlineSmall\knobl6.png"
  File "src\skins\outlineSmall\knobl7.png"
  File "src\skins\outlineSmall\knobl8.png"
  File "src\skins\outlineSmall\knobl9.png"
  File "src\skins\outlineSmall\knobm0.png"
  File "src\skins\outlineSmall\knobm1.png"
  File "src\skins\outlineSmall\knobm10.png"
  File "src\skins\outlineSmall\knobm11.png"
  File "src\skins\outlineSmall\knobm12.png"
  File "src\skins\outlineSmall\knobm13.png"
  File "src\skins\outlineSmall\knobm14.png"
  File "src\skins\outlineSmall\knobm15.png"
  File "src\skins\outlineSmall\knobm16.png"
  File "src\skins\outlineSmall\knobm17.png"
  File "src\skins\outlineSmall\knobm18.png"
  File "src\skins\outlineSmall\knobm19.png"
  File "src\skins\outlineSmall\knobm2.png"
  File "src\skins\outlineSmall\knobm20.png"
  File "src\skins\outlineSmall\knobm21.png"
  File "src\skins\outlineSmall\knobm22.png"
  File "src\skins\outlineSmall\knobm23.png"
  File "src\skins\outlineSmall\knobm24.png"
  File "src\skins\outlineSmall\knobm25.png"
  File "src\skins\outlineSmall\knobm26.png"
  File "src\skins\outlineSmall\knobm27.png"
  File "src\skins\outlineSmall\knobm28.png"
  File "src\skins\outlineSmall\knobm29.png"
  File "src\skins\outlineSmall\knobm3.png"
  File "src\skins\outlineSmall\knobm30.png"
  File "src\skins\outlineSmall\knobm31.png"
  File "src\skins\outlineSmall\knobm32.png"
  File "src\skins\outlineSmall\knobm33.png"
  File "src\skins\outlineSmall\knobm34.png"
  File "src\skins\outlineSmall\knobm35.png"
  File "src\skins\outlineSmall\knobm36.png"
  File "src\skins\outlineSmall\knobm37.png"
  File "src\skins\outlineSmall\knobm38.png"
  File "src\skins\outlineSmall\knobm39.png"
  File "src\skins\outlineSmall\knobm4.png"
  File "src\skins\outlineSmall\knobm40.png"
  File "src\skins\outlineSmall\knobm41.png"
  File "src\skins\outlineSmall\knobm42.png"
  File "src\skins\outlineSmall\knobm43.png"
  File "src\skins\outlineSmall\knobm44.png"
  File "src\skins\outlineSmall\knobm5.png"
  File "src\skins\outlineSmall\knobm6.png"
  File "src\skins\outlineSmall\knobm7.png"
  File "src\skins\outlineSmall\knobm8.png"
  File "src\skins\outlineSmall\knobm9.png"
  File "src\skins\outlineSmall\knobr0.png"
  File "src\skins\outlineSmall\knobr1.png"
  File "src\skins\outlineSmall\knobr10.png"
  File "src\skins\outlineSmall\knobr11.png"
  File "src\skins\outlineSmall\knobr12.png"
  File "src\skins\outlineSmall\knobr13.png"
  File "src\skins\outlineSmall\knobr14.png"
  File "src\skins\outlineSmall\knobr15.png"
  File "src\skins\outlineSmall\knobr16.png"
  File "src\skins\outlineSmall\knobr17.png"
  File "src\skins\outlineSmall\knobr18.png"
  File "src\skins\outlineSmall\knobr19.png"
  File "src\skins\outlineSmall\knobr2.png"
  File "src\skins\outlineSmall\knobr20.png"
  File "src\skins\outlineSmall\knobr21.png"
  File "src\skins\outlineSmall\knobr22.png"
  File "src\skins\outlineSmall\knobr23.png"
  File "src\skins\outlineSmall\knobr24.png"
  File "src\skins\outlineSmall\knobr25.png"
  File "src\skins\outlineSmall\knobr26.png"
  File "src\skins\outlineSmall\knobr27.png"
  File "src\skins\outlineSmall\knobr28.png"
  File "src\skins\outlineSmall\knobr29.png"
  File "src\skins\outlineSmall\knobr3.png"
  File "src\skins\outlineSmall\knobr30.png"
  File "src\skins\outlineSmall\knobr31.png"
  File "src\skins\outlineSmall\knobr32.png"
  File "src\skins\outlineSmall\knobr33.png"
  File "src\skins\outlineSmall\knobr34.png"
  File "src\skins\outlineSmall\knobr35.png"
  File "src\skins\outlineSmall\knobr36.png"
  File "src\skins\outlineSmall\knobr37.png"
  File "src\skins\outlineSmall\knobr38.png"
  File "src\skins\outlineSmall\knobr39.png"
  File "src\skins\outlineSmall\knobr4.png"
  File "src\skins\outlineSmall\knobr40.png"
  File "src\skins\outlineSmall\knobr41.png"
  File "src\skins\outlineSmall\knobr42.png"
  File "src\skins\outlineSmall\knobr43.png"
  File "src\skins\outlineSmall\knobr44.png"
  File "src\skins\outlineSmall\knobr5.png"
  File "src\skins\outlineSmall\knobr6.png"
  File "src\skins\outlineSmall\knobr7.png"
  File "src\skins\outlineSmall\knobr8.png"
  File "src\skins\outlineSmall\knobr9.png"
  File "src\skins\outlineSmall\play-off-Ch1.png"
  File "src\skins\outlineSmall\play-off-Ch2.png"
  File "src\skins\outlineSmall\play-on-Ch1.png"
  File "src\skins\outlineSmall\play-on-Ch2.png"
  File "src\skins\outlineSmall\playpos-marker1.png"
  File "src\skins\outlineSmall\playpos-marker2.png"
  File "src\skins\outlineSmall\playpos-slider.png"
  File "src\skins\outlineSmall\ratedown-off-Ch1.png"
  File "src\skins\outlineSmall\ratedown-off-Ch2.png"
  File "src\skins\outlineSmall\ratedown-on-Ch1.png"
  File "src\skins\outlineSmall\ratedown-on-Ch2.png"
  File "src\skins\outlineSmall\ratehandle-off-Ch1.png"
  File "src\skins\outlineSmall\ratehandle-off-Ch2.png"
  File "src\skins\outlineSmall\ratehandle-on-Ch1.png"
  File "src\skins\outlineSmall\ratehandle-on-Ch2.png"
  File "src\skins\outlineSmall\rateslider-off-Ch1.png"
  File "src\skins\outlineSmall\rateslider-off-Ch2.png"
  File "src\skins\outlineSmall\rateslider-on-Ch1.png"
  File "src\skins\outlineSmall\rateslider-on-Ch2.png"
  File "src\skins\outlineSmall\rateup-off-Ch1.png"
  File "src\skins\outlineSmall\rateup-off-Ch2.png"
  File "src\skins\outlineSmall\rateup-on-Ch1.png"
  File "src\skins\outlineSmall\rateup-on-Ch2.png"
  File "src\skins\outlineSmall\rev-off-Ch1.png"
  File "src\skins\outlineSmall\rev-off-Ch2.png"
  File "src\skins\outlineSmall\rev-on-Ch1.png"
  File "src\skins\outlineSmall\rev-on-Ch2.png"
  File "src\skins\outlineSmall\scene.png"
  File "src\skins\outlineSmall\skin.xml"
  File "src\skins\outlineSmall\sync-off-Ch1.png"
  File "src\skins\outlineSmall\sync-off-Ch2.png"
  File "src\skins\outlineSmall\sync-on-Ch1.png"
  File "src\skins\outlineSmall\sync-on-Ch2.png"
  File "src\skins\outlineSmall\volhandle-off-Ch1.png"
  File "src\skins\outlineSmall\volhandle-off-Ch2.png"
  File "src\skins\outlineSmall\volhandle-on-Ch1.png"
  File "src\skins\outlineSmall\volhandle-on-Ch2.png"
  File "src\skins\outlineSmall\volslider-off-Ch1.png"
  File "src\skins\outlineSmall\volslider-off-Ch2.png"
  File "src\skins\outlineSmall\volslider-on-Ch1.png"
  File "src\skins\outlineSmall\volslider-on-Ch2.png"
  File "src\skins\outlineSmall\vumeter-off-.png"
  File "src\skins\outlineSmall\vumeter-off-Ch1.png"
  File "src\skins\outlineSmall\vumeter-off-Ch2.png"
  File "src\skins\outlineSmall\vumeter-on-.png"
  File "src\skins\outlineSmall\vumeter-on-Ch1.png"
  File "src\skins\outlineSmall\vumeter-on-Ch2.png"
  
  SetOutPath $INSTDIR\skins\traditional
  File "src\skins\traditional\balanceback.png"
  File "src\skins\traditional\cross.png"
  File "src\skins\traditional\cue0.png"
  File "src\skins\traditional\cue1.png"
  File "src\skins\traditional\cue2.png"
  File "src\skins\traditional\cue3.png"
  File "src\skins\traditional\cue4.png"
  File "src\skins\traditional\cue5.png"
  File "src\skins\traditional\cueback1.png"
  File "src\skins\traditional\cueback2.png"
  File "src\skins\traditional\cuec0.png"
  File "src\skins\traditional\cuec1.png"
  File "src\skins\traditional\cuec2.png"
  File "src\skins\traditional\cuec3.png"
  File "src\skins\traditional\cuec4.png"
  File "src\skins\traditional\cuec5.png"
  File "src\skins\traditional\cuecback1.png"
  File "src\skins\traditional\cuecback2.png"
  File "src\skins\traditional\down0.png"
  File "src\skins\traditional\down1.png"
  File "src\skins\traditional\down2.png"
  File "src\skins\traditional\down3.png"
  File "src\skins\traditional\down4.png"
  File "src\skins\traditional\down5.png"
  File "src\skins\traditional\downback1.png"
  File "src\skins\traditional\endoftrackmode-loop.png"
  File "src\skins\traditional\endoftrackmode-next.png"
  File "src\skins\traditional\endoftrackmode-ping.png"
  File "src\skins\traditional\endoftrackmode-stop.png"
  File "src\skins\traditional\filterhighback1.png"
  File "src\skins\traditional\filterhighback2.png"
  File "src\skins\traditional\filterlowback1.png"
  File "src\skins\traditional\filterlowback2.png"
  File "src\skins\traditional\filtermidback1.png"
  File "src\skins\traditional\filtermidback2.png"
  File "src\skins\traditional\gainback1.png"
  File "src\skins\traditional\gainback2.png"
  File "src\skins\traditional\headmixback.png"
  File "src\skins\traditional\headvolback.png"
  File "src\skins\traditional\knob.png"
  File "src\skins\traditional\knob0.png"
  File "src\skins\traditional\knob1.png"
  File "src\skins\traditional\knob10.png"
  File "src\skins\traditional\knob11.png"
  File "src\skins\traditional\knob12.png"
  File "src\skins\traditional\knob13.png"
  File "src\skins\traditional\knob14.png"
  File "src\skins\traditional\knob15.png"
  File "src\skins\traditional\knob16.png"
  File "src\skins\traditional\knob17.png"
  File "src\skins\traditional\knob18.png"
  File "src\skins\traditional\knob19.png"
  File "src\skins\traditional\knob2.png"
  File "src\skins\traditional\knob20.png"
  File "src\skins\traditional\knob21.png"
  File "src\skins\traditional\knob22.png"
  File "src\skins\traditional\knob23.png"
  File "src\skins\traditional\knob24.png"
  File "src\skins\traditional\knob25.png"
  File "src\skins\traditional\knob26.png"
  File "src\skins\traditional\knob27.png"
  File "src\skins\traditional\knob28.png"
  File "src\skins\traditional\knob29.png"
  File "src\skins\traditional\knob3.png"
  File "src\skins\traditional\knob30.png"
  File "src\skins\traditional\knob4.png"
  File "src\skins\traditional\knob5.png"
  File "src\skins\traditional\knob6.png"
  File "src\skins\traditional\knob7.png"
  File "src\skins\traditional\knob8.png"
  File "src\skins\traditional\knob9.png"
  File "src\skins\traditional\knobold.png"
  File "src\skins\traditional\ledl1.png"
  File "src\skins\traditional\ledl2.png"
  File "src\skins\traditional\ledl3.png"
  File "src\skins\traditional\ledl4.png"
  File "src\skins\traditional\ledr1.png"
  File "src\skins\traditional\ledr2.png"
  File "src\skins\traditional\ledr3.png"
  File "src\skins\traditional\ledr4.png"
  File "src\skins\traditional\main.png"
  File "src\skins\traditional\masterback.png"
  File "src\skins\traditional\pgm0.png"
  File "src\skins\traditional\pgm1.png"
  File "src\skins\traditional\pgm2.png"
  File "src\skins\traditional\pitchleft.png"
  File "src\skins\traditional\pitchright.png"
  File "src\skins\traditional\play0.png"
  File "src\skins\traditional\play1.png"
  File "src\skins\traditional\play2.png"
  File "src\skins\traditional\play3.png"
  File "src\skins\traditional\play4.png"
  File "src\skins\traditional\play5.png"
  File "src\skins\traditional\playback1.png"
  File "src\skins\traditional\playback2.png"
  File "src\skins\traditional\playposmarker.png"
  File "src\skins\traditional\playposslider.png"
  File "src\skins\traditional\skin.xml"
  File "src\skins\traditional\sliderhandle1.png"
  File "src\skins\traditional\sliderhandle3.png"
  File "src\skins\traditional\step0.png"
  File "src\skins\traditional\step1.png"
  File "src\skins\traditional\step2.png"
  File "src\skins\traditional\stop0.png"
  File "src\skins\traditional\stop1.png"
  File "src\skins\traditional\stop2.png"
  File "src\skins\traditional\stop3.png"
  File "src\skins\traditional\stop4.png"
  File "src\skins\traditional\stop5.png"
  File "src\skins\traditional\up0.png"
  File "src\skins\traditional\up1.png"
  File "src\skins\traditional\up2.png"
  File "src\skins\traditional\up3.png"
  File "src\skins\traditional\up4.png"
  File "src\skins\traditional\up5.png"
  File "src\skins\traditional\upback1.png"
  File "src\skins\traditional\volleft.png"
  File "src\skins\traditional\volright.png"
  File "src\skins\traditional\vpred0.png"
  File "src\skins\traditional\vpred1.png"
  File "src\skins\traditional\vpred2.png"
  File "src\skins\traditional\vpred3.png"
  File "src\skins\traditional\vpred4.png"
  File "src\skins\traditional\vpred5.png"
  File "src\skins\traditional\vpredback.png"
  File "src\skins\traditional\vu0l.png"
  File "src\skins\traditional\vu0r.png"
  File "src\skins\traditional\vu10l.png"
  File "src\skins\traditional\vu10r.png"
  File "src\skins\traditional\vu11l.png"
  File "src\skins\traditional\vu11r.png"
  File "src\skins\traditional\vu12l.png"
  File "src\skins\traditional\vu12r.png"
  File "src\skins\traditional\vu13l.png"
  File "src\skins\traditional\vu13r.png"
  File "src\skins\traditional\vu14l.png"
  File "src\skins\traditional\vu14r.png"
  File "src\skins\traditional\vu15l.png"
  File "src\skins\traditional\vu15r.png"
  File "src\skins\traditional\vu16l.png"
  File "src\skins\traditional\vu16r.png"
  File "src\skins\traditional\vu17l.png"
  File "src\skins\traditional\vu17r.png"
  File "src\skins\traditional\vu18l.png"
  File "src\skins\traditional\vu18r.png"
  File "src\skins\traditional\vu19l.png"
  File "src\skins\traditional\vu19r.png"
  File "src\skins\traditional\vu1l.png"
  File "src\skins\traditional\vu1r.png"
  File "src\skins\traditional\vu20l.png"
  File "src\skins\traditional\vu20r.png"
  File "src\skins\traditional\vu21l.png"
  File "src\skins\traditional\vu21r.png"
  File "src\skins\traditional\vu22l.png"
  File "src\skins\traditional\vu22r.png"
  File "src\skins\traditional\vu23l.png"
  File "src\skins\traditional\vu23r.png"
  File "src\skins\traditional\vu24l.png"
  File "src\skins\traditional\vu24r.png"
  File "src\skins\traditional\vu25l.png"
  File "src\skins\traditional\vu25r.png"
  File "src\skins\traditional\vu26l.png"
  File "src\skins\traditional\vu26r.png"
  File "src\skins\traditional\vu27l.png"
  File "src\skins\traditional\vu27r.png"
  File "src\skins\traditional\vu28l.png"
  File "src\skins\traditional\vu28r.png"
  File "src\skins\traditional\vu29l.png"
  File "src\skins\traditional\vu29r.png"
  File "src\skins\traditional\vu2l.png"
  File "src\skins\traditional\vu2r.png"
  File "src\skins\traditional\vu30l.png"
  File "src\skins\traditional\vu30r.png"
  File "src\skins\traditional\vu31l.png"
  File "src\skins\traditional\vu31r.png"
  File "src\skins\traditional\vu32l.png"
  File "src\skins\traditional\vu32r.png"
  File "src\skins\traditional\vu3l.png"
  File "src\skins\traditional\vu3r.png"
  File "src\skins\traditional\vu4l.png"
  File "src\skins\traditional\vu4r.png"
  File "src\skins\traditional\vu5l.png"
  File "src\skins\traditional\vu5r.png"
  File "src\skins\traditional\vu6l.png"
  File "src\skins\traditional\vu6r.png"
  File "src\skins\traditional\vu7l.png"
  File "src\skins\traditional\vu7r.png"
  File "src\skins\traditional\vu8l.png"
  File "src\skins\traditional\vu8r.png"
  File "src\skins\traditional\vu9l.png"
  File "src\skins\traditional\vu9r.png"
  File "src\skins\traditional\zpet0.png"
  File "src\skins\traditional\zpet1.png"
  File "src\skins\traditional\zpet2.png"
  File "src\skins\traditional\zpet3.png"
  File "src\skins\traditional\zpet4.png"
  File "src\skins\traditional\zpet5.png"
  File "src\skins\traditional\zpetback.png"

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\NSIS_Mixxx "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Mixxx" "DisplayName" "NSIS Mixxx"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Mixxx" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Mixxx" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Mixxx" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts" SecStartMenu

  CreateDirectory "$SMPROGRAMS\Mixxx"
  SetOutPath $INSTDIR
  CreateShortCut "$SMPROGRAMS\Mixxx\Mixxx.lnk" "$INSTDIR\mixxx.exe" "" "$INSTDIR\mixxx.exe" 0
  CreateShortCut "$SMPROGRAMS\Mixxx\Manual.lnk" "$INSTDIR\Mixxx-Manual.pdf" "" "$INSTDIR\Mixxx-Manual.pdf" 0
  CreateShortCut "$SMPROGRAMS\Mixxx\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Desktop Shortcut" SecDesktop

  SetOutPath $INSTDIR
  CreateShortCut "$DESKTOP\Mixxx.lnk" "$INSTDIR\mixxx.exe" "" "$INSTDIR\mixxx.exe" 0
  
SectionEnd

;--------------------------------
;Descriptions

  ;Language strings
  LangString DESC_SecMixxx ${LANG_ENGLISH} "Mixxx software."
  LangString DESC_SecStartMenu ${LANG_ENGLISH} "Start menu shortcuts."
  LangString DESC_SecDesktop ${LANG_ENGLISH} "Desktop shortcut."

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecMixxx} $(DESC_SecMixxx)
    !insertmacro MUI_DESCRIPTION_TEXT ${SecStartMenu} $(DESC_SecStartMenu)
    !insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END


;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Mixxx"
  DeleteRegKey HKLM SOFTWARE\NSIS_Mixxx

  ; Remove files and uninstaller
  Delete $INSTDIR\mixxx.exe
  Delete $INSTDIR\mixxx.log
  Delete $INSTDIR\*.dll
  Delete $INSTDIR\uninstall.exe
  Delete $INSTDIR\Mixxx-Manual.pdf
  Delete $INSTDIR\LICENSE
  Delete $INSTDIR\README
  Delete $INSTDIR\COPYING

  Delete $INSTDIR\Microsoft.VC80.CRT.manifest

  ; Remove skins, keyboard, midi defs
  Delete $INSTDIR\skins\outline\*.*
  Delete $INSTDIR\skins\outlineClose\*.*
  Delete $INSTDIR\skins\outlineSmall\*.*
  Delete $INSTDIR\skins\outlineMini\*.*
  Delete "$INSTDIR\skins\Collusion (1280)\*.*"
  Delete "$INSTDIR\skins\Collusion (1280-WS)\*.*"
  Delete $INSTDIR\skins\hercules\*.*
  Delete $INSTDIR\skins\nCut\*.*
  Delete $INSTDIR\skins\traditional\*.*
  Delete $INSTDIR\skins\*.*
  Delete $INSTDIR\keyboard\*.*
  Delete $INSTDIR\midi\*.*
  ;Delete $INSTDIR\promo\*.*
  RMDir "$INSTDIR\skins\outline"
  RMDir "$INSTDIR\skins\outlineClose"
  RMDir "$INSTDIR\skins\outlineSmall"
  RMDir "$INSTDIR\skins\outlineMini"
  RMDir "$INSTDIR\skins\Collusion (1280)"
  RMDir "$INSTDIR\skins\Collusion (1280-WS)"
  RMDir "$INSTDIR\skins\hercules"
  RMDir "$INSTDIR\skins\nCut"
  RMDir "$INSTDIR\skins\traditional"
  RMDir "$INSTDIR\skins"
  RMDir "$INSTDIR\midi"
  RMDir "$INSTDIR\keyboard"
  ;RMDir "$INSTDIR\promo"


  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\Mixxx\*.*"
  Delete "$DESKTOP\Mixxx.lnk"

  ; Remove directories used
  RMDir "$SMPROGRAMS\Mixxx"
  RMDir "$INSTDIR"

SectionEnd
