      SUBROUTINE MN_PRT
C
C     EITHER PARTITIONS OR REBINS A HISTOGRAM
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER IFBIN(MDIMMX),IPLO(MDIMMX),IPHI(MDIMMX)
      REAL AFLO(MDIMMX),AFHI(MDIMMX)
      INTEGER IPCMB(MDIMMX)
C
      CHARACTER*255 TEXT,CONCAT
      INTEGER INUM(10),lent
      REAL RNUM(10)
      LOGICAL QERRL,QERRH
      integer lnblnk
      LOGICAL HEXIST
      external lnblnk,hexist
C
      CALL WAITYQ('Give histogram number: ')
      CALL MN_HNO(IDA,IDB,IDELIM,NNID)
      IF(IDA.LE.0) GOTO 9000
C
C     SEE IF HISTOGRAM EXISTS
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' does not exist'')') IDA,IDB
          CALL MN_ERR('MN_PRT',TXTERR)
          GOTO 9000
      ENDIF
C
C     CHECK WHETHER I CAN CARRY OUT THE OPERATION
C
      IF(IABS(NDIM).GT.2) THEN
          IF(COMND1.EQ.'PARTITION') THEN
              CALL MN_ERR('MN_PRT'
     +         ,'I can only partition 1 or 2-dimensional histograms')
          ELSEIF(COMND1.EQ.'REBIN') THEN
              CALL MN_ERR('MN_PRT'
     +         ,'I can only rebin 1 or 2-dimensional histograms')
          ENDIF
          GOTO 9000
      ELSE IF(COMND1.EQ.'PARTITION' .AND. NDIM.EQ.-2) THEN
          CALL MN_ERR('MN_PRT'
     +     ,'I cannot partition a true scatter plot.' //
     +      ' Use the PROJECT command instead')
          GOTO 9000
      ELSE IF(COMND1.EQ.'REBIN' .AND. NDIM.LT.0) THEN
          CALL MN_ERR('MN_PRT'
     +     ,'I can only rebin binned histograms.')
          CALL MN_ERR('MN_PRT'
     +     ,'Use the project command to make a binned from' //
     +      ' from an unbinned plot')
          GOTO 9000
      ENDIF
C
      CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
C
C     GET PARTITION LIMITS
C
      IF(COMND1.EQ.'PARTITION') THEN
          DO 2500 NAX=1,IABS(NDIM)
              AFLO(NAX) = ADLO(NAX)
              AFHI(NAX) = ADHI(NAX)
              TEXT = CONCAT(TDNAM(NAX,NH),'axis.')
              IF(IDELIM.LT.0) WRITE(LUNTTO,'(1X,A)') TEXT
              CALL MN_BLM(2,ntmode,IDELIM,COMND1
     +         ,NDUM,AFLO(NAX),AFHI(NAX),NNUM,IERR)
              IF(IERR.NE.0) GOTO 9000
C
              IF(AFLO(NAX).EQ.0.0 .AND. AFHI(NAX).EQ.0.0) THEN
                  CALL MN_ERR('MN_PRT','No partition done.' //
     1             ' Lower and upper edges are 0.0')
                  GOTO 9000
C
              ELSEIF(AFLO(NAX).GE.AFHI(NAX)) THEN
                  WRITE(TXTERR,'(''Lower edge'',G11.4
     1             ,'' greater then upper edge'',G11.4)')
     2             AFLO(NAX),AFHI(NAX)
                  CALL MN_ERR('MN_PRT',TXTERR)
                  GOTO 9000
C
              ELSEIF(ADLO(NAX).GE.ADHI(NAX)) THEN
                  WRITE(TXTERR,'(''Plot'',I7,I4,'' is screwed up!!'')')
     +             IDA,IDB
                  CALL M_EMSG('MN_PRT',TXTERR)
                  WRITE(TXTERR,'('' Lower edge'',G11.4
     1               ,'' greater then upper edge'',G11.4)')
     2             ADLO(NAX),ADHI(NAX)
                  CALL MN_ERR('MN_PRT',TXTERR)
                  GOTO 9000
C
              ELSEIF(NDIM.GT.0 .AND.
     +               (ADLO(NAX).GT.AFLO(NAX) .OR.
     +                ADHI(NAX).LT.AFHI(NAX))) THEN
                  WRITE(TXTMES,'('' WARNING: Either the upper''
     1             ,'' or lower limits of the histogram'')')
                  CALL MN_MES(LUNTTO,'M',TXTMES)
                  WRITE(TXTMES,'('' are inside the partition range:''
     1               ,'' Histogram limits:'',2G11.4)')
     1             ADLO(NAX),ADHI(NAX)
                  CALL MN_MES(LUNTTO,'ME',TXTMES)
              ENDIF
C
              IPLO(NAX) = NPNT
              IPHI(NAX) = 0
              NCOMB = 1
              IPCMB(NAX) = NCOMB
              IF(IDBIN(NAX).NE.0) DX = (ADHI(NAX) - ADLO(NAX)) /
     1         FLOAT(IDBIN(NAX))
              IF(NDIM.LT.0) THEN
                  IUP = 0
                  DO 2200 II=1,NPNT
                      IF(IUP.EQ.0 .AND. II.GE.2) THEN
                          IF(X.GT.XLAST) THEN
                              IUP = 1
                          ELSEIF(X.LT.XLAST) THEN
                              IUP = -1
                          ENDIF
                      ENDIF
                      X = AMNP(II,NH,NAX,1,IERR)
                      IF(X.GE.AFLO(NAX) .AND. X.LE.AFHI(NAX))
     +                 IPLO(NAX) = MIN0(II,IPLO(NAX))
                      IF(X.GE.AFLO(NAX) .AND. X.LE.AFHI(NAX))
     +                 IPHI(NAX) = MAX0(II,IPHI(NAX))
                      IF((IUP.EQ.1   .AND. X.LT.XLAST) .OR.
     +                   (IUP.EQ.-1  .AND. X.GT.XLAST)) THEN
                          CALL M_EMSG('MN_PRT'
     +                     ,'Data is not monotonically increasing or' //
     +                      ' decreasing. Partition may not be correct')
                      ENDIF
                      XLAST = X
2200              CONTINUE
              ELSE
                  IPLO(NAX) = IFIX((AFLO(NAX) - ADLO(NAX))/DX + 0.5) + 1
                  IPLO(NAX) = MAX0(1,IPLO(NAX))
                  IPLO(NAX) = MIN0(IDBIN(NAX),IPLO(NAX))
                  IPHI(NAX) = IFIX((AFHI(NAX) - ADLO(NAX))/DX + 0.5)
                  IPHI(NAX) = MAX0(1,IPHI(NAX))
                  IPHI(NAX) = MIN0(IDBIN(NAX),IPHI(NAX))
C
C                 RECALCULATE THE PARTITION LIMITS TO CORRESPOND TO THE
C                 THE BIN EDGES
C
                  AFLO(NAX) = ADLO(NAX) + FLOAT(IPLO(NAX)-1)*DX
                  AFHI(NAX) = ADLO(NAX) + FLOAT(IPHI(NAX))*DX
              ENDIF
              NPCOP = IPHI(NAX) - IPLO(NAX) + 1
              IFBIN(NAX) = NPCOP
C
              IF(NPCOP.LE.0) THEN
                  WRITE(TXTERR,'(''Error in partitioning.''
     1             ,'' Limits asked for'',2G12.5
     2             ,'' Bins corresponding to them'',2I6)')
     3             AFLO(NAX),AFHI(NAX),IPLO(NAX),IPHI(NAX)
                  CALL MN_ERR('MN_PRT',TXTERR)
                  GOTO 9000
              ENDIF
2500      CONTINUE
C
C     GET REBIN SPECIFICATION
C
      ELSE IF(COMND1.EQ.'REBIN') THEN
          DO 3500 NAX=1,IABS(NDIM)
              TEXT = CONCAT(TDNAM(NAX,NH),'axis.')
              IF(IDELIM.LT.0) WRITE(LUNTTO,'(1X,A)') TEXT
              INUM(3) = IDBIN(NAX)
              RNUM(1) = 1.0
              RNUM(2) = FLOAT(IDBIN(NAX))
              CALL MN_BLM(3,0,IDELIM,COMND1
     +         ,INUM(3),RNUM(1),RNUM(2),NNUM,IERR)
              IF(IERR.NE.0) GOTO 9000
              INUM(1) = NINT(RNUM(1))
              INUM(2) = NINT(RNUM(2))
C
              NCOMB = (INUM(2)-INUM(1)+1) / INUM(3)
              NPCOP = INUM(3)
              IPLO(NAX)  = INUM(1)
              IPHI(NAX)  = IPLO(NAX) + NCOMB*NPCOP - 1
              IPCMB(NAX) = NCOMB
              IFBIN(NAX) = NPCOP
              lent = lnblnk(tdnam(nax,nh))
              WRITE(TXTMES,'(1X,A,'' axis''
     1         ,'' will have'',I5,'' bins,''
     2         ,'' using bins'',I5,'' ->'',I5)')
     2         TDNAM(NAX,NH)(:lent),IFBIN(NAX),IPLO(NAX),IPHI(NAX)
              CALL MN_MES(LUNTTO,'ME',TXTMES)
C
C             SORT OUT THE HISTOGRAM LIMITS
C
              DFXL = 0.0
              DFXH = 0.0
              DX = (ADHI(NAX) - ADLO(NAX)) / FLOAT(IDBIN(NAX))
              XFLO = ADLO(NAX) + FLOAT(IPLO(NAX)-1)*DX + 0.5*DX
              XFHI = ADLO(NAX) + FLOAT(IPHI(NAX)-1)*DX + 0.5*DX
              DFXL = 0.5*DX
              DFXH = 0.5*DX
              AFLO(NAX) = XFLO - DFXL
              AFHI(NAX) = XFHI + DFXH
3500      CONTINUE
      ENDIF
C
C     GET A NEW LOCATION
C
      NPCOP = IFBIN(1)
      IF(IABS(NDIM).GT.1) NPCOP = NPCOP * IFBIN(2)
      NWRD  = NPCOP * NWPPT
      NBPPT = 0
      CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH2,NPTRH2,NPTRD2,NWH,NBPPT,NTMODE)
      IF(NH2.LE.0) GOTO 9000
C
C     DO THE COPYING AND
C     CALCULATE THE NUMBER OF ENTRIES AND THE LIMITS
C
      EDENT2 = 0.0
      EDLO2 = 1.0E+30
      EDHI2 = -1.0E+30
      NPTR2 = NPTRD2 - 1 - NWPPT
      IF(IABS(NDIM).LT.2) THEN
          IFBIN(2) = 1
          IPLO(2)  = 1
          IPCMB(2) = 1
      ENDIF
      DO 5000 JJ=1,IFBIN(2)
          DO 4900 II=1,IFBIN(1)
              NPTR2  = NPTR2 + NWPPT
              XSUM   = 0.0
              XSUML  = 1.0E+30
              XSUMH  = -1.0E+30
              ZSUM   = 0.0
              DZSUML = 0.0
              DZSUMH = 0.0
              DXL = 0.0
              DXH = 0.0
              DO 4500 LL=1,IPCMB(2)
                  NBIN2 = IPLO(2) - 1 + (JJ - 1)*IPCMB(2) + LL
                  DO 4400 KK=1,IPCMB(1)
                      NBIN1 = IPLO(1) - 1 + (II - 1)*IPCMB(1) + KK
                      NBIN12 = IDBIN(1)*(NBIN2-1) + NBIN1
                      IF(NDIM.LT.0) THEN
                          X = AMNX(NBIN12,NH,IERR)
                          IF(QERRL) DXL = AMNDXN(NBIN12,NH,IERR)
                          DXH = DXL
                          IF(QERRH) DXH = AMNDXP(NBIN12,NH,IERR)
                          XSUM = XSUM + X
                          XSUML = AMIN1(XSUML,X-DXL)
                          XSUMH = AMAX1(XSUMH,X+DXH)
                      ENDIF
                      Z = AMNE(NBIN12,NH,IERR)
                      ZSUM = ZSUM + Z
                      IF(QERRL) THEN
                          DZL = AMNDEN(NBIN12,NH,IERR)
                          DZSUML = DZSUML + DZL*DZL
                      ENDIF
                      IF(QERRH) THEN
                          DZH = AMNDEP(NBIN12,NH,IERR)
                          DZSUMH = DZSUMH + DZH*DZH
                      ENDIF
4400              CONTINUE
4500          CONTINUE
C
              IF(IPCMB(1).GT.1 .OR. IPCMB(2).GT.1) THEN
                  IF(NDIM.LT.0) THEN
                      XSUM = XSUM / FLOAT(IPCMB(1))
                  ENDIF
                  IF(QERRL) DZSUML = SQRT(DZSUML)
                  IF(QERRH) THEN
                      DZSUMH = SQRT(DZSUMH)
                  ELSE
                      DZSUMH = DZSUML
                  ENDIF
              ELSE
                  IF(QERRL) DZSUML = DZL
                  IF(QERRH) THEN
                      DZSUMH = DZH
                  ELSE
                      DZSUMH = DZSUML
                  ENDIF
              ENDIF
              IF(NDIM.LT.0) THEN
                  DXSUML = XSUM - XSUML
                  DXSUMH = XSUMH - XSUM
                  RDAT(NPTR2+1) = XSUM
                  IF(QERRL) RDAT(NPTR2+NOFF +1) = DXSUML
                  IF(QERRH) RDAT(NPTR2+NOFFL+1) = DXSUMH
              ENDIF
              RDAT(NPTR2+NOFF) = ZSUM
              IF(QERRL) RDAT(NPTR2+NOFFL) = DZSUML
              IF(QERRH) RDAT(NPTR2+NOFFH) = DZSUMH
              EDENT2 = EDENT2 + ZSUM
              EDLO2 = AMIN1(EDLO2,ZSUM-DZSUML)
              EDHI2 = AMAX1(EDHI2,ZSUM+DZSUMH)
4900      CONTINUE
5000  CONTINUE
C
C     NOW EDIT THE HEADER WORDS THAT HAVE CHANGED
C     UPDATE THE POINTERS
C     AND DELETE THE OLD HISTOGRAM
C
      IDPTRH(NH) = -IABS(IDPTRH(NH))
      IDPTRD(NH) = -IABS(IDPTRD(NH))
      NWTOT = NWH + NWRD
      CALL M_RTIM(NHDAT2,NHTIM2)
      CALL MN_HDU(RDAT(NPTRH2),NWTOT,NWH,NWRD,IDA,IDB
     1 ,NDIM,NWPPT,NPCOP,NHDAT2,NHTIM2,NSDATE,NSTIME,NTMODE
     + ,EDENT2,EDLO2,EDHI2,IFBIN,AFLO,AFHI,NBPPT,ACONT)
      CALL MN_PTU(NH2,NWTOT,IDA,IDB,NPTRH2,NPTRD2
     1 ,TDTIT(NH),TDFIL(NH),' ',TDNAM(1,NH))
      CALL MN_MSU(IDA,IDB,NDIM,NWH,NH2)
C
C     DELETE THE HBOOK HISTOGRAM IF IT EXISTS
C
cicb      IDH = IDB*1000 + IDA
      IDH = IDA
      IF(HEXIST(IDH)) CALL HDELET(IDH)
C
 9000 CONTINUE
      RETURN
      END
