      SUBROUTINE M_SFLG(IDELIM,QPRDRW,IERR)
C
C-----------------------------------------------------------------------
C
C     Sets various flags used for plotting and other things
C
C     Called by MN_SET
C
C-----------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mncmd.inc"
#include "mnfit.inc"
#include "mnhpj.inc"
#include "mngrn.inc"
#include "mnflg.inc"
#include "mndbg.inc"
#include "mntyq.inc"
#include "mnlun.inc"
C
      LOGICAL QPRDRW
C
      CHARACTER*80 FILNAM
      LOGICAL QVAL
C
      IERR = 0
C
      IF(COMND1.NE.'SHOW') THEN
          CALL WAITYQ('On or Off: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          IF(MOD(KCMD,2).EQ.1) THEN
              QVAL = .TRUE.
          ELSEIF(KCMD.GT.0) THEN
              QVAL = .FALSE.
          ELSE
              CALL MN_DCK(IDELIM,KCMD,MLOG,LOGNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('M_SFLG')
              GOTO 9000
          ENDIF
      ENDIF
C
      IF(COMND2.EQ.'EXCLUSIONS') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Excluded regions shown: '',L1)')
     +         QSEXCL
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QSEXCL = QVAL
          ENDIF
      ELSEIF(COMND2.EQ.'TEXT') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Header text in DISPLAY shown: '',L1)')
     +         QSTEXT
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QPRDRW = .TRUE.
              QSTEXT = QVAL
          ENDIF
      ELSEIF(COMND2.EQ.'BOX') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Box drawn round picture: '',L1)')
     +         QSBOX
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QPRDRW = .TRUE.
              QSBOX = QVAL
          ENDIF
      ELSEIF(COMND2.EQ.'PI') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Pi symbol used in scale: '',L1)')
     +         QPIPLT
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QPRDRW = .TRUE.
              QPIPLT = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'ALIAS') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Alias interpretation: ''
     +         ,L1)') QALIAS
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QALIAS = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'AUTOSWITCH') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Ask before switching to/from''
     +         ,'' graphics mode: '',L1)') QASWCH
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QASWCH = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'WAIT_CR') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Ask for a <CR> before switching''
     +         ,'' to/from graphics mode: '',L1)') QAWAIT
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QAWAIT = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'AUTOSCALE') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Automatically rescale text sizes''
     +         ,'' when windowing: '',L1)') QASCAL
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QASCAL = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'AUTOTRIM') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Automatically drop scale on last''
     +         ,'' point for 3-D plots and 0 spacing windows: '',L1)')
     +         QATRIM
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QPRDRW = .TRUE.
              QATRIM = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'IGARC') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Use HIGZ routine (IGARC)''
     +         ,'' for circles and arcs: '',L1)')
     +         QIGARC
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QPRDRW = .TRUE.
              QIGARC = QVAL
          ENDIF
*
      ELSEIF(COMND2.EQ.'ECHO') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Commands will be echoed: '',L1)')
     +         QECHO
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QECHO = QVAL
          ENDIF
      ELSEIF(COMND2.EQ.'MANUAL') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Extra characters added when echoing: ''
     +         ,L1)') QMANUAL
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QMANUAL = QVAL
          ENDIF
C
C     Turn on or off logging of all commands
C
      ELSEIF(COMND2.EQ.'LOG') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Logging of commands on: '',L1)')
     +         QALOG
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSEIF(QVAL) THEN
              IF(QALOG) THEN
                  CALL M_EMSG('M_SFLG'
     +             ,'Logging of commands is already on')
              ELSE
                  FILNAM = 'mn_fit.log'
                  CALL CLEO_GETLUN(LUNLOG,'M_SFLG')
                  CALL MN_FIL(-43,LUNLOG,FILNAM,IDELIM,IERR)
                  IF(IERR.EQ.0) QALOG = .TRUE.
              ENDIF
          ELSE
              IF(.NOT.QALOG) THEN
                  CALL M_EMSG('M_SFLG'
     +            ,'Logging of commands is already off')
              ELSE
                  CLOSE(UNIT=LUNLOG)
                  CALL CLEO_FRELUN(LUNLOG,'M_SFLG')
                  LUNLOG = 0
                  QALOG = .FALSE.
              ENDIF
          ENDIF
C
      ELSEIF(COMND2.EQ.'NORMALIZE') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Overall normalization factor on: ''
     +         ,L1)') QSNORM
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSEIF(NHFIT.GT.0) THEN
              CALL MN_ERR('M_SFLG'
     +         ,'This option is not valid during fitting')
              IERR = 1
          ELSE
              QSNORM = QVAL
          ENDIF
      ELSEIF(COMND2.EQ.'RATIO') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Ratio of areas used: ''
     +         ,L1)') QRATIO
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSEIF(NHFIT.GT.0) THEN
              CALL MN_ERR('M_SFLG'
     +         ,'This option is not valid during fitting')
              IERR = 1
          ELSE
              QRATIO = QVAL
          ENDIF
C
C     SET THE ERROR ON ZERO TO 1 OR NOT
C
      ELSE IF(COMND2.EQ.'ERR_ZERO') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Error on 0 points will be 1: '',L1)')
     +         QENULL
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QENULL = QVAL
          ENDIF
C
C     SHOW ZERO POINTS WITH ZERO ERRORS
C
      ELSE IF(COMND2.EQ.'SHOW_ZERO') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' 0 Points with 0 errors will be shown: ''
     +         ,L1)') QSNULL
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QPRDRW = .TRUE.
              QSNULL = QVAL
          ENDIF
C
C     Enable/disable debug printout
C
      ELSEIF(COMND2.EQ.'DEBUG') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Debug printout enabled: '',L1
     +         ,'',  Level'',I4)',IOSTAT=IOERR) QDEBUG,NDEBUG
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QDEBUG = QVAL
              IF(QDEBUG .AND. IDELIM.EQ.0) THEN
                  CALL WAITYQ('Give printout level: ')
                  NVAL = IVLTYQ(.TRUE.,IDELIM)
                  CALL MN_NCK(NVAL,IDELIM,IERR)
                  IF(IERR.NE.0) GOTO 9000
                  NDEBUG = NVAL
              ENDIF
          ENDIF
C
C     Break handling turned on or off
C
      ELSEIF(COMND2.EQ.'BREAK') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Break handling on: '',L1)')
     +         QBREAK
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QBREAK = QVAL
              IF(QBREAK) THEN
                  CALL M_BRON
              ELSE
                  CALL M_BROF
              ENDIF
          ENDIF
C
C     Mouse used for x,y positions
C
      ELSEIF(COMND2.EQ.'MOUSE') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Mouse used for x,y positions: '',L1)')
     +         QMOUSE
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QMOUSE = QVAL
          ENDIF
C
C     Aborting of Macros when errors occur
C
      ELSEIF(COMND2.EQ.'ABORT') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Aborting of macros on: '',L1)')
     +         QABORT
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QABORT = QVAL
          ENDIF
C
C     Turn on/off sending of special string for TKTCL interface
C
      ELSEIF(COMND2.EQ.'TKTCL') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' TK/TCL interface on: '',L1)')
     +         QTKTCL
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QTKTCL = QVAL
          ENDIF
C
C     Automatic refetching of Ntuples
C
      ELSEIF(COMND2.EQ.'AUTOFETCH') THEN
          IF(COMND1.EQ.'SHOW') THEN
              WRITE(TXTMES,'('' Automatic refetching of Ntuples: ''
     +         ,L1)') QAFETCH
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ELSE
              QAFETCH = QVAL
          ENDIF
      ENDIF
C
9000  CONTINUE
      END
