
AC_DEFUN([MODBT_CHECK_DOCDIR],
[   AC_MSG_CHECKING(documentation directory)
    AC_ARG_WITH(docdir,
[  --with-docdir=[PATH]                  Directory to install HTML documentation.],
[
    

    if test "$withval" = "yes"; then
        DOC_DIR="$datadir/doc/mod_bt"
        AC_MSG_RESULT($DOC_DIR)
    elif test -z "$withval"; then
        DOC_DIR="$datadir/doc/mod_bt"
        AC_MSG_RESULT($DOC_DIR)
    elif test "$withval" = "no"; then
        DOC_DIR=""
        AC_MSG_RESULT(no documentation)
    else
        DOC_DIR="$withval"
        AC_MSG_RESULT($DOC_DIR)
    fi
]
,
[
    DOC_DIR="$datadir/doc/mod_bt"
    AC_MSG_RESULT($DOC_DIR)
])
AC_SUBST(DOC_DIR)
])


AC_DEFUN([MODBT_CHECK_MODPERL_SRC],
[AC_MSG_CHECKING(for mod_perl source directory)
AC_ARG_WITH(modperl-src,
[  --with-modperl-src=[PATH]	Path to the mod_perl sources.],
[
	if test "$withval" = "yes"; then
		AC_MSG_ERROR(--with-modperl-src requires an argument.)
	elif test -n "$withval"; then
		CPPFLAGS="$CPPFLAGS -I$withval/xs -I$withval/src/modules/perl"
		AC_MSG_RESULT($withval)
	else
		AC_MSG_RESULT(no)
	fi
],
[
	AC_MSG_RESULT(no)
])
])

AC_DEFUN([MODBT_CHECK_APR_CONFIG],
[
APR_FIND_APR("", "", 1, [ 0 1 ])
if test -n "$apr_config"; then
APR_CONFIG="$apr_config"
LIBBTT_LIBS="`$APR_CONFIG --link-ld` $LIBBTT_LIBS"
APR_LIBS="`$APR_CONFIG --link-ld`"
CPPFLAGS="`$APR_CONFIG --includes --cppflags` $CPPFLAGS"
AC_SUBST(LIBBTT_LIBS)
AC_SUBST(APR_CONFIG)
AC_SUBST(APR_LIBS)
AC_SUBST(CPPFLAGS)
else
AC_MSG_ERROR(APR is required)
fi
])

AC_DEFUN([MODBT_CHECK_APU_CONFIG],
[
APR_FIND_APU("", "", 1, [ 0 1 ])
if test -n "$apu_config"; then
APU_CONFIG="$apu_config"
LIBBTPEER_LIBS="`$APU_CONFIG --link-ld` $LIBBTPEER_LIBS"
APU_LIBS="`$APU_CONFIG --link-ld`"
CPPFLAGS="`$APU_CONFIG --includes` $CPPFLAGS"
AC_SUBST(LIBBTPEER_LIBS)
AC_SUBST(APU_CONFIG)
AC_SUBST(APU_LIBS)
AC_SUBST(CPPFLAGS)
fi
])


AC_DEFUN([MODBT_DETECT_APXS],[
    AC_PATH_PROGS([APXS], [ apxs2 apxs ], [], [$PATH])
    if test "$APXS" = ""; then
        BUILD_APACHE2=0
    else
        BUILD_APACHE2=1
    fi
])

AC_DEFUN([MODBT_CHECK_APXS],
[AC_ARG_WITH(apxs,
[  --with-apxs[=FILE]    Build shared Apache module.  FILE is the optional
                        pathname to the Apache apxs tool; defaults to "apxs".
                        (This option needs Perl installed)],
[
    if test "$withval" = "yes"; then
        MODBT_DETECT_APXS()
    elif test "$withval" = "no"; then
        AC_MSG_CHECKING(for apxs2)
        AC_MSG_RESULT(no)
	APXS=""
        BUILD_APACHE2=0
    else
        AC_MSG_CHECKING(for apxs2)
        AC_MSG_RESULT($withval)
    	APXS="$withval"
    	BUILD_APACHE2=1
    fi
],[
    MODBT_DETECT_APXS()
])
AC_SUBST(APXS BUILD_APACHE2)
])

AC_DEFUN([MODBT_CHECK_PERL],
[AC_ARG_WITH(perl,
[  --with-perl[=FILE]   Path to perl interpreter],
[

    if test "$withval" = "yes"; then
    	AC_PATH_PROGS([PERL], [ perl ])
    	
    	if test "$PERL" = ""; then
    		BUILD_PERL=0
    	else
    		BUILD_PERL=1
    	fi
    elif test "$withval" = "no"; then
	    AC_MSG_RESULT(no)
	    PERL=""
	    BUILD_PERL=0
    else
    	PERL="$withval"
    	BUILD_PERL=1
	fi
	
	if test "$BUILD_PERL" = "1"; then
		if ! $PERL -M5.006 -e 1; then
			echo "Perl version is too old; skipped"
			BUILD_PERL=0
		fi
	fi
],[
   	AC_PATH_PROGS([PERL], [ perl ])
    	
   	if test "$PERL" = ""; then
   		BUILD_PERL=0
   	else
   		BUILD_PERL=1
   	fi

	if test "$BUILD_PERL" = "1"; then
		if ! $PERL -M5.006 -e 1; then
			echo "Perl version is too old; skipped"
			BUILD_PERL=0
		fi
	fi
    	
])
AC_SUBST(PERL BUILD_PERL)
])

AC_DEFUN([MODBT_CHECK_MAKEFILEPL_ARGS],
[
 AC_ARG_WITH(makefilepl-args,
  [  --with-makefilepl-args=ARGS    Extra command-line arguments to pass to perl Makefile.PL's ],
  [
     if test "$withval" = "yes"; then
         MAKEFILEPL_ARGS=""
     elif test "$withval" = "no"; then
         MAKEFILEPL_ARGS=""
     else
         MAKEFILEPL_ARGS="$withval"
     fi
  ]
 )
 AC_SUBST(MAKEFILEPL_ARGS)
])

AC_DEFUN([MODBT_CHECK_MODPERL],
[
 AC_MSG_CHECKING(for mod_perl)
 AC_ARG_WITH(modperl,
[  --with-modperl[=PATH]   Location where mod-perl is installed (if different than apache2)],
[
	if test "$PERL" == ""; then
		AC_MSG_RESULT(perl is not enabled)
                BUILD_MODPERL=0
	elif test "$APXS" == ""; then
		AC_MSG_RESULT(apache2 is not enabled)
                BUILD_MODPERL=0
	elif test "$withval" = "yes"; then
		MODPERL_PREFIX=`$APXS -q PREFIX`
		BUILD_MODPERL=1
		AC_MSG_RESULT($withval)
    elif test "$withval" = "no"; then
	    AC_MSG_RESULT(no)
	    MODPERL_PREFIX=""
	    BUILD_MODPERL=0
    else
    	MODPERL_PREFIX="$withval"
    	BUILD_MODPERL=1
    	AC_MSG_RESULT($withval)
	fi
	
	
	if test "$BUILD_MODPERL" = "1"; then
		CPPFLAGS="$CPPFLAGS -I`$APXS -q INCLUDEDIR`"
		AC_CHECK_HEADERS([ modperl_apache_includes.h ], [ ],
			[ AC_MSG_ERROR(modperl_apache_includes.h not found, specify prefix for mod_perl or re-run without --with-mod-perl) ]
		)
	fi
	],[

	if test "$APXS" = "" || test "$PERL" = ""; then
		AC_MSG_RESULT(skipped)
		BUILD_MODPERL=0
		MODPERL_PREFIX=""
	else
		echo
		MODPERL_PREFIX=`$APXS -q PREFIX`
		BUILD_MODPERL=1
#		AC_MSG_RESULT($MODPERL_PREFIX)
		CPPFLAGS="$CPPFLAGS -I`$APXS -q INCLUDEDIR`"
		AC_CHECK_HEADERS([ modperl_apache_includes.h ], [ ],
			[
				BUILD_MODPERL=0
				MODPERL_PREFIX=""
			])
	fi
])
AC_SUBST(MODPERL_PREFIX BUILD_MODPERL)
])

AC_DEFUN([MODBT_CHECK_PHP_CONFIG],
[AC_ARG_WITH(php-config,
[  --with-php-config[=FILE]    Path to php-config binary from php4.],
[

	if test "$APXS" = ""; then
                BUILD_PHP=0
                AC_MSG_RESULT(apache2 is not enabled)
	elif test "$withval" = "yes" || test "$withval" = ""; then
    	AC_PATH_PROGS([PHP_CONFIG], [ php-config ])
    	
    	if test "$APR_CONFIG" = ""; then
    		BUILD_PHP=0
    	else
    		BUILD_PHP=1
    	fi
    else
	AC_MSG_CHECKING(for php-config)
        if test "$withval" = "no"; then
            BUILD_PHP=0
        else
            PHP_CONFIG="$withval"
            BUILD_PHP=1
        fi
    	AC_MSG_RESULT($withval)
	fi
],[
	if test "$APXS" = ""; then
		AC_MSG_CHECKING(for php-config)
		AC_MSG_RESULT(skipped)
	else
    	AC_PATH_PROGS([PHP_CONFIG], [ php-config ])
     	
    	if test "$PHP_CONFIG" = ""; then
    		BUILD_PHP=0
    	else
    		BUILD_PHP=1
    	fi
    fi
])
AC_SUBST(PHP_CONFIG BUILD_PHP)
])

AC_DEFUN([MODBT_CHECK_POD],
[AC_ARG_WITH(pod2html,
[  --with-pod2html[=FILE]    Path to pod2html script from perl.],
[

	if test "$PERL" = ""; then
		AC_MSG_ERROR(--with-pod2html requires --with-perl)
	elif test "$withval" = "yes" || test "$withval" = ""; then
    	AC_PATH_PROGS([POD2HTML], [ pod2html ])
    else
    	POD2HTML="$withval"
    	AC_MSG_CHECKING(for pod2html)
    	AC_MSG_RESULT($withval)
	fi
],[
	if test "$PERL" = ""; then
		AC_MSG_CHECKING(for pod2html)
		AC_MSG_RESULT(skipped)
	else
    	AC_PATH_PROGS([POD2HTML], [ pod2html ])
    fi
])

AC_ARG_WITH(pod2man,
[  --with-pod2man[=FILE]    Path to pod2man script from perl.],
[

	if test "$PERL" = ""; then
		AC_MSG_ERROR(--with-pod2html requires --with-perl)
	elif test "$withval" = "yes" || test "$withval" = ""; then
    	AC_PATH_PROGS([POD2MAN], [ pod2man ])
    else
    	POD2MAN="$withval"
    	AC_MSG_CHECKING(for pod2man)
    	AC_MSG_RESULT($withval)
	fi
],[
	if test "$PERL" = ""; then
		AC_MSG_CHECKING(for pod2man)
		AC_MSG_RESULT(skipped)
	else
    	AC_PATH_PROGS([POD2MAN], [ pod2man ])
    fi
])


AC_SUBST(POD2HTML)
AC_SUBST(POD2MAN)
])

AC_DEFUN([MODBT_CHECK_PERL_PREFIX],
[AC_ARG_WITH(perl-prefix,
[  --with-perl-prefix[=PATH]    Alternate installation prefix for perl extensions.],
[

	if test "$PERL" = ""; then
		AC_MSG_ERROR(--with-perl-prefix requires --with-perl)
	elif test "$withval" = "yes" || test "$withval" = ""; then
    	AC_MSG_ERROR(--with-perl-prefix requires a value)
    else
    	PERL_PREFIX="$withval"
    	AC_MSG_CHECKING(for alternate perl prefix)
    	AC_MSG_RESULT($withval)
	fi
])
AC_SUBST(PERL_PREFIX)
])

AC_DEFUN([MODBT_CHECK_PERL_LIB],
[AC_ARG_WITH(perl-lib,
[  --with-perl-lib[=PATH]    Alternate installation prefix for perl libraries.],
[

	if test "$PERL" = ""; then
		AC_MSG_ERROR(--with-perl-lib requires --with-perl)
	elif test "$withval" = "yes" || test "$withval" = ""; then
    	AC_MSG_ERROR(--with-perl-lib requires a value)
    else
    	PERL_LIB="$withval"
    	AC_MSG_CHECKING(for alternate perl library path)
    	AC_MSG_RESULT($withval)
	fi
])
AC_SUBST(PERL_LIB)
])

AC_DEFUN([MODBT_ECHO_BUILD],
[
	if test "$1" = "" || test "$1" = "0"; then
		echo "no"
	else
		echo "yes"
	fi
])

AC_DEFUN([MODBT_CHECK_PHP_HEADERS],
[
	if test "$BUILD_PHP" = "1"; then
		PHP_INCLUDE=`$PHP_CONFIG --includes`
		export CPPFLAGS="$CPPFLAGS $PHP_INCLUDE"
		AC_CHECK_HEADERS([Zend/zend.h], [], [ AC_MSG_ERROR(php headers not found. Specify in CPPFLAGS or run configure --without-php-config) ])
	fi
])

AC_DEFUN([MODBT_CHECK_BDB],
[
	AC_ARG_WITH(bdb,
		[  --with-bdb=PFX	Prefix where Berkeley DB is installed. ],
		bdb_config_prefix="$withval", bdb_config_prefix="")
	
	AC_MSG_CHECKING(for Berkeley DB - versison >= 4.2)
	OLD_LIBS="$LIBS"
    if test "$withval" = "no"; then
        BUILD_BDB=0
        AC_MSG_RESULT(no)
    else
        for i in db-4.4 db-4.3 db-4.2 db; do
            LIBS="$OLD_LIBS $LIBBTT_LIBS -l$i"
            AC_TRY_RUN([
#include <db.h>
#include <stdio.h>
#define MAJOR 4
#define MINOR 2

int main ()
{
	int maj, min;
	db_version(&maj, &min, NULL);
        if(DB_VERSION_MAJOR != maj || DB_VERSION_MINOR != min) {
                fprintf(stderr, "libdb-%i.%i found, but we have headers for %i.%i!\n",
                        maj, min, DB_VERSION_MAJOR, DB_VERSION_MINOR);
                return 2;        
	} else if(maj >= MAJOR && min >= MINOR) {
		return 0;
        } else {
		fprintf(stderr, "libdb-%i.%i found, %i.%i or greater required\n",
			maj, min, MAJOR, MINOR);
		return 1;
	}
}
            ], [
                libdb_lib="$i"
            ])
            if test -n "$libdb_lib"; then break; fi
        done
        LIBS="$OLD_LIBS"
        if test "x$libdb_lib" = "x" ; then
            AC_MSG_RESULT(not found)
            BUILD_BDB=0
        else
            AC_MSG_RESULT($libdb_lib)
            LIBBTT_LIBS="-l$libdb_lib"
            BUILD_BDB=1
        fi
    fi
    
    AC_SUBST(LIBBTT_LIBS)
    AC_SUBST(BUILD_BDB)
])

m4_include([libtool.m4])
m4_include([find_apr.m4])
m4_include([find_apu.m4])
