/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker.h>

/* data is set to the scrape config */
/* modifies nothing */
int btt_iter_scrape_add_hash(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
) {
    btt_cxn_scrape_config* config = (btt_cxn_scrape_config*) data;
    btt_infohash *infohash = (btt_infohash*)val->data;
 
    char *rv;
    int len = 0;
 
    if(config->verbose)
        len = btt_infohash2scrape_verbose(config->rv.pool, infohash, &rv);
    else if(config->xml == BTT_SCRAPE_XML)
        len = btt_infohash2xml(config->rv.pool, infohash, &rv);
    else if(config->xml == BTT_SCRAPE_HTML)
        len = btt_infohash2tr(
            config->rv.pool, infohash, config->tracker->c->detail_url, &rv
        );
    else
        len = btt_infohash2scrape(config->rv.pool, infohash, &rv);
 
    if(len) {
        config->t_seeds += (infohash->seeds - infohash->shields);
        config->t_downloaders += (infohash->peers - infohash->seeds);
        config->t_shields += infohash->shields;
        config->t_completed += infohash->completes;
        config->t_hashes ++;

        if(
            config->rv.buffer_length <
            (config->rv.content_length + len + 10240)
        ) {
            config->rv.buffer_length += len + 10240;
            if(!(
                config->rv.content =
                    realloc(config->rv.content, config->rv.buffer_length)
            )) {
                fprintf(
                    stderr, "btt_iter_make_peerlist string(): "
                    "Couldn't allocate %u bytes!\n", config->rv.buffer_length
                );
                return APR_ENOMEM;                
            }
        }

        memcpy(&(config->rv.content[config->rv.content_length]), rv, len);
        config->rv.content_length = config->rv.content_length + len;
        
        if(config->xml) {
            config->rv.content[config->rv.content_length] = '\n';
            config->rv.content_length++;
        }
        
        config->rv.content[config->rv.content_length] = 0;
        return 0;
    } else {
        fprintf(
            stderr, "bt_iter_scrape_add_hash(%s): Failed to encode hash!\n",
            bt_str_infohash(p, infohash->infohash)
        );
        fflush(stderr);
        return BT_CALLBACK_STOP;
    }
}
