/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include <stdio.h>
#include <libbttracker.h>

int btt_tracker_free(btt_tracker** tracker, int master) {
    if((*tracker)->myapr) {
        if(!btt_tracker_disconnect(*tracker)) {
            fprintf(stderr, "bt_tracker_free(): bt_tracker_disconnect failed!\n");
            fflush(stderr);
            return 0;
        }
    }
    
    if(master) {
        if(apr_shm_destroy((*tracker)->m) == APR_SUCCESS) {
            btt_free_tracker_pool(*tracker);
            *tracker = NULL;
            return 1;
        } else {
            fprintf(stderr, "bt_tracker_free(): Destroying shared memory segment failed!\n");
            fflush(stderr);
            return 0;
        }
    } else {
        if(apr_shm_detach((*tracker)->m) == APR_SUCCESS) {
            btt_free_tracker_pool(*tracker);
            *tracker = NULL;
            return 1;
        } else {
            fprintf(stderr, "bt_tracker_free(): Detaching from shared memory segment failed!\n");
            fflush(stderr);
            return 0;
        }
    }
}

void btt_free_tracker_pool(btt_tracker *t) {
    const char* path = NULL;

    if(t->shlock) {
        apr_file_name_get(&path, t->shlock);
        apr_file_unlock(t->shlock);
        apr_file_close(t->shlock);
        apr_file_remove(path, t->p);
    }

    apr_pool_destroy(t->p);
    if(t->myapr)
        apr_pool_terminate();
    return;
}
