/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.doa;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DoaReader {
	
	public Doa getDoa(File pFile) {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();


			SchemaFactory schemaFactory = 
			    SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");


			factory.setSchema(schemaFactory.newSchema(
			    new Source[] {new StreamSource("config/doaTemplate.xsd")}));


			SAXParser parser = factory.newSAXParser();

			SAXReader reader = new SAXReader(parser.getXMLReader());

			reader.setValidation(false);
			Document document = reader.read(pFile.toURI().toURL());
			List<String> aLinesList = treeWalk(document);
			return new Doa( (String)((Element) document.getRootElement().elementIterator("description").next()).getText(), aLinesList);
			
		} catch (Exception e) {
			return null;
		}
	}

	private static List<String> treeWalk(Document document) {
    	List<String> aLinesList = new ArrayList<String>();
        for ( Iterator i = document.getRootElement().elementIterator("line"); i.hasNext(); ) {
            Element aLine = (Element) i.next();
            aLinesList.add(aLine.getText());
        }
		return aLinesList;
    }

}
