/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

import monajat.gui.main.help.MonajatAbout;
import monajat.util.LoacationSetter;
import monajat.util.PropertyManager;
import monajat.util.Language_util.Language;
import monajat.util.Language_util.LanguageResource;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class MonajatTray {

	private static Shell shell;

	private static Display display;

	private static Image image;

	private static Tray tray;

	private static MonajatTimer aMonajatTimer;

	public static void main(String[] args) {
		display = new Display();
		shell = new Shell(display);
		
		InitMonajah();
		aMonajatTimer = new MonajatTimer();
		aMonajatTimer.start();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		image.dispose();
		display.dispose();
	}

	public static void restartMonajat() {
		aMonajatTimer.stop();
		aMonajatTimer = null;
		PropertyManager.sPropertyManager = null;
		LanguageResource.sLanguageResource = null;
		image.dispose();
		display.syncExec(new Runnable() {
			public void run() {
				tray.dispose();
//				display.dispose();
//				shell.dispose();
			}
		});
		InitMonajah();
		aMonajatTimer = new MonajatTimer();
		aMonajatTimer.start();
	}

	public static void InitMonajah() {
		Map<String, Locale> aLanguageMap = new HashMap<String, Locale>();
		aLanguageMap.put("arabic", new Locale("ar"));
		aLanguageMap.put("english", new Locale("en"));
		aLanguageMap.put("french", new Locale("fr"));
		aLanguageMap.put("pashto", new Locale("ps"));
		aLanguageMap.put("german", new Locale("de"));
		aLanguageMap.put("dutch (nl)", new Locale("nl"));

		Locale default_language = new Locale("en");
		String aUserLanguage = PropertyManager.getProperty("language");
		if (aUserLanguage != null
				&& aLanguageMap.containsKey(aUserLanguage.toLowerCase())) {
			Language.setCurrentLocale(aLanguageMap.get(PropertyManager
					.getProperty("language").toLowerCase()));
		} else {
			Language.setCurrentLocale(default_language);
		}
		UIManager.put("OptionPane.cancelButtonText", LanguageResource
				.getString("Cancel"));
		UIManager.put("OptionPane.noButtonText", LanguageResource
				.getString("No"));
		UIManager.put("OptionPane.okButtonText", LanguageResource
				.getString("Ok"));
		UIManager.put("OptionPane.yesButtonText", LanguageResource
				.getString("Yes"));
		initTray();
	}

	private static void initTray() {
		image = new Image(display, PropertyManager.getProperty("picsPath")
				+ "/Doa_tray.png");
		display.syncExec(new Runnable() {
			public void run() {
				tray = display.getSystemTray();
		if (tray == null) {
			System.out.println("The system tray is not available");
		} else {
			final TrayItem item = new TrayItem(tray, SWT.NONE);
			item.setToolTipText(LanguageResource.getString("Monajat"));
			final Menu menu = new Menu(shell, SWT.POP_UP);

			MenuItem about = new MenuItem(menu, SWT.PUSH);
			about.setText(LanguageResource.getString("About"));
			about.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					new MonajatAbout();
				}
			});

			MenuItem preferences = new MenuItem(menu, SWT.PUSH);
			preferences.setText(LanguageResource.getString("Preferences"));
			preferences.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					new Thread("applicationThread") {
						public void run() {
							if (Thread.currentThread().getName().equals(
									"applicationThread")) {
								MonajatPreferences aPreferences = null;
								aPreferences = new MonajatPreferences();
								GuiFontSetter.adjustFont(aPreferences);
								aPreferences.setVisible(true);
							}
						}
					}.start();
				}
			});

			MenuItem showItem = new MenuItem(menu, SWT.PUSH);
			showItem.setText(LanguageResource.getString("Show prayer"));
			showItem.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					MonajatTimer.showDoa();
				}
			});

			MenuItem fullMode = new MenuItem(menu, SWT.PUSH);
			fullMode.setText(LanguageResource.getString("Monajat"));
			fullMode.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					new FullMode();
				}
			});
			new MenuItem(menu, SWT.SEPARATOR);

			MenuItem closeItem = new MenuItem(menu, SWT.PUSH);
			closeItem.setText(LanguageResource.getString("Close"));
			closeItem.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					System.exit(0);
				}
			});

			item.addListener(SWT.MenuDetect, new Listener() {
				public void handleEvent(Event event) {
					menu.setVisible(true);
				}
			});
			item.setImage(image);
		}
			}
		});
	}

}
