/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.reusables;


import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

import monajat.util.PropertyManager;
import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class LabeldRadioButtons extends JPanel implements ActionListener, FocusListener {

	private static final long serialVersionUID = 1L;
	
	private List<JRadioButton> mCheckBoxes;
	
	public LabeldRadioButtons(String pName, String... pRadioButtons) {
		super();
		this.setLayout(new VerticalBagLayout());
		this.mCheckBoxes = new ArrayList<JRadioButton>();
		JPanel aNamePanel = new JPanel();
		aNamePanel.setLayout(new GridLayout(3, 3, 30, 30));
		aNamePanel.setBorder(new TitledBorder(LanguageResource.getString(pName)));
		///////////
		int aUser_screen= 4;
		if (PropertyManager.getProperty("on_screen") != null && PropertyManager.getProperty("on_screen").length() > 0) {
			aUser_screen=Integer.parseInt(PropertyManager.getProperty("on_screen"));	     	
		}
		//System.out.println(aUser_screen);
		int i=0;
		for (String aString : pRadioButtons) {
			JRadioButton aRadioButton = new JRadioButton(LanguageResource.getString(aString));
			this.mCheckBoxes.add(aRadioButton);
			aRadioButton.addFocusListener(this);
			aNamePanel.add(OreintationHelper.setJComponentOreintation(aRadioButton));
			aRadioButton.addActionListener(this);
			aRadioButton.setActionCommand(aString);
			if(i==aUser_screen) aRadioButton.setSelected(true);
			i++;
		}
		this.add(aNamePanel);
	}

	public void actionPerformed(ActionEvent pEvent) {
		JRadioButton aSourceRadioButton = (JRadioButton) pEvent.getSource();
		boolean aSourceRadioButtonStatus = aSourceRadioButton.isSelected();
		if (!aSourceRadioButtonStatus) {
			aSourceRadioButton.setSelected(false);
		} else {
			for (JRadioButton aCheckbox : this.mCheckBoxes) {
				if (aCheckbox != aSourceRadioButton) {
					aCheckbox.setSelected(!aSourceRadioButtonStatus);
				}
			}
		}
	}

	public void focusGained(FocusEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void focusLost(FocusEvent e) {
		// TODO Auto-generated method stub
		
	}

	public List<JRadioButton> getCheckBoxes() {
		return mCheckBoxes;
	}

	public void setCheckBoxes(List<JRadioButton> pCheckBoxes) {
		mCheckBoxes = pCheckBoxes;
	}

}
