/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;

public final class LoacationSetter {

	private static int x = 0;

	private static int y = 0;

	public static Point calculateLocationOnScreen(int width, int height) {
		int position = -1;
		try {
			position = Integer.parseInt(PropertyManager
					.getProperty("on_screen"));
		} catch (NumberFormatException e) {
			position = -1;
		}
		Dimension aScreen = Toolkit.getDefaultToolkit().getScreenSize();
		switch (position) {
		case 0:
			x = 0;
			y = 0;
			break;
		case 1:
			x = (int) ((aScreen.getWidth() - width) / 2);
			y = 0;
			break;
		case 2:
			x = (int) (aScreen.getWidth() - width);
			y = 0;
			break;
		case 3:
			x = 0;
			y = (int) ((aScreen.getHeight() - height) / 2);
			break;
		case 4:
			x = (int) ((aScreen.getWidth() - width) / 2);
			y = (int) ((aScreen.getHeight() - height) / 2);
			break;
		case 5:
			x = (int) ((aScreen.getWidth() - width));
			y = (int) ((aScreen.getHeight() - height) / 2);
			break;
		case 6:
			x = 0;
			y = (int) ((aScreen.getHeight() - height));
			break;
		case 7:
			x = (int) ((aScreen.getWidth() - width) / 2);
			y = (int) ((aScreen.getHeight() - height));
			break;
		case 8:
			x = (int) ((aScreen.getWidth() - width));
			y = (int) ((aScreen.getHeight() - height));
			break;
		default:
			x = (int) ((aScreen.getWidth() - width) / 2);
			y = (int) ((aScreen.getHeight() - height) / 2);
			break;
		}
		return new Point(x, y);
	}

	public static Point calculateMiddleLocationOnScreen(int width, int height) {

		Dimension aScreen = Toolkit.getDefaultToolkit().getScreenSize();

		x = (int) ((aScreen.getWidth() - width) / 2);
		y = (int) ((aScreen.getHeight() - height) / 2);
		return new Point(x, y);
	}

	public int getX() {
		return x;
	}

	public void setX(int pX) {
		x = pX;
	}

	public int getY() {
		return y;
	}

	public void setY(int pY) {
		y = pY;
	}
}
