//
// Unit test for ReviewUselessControlFlowRule
//
// Authors:
//	Sebastien Pouliot <sebastien@ximian.com>
//
// Copyright (C) 2008 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;

using Gendarme.Rules.Correctness;

using NUnit.Framework;
using Test.Rules.Definitions;
using Test.Rules.Fixtures;

namespace Test.Rules.Correctness {

#pragma warning disable 642

	[TestFixture]
	public class ReviewUselessControlFlowTest : MethodRuleTestFixture<ReviewUselessControlFlowRule> {

		[Test]
		public void DoesNotApply ()
		{
			AssertRuleDoesNotApply (SimpleMethods.ExternalMethod);
		}

		public void TypoExtraSemiColumn (int x)
		{
			// note: C# compilers will *warn* about this - but will compile it
			// warning CS0642: Possible mistaken empty statement
			if (x == 1);
				Console.WriteLine ("of course");
			// br[true|false][.s] on next instruction
			// note: this could be bad, i.e. non-optimal, IL generated by the compiler
		}

		public void CorrectCondition (int x)
		{
			if (x == 1)
				Console.WriteLine ("of course");
		}

		[Test]
		public void ProbableTypo ()
		{
			AssertRuleFailure<ReviewUselessControlFlowTest> ("TypoExtraSemiColumn", 1);

			AssertRuleSuccess<ReviewUselessControlFlowTest> ("CorrectCondition");
		}

		public void EmptyCondition (int x)
		{
			// no compiler warning
			// - MS C# compiler (CSC) inserts 2 NOP between the brtrue[.s]
			// - Mono's [G]MCS does not insert NOP so it looks just like the previous case
			// and the ldstr (probably to help the debugger insert breakpoints)
			if (x == 0) {
				// TODO - ever seen such thing ? ;-)
			}
			Console.WriteLine ("of course");
		}

		public void Condition (int x)
		{
			if (x == 0) {
				Console.WriteLine ("zero");
			}
			Console.WriteLine ("of course");
		}

		[Test]
		public void UnneededCode ()
		{
			AssertRuleFailure<ReviewUselessControlFlowTest> ("EmptyCondition", 1);

			AssertRuleSuccess<ReviewUselessControlFlowTest> ("Condition");
		}
	}
}
