// Autogenerated code. Do not edit.

using RabbitMQ.Client;
using RabbitMQ.Client.Exceptions;

namespace RabbitMQ.Client.Framing.v0_8 {
  public class Protocol: RabbitMQ.Client.Framing.Impl.v0_8.ProtocolBase {
    ///<summary>Protocol major version (= 8)</summary>
    public override int MajorVersion { get { return 8; } }
    ///<summary>Protocol minor version (= 0)</summary>
    public override int MinorVersion { get { return 0; } }
    ///<summary>Protocol API name (= AMQP_0_8)</summary>
    public override string ApiName { get { return "AMQP_0_8"; } }
    ///<summary>Default TCP port (= 5672)</summary>
    public override int DefaultPort { get { return 5672; } }

    public override RabbitMQ.Client.Impl.MethodBase DecodeMethodFrom(RabbitMQ.Util.NetworkBinaryReader reader) {
      ushort classId = reader.ReadUInt16();
      ushort methodId = reader.ReadUInt16();

      switch (classId) {
        case 10: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionStart result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionStart();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionStartOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionStartOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionSecure result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionSecure();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionSecureOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionSecureOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionTune result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionTune();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionTuneOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionTuneOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionOpen result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionOpenOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionOpenOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionRedirect result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionRedirect();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionClose result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionClose();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 61: {
              RabbitMQ.Client.Framing.Impl.v0_8.ConnectionCloseOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ConnectionCloseOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 20: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelOpen result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelOpenOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelOpenOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelFlow result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelFlow();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelFlowOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelFlowOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelAlert result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelAlert();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelClose result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelClose();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_8.ChannelCloseOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ChannelCloseOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 30: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.AccessRequest result = new RabbitMQ.Client.Framing.Impl.v0_8.AccessRequest();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.AccessRequestOk result = new RabbitMQ.Client.Framing.Impl.v0_8.AccessRequestOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 40: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDeclare result = new RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDeclare();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDeclareOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDeclareOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDelete result = new RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDelete();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDeleteOk result = new RabbitMQ.Client.Framing.Impl.v0_8.ExchangeDeleteOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 50: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueueDeclare result = new RabbitMQ.Client.Framing.Impl.v0_8.QueueDeclare();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueueDeclareOk result = new RabbitMQ.Client.Framing.Impl.v0_8.QueueDeclareOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueueBind result = new RabbitMQ.Client.Framing.Impl.v0_8.QueueBind();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueueBindOk result = new RabbitMQ.Client.Framing.Impl.v0_8.QueueBindOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueuePurge result = new RabbitMQ.Client.Framing.Impl.v0_8.QueuePurge();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueuePurgeOk result = new RabbitMQ.Client.Framing.Impl.v0_8.QueuePurgeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueueDelete result = new RabbitMQ.Client.Framing.Impl.v0_8.QueueDelete();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_8.QueueDeleteOk result = new RabbitMQ.Client.Framing.Impl.v0_8.QueueDeleteOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 60: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicQos result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicQosOk result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicQosOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicConsume result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicConsumeOk result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicConsumeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicCancel result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicCancelOk result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicCancelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicPublish result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicPublish();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicReturn result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicReturn();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicDeliver result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicDeliver();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 70: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicGet result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicGet();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 71: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicGetOk result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicGetOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 72: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicGetEmpty result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicGetEmpty();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 80: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicAck result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicAck();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 90: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicReject result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicReject();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 100: {
              RabbitMQ.Client.Framing.Impl.v0_8.BasicRecover result = new RabbitMQ.Client.Framing.Impl.v0_8.BasicRecover();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 70: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileQos result = new RabbitMQ.Client.Framing.Impl.v0_8.FileQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileQosOk result = new RabbitMQ.Client.Framing.Impl.v0_8.FileQosOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileConsume result = new RabbitMQ.Client.Framing.Impl.v0_8.FileConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileConsumeOk result = new RabbitMQ.Client.Framing.Impl.v0_8.FileConsumeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileCancel result = new RabbitMQ.Client.Framing.Impl.v0_8.FileCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileCancelOk result = new RabbitMQ.Client.Framing.Impl.v0_8.FileCancelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileOpen result = new RabbitMQ.Client.Framing.Impl.v0_8.FileOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileOpenOk result = new RabbitMQ.Client.Framing.Impl.v0_8.FileOpenOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileStage result = new RabbitMQ.Client.Framing.Impl.v0_8.FileStage();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_8.FilePublish result = new RabbitMQ.Client.Framing.Impl.v0_8.FilePublish();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 70: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileReturn result = new RabbitMQ.Client.Framing.Impl.v0_8.FileReturn();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 80: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileDeliver result = new RabbitMQ.Client.Framing.Impl.v0_8.FileDeliver();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 90: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileAck result = new RabbitMQ.Client.Framing.Impl.v0_8.FileAck();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 100: {
              RabbitMQ.Client.Framing.Impl.v0_8.FileReject result = new RabbitMQ.Client.Framing.Impl.v0_8.FileReject();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 80: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamQos result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamQosOk result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamQosOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamConsume result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamConsumeOk result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamConsumeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamCancel result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamCancelOk result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamCancelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamPublish result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamPublish();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamReturn result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamReturn();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_8.StreamDeliver result = new RabbitMQ.Client.Framing.Impl.v0_8.StreamDeliver();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 90: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.TxSelect result = new RabbitMQ.Client.Framing.Impl.v0_8.TxSelect();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.TxSelectOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TxSelectOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.TxCommit result = new RabbitMQ.Client.Framing.Impl.v0_8.TxCommit();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.TxCommitOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TxCommitOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.TxRollback result = new RabbitMQ.Client.Framing.Impl.v0_8.TxRollback();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.TxRollbackOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TxRollbackOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 100: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.DtxSelect result = new RabbitMQ.Client.Framing.Impl.v0_8.DtxSelect();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.DtxSelectOk result = new RabbitMQ.Client.Framing.Impl.v0_8.DtxSelectOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.DtxStart result = new RabbitMQ.Client.Framing.Impl.v0_8.DtxStart();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.DtxStartOk result = new RabbitMQ.Client.Framing.Impl.v0_8.DtxStartOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 110: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.TunnelRequest result = new RabbitMQ.Client.Framing.Impl.v0_8.TunnelRequest();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 120: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestInteger result = new RabbitMQ.Client.Framing.Impl.v0_8.TestInteger();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestIntegerOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TestIntegerOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestString result = new RabbitMQ.Client.Framing.Impl.v0_8.TestString();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestStringOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TestStringOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestTable result = new RabbitMQ.Client.Framing.Impl.v0_8.TestTable();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestTableOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TestTableOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestContent result = new RabbitMQ.Client.Framing.Impl.v0_8.TestContent();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_8.TestContentOk result = new RabbitMQ.Client.Framing.Impl.v0_8.TestContentOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        default: break;
      }
      throw new RabbitMQ.Client.Impl.UnknownClassOrMethodException(classId, methodId);
    }

    public override RabbitMQ.Client.Impl.ContentHeaderBase DecodeContentHeaderFrom(RabbitMQ.Util.NetworkBinaryReader reader) {
      ushort classId = reader.ReadUInt16();

      switch (classId) {
        case 60: return new BasicProperties();
        case 70: return new FileProperties();
        case 80: return new StreamProperties();
        case 110: return new TunnelProperties();
        case 120: return new TestProperties();
        default: break;
      }
      throw new RabbitMQ.Client.Impl.UnknownClassOrMethodException(classId, 0);
    }
  }
  public class Constants {
    ///<summary>(= 1)</summary>
    public const int FrameMethod = 1;
    ///<summary>(= 2)</summary>
    public const int FrameHeader = 2;
    ///<summary>(= 3)</summary>
    public const int FrameBody = 3;
    ///<summary>(= 4)</summary>
    public const int FrameOobMethod = 4;
    ///<summary>(= 5)</summary>
    public const int FrameOobHeader = 5;
    ///<summary>(= 6)</summary>
    public const int FrameOobBody = 6;
    ///<summary>(= 7)</summary>
    public const int FrameTrace = 7;
    ///<summary>(= 8)</summary>
    public const int FrameHeartbeat = 8;
    ///<summary>(= 4096)</summary>
    public const int FrameMinSize = 4096;
    ///<summary>(= 206)</summary>
    public const int FrameEnd = 206;
    ///<summary>(= 200)</summary>
    public const int ReplySuccess = 200;
    ///<summary>(= 310)</summary>
    public const int NotDelivered = 310;
    ///<summary>(= 311)</summary>
    public const int ContentTooLarge = 311;
    ///<summary>(= 320)</summary>
    public const int ConnectionForced = 320;
    ///<summary>(= 402)</summary>
    public const int InvalidPath = 402;
    ///<summary>(= 403)</summary>
    public const int AccessRefused = 403;
    ///<summary>(= 404)</summary>
    public const int NotFound = 404;
    ///<summary>(= 405)</summary>
    public const int ResourceLocked = 405;
    ///<summary>(= 501)</summary>
    public const int FrameError = 501;
    ///<summary>(= 502)</summary>
    public const int SyntaxError = 502;
    ///<summary>(= 503)</summary>
    public const int CommandInvalid = 503;
    ///<summary>(= 504)</summary>
    public const int ChannelError = 504;
    ///<summary>(= 506)</summary>
    public const int ResourceError = 506;
    ///<summary>(= 530)</summary>
    public const int NotAllowed = 530;
    ///<summary>(= 540)</summary>
    public const int NotImplemented = 540;
    ///<summary>(= 541)</summary>
    public const int InternalError = 541;
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.start".</summary>
  public interface IConnectionStart: IMethod {
    byte VersionMajor { get; }
    byte VersionMinor { get; }
    System.Collections.IDictionary ServerProperties { get; }
    byte[] Mechanisms { get; }
    byte[] Locales { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.start-ok".</summary>
  public interface IConnectionStartOk: IMethod {
    System.Collections.IDictionary ClientProperties { get; }
    string Mechanism { get; }
    byte[] Response { get; }
    string Locale { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.secure".</summary>
  public interface IConnectionSecure: IMethod {
    byte[] Challenge { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.secure-ok".</summary>
  public interface IConnectionSecureOk: IMethod {
    byte[] Response { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.tune".</summary>
  public interface IConnectionTune: IMethod {
    ushort ChannelMax { get; }
    uint FrameMax { get; }
    ushort Heartbeat { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.tune-ok".</summary>
  public interface IConnectionTuneOk: IMethod {
    ushort ChannelMax { get; }
    uint FrameMax { get; }
    ushort Heartbeat { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.open".</summary>
  public interface IConnectionOpen: IMethod {
    string VirtualHost { get; }
    string Capabilities { get; }
    bool Insist { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.open-ok".</summary>
  public interface IConnectionOpenOk: IMethod {
    string KnownHosts { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.redirect".</summary>
  public interface IConnectionRedirect: IMethod {
    string Host { get; }
    string KnownHosts { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.close".</summary>
  public interface IConnectionClose: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    ushort ClassId { get; }
    ushort MethodId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.close-ok".</summary>
  public interface IConnectionCloseOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.open".</summary>
  public interface IChannelOpen: IMethod {
    string OutOfBand { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.open-ok".</summary>
  public interface IChannelOpenOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.flow".</summary>
  public interface IChannelFlow: IMethod {
    bool Active { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.flow-ok".</summary>
  public interface IChannelFlowOk: IMethod {
    bool Active { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.alert".</summary>
  public interface IChannelAlert: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    System.Collections.IDictionary Details { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.close".</summary>
  public interface IChannelClose: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    ushort ClassId { get; }
    ushort MethodId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.close-ok".</summary>
  public interface IChannelCloseOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "access.request".</summary>
  public interface IAccessRequest: IMethod {
    string Realm { get; }
    bool Exclusive { get; }
    bool Passive { get; }
    bool Active { get; }
    bool Write { get; }
    bool Read { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "access.request-ok".</summary>
  public interface IAccessRequestOk: IMethod {
    ushort Ticket { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.declare".</summary>
  public interface IExchangeDeclare: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string Type { get; }
    bool Passive { get; }
    bool Durable { get; }
    bool AutoDelete { get; }
    bool Internal { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.declare-ok".</summary>
  public interface IExchangeDeclareOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.delete".</summary>
  public interface IExchangeDelete: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    bool IfUnused { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.delete-ok".</summary>
  public interface IExchangeDeleteOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.declare".</summary>
  public interface IQueueDeclare: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool Passive { get; }
    bool Durable { get; }
    bool Exclusive { get; }
    bool AutoDelete { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.declare-ok".</summary>
  public interface IQueueDeclareOk: IMethod {
    string Queue { get; }
    uint MessageCount { get; }
    uint ConsumerCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.bind".</summary>
  public interface IQueueBind: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.bind-ok".</summary>
  public interface IQueueBindOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.purge".</summary>
  public interface IQueuePurge: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.purge-ok".</summary>
  public interface IQueuePurgeOk: IMethod {
    uint MessageCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.delete".</summary>
  public interface IQueueDelete: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool IfUnused { get; }
    bool IfEmpty { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.delete-ok".</summary>
  public interface IQueueDeleteOk: IMethod {
    uint MessageCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.qos".</summary>
  public interface IBasicQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.qos-ok".</summary>
  public interface IBasicQosOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.consume".</summary>
  public interface IBasicConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string ConsumerTag { get; }
    bool NoLocal { get; }
    bool NoAck { get; }
    bool Exclusive { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.consume-ok".</summary>
  public interface IBasicConsumeOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.cancel".</summary>
  public interface IBasicCancel: IMethod {
    string ConsumerTag { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.cancel-ok".</summary>
  public interface IBasicCancelOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.publish".</summary>
  public interface IBasicPublish: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Mandatory { get; }
    bool Immediate { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.return".</summary>
  public interface IBasicReturn: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.deliver".</summary>
  public interface IBasicDeliver: IMethod {
    string ConsumerTag { get; }
    ulong DeliveryTag { get; }
    bool Redelivered { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.get".</summary>
  public interface IBasicGet: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool NoAck { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.get-ok".</summary>
  public interface IBasicGetOk: IMethod {
    ulong DeliveryTag { get; }
    bool Redelivered { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    uint MessageCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.get-empty".</summary>
  public interface IBasicGetEmpty: IMethod {
    string ClusterId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.ack".</summary>
  public interface IBasicAck: IMethod {
    ulong DeliveryTag { get; }
    bool Multiple { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.reject".</summary>
  public interface IBasicReject: IMethod {
    ulong DeliveryTag { get; }
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.recover".</summary>
  public interface IBasicRecover: IMethod {
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.qos".</summary>
  public interface IFileQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.qos-ok".</summary>
  public interface IFileQosOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "file.consume".</summary>
  public interface IFileConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string ConsumerTag { get; }
    bool NoLocal { get; }
    bool NoAck { get; }
    bool Exclusive { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.consume-ok".</summary>
  public interface IFileConsumeOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.cancel".</summary>
  public interface IFileCancel: IMethod {
    string ConsumerTag { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.cancel-ok".</summary>
  public interface IFileCancelOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.open".</summary>
  public interface IFileOpen: IMethod {
    string Identifier { get; }
    ulong ContentSize { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.open-ok".</summary>
  public interface IFileOpenOk: IMethod {
    ulong StagedSize { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.stage".</summary>
  public interface IFileStage: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "file.publish".</summary>
  public interface IFilePublish: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Mandatory { get; }
    bool Immediate { get; }
    string Identifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.return".</summary>
  public interface IFileReturn: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.deliver".</summary>
  public interface IFileDeliver: IMethod {
    string ConsumerTag { get; }
    ulong DeliveryTag { get; }
    bool Redelivered { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    string Identifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.ack".</summary>
  public interface IFileAck: IMethod {
    ulong DeliveryTag { get; }
    bool Multiple { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.reject".</summary>
  public interface IFileReject: IMethod {
    ulong DeliveryTag { get; }
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.qos".</summary>
  public interface IStreamQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    uint ConsumeRate { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.qos-ok".</summary>
  public interface IStreamQosOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.consume".</summary>
  public interface IStreamConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string ConsumerTag { get; }
    bool NoLocal { get; }
    bool Exclusive { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.consume-ok".</summary>
  public interface IStreamConsumeOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.cancel".</summary>
  public interface IStreamCancel: IMethod {
    string ConsumerTag { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.cancel-ok".</summary>
  public interface IStreamCancelOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.publish".</summary>
  public interface IStreamPublish: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Mandatory { get; }
    bool Immediate { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.return".</summary>
  public interface IStreamReturn: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.deliver".</summary>
  public interface IStreamDeliver: IMethod {
    string ConsumerTag { get; }
    ulong DeliveryTag { get; }
    string Exchange { get; }
    string Queue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.select".</summary>
  public interface ITxSelect: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.select-ok".</summary>
  public interface ITxSelectOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.commit".</summary>
  public interface ITxCommit: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.commit-ok".</summary>
  public interface ITxCommitOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.rollback".</summary>
  public interface ITxRollback: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.rollback-ok".</summary>
  public interface ITxRollbackOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.select".</summary>
  public interface IDtxSelect: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.select-ok".</summary>
  public interface IDtxSelectOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.start".</summary>
  public interface IDtxStart: IMethod {
    string DtxIdentifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.start-ok".</summary>
  public interface IDtxStartOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tunnel.request".</summary>
  public interface ITunnelRequest: IMethod {
    System.Collections.IDictionary MetaData { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.integer".</summary>
  public interface ITestInteger: IMethod {
    byte Integer1 { get; }
    ushort Integer2 { get; }
    uint Integer3 { get; }
    ulong Integer4 { get; }
    byte Operation { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.integer-ok".</summary>
  public interface ITestIntegerOk: IMethod {
    ulong Result { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.string".</summary>
  public interface ITestString: IMethod {
    string String1 { get; }
    byte[] String2 { get; }
    byte Operation { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.string-ok".</summary>
  public interface ITestStringOk: IMethod {
    byte[] Result { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.table".</summary>
  public interface ITestTable: IMethod {
    System.Collections.IDictionary Table { get; }
    byte IntegerOp { get; }
    byte StringOp { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.table-ok".</summary>
  public interface ITestTableOk: IMethod {
    ulong IntegerResult { get; }
    byte[] StringResult { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "test.content".</summary>
  public interface ITestContent: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "test.content-ok".</summary>
  public interface ITestContentOk: IMethod {
    uint ContentChecksum { get; }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "basic"</summary>
  public class BasicProperties: RabbitMQ.Client.Impl.BasicProperties {
    private string m_contentType;
    private string m_contentEncoding;
    private System.Collections.IDictionary m_headers;
    private byte m_deliveryMode;
    private byte m_priority;
    private string m_correlationId;
    private string m_replyTo;
    private string m_expiration;
    private string m_messageId;
    private AmqpTimestamp m_timestamp;
    private string m_type;
    private string m_userId;
    private string m_appId;
    private string m_clusterId;

    private bool contentType_present = false;
    private bool contentEncoding_present = false;
    private bool headers_present = false;
    private bool deliveryMode_present = false;
    private bool priority_present = false;
    private bool correlationId_present = false;
    private bool replyTo_present = false;
    private bool expiration_present = false;
    private bool messageId_present = false;
    private bool timestamp_present = false;
    private bool type_present = false;
    private bool userId_present = false;
    private bool appId_present = false;
    private bool clusterId_present = false;

    public override string ContentType {
      get {
        return m_contentType;
      }
      set {
        contentType_present = true;
        m_contentType = value;
      }
    }
    public override string ContentEncoding {
      get {
        return m_contentEncoding;
      }
      set {
        contentEncoding_present = true;
        m_contentEncoding = value;
      }
    }
    public override System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        headers_present = true;
        m_headers = value;
      }
    }
    public override byte DeliveryMode {
      get {
        return m_deliveryMode;
      }
      set {
        deliveryMode_present = true;
        m_deliveryMode = value;
      }
    }
    public override byte Priority {
      get {
        return m_priority;
      }
      set {
        priority_present = true;
        m_priority = value;
      }
    }
    public override string CorrelationId {
      get {
        return m_correlationId;
      }
      set {
        correlationId_present = true;
        m_correlationId = value;
      }
    }
    public override string ReplyTo {
      get {
        return m_replyTo;
      }
      set {
        replyTo_present = true;
        m_replyTo = value;
      }
    }
    public override string Expiration {
      get {
        return m_expiration;
      }
      set {
        expiration_present = true;
        m_expiration = value;
      }
    }
    public override string MessageId {
      get {
        return m_messageId;
      }
      set {
        messageId_present = true;
        m_messageId = value;
      }
    }
    public override AmqpTimestamp Timestamp {
      get {
        return m_timestamp;
      }
      set {
        timestamp_present = true;
        m_timestamp = value;
      }
    }
    public override string Type {
      get {
        return m_type;
      }
      set {
        type_present = true;
        m_type = value;
      }
    }
    public override string UserId {
      get {
        return m_userId;
      }
      set {
        userId_present = true;
        m_userId = value;
      }
    }
    public override string AppId {
      get {
        return m_appId;
      }
      set {
        appId_present = true;
        m_appId = value;
      }
    }
    public override string ClusterId {
      get {
        return m_clusterId;
      }
      set {
        clusterId_present = true;
        m_clusterId = value;
      }
    }

    public override void ClearContentType() { contentType_present = false; }
    public override void ClearContentEncoding() { contentEncoding_present = false; }
    public override void ClearHeaders() { headers_present = false; }
    public override void ClearDeliveryMode() { deliveryMode_present = false; }
    public override void ClearPriority() { priority_present = false; }
    public override void ClearCorrelationId() { correlationId_present = false; }
    public override void ClearReplyTo() { replyTo_present = false; }
    public override void ClearExpiration() { expiration_present = false; }
    public override void ClearMessageId() { messageId_present = false; }
    public override void ClearTimestamp() { timestamp_present = false; }
    public override void ClearType() { type_present = false; }
    public override void ClearUserId() { userId_present = false; }
    public override void ClearAppId() { appId_present = false; }
    public override void ClearClusterId() { clusterId_present = false; }

    public BasicProperties() {}
    public override int ProtocolClassId { get { return 60; } }
    public override string ProtocolClassName { get { return "basic"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      contentType_present = reader.ReadPresence();
      contentEncoding_present = reader.ReadPresence();
      headers_present = reader.ReadPresence();
      deliveryMode_present = reader.ReadPresence();
      priority_present = reader.ReadPresence();
      correlationId_present = reader.ReadPresence();
      replyTo_present = reader.ReadPresence();
      expiration_present = reader.ReadPresence();
      messageId_present = reader.ReadPresence();
      timestamp_present = reader.ReadPresence();
      type_present = reader.ReadPresence();
      userId_present = reader.ReadPresence();
      appId_present = reader.ReadPresence();
      clusterId_present = reader.ReadPresence();
      reader.FinishPresence();
      if (contentType_present) { m_contentType = reader.ReadShortstr(); }
      if (contentEncoding_present) { m_contentEncoding = reader.ReadShortstr(); }
      if (headers_present) { m_headers = reader.ReadTable(); }
      if (deliveryMode_present) { m_deliveryMode = reader.ReadOctet(); }
      if (priority_present) { m_priority = reader.ReadOctet(); }
      if (correlationId_present) { m_correlationId = reader.ReadShortstr(); }
      if (replyTo_present) { m_replyTo = reader.ReadShortstr(); }
      if (expiration_present) { m_expiration = reader.ReadShortstr(); }
      if (messageId_present) { m_messageId = reader.ReadShortstr(); }
      if (timestamp_present) { m_timestamp = reader.ReadTimestamp(); }
      if (type_present) { m_type = reader.ReadShortstr(); }
      if (userId_present) { m_userId = reader.ReadShortstr(); }
      if (appId_present) { m_appId = reader.ReadShortstr(); }
      if (clusterId_present) { m_clusterId = reader.ReadShortstr(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(contentType_present);
      writer.WritePresence(contentEncoding_present);
      writer.WritePresence(headers_present);
      writer.WritePresence(deliveryMode_present);
      writer.WritePresence(priority_present);
      writer.WritePresence(correlationId_present);
      writer.WritePresence(replyTo_present);
      writer.WritePresence(expiration_present);
      writer.WritePresence(messageId_present);
      writer.WritePresence(timestamp_present);
      writer.WritePresence(type_present);
      writer.WritePresence(userId_present);
      writer.WritePresence(appId_present);
      writer.WritePresence(clusterId_present);
      writer.FinishPresence();
      if (contentType_present) { writer.WriteShortstr(m_contentType); }
      if (contentEncoding_present) { writer.WriteShortstr(m_contentEncoding); }
      if (headers_present) { writer.WriteTable(m_headers); }
      if (deliveryMode_present) { writer.WriteOctet(m_deliveryMode); }
      if (priority_present) { writer.WriteOctet(m_priority); }
      if (correlationId_present) { writer.WriteShortstr(m_correlationId); }
      if (replyTo_present) { writer.WriteShortstr(m_replyTo); }
      if (expiration_present) { writer.WriteShortstr(m_expiration); }
      if (messageId_present) { writer.WriteShortstr(m_messageId); }
      if (timestamp_present) { writer.WriteTimestamp(m_timestamp); }
      if (type_present) { writer.WriteShortstr(m_type); }
      if (userId_present) { writer.WriteShortstr(m_userId); }
      if (appId_present) { writer.WriteShortstr(m_appId); }
      if (clusterId_present) { writer.WriteShortstr(m_clusterId); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("content type="); sb.Append(contentType_present ? (m_contentType == null ? "(null)" : m_contentType.ToString()) : "_"); sb.Append(", ");
      sb.Append("content encoding="); sb.Append(contentEncoding_present ? (m_contentEncoding == null ? "(null)" : m_contentEncoding.ToString()) : "_"); sb.Append(", ");
      sb.Append("headers="); sb.Append(headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("delivery mode="); sb.Append(deliveryMode_present ? m_deliveryMode.ToString() : "_"); sb.Append(", ");
      sb.Append("priority="); sb.Append(priority_present ? m_priority.ToString() : "_"); sb.Append(", ");
      sb.Append("correlation id="); sb.Append(correlationId_present ? (m_correlationId == null ? "(null)" : m_correlationId.ToString()) : "_"); sb.Append(", ");
      sb.Append("reply to="); sb.Append(replyTo_present ? (m_replyTo == null ? "(null)" : m_replyTo.ToString()) : "_"); sb.Append(", ");
      sb.Append("expiration="); sb.Append(expiration_present ? (m_expiration == null ? "(null)" : m_expiration.ToString()) : "_"); sb.Append(", ");
      sb.Append("message id="); sb.Append(messageId_present ? (m_messageId == null ? "(null)" : m_messageId.ToString()) : "_"); sb.Append(", ");
      sb.Append("timestamp="); sb.Append(timestamp_present ? m_timestamp.ToString() : "_"); sb.Append(", ");
      sb.Append("type="); sb.Append(type_present ? (m_type == null ? "(null)" : m_type.ToString()) : "_"); sb.Append(", ");
      sb.Append("user id="); sb.Append(userId_present ? (m_userId == null ? "(null)" : m_userId.ToString()) : "_"); sb.Append(", ");
      sb.Append("app id="); sb.Append(appId_present ? (m_appId == null ? "(null)" : m_appId.ToString()) : "_"); sb.Append(", ");
      sb.Append("cluster id="); sb.Append(clusterId_present ? (m_clusterId == null ? "(null)" : m_clusterId.ToString()) : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "file"</summary>
  public class FileProperties: RabbitMQ.Client.Impl.FileProperties {
    private string m_contentType;
    private string m_contentEncoding;
    private System.Collections.IDictionary m_headers;
    private byte m_priority;
    private string m_replyTo;
    private string m_messageId;
    private string m_filename;
    private AmqpTimestamp m_timestamp;
    private string m_clusterId;

    private bool contentType_present = false;
    private bool contentEncoding_present = false;
    private bool headers_present = false;
    private bool priority_present = false;
    private bool replyTo_present = false;
    private bool messageId_present = false;
    private bool filename_present = false;
    private bool timestamp_present = false;
    private bool clusterId_present = false;

    public override string ContentType {
      get {
        return m_contentType;
      }
      set {
        contentType_present = true;
        m_contentType = value;
      }
    }
    public override string ContentEncoding {
      get {
        return m_contentEncoding;
      }
      set {
        contentEncoding_present = true;
        m_contentEncoding = value;
      }
    }
    public override System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        headers_present = true;
        m_headers = value;
      }
    }
    public override byte Priority {
      get {
        return m_priority;
      }
      set {
        priority_present = true;
        m_priority = value;
      }
    }
    public override string ReplyTo {
      get {
        return m_replyTo;
      }
      set {
        replyTo_present = true;
        m_replyTo = value;
      }
    }
    public override string MessageId {
      get {
        return m_messageId;
      }
      set {
        messageId_present = true;
        m_messageId = value;
      }
    }
    public override string Filename {
      get {
        return m_filename;
      }
      set {
        filename_present = true;
        m_filename = value;
      }
    }
    public override AmqpTimestamp Timestamp {
      get {
        return m_timestamp;
      }
      set {
        timestamp_present = true;
        m_timestamp = value;
      }
    }
    public override string ClusterId {
      get {
        return m_clusterId;
      }
      set {
        clusterId_present = true;
        m_clusterId = value;
      }
    }

    public override void ClearContentType() { contentType_present = false; }
    public override void ClearContentEncoding() { contentEncoding_present = false; }
    public override void ClearHeaders() { headers_present = false; }
    public override void ClearPriority() { priority_present = false; }
    public override void ClearReplyTo() { replyTo_present = false; }
    public override void ClearMessageId() { messageId_present = false; }
    public override void ClearFilename() { filename_present = false; }
    public override void ClearTimestamp() { timestamp_present = false; }
    public override void ClearClusterId() { clusterId_present = false; }

    public FileProperties() {}
    public override int ProtocolClassId { get { return 70; } }
    public override string ProtocolClassName { get { return "file"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      contentType_present = reader.ReadPresence();
      contentEncoding_present = reader.ReadPresence();
      headers_present = reader.ReadPresence();
      priority_present = reader.ReadPresence();
      replyTo_present = reader.ReadPresence();
      messageId_present = reader.ReadPresence();
      filename_present = reader.ReadPresence();
      timestamp_present = reader.ReadPresence();
      clusterId_present = reader.ReadPresence();
      reader.FinishPresence();
      if (contentType_present) { m_contentType = reader.ReadShortstr(); }
      if (contentEncoding_present) { m_contentEncoding = reader.ReadShortstr(); }
      if (headers_present) { m_headers = reader.ReadTable(); }
      if (priority_present) { m_priority = reader.ReadOctet(); }
      if (replyTo_present) { m_replyTo = reader.ReadShortstr(); }
      if (messageId_present) { m_messageId = reader.ReadShortstr(); }
      if (filename_present) { m_filename = reader.ReadShortstr(); }
      if (timestamp_present) { m_timestamp = reader.ReadTimestamp(); }
      if (clusterId_present) { m_clusterId = reader.ReadShortstr(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(contentType_present);
      writer.WritePresence(contentEncoding_present);
      writer.WritePresence(headers_present);
      writer.WritePresence(priority_present);
      writer.WritePresence(replyTo_present);
      writer.WritePresence(messageId_present);
      writer.WritePresence(filename_present);
      writer.WritePresence(timestamp_present);
      writer.WritePresence(clusterId_present);
      writer.FinishPresence();
      if (contentType_present) { writer.WriteShortstr(m_contentType); }
      if (contentEncoding_present) { writer.WriteShortstr(m_contentEncoding); }
      if (headers_present) { writer.WriteTable(m_headers); }
      if (priority_present) { writer.WriteOctet(m_priority); }
      if (replyTo_present) { writer.WriteShortstr(m_replyTo); }
      if (messageId_present) { writer.WriteShortstr(m_messageId); }
      if (filename_present) { writer.WriteShortstr(m_filename); }
      if (timestamp_present) { writer.WriteTimestamp(m_timestamp); }
      if (clusterId_present) { writer.WriteShortstr(m_clusterId); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("content type="); sb.Append(contentType_present ? (m_contentType == null ? "(null)" : m_contentType.ToString()) : "_"); sb.Append(", ");
      sb.Append("content encoding="); sb.Append(contentEncoding_present ? (m_contentEncoding == null ? "(null)" : m_contentEncoding.ToString()) : "_"); sb.Append(", ");
      sb.Append("headers="); sb.Append(headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("priority="); sb.Append(priority_present ? m_priority.ToString() : "_"); sb.Append(", ");
      sb.Append("reply to="); sb.Append(replyTo_present ? (m_replyTo == null ? "(null)" : m_replyTo.ToString()) : "_"); sb.Append(", ");
      sb.Append("message id="); sb.Append(messageId_present ? (m_messageId == null ? "(null)" : m_messageId.ToString()) : "_"); sb.Append(", ");
      sb.Append("filename="); sb.Append(filename_present ? (m_filename == null ? "(null)" : m_filename.ToString()) : "_"); sb.Append(", ");
      sb.Append("timestamp="); sb.Append(timestamp_present ? m_timestamp.ToString() : "_"); sb.Append(", ");
      sb.Append("cluster id="); sb.Append(clusterId_present ? (m_clusterId == null ? "(null)" : m_clusterId.ToString()) : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "stream"</summary>
  public class StreamProperties: RabbitMQ.Client.Impl.StreamProperties {
    private string m_contentType;
    private string m_contentEncoding;
    private System.Collections.IDictionary m_headers;
    private byte m_priority;
    private AmqpTimestamp m_timestamp;

    private bool contentType_present = false;
    private bool contentEncoding_present = false;
    private bool headers_present = false;
    private bool priority_present = false;
    private bool timestamp_present = false;

    public override string ContentType {
      get {
        return m_contentType;
      }
      set {
        contentType_present = true;
        m_contentType = value;
      }
    }
    public override string ContentEncoding {
      get {
        return m_contentEncoding;
      }
      set {
        contentEncoding_present = true;
        m_contentEncoding = value;
      }
    }
    public override System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        headers_present = true;
        m_headers = value;
      }
    }
    public override byte Priority {
      get {
        return m_priority;
      }
      set {
        priority_present = true;
        m_priority = value;
      }
    }
    public override AmqpTimestamp Timestamp {
      get {
        return m_timestamp;
      }
      set {
        timestamp_present = true;
        m_timestamp = value;
      }
    }

    public override void ClearContentType() { contentType_present = false; }
    public override void ClearContentEncoding() { contentEncoding_present = false; }
    public override void ClearHeaders() { headers_present = false; }
    public override void ClearPriority() { priority_present = false; }
    public override void ClearTimestamp() { timestamp_present = false; }

    public StreamProperties() {}
    public override int ProtocolClassId { get { return 80; } }
    public override string ProtocolClassName { get { return "stream"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      contentType_present = reader.ReadPresence();
      contentEncoding_present = reader.ReadPresence();
      headers_present = reader.ReadPresence();
      priority_present = reader.ReadPresence();
      timestamp_present = reader.ReadPresence();
      reader.FinishPresence();
      if (contentType_present) { m_contentType = reader.ReadShortstr(); }
      if (contentEncoding_present) { m_contentEncoding = reader.ReadShortstr(); }
      if (headers_present) { m_headers = reader.ReadTable(); }
      if (priority_present) { m_priority = reader.ReadOctet(); }
      if (timestamp_present) { m_timestamp = reader.ReadTimestamp(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(contentType_present);
      writer.WritePresence(contentEncoding_present);
      writer.WritePresence(headers_present);
      writer.WritePresence(priority_present);
      writer.WritePresence(timestamp_present);
      writer.FinishPresence();
      if (contentType_present) { writer.WriteShortstr(m_contentType); }
      if (contentEncoding_present) { writer.WriteShortstr(m_contentEncoding); }
      if (headers_present) { writer.WriteTable(m_headers); }
      if (priority_present) { writer.WriteOctet(m_priority); }
      if (timestamp_present) { writer.WriteTimestamp(m_timestamp); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("content type="); sb.Append(contentType_present ? (m_contentType == null ? "(null)" : m_contentType.ToString()) : "_"); sb.Append(", ");
      sb.Append("content encoding="); sb.Append(contentEncoding_present ? (m_contentEncoding == null ? "(null)" : m_contentEncoding.ToString()) : "_"); sb.Append(", ");
      sb.Append("headers="); sb.Append(headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("priority="); sb.Append(priority_present ? m_priority.ToString() : "_"); sb.Append(", ");
      sb.Append("timestamp="); sb.Append(timestamp_present ? m_timestamp.ToString() : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "tunnel"</summary>
  public class TunnelProperties: RabbitMQ.Client.Impl.ContentHeaderBase {
    private System.Collections.IDictionary m_headers;
    private string m_proxyName;
    private string m_dataName;
    private byte m_durable;
    private byte m_broadcast;

    private bool headers_present = false;
    private bool proxyName_present = false;
    private bool dataName_present = false;
    private bool durable_present = false;
    private bool broadcast_present = false;

    public System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        headers_present = true;
        m_headers = value;
      }
    }
    public string ProxyName {
      get {
        return m_proxyName;
      }
      set {
        proxyName_present = true;
        m_proxyName = value;
      }
    }
    public string DataName {
      get {
        return m_dataName;
      }
      set {
        dataName_present = true;
        m_dataName = value;
      }
    }
    public byte Durable {
      get {
        return m_durable;
      }
      set {
        durable_present = true;
        m_durable = value;
      }
    }
    public byte Broadcast {
      get {
        return m_broadcast;
      }
      set {
        broadcast_present = true;
        m_broadcast = value;
      }
    }

    public void ClearHeaders() { headers_present = false; }
    public void ClearProxyName() { proxyName_present = false; }
    public void ClearDataName() { dataName_present = false; }
    public void ClearDurable() { durable_present = false; }
    public void ClearBroadcast() { broadcast_present = false; }

    public TunnelProperties() {}
    public override int ProtocolClassId { get { return 110; } }
    public override string ProtocolClassName { get { return "tunnel"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      headers_present = reader.ReadPresence();
      proxyName_present = reader.ReadPresence();
      dataName_present = reader.ReadPresence();
      durable_present = reader.ReadPresence();
      broadcast_present = reader.ReadPresence();
      reader.FinishPresence();
      if (headers_present) { m_headers = reader.ReadTable(); }
      if (proxyName_present) { m_proxyName = reader.ReadShortstr(); }
      if (dataName_present) { m_dataName = reader.ReadShortstr(); }
      if (durable_present) { m_durable = reader.ReadOctet(); }
      if (broadcast_present) { m_broadcast = reader.ReadOctet(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(headers_present);
      writer.WritePresence(proxyName_present);
      writer.WritePresence(dataName_present);
      writer.WritePresence(durable_present);
      writer.WritePresence(broadcast_present);
      writer.FinishPresence();
      if (headers_present) { writer.WriteTable(m_headers); }
      if (proxyName_present) { writer.WriteShortstr(m_proxyName); }
      if (dataName_present) { writer.WriteShortstr(m_dataName); }
      if (durable_present) { writer.WriteOctet(m_durable); }
      if (broadcast_present) { writer.WriteOctet(m_broadcast); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("headers="); sb.Append(headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("proxy name="); sb.Append(proxyName_present ? (m_proxyName == null ? "(null)" : m_proxyName.ToString()) : "_"); sb.Append(", ");
      sb.Append("data name="); sb.Append(dataName_present ? (m_dataName == null ? "(null)" : m_dataName.ToString()) : "_"); sb.Append(", ");
      sb.Append("durable="); sb.Append(durable_present ? m_durable.ToString() : "_"); sb.Append(", ");
      sb.Append("broadcast="); sb.Append(broadcast_present ? m_broadcast.ToString() : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "test"</summary>
  public class TestProperties: RabbitMQ.Client.Impl.ContentHeaderBase {




    public TestProperties() {}
    public override int ProtocolClassId { get { return 120; } }
    public override string ProtocolClassName { get { return "test"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      reader.FinishPresence();
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.FinishPresence();
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
}
namespace RabbitMQ.Client.Framing.Impl.v0_8 {
  using RabbitMQ.Client.Framing.v0_8;
  public enum ClassId {
    Connection = 10,
    Channel = 20,
    Access = 30,
    Exchange = 40,
    Queue = 50,
    Basic = 60,
    File = 70,
    Stream = 80,
    Tx = 90,
    Dtx = 100,
    Tunnel = 110,
    Test = 120,
    Invalid = -1
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionStart: RabbitMQ.Client.Impl.MethodBase, IConnectionStart {
    public const int ClassId = 10;
    public const int MethodId = 10;

    public byte m_versionMajor;
    public byte m_versionMinor;
    public System.Collections.IDictionary m_serverProperties;
    public byte[] m_mechanisms;
    public byte[] m_locales;

    byte IConnectionStart.VersionMajor { get { return m_versionMajor; } }
    byte IConnectionStart.VersionMinor { get { return m_versionMinor; } }
    System.Collections.IDictionary IConnectionStart.ServerProperties { get { return m_serverProperties; } }
    byte[] IConnectionStart.Mechanisms { get { return m_mechanisms; } }
    byte[] IConnectionStart.Locales { get { return m_locales; } }

    public ConnectionStart() {}
    public ConnectionStart(
      byte initVersionMajor,
      byte initVersionMinor,
      System.Collections.IDictionary initServerProperties,
      byte[] initMechanisms,
      byte[] initLocales)
    {
      m_versionMajor = initVersionMajor;
      m_versionMinor = initVersionMinor;
      m_serverProperties = initServerProperties;
      m_mechanisms = initMechanisms;
      m_locales = initLocales;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "connection.start"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_versionMajor = reader.ReadOctet();
      m_versionMinor = reader.ReadOctet();
      m_serverProperties = reader.ReadTable();
      m_mechanisms = reader.ReadLongstr();
      m_locales = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteOctet(m_versionMajor);
      writer.WriteOctet(m_versionMinor);
      writer.WriteTable(m_serverProperties);
      writer.WriteLongstr(m_mechanisms);
      writer.WriteLongstr(m_locales);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_versionMajor); sb.Append(",");
      sb.Append(m_versionMinor); sb.Append(",");
      sb.Append(m_serverProperties); sb.Append(",");
      sb.Append(m_mechanisms); sb.Append(",");
      sb.Append(m_locales);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionStartOk: RabbitMQ.Client.Impl.MethodBase, IConnectionStartOk {
    public const int ClassId = 10;
    public const int MethodId = 11;

    public System.Collections.IDictionary m_clientProperties;
    public string m_mechanism;
    public byte[] m_response;
    public string m_locale;

    System.Collections.IDictionary IConnectionStartOk.ClientProperties { get { return m_clientProperties; } }
    string IConnectionStartOk.Mechanism { get { return m_mechanism; } }
    byte[] IConnectionStartOk.Response { get { return m_response; } }
    string IConnectionStartOk.Locale { get { return m_locale; } }

    public ConnectionStartOk() {}
    public ConnectionStartOk(
      System.Collections.IDictionary initClientProperties,
      string initMechanism,
      byte[] initResponse,
      string initLocale)
    {
      m_clientProperties = initClientProperties;
      m_mechanism = initMechanism;
      m_response = initResponse;
      m_locale = initLocale;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "connection.start-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_clientProperties = reader.ReadTable();
      m_mechanism = reader.ReadShortstr();
      m_response = reader.ReadLongstr();
      m_locale = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteTable(m_clientProperties);
      writer.WriteShortstr(m_mechanism);
      writer.WriteLongstr(m_response);
      writer.WriteShortstr(m_locale);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_clientProperties); sb.Append(",");
      sb.Append(m_mechanism); sb.Append(",");
      sb.Append(m_response); sb.Append(",");
      sb.Append(m_locale);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionSecure: RabbitMQ.Client.Impl.MethodBase, IConnectionSecure {
    public const int ClassId = 10;
    public const int MethodId = 20;

    public byte[] m_challenge;

    byte[] IConnectionSecure.Challenge { get { return m_challenge; } }

    public ConnectionSecure() {}
    public ConnectionSecure(
      byte[] initChallenge)
    {
      m_challenge = initChallenge;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "connection.secure"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_challenge = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_challenge);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_challenge);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionSecureOk: RabbitMQ.Client.Impl.MethodBase, IConnectionSecureOk {
    public const int ClassId = 10;
    public const int MethodId = 21;

    public byte[] m_response;

    byte[] IConnectionSecureOk.Response { get { return m_response; } }

    public ConnectionSecureOk() {}
    public ConnectionSecureOk(
      byte[] initResponse)
    {
      m_response = initResponse;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "connection.secure-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_response = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_response);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_response);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionTune: RabbitMQ.Client.Impl.MethodBase, IConnectionTune {
    public const int ClassId = 10;
    public const int MethodId = 30;

    public ushort m_channelMax;
    public uint m_frameMax;
    public ushort m_heartbeat;

    ushort IConnectionTune.ChannelMax { get { return m_channelMax; } }
    uint IConnectionTune.FrameMax { get { return m_frameMax; } }
    ushort IConnectionTune.Heartbeat { get { return m_heartbeat; } }

    public ConnectionTune() {}
    public ConnectionTune(
      ushort initChannelMax,
      uint initFrameMax,
      ushort initHeartbeat)
    {
      m_channelMax = initChannelMax;
      m_frameMax = initFrameMax;
      m_heartbeat = initHeartbeat;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "connection.tune"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_channelMax = reader.ReadShort();
      m_frameMax = reader.ReadLong();
      m_heartbeat = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_channelMax);
      writer.WriteLong(m_frameMax);
      writer.WriteShort(m_heartbeat);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_channelMax); sb.Append(",");
      sb.Append(m_frameMax); sb.Append(",");
      sb.Append(m_heartbeat);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionTuneOk: RabbitMQ.Client.Impl.MethodBase, IConnectionTuneOk {
    public const int ClassId = 10;
    public const int MethodId = 31;

    public ushort m_channelMax;
    public uint m_frameMax;
    public ushort m_heartbeat;

    ushort IConnectionTuneOk.ChannelMax { get { return m_channelMax; } }
    uint IConnectionTuneOk.FrameMax { get { return m_frameMax; } }
    ushort IConnectionTuneOk.Heartbeat { get { return m_heartbeat; } }

    public ConnectionTuneOk() {}
    public ConnectionTuneOk(
      ushort initChannelMax,
      uint initFrameMax,
      ushort initHeartbeat)
    {
      m_channelMax = initChannelMax;
      m_frameMax = initFrameMax;
      m_heartbeat = initHeartbeat;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "connection.tune-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_channelMax = reader.ReadShort();
      m_frameMax = reader.ReadLong();
      m_heartbeat = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_channelMax);
      writer.WriteLong(m_frameMax);
      writer.WriteShort(m_heartbeat);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_channelMax); sb.Append(",");
      sb.Append(m_frameMax); sb.Append(",");
      sb.Append(m_heartbeat);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionOpen: RabbitMQ.Client.Impl.MethodBase, IConnectionOpen {
    public const int ClassId = 10;
    public const int MethodId = 40;

    public string m_virtualHost;
    public string m_capabilities;
    public bool m_insist;

    string IConnectionOpen.VirtualHost { get { return m_virtualHost; } }
    string IConnectionOpen.Capabilities { get { return m_capabilities; } }
    bool IConnectionOpen.Insist { get { return m_insist; } }

    public ConnectionOpen() {}
    public ConnectionOpen(
      string initVirtualHost,
      string initCapabilities,
      bool initInsist)
    {
      m_virtualHost = initVirtualHost;
      m_capabilities = initCapabilities;
      m_insist = initInsist;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "connection.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_virtualHost = reader.ReadShortstr();
      m_capabilities = reader.ReadShortstr();
      m_insist = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_virtualHost);
      writer.WriteShortstr(m_capabilities);
      writer.WriteBit(m_insist);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_virtualHost); sb.Append(",");
      sb.Append(m_capabilities); sb.Append(",");
      sb.Append(m_insist);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionOpenOk: RabbitMQ.Client.Impl.MethodBase, IConnectionOpenOk {
    public const int ClassId = 10;
    public const int MethodId = 41;

    public string m_knownHosts;

    string IConnectionOpenOk.KnownHosts { get { return m_knownHosts; } }

    public ConnectionOpenOk() {}
    public ConnectionOpenOk(
      string initKnownHosts)
    {
      m_knownHosts = initKnownHosts;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "connection.open-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_knownHosts = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_knownHosts);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_knownHosts);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionRedirect: RabbitMQ.Client.Impl.MethodBase, IConnectionRedirect {
    public const int ClassId = 10;
    public const int MethodId = 50;

    public string m_host;
    public string m_knownHosts;

    string IConnectionRedirect.Host { get { return m_host; } }
    string IConnectionRedirect.KnownHosts { get { return m_knownHosts; } }

    public ConnectionRedirect() {}
    public ConnectionRedirect(
      string initHost,
      string initKnownHosts)
    {
      m_host = initHost;
      m_knownHosts = initKnownHosts;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "connection.redirect"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_host = reader.ReadShortstr();
      m_knownHosts = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_host);
      writer.WriteShortstr(m_knownHosts);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_host); sb.Append(",");
      sb.Append(m_knownHosts);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionClose: RabbitMQ.Client.Impl.MethodBase, IConnectionClose {
    public const int ClassId = 10;
    public const int MethodId = 60;

    public ushort m_replyCode;
    public string m_replyText;
    public ushort m_classId;
    public ushort m_methodId;

    ushort IConnectionClose.ReplyCode { get { return m_replyCode; } }
    string IConnectionClose.ReplyText { get { return m_replyText; } }
    ushort IConnectionClose.ClassId { get { return m_classId; } }
    ushort IConnectionClose.MethodId { get { return m_methodId; } }

    public ConnectionClose() {}
    public ConnectionClose(
      ushort initReplyCode,
      string initReplyText,
      ushort initClassId,
      ushort initMethodId)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_classId = initClassId;
      m_methodId = initMethodId;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "connection.close"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_classId = reader.ReadShort();
      m_methodId = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShort(m_classId);
      writer.WriteShort(m_methodId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_classId); sb.Append(",");
      sb.Append(m_methodId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionCloseOk: RabbitMQ.Client.Impl.MethodBase, IConnectionCloseOk {
    public const int ClassId = 10;
    public const int MethodId = 61;



    public ConnectionCloseOk(
)
    {
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 61; } }
    public override string ProtocolMethodName { get { return "connection.close-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelOpen: RabbitMQ.Client.Impl.MethodBase, IChannelOpen {
    public const int ClassId = 20;
    public const int MethodId = 10;

    public string m_outOfBand;

    string IChannelOpen.OutOfBand { get { return m_outOfBand; } }

    public ChannelOpen() {}
    public ChannelOpen(
      string initOutOfBand)
    {
      m_outOfBand = initOutOfBand;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "channel.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_outOfBand = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_outOfBand);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_outOfBand);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelOpenOk: RabbitMQ.Client.Impl.MethodBase, IChannelOpenOk {
    public const int ClassId = 20;
    public const int MethodId = 11;



    public ChannelOpenOk(
)
    {
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "channel.open-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelFlow: RabbitMQ.Client.Impl.MethodBase, IChannelFlow {
    public const int ClassId = 20;
    public const int MethodId = 20;

    public bool m_active;

    bool IChannelFlow.Active { get { return m_active; } }

    public ChannelFlow() {}
    public ChannelFlow(
      bool initActive)
    {
      m_active = initActive;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "channel.flow"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_active = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_active);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_active);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelFlowOk: RabbitMQ.Client.Impl.MethodBase, IChannelFlowOk {
    public const int ClassId = 20;
    public const int MethodId = 21;

    public bool m_active;

    bool IChannelFlowOk.Active { get { return m_active; } }

    public ChannelFlowOk() {}
    public ChannelFlowOk(
      bool initActive)
    {
      m_active = initActive;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "channel.flow-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_active = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_active);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_active);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelAlert: RabbitMQ.Client.Impl.MethodBase, IChannelAlert {
    public const int ClassId = 20;
    public const int MethodId = 30;

    public ushort m_replyCode;
    public string m_replyText;
    public System.Collections.IDictionary m_details;

    ushort IChannelAlert.ReplyCode { get { return m_replyCode; } }
    string IChannelAlert.ReplyText { get { return m_replyText; } }
    System.Collections.IDictionary IChannelAlert.Details { get { return m_details; } }

    public ChannelAlert() {}
    public ChannelAlert(
      ushort initReplyCode,
      string initReplyText,
      System.Collections.IDictionary initDetails)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_details = initDetails;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "channel.alert"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_details = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteTable(m_details);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_details);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelClose: RabbitMQ.Client.Impl.MethodBase, IChannelClose {
    public const int ClassId = 20;
    public const int MethodId = 40;

    public ushort m_replyCode;
    public string m_replyText;
    public ushort m_classId;
    public ushort m_methodId;

    ushort IChannelClose.ReplyCode { get { return m_replyCode; } }
    string IChannelClose.ReplyText { get { return m_replyText; } }
    ushort IChannelClose.ClassId { get { return m_classId; } }
    ushort IChannelClose.MethodId { get { return m_methodId; } }

    public ChannelClose() {}
    public ChannelClose(
      ushort initReplyCode,
      string initReplyText,
      ushort initClassId,
      ushort initMethodId)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_classId = initClassId;
      m_methodId = initMethodId;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "channel.close"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_classId = reader.ReadShort();
      m_methodId = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShort(m_classId);
      writer.WriteShort(m_methodId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_classId); sb.Append(",");
      sb.Append(m_methodId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelCloseOk: RabbitMQ.Client.Impl.MethodBase, IChannelCloseOk {
    public const int ClassId = 20;
    public const int MethodId = 41;



    public ChannelCloseOk(
)
    {
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "channel.close-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class AccessRequest: RabbitMQ.Client.Impl.MethodBase, IAccessRequest {
    public const int ClassId = 30;
    public const int MethodId = 10;

    public string m_realm;
    public bool m_exclusive;
    public bool m_passive;
    public bool m_active;
    public bool m_write;
    public bool m_read;

    string IAccessRequest.Realm { get { return m_realm; } }
    bool IAccessRequest.Exclusive { get { return m_exclusive; } }
    bool IAccessRequest.Passive { get { return m_passive; } }
    bool IAccessRequest.Active { get { return m_active; } }
    bool IAccessRequest.Write { get { return m_write; } }
    bool IAccessRequest.Read { get { return m_read; } }

    public AccessRequest() {}
    public AccessRequest(
      string initRealm,
      bool initExclusive,
      bool initPassive,
      bool initActive,
      bool initWrite,
      bool initRead)
    {
      m_realm = initRealm;
      m_exclusive = initExclusive;
      m_passive = initPassive;
      m_active = initActive;
      m_write = initWrite;
      m_read = initRead;
    }

    public override int ProtocolClassId { get { return 30; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "access.request"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_realm = reader.ReadShortstr();
      m_exclusive = reader.ReadBit();
      m_passive = reader.ReadBit();
      m_active = reader.ReadBit();
      m_write = reader.ReadBit();
      m_read = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_realm);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_passive);
      writer.WriteBit(m_active);
      writer.WriteBit(m_write);
      writer.WriteBit(m_read);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_realm); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_passive); sb.Append(",");
      sb.Append(m_active); sb.Append(",");
      sb.Append(m_write); sb.Append(",");
      sb.Append(m_read);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class AccessRequestOk: RabbitMQ.Client.Impl.MethodBase, IAccessRequestOk {
    public const int ClassId = 30;
    public const int MethodId = 11;

    public ushort m_ticket;

    ushort IAccessRequestOk.Ticket { get { return m_ticket; } }

    public AccessRequestOk() {}
    public AccessRequestOk(
      ushort initTicket)
    {
      m_ticket = initTicket;
    }

    public override int ProtocolClassId { get { return 30; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "access.request-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDeclare: RabbitMQ.Client.Impl.MethodBase, IExchangeDeclare {
    public const int ClassId = 40;
    public const int MethodId = 10;

    public ushort m_ticket;
    public string m_exchange;
    public string m_type;
    public bool m_passive;
    public bool m_durable;
    public bool m_autoDelete;
    public bool m_internal;
    public bool m_nowait;
    public System.Collections.IDictionary m_arguments;

    ushort IExchangeDeclare.Ticket { get { return m_ticket; } }
    string IExchangeDeclare.Exchange { get { return m_exchange; } }
    string IExchangeDeclare.Type { get { return m_type; } }
    bool IExchangeDeclare.Passive { get { return m_passive; } }
    bool IExchangeDeclare.Durable { get { return m_durable; } }
    bool IExchangeDeclare.AutoDelete { get { return m_autoDelete; } }
    bool IExchangeDeclare.Internal { get { return m_internal; } }
    bool IExchangeDeclare.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IExchangeDeclare.Arguments { get { return m_arguments; } }

    public ExchangeDeclare() {}
    public ExchangeDeclare(
      ushort initTicket,
      string initExchange,
      string initType,
      bool initPassive,
      bool initDurable,
      bool initAutoDelete,
      bool initInternal,
      bool initNowait,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_type = initType;
      m_passive = initPassive;
      m_durable = initDurable;
      m_autoDelete = initAutoDelete;
      m_internal = initInternal;
      m_nowait = initNowait;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "exchange.declare"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_type = reader.ReadShortstr();
      m_passive = reader.ReadBit();
      m_durable = reader.ReadBit();
      m_autoDelete = reader.ReadBit();
      m_internal = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_type);
      writer.WriteBit(m_passive);
      writer.WriteBit(m_durable);
      writer.WriteBit(m_autoDelete);
      writer.WriteBit(m_internal);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_type); sb.Append(",");
      sb.Append(m_passive); sb.Append(",");
      sb.Append(m_durable); sb.Append(",");
      sb.Append(m_autoDelete); sb.Append(",");
      sb.Append(m_internal); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDeclareOk: RabbitMQ.Client.Impl.MethodBase, IExchangeDeclareOk {
    public const int ClassId = 40;
    public const int MethodId = 11;



    public ExchangeDeclareOk(
)
    {
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "exchange.declare-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDelete: RabbitMQ.Client.Impl.MethodBase, IExchangeDelete {
    public const int ClassId = 40;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_exchange;
    public bool m_ifUnused;
    public bool m_nowait;

    ushort IExchangeDelete.Ticket { get { return m_ticket; } }
    string IExchangeDelete.Exchange { get { return m_exchange; } }
    bool IExchangeDelete.IfUnused { get { return m_ifUnused; } }
    bool IExchangeDelete.Nowait { get { return m_nowait; } }

    public ExchangeDelete() {}
    public ExchangeDelete(
      ushort initTicket,
      string initExchange,
      bool initIfUnused,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_ifUnused = initIfUnused;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "exchange.delete"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_ifUnused = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteBit(m_ifUnused);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_ifUnused); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDeleteOk: RabbitMQ.Client.Impl.MethodBase, IExchangeDeleteOk {
    public const int ClassId = 40;
    public const int MethodId = 21;



    public ExchangeDeleteOk(
)
    {
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "exchange.delete-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDeclare: RabbitMQ.Client.Impl.MethodBase, IQueueDeclare {
    public const int ClassId = 50;
    public const int MethodId = 10;

    public ushort m_ticket;
    public string m_queue;
    public bool m_passive;
    public bool m_durable;
    public bool m_exclusive;
    public bool m_autoDelete;
    public bool m_nowait;
    public System.Collections.IDictionary m_arguments;

    ushort IQueueDeclare.Ticket { get { return m_ticket; } }
    string IQueueDeclare.Queue { get { return m_queue; } }
    bool IQueueDeclare.Passive { get { return m_passive; } }
    bool IQueueDeclare.Durable { get { return m_durable; } }
    bool IQueueDeclare.Exclusive { get { return m_exclusive; } }
    bool IQueueDeclare.AutoDelete { get { return m_autoDelete; } }
    bool IQueueDeclare.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IQueueDeclare.Arguments { get { return m_arguments; } }

    public QueueDeclare() {}
    public QueueDeclare(
      ushort initTicket,
      string initQueue,
      bool initPassive,
      bool initDurable,
      bool initExclusive,
      bool initAutoDelete,
      bool initNowait,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_passive = initPassive;
      m_durable = initDurable;
      m_exclusive = initExclusive;
      m_autoDelete = initAutoDelete;
      m_nowait = initNowait;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "queue.declare"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_passive = reader.ReadBit();
      m_durable = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_autoDelete = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_passive);
      writer.WriteBit(m_durable);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_autoDelete);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_passive); sb.Append(",");
      sb.Append(m_durable); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_autoDelete); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDeclareOk: RabbitMQ.Client.Impl.MethodBase, IQueueDeclareOk {
    public const int ClassId = 50;
    public const int MethodId = 11;

    public string m_queue;
    public uint m_messageCount;
    public uint m_consumerCount;

    string IQueueDeclareOk.Queue { get { return m_queue; } }
    uint IQueueDeclareOk.MessageCount { get { return m_messageCount; } }
    uint IQueueDeclareOk.ConsumerCount { get { return m_consumerCount; } }

    public QueueDeclareOk() {}
    public QueueDeclareOk(
      string initQueue,
      uint initMessageCount,
      uint initConsumerCount)
    {
      m_queue = initQueue;
      m_messageCount = initMessageCount;
      m_consumerCount = initConsumerCount;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "queue.declare-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_queue = reader.ReadShortstr();
      m_messageCount = reader.ReadLong();
      m_consumerCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_queue);
      writer.WriteLong(m_messageCount);
      writer.WriteLong(m_consumerCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_messageCount); sb.Append(",");
      sb.Append(m_consumerCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueBind: RabbitMQ.Client.Impl.MethodBase, IQueueBind {
    public const int ClassId = 50;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_exchange;
    public string m_routingKey;
    public bool m_nowait;
    public System.Collections.IDictionary m_arguments;

    ushort IQueueBind.Ticket { get { return m_ticket; } }
    string IQueueBind.Queue { get { return m_queue; } }
    string IQueueBind.Exchange { get { return m_exchange; } }
    string IQueueBind.RoutingKey { get { return m_routingKey; } }
    bool IQueueBind.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IQueueBind.Arguments { get { return m_arguments; } }

    public QueueBind() {}
    public QueueBind(
      ushort initTicket,
      string initQueue,
      string initExchange,
      string initRoutingKey,
      bool initNowait,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_nowait = initNowait;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "queue.bind"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueBindOk: RabbitMQ.Client.Impl.MethodBase, IQueueBindOk {
    public const int ClassId = 50;
    public const int MethodId = 21;



    public QueueBindOk(
)
    {
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "queue.bind-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueuePurge: RabbitMQ.Client.Impl.MethodBase, IQueuePurge {
    public const int ClassId = 50;
    public const int MethodId = 30;

    public ushort m_ticket;
    public string m_queue;
    public bool m_nowait;

    ushort IQueuePurge.Ticket { get { return m_ticket; } }
    string IQueuePurge.Queue { get { return m_queue; } }
    bool IQueuePurge.Nowait { get { return m_nowait; } }

    public QueuePurge() {}
    public QueuePurge(
      ushort initTicket,
      string initQueue,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "queue.purge"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueuePurgeOk: RabbitMQ.Client.Impl.MethodBase, IQueuePurgeOk {
    public const int ClassId = 50;
    public const int MethodId = 31;

    public uint m_messageCount;

    uint IQueuePurgeOk.MessageCount { get { return m_messageCount; } }

    public QueuePurgeOk() {}
    public QueuePurgeOk(
      uint initMessageCount)
    {
      m_messageCount = initMessageCount;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "queue.purge-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_messageCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_messageCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_messageCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDelete: RabbitMQ.Client.Impl.MethodBase, IQueueDelete {
    public const int ClassId = 50;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_queue;
    public bool m_ifUnused;
    public bool m_ifEmpty;
    public bool m_nowait;

    ushort IQueueDelete.Ticket { get { return m_ticket; } }
    string IQueueDelete.Queue { get { return m_queue; } }
    bool IQueueDelete.IfUnused { get { return m_ifUnused; } }
    bool IQueueDelete.IfEmpty { get { return m_ifEmpty; } }
    bool IQueueDelete.Nowait { get { return m_nowait; } }

    public QueueDelete() {}
    public QueueDelete(
      ushort initTicket,
      string initQueue,
      bool initIfUnused,
      bool initIfEmpty,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_ifUnused = initIfUnused;
      m_ifEmpty = initIfEmpty;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "queue.delete"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_ifUnused = reader.ReadBit();
      m_ifEmpty = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_ifUnused);
      writer.WriteBit(m_ifEmpty);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_ifUnused); sb.Append(",");
      sb.Append(m_ifEmpty); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDeleteOk: RabbitMQ.Client.Impl.MethodBase, IQueueDeleteOk {
    public const int ClassId = 50;
    public const int MethodId = 41;

    public uint m_messageCount;

    uint IQueueDeleteOk.MessageCount { get { return m_messageCount; } }

    public QueueDeleteOk() {}
    public QueueDeleteOk(
      uint initMessageCount)
    {
      m_messageCount = initMessageCount;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "queue.delete-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_messageCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_messageCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_messageCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicQos: RabbitMQ.Client.Impl.MethodBase, IBasicQos {
    public const int ClassId = 60;
    public const int MethodId = 10;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public bool m_global;

    uint IBasicQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IBasicQos.PrefetchCount { get { return m_prefetchCount; } }
    bool IBasicQos.Global { get { return m_global; } }

    public BasicQos() {}
    public BasicQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "basic.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicQosOk: RabbitMQ.Client.Impl.MethodBase, IBasicQosOk {
    public const int ClassId = 60;
    public const int MethodId = 11;



    public BasicQosOk(
)
    {
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "basic.qos-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicConsume: RabbitMQ.Client.Impl.MethodBase, IBasicConsume {
    public const int ClassId = 60;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_consumerTag;
    public bool m_noLocal;
    public bool m_noAck;
    public bool m_exclusive;
    public bool m_nowait;

    ushort IBasicConsume.Ticket { get { return m_ticket; } }
    string IBasicConsume.Queue { get { return m_queue; } }
    string IBasicConsume.ConsumerTag { get { return m_consumerTag; } }
    bool IBasicConsume.NoLocal { get { return m_noLocal; } }
    bool IBasicConsume.NoAck { get { return m_noAck; } }
    bool IBasicConsume.Exclusive { get { return m_exclusive; } }
    bool IBasicConsume.Nowait { get { return m_nowait; } }

    public BasicConsume() {}
    public BasicConsume(
      ushort initTicket,
      string initQueue,
      string initConsumerTag,
      bool initNoLocal,
      bool initNoAck,
      bool initExclusive,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_consumerTag = initConsumerTag;
      m_noLocal = initNoLocal;
      m_noAck = initNoAck;
      m_exclusive = initExclusive;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "basic.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_consumerTag = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_noAck = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_noAck);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_noAck); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicConsumeOk: RabbitMQ.Client.Impl.MethodBase, IBasicConsumeOk {
    public const int ClassId = 60;
    public const int MethodId = 21;

    public string m_consumerTag;

    string IBasicConsumeOk.ConsumerTag { get { return m_consumerTag; } }

    public BasicConsumeOk() {}
    public BasicConsumeOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "basic.consume-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicCancel: RabbitMQ.Client.Impl.MethodBase, IBasicCancel {
    public const int ClassId = 60;
    public const int MethodId = 30;

    public string m_consumerTag;
    public bool m_nowait;

    string IBasicCancel.ConsumerTag { get { return m_consumerTag; } }
    bool IBasicCancel.Nowait { get { return m_nowait; } }

    public BasicCancel() {}
    public BasicCancel(
      string initConsumerTag,
      bool initNowait)
    {
      m_consumerTag = initConsumerTag;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "basic.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicCancelOk: RabbitMQ.Client.Impl.MethodBase, IBasicCancelOk {
    public const int ClassId = 60;
    public const int MethodId = 31;

    public string m_consumerTag;

    string IBasicCancelOk.ConsumerTag { get { return m_consumerTag; } }

    public BasicCancelOk() {}
    public BasicCancelOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "basic.cancel-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicPublish: RabbitMQ.Client.Impl.MethodBase, IBasicPublish {
    public const int ClassId = 60;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_exchange;
    public string m_routingKey;
    public bool m_mandatory;
    public bool m_immediate;

    ushort IBasicPublish.Ticket { get { return m_ticket; } }
    string IBasicPublish.Exchange { get { return m_exchange; } }
    string IBasicPublish.RoutingKey { get { return m_routingKey; } }
    bool IBasicPublish.Mandatory { get { return m_mandatory; } }
    bool IBasicPublish.Immediate { get { return m_immediate; } }

    public BasicPublish() {}
    public BasicPublish(
      ushort initTicket,
      string initExchange,
      string initRoutingKey,
      bool initMandatory,
      bool initImmediate)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_mandatory = initMandatory;
      m_immediate = initImmediate;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "basic.publish"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_mandatory = reader.ReadBit();
      m_immediate = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_mandatory);
      writer.WriteBit(m_immediate);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_mandatory); sb.Append(",");
      sb.Append(m_immediate);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicReturn: RabbitMQ.Client.Impl.MethodBase, IBasicReturn {
    public const int ClassId = 60;
    public const int MethodId = 50;

    public ushort m_replyCode;
    public string m_replyText;
    public string m_exchange;
    public string m_routingKey;

    ushort IBasicReturn.ReplyCode { get { return m_replyCode; } }
    string IBasicReturn.ReplyText { get { return m_replyText; } }
    string IBasicReturn.Exchange { get { return m_exchange; } }
    string IBasicReturn.RoutingKey { get { return m_routingKey; } }

    public BasicReturn() {}
    public BasicReturn(
      ushort initReplyCode,
      string initReplyText,
      string initExchange,
      string initRoutingKey)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "basic.return"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicDeliver: RabbitMQ.Client.Impl.MethodBase, IBasicDeliver {
    public const int ClassId = 60;
    public const int MethodId = 60;

    public string m_consumerTag;
    public ulong m_deliveryTag;
    public bool m_redelivered;
    public string m_exchange;
    public string m_routingKey;

    string IBasicDeliver.ConsumerTag { get { return m_consumerTag; } }
    ulong IBasicDeliver.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicDeliver.Redelivered { get { return m_redelivered; } }
    string IBasicDeliver.Exchange { get { return m_exchange; } }
    string IBasicDeliver.RoutingKey { get { return m_routingKey; } }

    public BasicDeliver() {}
    public BasicDeliver(
      string initConsumerTag,
      ulong initDeliveryTag,
      bool initRedelivered,
      string initExchange,
      string initRoutingKey)
    {
      m_consumerTag = initConsumerTag;
      m_deliveryTag = initDeliveryTag;
      m_redelivered = initRedelivered;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "basic.deliver"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_deliveryTag = reader.ReadLonglong();
      m_redelivered = reader.ReadBit();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_redelivered);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicGet: RabbitMQ.Client.Impl.MethodBase, IBasicGet {
    public const int ClassId = 60;
    public const int MethodId = 70;

    public ushort m_ticket;
    public string m_queue;
    public bool m_noAck;

    ushort IBasicGet.Ticket { get { return m_ticket; } }
    string IBasicGet.Queue { get { return m_queue; } }
    bool IBasicGet.NoAck { get { return m_noAck; } }

    public BasicGet() {}
    public BasicGet(
      ushort initTicket,
      string initQueue,
      bool initNoAck)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_noAck = initNoAck;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 70; } }
    public override string ProtocolMethodName { get { return "basic.get"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_noAck = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_noAck);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_noAck);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicGetOk: RabbitMQ.Client.Impl.MethodBase, IBasicGetOk {
    public const int ClassId = 60;
    public const int MethodId = 71;

    public ulong m_deliveryTag;
    public bool m_redelivered;
    public string m_exchange;
    public string m_routingKey;
    public uint m_messageCount;

    ulong IBasicGetOk.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicGetOk.Redelivered { get { return m_redelivered; } }
    string IBasicGetOk.Exchange { get { return m_exchange; } }
    string IBasicGetOk.RoutingKey { get { return m_routingKey; } }
    uint IBasicGetOk.MessageCount { get { return m_messageCount; } }

    public BasicGetOk() {}
    public BasicGetOk(
      ulong initDeliveryTag,
      bool initRedelivered,
      string initExchange,
      string initRoutingKey,
      uint initMessageCount)
    {
      m_deliveryTag = initDeliveryTag;
      m_redelivered = initRedelivered;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_messageCount = initMessageCount;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 71; } }
    public override string ProtocolMethodName { get { return "basic.get-ok"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_redelivered = reader.ReadBit();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_messageCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_redelivered);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteLong(m_messageCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_messageCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicGetEmpty: RabbitMQ.Client.Impl.MethodBase, IBasicGetEmpty {
    public const int ClassId = 60;
    public const int MethodId = 72;

    public string m_clusterId;

    string IBasicGetEmpty.ClusterId { get { return m_clusterId; } }

    public BasicGetEmpty() {}
    public BasicGetEmpty(
      string initClusterId)
    {
      m_clusterId = initClusterId;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 72; } }
    public override string ProtocolMethodName { get { return "basic.get-empty"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_clusterId = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_clusterId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_clusterId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicAck: RabbitMQ.Client.Impl.MethodBase, IBasicAck {
    public const int ClassId = 60;
    public const int MethodId = 80;

    public ulong m_deliveryTag;
    public bool m_multiple;

    ulong IBasicAck.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicAck.Multiple { get { return m_multiple; } }

    public BasicAck() {}
    public BasicAck(
      ulong initDeliveryTag,
      bool initMultiple)
    {
      m_deliveryTag = initDeliveryTag;
      m_multiple = initMultiple;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 80; } }
    public override string ProtocolMethodName { get { return "basic.ack"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_multiple = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_multiple);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_multiple);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicReject: RabbitMQ.Client.Impl.MethodBase, IBasicReject {
    public const int ClassId = 60;
    public const int MethodId = 90;

    public ulong m_deliveryTag;
    public bool m_requeue;

    ulong IBasicReject.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicReject.Requeue { get { return m_requeue; } }

    public BasicReject() {}
    public BasicReject(
      ulong initDeliveryTag,
      bool initRequeue)
    {
      m_deliveryTag = initDeliveryTag;
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 90; } }
    public override string ProtocolMethodName { get { return "basic.reject"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicRecover: RabbitMQ.Client.Impl.MethodBase, IBasicRecover {
    public const int ClassId = 60;
    public const int MethodId = 100;

    public bool m_requeue;

    bool IBasicRecover.Requeue { get { return m_requeue; } }

    public BasicRecover() {}
    public BasicRecover(
      bool initRequeue)
    {
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 100; } }
    public override string ProtocolMethodName { get { return "basic.recover"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileQos: RabbitMQ.Client.Impl.MethodBase, IFileQos {
    public const int ClassId = 70;
    public const int MethodId = 10;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public bool m_global;

    uint IFileQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IFileQos.PrefetchCount { get { return m_prefetchCount; } }
    bool IFileQos.Global { get { return m_global; } }

    public FileQos() {}
    public FileQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "file.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileQosOk: RabbitMQ.Client.Impl.MethodBase, IFileQosOk {
    public const int ClassId = 70;
    public const int MethodId = 11;



    public FileQosOk(
)
    {
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "file.qos-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileConsume: RabbitMQ.Client.Impl.MethodBase, IFileConsume {
    public const int ClassId = 70;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_consumerTag;
    public bool m_noLocal;
    public bool m_noAck;
    public bool m_exclusive;
    public bool m_nowait;

    ushort IFileConsume.Ticket { get { return m_ticket; } }
    string IFileConsume.Queue { get { return m_queue; } }
    string IFileConsume.ConsumerTag { get { return m_consumerTag; } }
    bool IFileConsume.NoLocal { get { return m_noLocal; } }
    bool IFileConsume.NoAck { get { return m_noAck; } }
    bool IFileConsume.Exclusive { get { return m_exclusive; } }
    bool IFileConsume.Nowait { get { return m_nowait; } }

    public FileConsume() {}
    public FileConsume(
      ushort initTicket,
      string initQueue,
      string initConsumerTag,
      bool initNoLocal,
      bool initNoAck,
      bool initExclusive,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_consumerTag = initConsumerTag;
      m_noLocal = initNoLocal;
      m_noAck = initNoAck;
      m_exclusive = initExclusive;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "file.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_consumerTag = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_noAck = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_noAck);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_noAck); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileConsumeOk: RabbitMQ.Client.Impl.MethodBase, IFileConsumeOk {
    public const int ClassId = 70;
    public const int MethodId = 21;

    public string m_consumerTag;

    string IFileConsumeOk.ConsumerTag { get { return m_consumerTag; } }

    public FileConsumeOk() {}
    public FileConsumeOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "file.consume-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileCancel: RabbitMQ.Client.Impl.MethodBase, IFileCancel {
    public const int ClassId = 70;
    public const int MethodId = 30;

    public string m_consumerTag;
    public bool m_nowait;

    string IFileCancel.ConsumerTag { get { return m_consumerTag; } }
    bool IFileCancel.Nowait { get { return m_nowait; } }

    public FileCancel() {}
    public FileCancel(
      string initConsumerTag,
      bool initNowait)
    {
      m_consumerTag = initConsumerTag;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "file.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileCancelOk: RabbitMQ.Client.Impl.MethodBase, IFileCancelOk {
    public const int ClassId = 70;
    public const int MethodId = 31;

    public string m_consumerTag;

    string IFileCancelOk.ConsumerTag { get { return m_consumerTag; } }

    public FileCancelOk() {}
    public FileCancelOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "file.cancel-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileOpen: RabbitMQ.Client.Impl.MethodBase, IFileOpen {
    public const int ClassId = 70;
    public const int MethodId = 40;

    public string m_identifier;
    public ulong m_contentSize;

    string IFileOpen.Identifier { get { return m_identifier; } }
    ulong IFileOpen.ContentSize { get { return m_contentSize; } }

    public FileOpen() {}
    public FileOpen(
      string initIdentifier,
      ulong initContentSize)
    {
      m_identifier = initIdentifier;
      m_contentSize = initContentSize;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "file.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_identifier = reader.ReadShortstr();
      m_contentSize = reader.ReadLonglong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_identifier);
      writer.WriteLonglong(m_contentSize);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_identifier); sb.Append(",");
      sb.Append(m_contentSize);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileOpenOk: RabbitMQ.Client.Impl.MethodBase, IFileOpenOk {
    public const int ClassId = 70;
    public const int MethodId = 41;

    public ulong m_stagedSize;

    ulong IFileOpenOk.StagedSize { get { return m_stagedSize; } }

    public FileOpenOk() {}
    public FileOpenOk(
      ulong initStagedSize)
    {
      m_stagedSize = initStagedSize;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "file.open-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_stagedSize = reader.ReadLonglong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_stagedSize);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_stagedSize);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileStage: RabbitMQ.Client.Impl.MethodBase, IFileStage {
    public const int ClassId = 70;
    public const int MethodId = 50;



    public FileStage(
)
    {
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "file.stage"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FilePublish: RabbitMQ.Client.Impl.MethodBase, IFilePublish {
    public const int ClassId = 70;
    public const int MethodId = 60;

    public ushort m_ticket;
    public string m_exchange;
    public string m_routingKey;
    public bool m_mandatory;
    public bool m_immediate;
    public string m_identifier;

    ushort IFilePublish.Ticket { get { return m_ticket; } }
    string IFilePublish.Exchange { get { return m_exchange; } }
    string IFilePublish.RoutingKey { get { return m_routingKey; } }
    bool IFilePublish.Mandatory { get { return m_mandatory; } }
    bool IFilePublish.Immediate { get { return m_immediate; } }
    string IFilePublish.Identifier { get { return m_identifier; } }

    public FilePublish() {}
    public FilePublish(
      ushort initTicket,
      string initExchange,
      string initRoutingKey,
      bool initMandatory,
      bool initImmediate,
      string initIdentifier)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_mandatory = initMandatory;
      m_immediate = initImmediate;
      m_identifier = initIdentifier;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "file.publish"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_mandatory = reader.ReadBit();
      m_immediate = reader.ReadBit();
      m_identifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_mandatory);
      writer.WriteBit(m_immediate);
      writer.WriteShortstr(m_identifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_mandatory); sb.Append(",");
      sb.Append(m_immediate); sb.Append(",");
      sb.Append(m_identifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileReturn: RabbitMQ.Client.Impl.MethodBase, IFileReturn {
    public const int ClassId = 70;
    public const int MethodId = 70;

    public ushort m_replyCode;
    public string m_replyText;
    public string m_exchange;
    public string m_routingKey;

    ushort IFileReturn.ReplyCode { get { return m_replyCode; } }
    string IFileReturn.ReplyText { get { return m_replyText; } }
    string IFileReturn.Exchange { get { return m_exchange; } }
    string IFileReturn.RoutingKey { get { return m_routingKey; } }

    public FileReturn() {}
    public FileReturn(
      ushort initReplyCode,
      string initReplyText,
      string initExchange,
      string initRoutingKey)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 70; } }
    public override string ProtocolMethodName { get { return "file.return"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileDeliver: RabbitMQ.Client.Impl.MethodBase, IFileDeliver {
    public const int ClassId = 70;
    public const int MethodId = 80;

    public string m_consumerTag;
    public ulong m_deliveryTag;
    public bool m_redelivered;
    public string m_exchange;
    public string m_routingKey;
    public string m_identifier;

    string IFileDeliver.ConsumerTag { get { return m_consumerTag; } }
    ulong IFileDeliver.DeliveryTag { get { return m_deliveryTag; } }
    bool IFileDeliver.Redelivered { get { return m_redelivered; } }
    string IFileDeliver.Exchange { get { return m_exchange; } }
    string IFileDeliver.RoutingKey { get { return m_routingKey; } }
    string IFileDeliver.Identifier { get { return m_identifier; } }

    public FileDeliver() {}
    public FileDeliver(
      string initConsumerTag,
      ulong initDeliveryTag,
      bool initRedelivered,
      string initExchange,
      string initRoutingKey,
      string initIdentifier)
    {
      m_consumerTag = initConsumerTag;
      m_deliveryTag = initDeliveryTag;
      m_redelivered = initRedelivered;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_identifier = initIdentifier;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 80; } }
    public override string ProtocolMethodName { get { return "file.deliver"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_deliveryTag = reader.ReadLonglong();
      m_redelivered = reader.ReadBit();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_identifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_redelivered);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteShortstr(m_identifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_identifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileAck: RabbitMQ.Client.Impl.MethodBase, IFileAck {
    public const int ClassId = 70;
    public const int MethodId = 90;

    public ulong m_deliveryTag;
    public bool m_multiple;

    ulong IFileAck.DeliveryTag { get { return m_deliveryTag; } }
    bool IFileAck.Multiple { get { return m_multiple; } }

    public FileAck() {}
    public FileAck(
      ulong initDeliveryTag,
      bool initMultiple)
    {
      m_deliveryTag = initDeliveryTag;
      m_multiple = initMultiple;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 90; } }
    public override string ProtocolMethodName { get { return "file.ack"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_multiple = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_multiple);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_multiple);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileReject: RabbitMQ.Client.Impl.MethodBase, IFileReject {
    public const int ClassId = 70;
    public const int MethodId = 100;

    public ulong m_deliveryTag;
    public bool m_requeue;

    ulong IFileReject.DeliveryTag { get { return m_deliveryTag; } }
    bool IFileReject.Requeue { get { return m_requeue; } }

    public FileReject() {}
    public FileReject(
      ulong initDeliveryTag,
      bool initRequeue)
    {
      m_deliveryTag = initDeliveryTag;
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 100; } }
    public override string ProtocolMethodName { get { return "file.reject"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamQos: RabbitMQ.Client.Impl.MethodBase, IStreamQos {
    public const int ClassId = 80;
    public const int MethodId = 10;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public uint m_consumeRate;
    public bool m_global;

    uint IStreamQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IStreamQos.PrefetchCount { get { return m_prefetchCount; } }
    uint IStreamQos.ConsumeRate { get { return m_consumeRate; } }
    bool IStreamQos.Global { get { return m_global; } }

    public StreamQos() {}
    public StreamQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      uint initConsumeRate,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_consumeRate = initConsumeRate;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "stream.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_consumeRate = reader.ReadLong();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteLong(m_consumeRate);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_consumeRate); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamQosOk: RabbitMQ.Client.Impl.MethodBase, IStreamQosOk {
    public const int ClassId = 80;
    public const int MethodId = 11;



    public StreamQosOk(
)
    {
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "stream.qos-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamConsume: RabbitMQ.Client.Impl.MethodBase, IStreamConsume {
    public const int ClassId = 80;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_consumerTag;
    public bool m_noLocal;
    public bool m_exclusive;
    public bool m_nowait;

    ushort IStreamConsume.Ticket { get { return m_ticket; } }
    string IStreamConsume.Queue { get { return m_queue; } }
    string IStreamConsume.ConsumerTag { get { return m_consumerTag; } }
    bool IStreamConsume.NoLocal { get { return m_noLocal; } }
    bool IStreamConsume.Exclusive { get { return m_exclusive; } }
    bool IStreamConsume.Nowait { get { return m_nowait; } }

    public StreamConsume() {}
    public StreamConsume(
      ushort initTicket,
      string initQueue,
      string initConsumerTag,
      bool initNoLocal,
      bool initExclusive,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_consumerTag = initConsumerTag;
      m_noLocal = initNoLocal;
      m_exclusive = initExclusive;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "stream.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_consumerTag = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamConsumeOk: RabbitMQ.Client.Impl.MethodBase, IStreamConsumeOk {
    public const int ClassId = 80;
    public const int MethodId = 21;

    public string m_consumerTag;

    string IStreamConsumeOk.ConsumerTag { get { return m_consumerTag; } }

    public StreamConsumeOk() {}
    public StreamConsumeOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "stream.consume-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamCancel: RabbitMQ.Client.Impl.MethodBase, IStreamCancel {
    public const int ClassId = 80;
    public const int MethodId = 30;

    public string m_consumerTag;
    public bool m_nowait;

    string IStreamCancel.ConsumerTag { get { return m_consumerTag; } }
    bool IStreamCancel.Nowait { get { return m_nowait; } }

    public StreamCancel() {}
    public StreamCancel(
      string initConsumerTag,
      bool initNowait)
    {
      m_consumerTag = initConsumerTag;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "stream.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamCancelOk: RabbitMQ.Client.Impl.MethodBase, IStreamCancelOk {
    public const int ClassId = 80;
    public const int MethodId = 31;

    public string m_consumerTag;

    string IStreamCancelOk.ConsumerTag { get { return m_consumerTag; } }

    public StreamCancelOk() {}
    public StreamCancelOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "stream.cancel-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamPublish: RabbitMQ.Client.Impl.MethodBase, IStreamPublish {
    public const int ClassId = 80;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_exchange;
    public string m_routingKey;
    public bool m_mandatory;
    public bool m_immediate;

    ushort IStreamPublish.Ticket { get { return m_ticket; } }
    string IStreamPublish.Exchange { get { return m_exchange; } }
    string IStreamPublish.RoutingKey { get { return m_routingKey; } }
    bool IStreamPublish.Mandatory { get { return m_mandatory; } }
    bool IStreamPublish.Immediate { get { return m_immediate; } }

    public StreamPublish() {}
    public StreamPublish(
      ushort initTicket,
      string initExchange,
      string initRoutingKey,
      bool initMandatory,
      bool initImmediate)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_mandatory = initMandatory;
      m_immediate = initImmediate;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "stream.publish"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_mandatory = reader.ReadBit();
      m_immediate = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_mandatory);
      writer.WriteBit(m_immediate);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_mandatory); sb.Append(",");
      sb.Append(m_immediate);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamReturn: RabbitMQ.Client.Impl.MethodBase, IStreamReturn {
    public const int ClassId = 80;
    public const int MethodId = 50;

    public ushort m_replyCode;
    public string m_replyText;
    public string m_exchange;
    public string m_routingKey;

    ushort IStreamReturn.ReplyCode { get { return m_replyCode; } }
    string IStreamReturn.ReplyText { get { return m_replyText; } }
    string IStreamReturn.Exchange { get { return m_exchange; } }
    string IStreamReturn.RoutingKey { get { return m_routingKey; } }

    public StreamReturn() {}
    public StreamReturn(
      ushort initReplyCode,
      string initReplyText,
      string initExchange,
      string initRoutingKey)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "stream.return"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamDeliver: RabbitMQ.Client.Impl.MethodBase, IStreamDeliver {
    public const int ClassId = 80;
    public const int MethodId = 60;

    public string m_consumerTag;
    public ulong m_deliveryTag;
    public string m_exchange;
    public string m_queue;

    string IStreamDeliver.ConsumerTag { get { return m_consumerTag; } }
    ulong IStreamDeliver.DeliveryTag { get { return m_deliveryTag; } }
    string IStreamDeliver.Exchange { get { return m_exchange; } }
    string IStreamDeliver.Queue { get { return m_queue; } }

    public StreamDeliver() {}
    public StreamDeliver(
      string initConsumerTag,
      ulong initDeliveryTag,
      string initExchange,
      string initQueue)
    {
      m_consumerTag = initConsumerTag;
      m_deliveryTag = initDeliveryTag;
      m_exchange = initExchange;
      m_queue = initQueue;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "stream.deliver"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_deliveryTag = reader.ReadLonglong();
      m_exchange = reader.ReadShortstr();
      m_queue = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_queue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_queue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxSelect: RabbitMQ.Client.Impl.MethodBase, ITxSelect {
    public const int ClassId = 90;
    public const int MethodId = 10;



    public TxSelect(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "tx.select"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxSelectOk: RabbitMQ.Client.Impl.MethodBase, ITxSelectOk {
    public const int ClassId = 90;
    public const int MethodId = 11;



    public TxSelectOk(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "tx.select-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxCommit: RabbitMQ.Client.Impl.MethodBase, ITxCommit {
    public const int ClassId = 90;
    public const int MethodId = 20;



    public TxCommit(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "tx.commit"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxCommitOk: RabbitMQ.Client.Impl.MethodBase, ITxCommitOk {
    public const int ClassId = 90;
    public const int MethodId = 21;



    public TxCommitOk(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "tx.commit-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxRollback: RabbitMQ.Client.Impl.MethodBase, ITxRollback {
    public const int ClassId = 90;
    public const int MethodId = 30;



    public TxRollback(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "tx.rollback"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxRollbackOk: RabbitMQ.Client.Impl.MethodBase, ITxRollbackOk {
    public const int ClassId = 90;
    public const int MethodId = 31;



    public TxRollbackOk(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "tx.rollback-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxSelect: RabbitMQ.Client.Impl.MethodBase, IDtxSelect {
    public const int ClassId = 100;
    public const int MethodId = 10;



    public DtxSelect(
)
    {
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "dtx.select"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxSelectOk: RabbitMQ.Client.Impl.MethodBase, IDtxSelectOk {
    public const int ClassId = 100;
    public const int MethodId = 11;



    public DtxSelectOk(
)
    {
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "dtx.select-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxStart: RabbitMQ.Client.Impl.MethodBase, IDtxStart {
    public const int ClassId = 100;
    public const int MethodId = 20;

    public string m_dtxIdentifier;

    string IDtxStart.DtxIdentifier { get { return m_dtxIdentifier; } }

    public DtxStart() {}
    public DtxStart(
      string initDtxIdentifier)
    {
      m_dtxIdentifier = initDtxIdentifier;
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "dtx.start"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_dtxIdentifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_dtxIdentifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_dtxIdentifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxStartOk: RabbitMQ.Client.Impl.MethodBase, IDtxStartOk {
    public const int ClassId = 100;
    public const int MethodId = 21;



    public DtxStartOk(
)
    {
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "dtx.start-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TunnelRequest: RabbitMQ.Client.Impl.MethodBase, ITunnelRequest {
    public const int ClassId = 110;
    public const int MethodId = 10;

    public System.Collections.IDictionary m_metaData;

    System.Collections.IDictionary ITunnelRequest.MetaData { get { return m_metaData; } }

    public TunnelRequest() {}
    public TunnelRequest(
      System.Collections.IDictionary initMetaData)
    {
      m_metaData = initMetaData;
    }

    public override int ProtocolClassId { get { return 110; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "tunnel.request"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_metaData = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteTable(m_metaData);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_metaData);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestInteger: RabbitMQ.Client.Impl.MethodBase, ITestInteger {
    public const int ClassId = 120;
    public const int MethodId = 10;

    public byte m_integer1;
    public ushort m_integer2;
    public uint m_integer3;
    public ulong m_integer4;
    public byte m_operation;

    byte ITestInteger.Integer1 { get { return m_integer1; } }
    ushort ITestInteger.Integer2 { get { return m_integer2; } }
    uint ITestInteger.Integer3 { get { return m_integer3; } }
    ulong ITestInteger.Integer4 { get { return m_integer4; } }
    byte ITestInteger.Operation { get { return m_operation; } }

    public TestInteger() {}
    public TestInteger(
      byte initInteger1,
      ushort initInteger2,
      uint initInteger3,
      ulong initInteger4,
      byte initOperation)
    {
      m_integer1 = initInteger1;
      m_integer2 = initInteger2;
      m_integer3 = initInteger3;
      m_integer4 = initInteger4;
      m_operation = initOperation;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "test.integer"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_integer1 = reader.ReadOctet();
      m_integer2 = reader.ReadShort();
      m_integer3 = reader.ReadLong();
      m_integer4 = reader.ReadLonglong();
      m_operation = reader.ReadOctet();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteOctet(m_integer1);
      writer.WriteShort(m_integer2);
      writer.WriteLong(m_integer3);
      writer.WriteLonglong(m_integer4);
      writer.WriteOctet(m_operation);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_integer1); sb.Append(",");
      sb.Append(m_integer2); sb.Append(",");
      sb.Append(m_integer3); sb.Append(",");
      sb.Append(m_integer4); sb.Append(",");
      sb.Append(m_operation);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestIntegerOk: RabbitMQ.Client.Impl.MethodBase, ITestIntegerOk {
    public const int ClassId = 120;
    public const int MethodId = 11;

    public ulong m_result;

    ulong ITestIntegerOk.Result { get { return m_result; } }

    public TestIntegerOk() {}
    public TestIntegerOk(
      ulong initResult)
    {
      m_result = initResult;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "test.integer-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_result = reader.ReadLonglong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_result);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_result);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestString: RabbitMQ.Client.Impl.MethodBase, ITestString {
    public const int ClassId = 120;
    public const int MethodId = 20;

    public string m_string1;
    public byte[] m_string2;
    public byte m_operation;

    string ITestString.String1 { get { return m_string1; } }
    byte[] ITestString.String2 { get { return m_string2; } }
    byte ITestString.Operation { get { return m_operation; } }

    public TestString() {}
    public TestString(
      string initString1,
      byte[] initString2,
      byte initOperation)
    {
      m_string1 = initString1;
      m_string2 = initString2;
      m_operation = initOperation;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "test.string"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_string1 = reader.ReadShortstr();
      m_string2 = reader.ReadLongstr();
      m_operation = reader.ReadOctet();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_string1);
      writer.WriteLongstr(m_string2);
      writer.WriteOctet(m_operation);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_string1); sb.Append(",");
      sb.Append(m_string2); sb.Append(",");
      sb.Append(m_operation);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestStringOk: RabbitMQ.Client.Impl.MethodBase, ITestStringOk {
    public const int ClassId = 120;
    public const int MethodId = 21;

    public byte[] m_result;

    byte[] ITestStringOk.Result { get { return m_result; } }

    public TestStringOk() {}
    public TestStringOk(
      byte[] initResult)
    {
      m_result = initResult;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "test.string-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_result = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_result);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_result);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestTable: RabbitMQ.Client.Impl.MethodBase, ITestTable {
    public const int ClassId = 120;
    public const int MethodId = 30;

    public System.Collections.IDictionary m_table;
    public byte m_integerOp;
    public byte m_stringOp;

    System.Collections.IDictionary ITestTable.Table { get { return m_table; } }
    byte ITestTable.IntegerOp { get { return m_integerOp; } }
    byte ITestTable.StringOp { get { return m_stringOp; } }

    public TestTable() {}
    public TestTable(
      System.Collections.IDictionary initTable,
      byte initIntegerOp,
      byte initStringOp)
    {
      m_table = initTable;
      m_integerOp = initIntegerOp;
      m_stringOp = initStringOp;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "test.table"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_table = reader.ReadTable();
      m_integerOp = reader.ReadOctet();
      m_stringOp = reader.ReadOctet();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteTable(m_table);
      writer.WriteOctet(m_integerOp);
      writer.WriteOctet(m_stringOp);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_table); sb.Append(",");
      sb.Append(m_integerOp); sb.Append(",");
      sb.Append(m_stringOp);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestTableOk: RabbitMQ.Client.Impl.MethodBase, ITestTableOk {
    public const int ClassId = 120;
    public const int MethodId = 31;

    public ulong m_integerResult;
    public byte[] m_stringResult;

    ulong ITestTableOk.IntegerResult { get { return m_integerResult; } }
    byte[] ITestTableOk.StringResult { get { return m_stringResult; } }

    public TestTableOk() {}
    public TestTableOk(
      ulong initIntegerResult,
      byte[] initStringResult)
    {
      m_integerResult = initIntegerResult;
      m_stringResult = initStringResult;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "test.table-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_integerResult = reader.ReadLonglong();
      m_stringResult = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_integerResult);
      writer.WriteLongstr(m_stringResult);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_integerResult); sb.Append(",");
      sb.Append(m_stringResult);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestContent: RabbitMQ.Client.Impl.MethodBase, ITestContent {
    public const int ClassId = 120;
    public const int MethodId = 40;



    public TestContent(
)
    {
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "test.content"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TestContentOk: RabbitMQ.Client.Impl.MethodBase, ITestContentOk {
    public const int ClassId = 120;
    public const int MethodId = 41;

    public uint m_contentChecksum;

    uint ITestContentOk.ContentChecksum { get { return m_contentChecksum; } }

    public TestContentOk() {}
    public TestContentOk(
      uint initContentChecksum)
    {
      m_contentChecksum = initContentChecksum;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "test.content-ok"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_contentChecksum = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_contentChecksum);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_contentChecksum);
      sb.Append(")");
    }
  }

  public class Model: RabbitMQ.Client.Impl.ModelBase {
    public Model(RabbitMQ.Client.Impl.ISession session): base(session) {}
    public override System.UInt16 _Private_AccessRequest(
      System.String @realm,
      System.Boolean @exclusive,
      System.Boolean @passive,
      System.Boolean @active,
      System.Boolean @write,
      System.Boolean @read)
    {
      AccessRequest __req = new AccessRequest();
      __req.m_realm = @realm;
      __req.m_exclusive = @exclusive;
      __req.m_passive = @passive;
      __req.m_active = @active;
      __req.m_write = @write;
      __req.m_read = @read;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      AccessRequestOk __rep = __repBase as AccessRequestOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_ticket;
    }
    public override void _Private_BasicPublish(
      System.UInt16 @ticket,
      System.String @exchange,
      System.String @routingKey,
      System.Boolean @mandatory,
      System.Boolean @immediate,
      RabbitMQ.Client.IBasicProperties @basicProperties,
      System.Byte[] @body)
    {
      BasicPublish __req = new BasicPublish();
      __req.m_ticket = @ticket;
      __req.m_exchange = @exchange;
      __req.m_routingKey = @routingKey;
      __req.m_mandatory = @mandatory;
      __req.m_immediate = @immediate;
      ModelSend(__req, (BasicProperties) basicProperties,body);
    }
    public override void _Private_BasicConsume(
      System.UInt16 @ticket,
      System.String @queue,
      System.String @consumerTag,
      System.Boolean @noLocal,
      System.Boolean @noAck,
      System.Boolean @exclusive,
      System.Boolean @nowait,
      System.Collections.IDictionary @filter)
    {
      BasicConsume __req = new BasicConsume();
      __req.m_ticket = @ticket;
      __req.m_queue = @queue;
      __req.m_consumerTag = @consumerTag;
      __req.m_noLocal = @noLocal;
      __req.m_noAck = @noAck;
      __req.m_exclusive = @exclusive;
      __req.m_nowait = @nowait;
      if (@filter != null) {
        throw new UnsupportedMethodFieldException("_Private_BasicConsume","filter");
      }
      ModelSend(__req,null,null);
    }
    public override void _Private_BasicCancel(
      System.String @consumerTag,
      System.Boolean @nowait)
    {
      BasicCancel __req = new BasicCancel();
      __req.m_consumerTag = @consumerTag;
      __req.m_nowait = @nowait;
      ModelSend(__req,null,null);
    }
    public override void _Private_ChannelOpen(
      System.String @outOfBand)
    {
      ChannelOpen __req = new ChannelOpen();
      __req.m_outOfBand = @outOfBand;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ChannelOpenOk __rep = __repBase as ChannelOpenOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void _Private_ChannelCloseOk()
    {
      ChannelCloseOk __req = new ChannelCloseOk();
      ModelSend(__req,null,null);
    }
    public override void _Private_ChannelClose(
      System.UInt16 @replyCode,
      System.String @replyText,
      System.UInt16 @classId,
      System.UInt16 @methodId)
    {
      ChannelClose __req = new ChannelClose();
      __req.m_replyCode = @replyCode;
      __req.m_replyText = @replyText;
      __req.m_classId = @classId;
      __req.m_methodId = @methodId;
      ModelSend(__req,null,null);
    }
    public override void _Private_BasicGet(
      System.UInt16 @ticket,
      System.String @queue,
      System.Boolean @noAck)
    {
      BasicGet __req = new BasicGet();
      __req.m_ticket = @ticket;
      __req.m_queue = @queue;
      __req.m_noAck = @noAck;
      ModelSend(__req,null,null);
    }
    public override RabbitMQ.Client.Impl.ConnectionTuneDetails ConnectionStartOk(
      System.Collections.IDictionary @clientProperties,
      System.String @mechanism,
      System.Byte[] @response,
      System.String @locale)
    {
      ConnectionStartOk __req = new ConnectionStartOk();
      __req.m_clientProperties = @clientProperties;
      __req.m_mechanism = @mechanism;
      __req.m_response = @response;
      __req.m_locale = @locale;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ConnectionTune __rep = __repBase as ConnectionTune;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      RabbitMQ.Client.Impl.ConnectionTuneDetails __result = new RabbitMQ.Client.Impl.ConnectionTuneDetails();
      __result.channelMax = __rep.m_channelMax;
      __result.frameMax = __rep.m_frameMax;
      __result.heartbeat = __rep.m_heartbeat;
      return __result;
    }
    public override void ConnectionTuneOk(
      System.UInt16 @channelMax,
      System.UInt32 @frameMax,
      System.UInt16 @heartbeat)
    {
      ConnectionTuneOk __req = new ConnectionTuneOk();
      __req.m_channelMax = @channelMax;
      __req.m_frameMax = @frameMax;
      __req.m_heartbeat = @heartbeat;
      ModelSend(__req,null,null);
    }
    public override void _Private_ConnectionOpen(
      System.String @virtualHost,
      System.String @capabilities,
      System.Boolean @insist)
    {
      ConnectionOpen __req = new ConnectionOpen();
      __req.m_virtualHost = @virtualHost;
      __req.m_capabilities = @capabilities;
      __req.m_insist = @insist;
      ModelSend(__req,null,null);
    }
    public override void _Private_ConnectionClose(
      System.UInt16 @replyCode,
      System.String @replyText,
      System.UInt16 @classId,
      System.UInt16 @methodId)
    {
      ConnectionClose __req = new ConnectionClose();
      __req.m_replyCode = @replyCode;
      __req.m_replyText = @replyText;
      __req.m_classId = @classId;
      __req.m_methodId = @methodId;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ConnectionCloseOk __rep = __repBase as ConnectionCloseOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void _Private_ConnectionCloseOk()
    {
      ConnectionCloseOk __req = new ConnectionCloseOk();
      ModelSend(__req,null,null);
    }
    public override RabbitMQ.Client.IBasicProperties CreateBasicProperties()
    {
      return new BasicProperties();
    }
    public override RabbitMQ.Client.IFileProperties CreateFileProperties()
    {
      return new FileProperties();
    }
    public override RabbitMQ.Client.IStreamProperties CreateStreamProperties()
    {
      return new StreamProperties();
    }
    public override void ChannelFlow(
      System.Boolean @active)
    {
      ChannelFlow __req = new ChannelFlow();
      __req.m_active = @active;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ChannelFlowOk __rep = __repBase as ChannelFlowOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void ExchangeDeclare(
      System.UInt16 @ticket,
      System.String @exchange,
      System.String @type,
      System.Boolean @passive,
      System.Boolean @durable,
      System.Boolean @autoDelete,
      System.Boolean @internal,
      System.Boolean @nowait,
      System.Collections.IDictionary @arguments)
    {
      ExchangeDeclare __req = new ExchangeDeclare();
      __req.m_ticket = @ticket;
      __req.m_exchange = @exchange;
      __req.m_type = @type;
      __req.m_passive = @passive;
      __req.m_durable = @durable;
      __req.m_autoDelete = @autoDelete;
      __req.m_internal = @internal;
      __req.m_nowait = @nowait;
      __req.m_arguments = @arguments;
      if (nowait) {
        ModelSend(__req,null,null);
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ExchangeDeclareOk __rep = __repBase as ExchangeDeclareOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void ExchangeDelete(
      System.UInt16 @ticket,
      System.String @exchange,
      System.Boolean @ifUnused,
      System.Boolean @nowait)
    {
      ExchangeDelete __req = new ExchangeDelete();
      __req.m_ticket = @ticket;
      __req.m_exchange = @exchange;
      __req.m_ifUnused = @ifUnused;
      __req.m_nowait = @nowait;
      if (nowait) {
        ModelSend(__req,null,null);
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ExchangeDeleteOk __rep = __repBase as ExchangeDeleteOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override System.String QueueDeclare(
      System.UInt16 @ticket,
      System.String @queue,
      System.Boolean @passive,
      System.Boolean @durable,
      System.Boolean @exclusive,
      System.Boolean @autoDelete,
      System.Boolean @nowait,
      System.Collections.IDictionary @arguments)
    {
      QueueDeclare __req = new QueueDeclare();
      __req.m_ticket = @ticket;
      __req.m_queue = @queue;
      __req.m_passive = @passive;
      __req.m_durable = @durable;
      __req.m_exclusive = @exclusive;
      __req.m_autoDelete = @autoDelete;
      __req.m_nowait = @nowait;
      __req.m_arguments = @arguments;
      if (nowait) {
        ModelSend(__req,null,null);
        return null;
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueDeclareOk __rep = __repBase as QueueDeclareOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_queue;
    }
    public override void QueueBind(
      System.UInt16 @ticket,
      System.String @queue,
      System.String @exchange,
      System.String @routingKey,
      System.Boolean @nowait,
      System.Collections.IDictionary @arguments)
    {
      QueueBind __req = new QueueBind();
      __req.m_ticket = @ticket;
      __req.m_queue = @queue;
      __req.m_exchange = @exchange;
      __req.m_routingKey = @routingKey;
      __req.m_nowait = @nowait;
      __req.m_arguments = @arguments;
      if (nowait) {
        ModelSend(__req,null,null);
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueBindOk __rep = __repBase as QueueBindOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void QueueUnbind(
      System.UInt16 @ticket,
      System.String @queue,
      System.String @exchange,
      System.String @routingKey,
      System.Collections.IDictionary @arguments)
    {
      throw new UnsupportedMethodException("QueueUnbind");
    }
    public override System.UInt32 QueuePurge(
      System.UInt16 @ticket,
      System.String @queue,
      System.Boolean @nowait)
    {
      QueuePurge __req = new QueuePurge();
      __req.m_ticket = @ticket;
      __req.m_queue = @queue;
      __req.m_nowait = @nowait;
      if (nowait) {
        ModelSend(__req,null,null);
        return 0xFFFFFFFF;
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueuePurgeOk __rep = __repBase as QueuePurgeOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_messageCount;
    }
    public override System.UInt32 QueueDelete(
      System.UInt16 @ticket,
      System.String @queue,
      System.Boolean @ifUnused,
      System.Boolean @ifEmpty,
      System.Boolean @nowait)
    {
      QueueDelete __req = new QueueDelete();
      __req.m_ticket = @ticket;
      __req.m_queue = @queue;
      __req.m_ifUnused = @ifUnused;
      __req.m_ifEmpty = @ifEmpty;
      __req.m_nowait = @nowait;
      if (nowait) {
        ModelSend(__req,null,null);
        return 0xFFFFFFFF;
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueDeleteOk __rep = __repBase as QueueDeleteOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_messageCount;
    }
    public override void BasicQos(
      System.UInt32 @prefetchSize,
      System.UInt16 @prefetchCount,
      System.Boolean @global)
    {
      BasicQos __req = new BasicQos();
      __req.m_prefetchSize = @prefetchSize;
      __req.m_prefetchCount = @prefetchCount;
      __req.m_global = @global;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      BasicQosOk __rep = __repBase as BasicQosOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void BasicAck(
      System.UInt64 @deliveryTag,
      System.Boolean @multiple)
    {
      BasicAck __req = new BasicAck();
      __req.m_deliveryTag = @deliveryTag;
      __req.m_multiple = @multiple;
      ModelSend(__req,null,null);
    }
    public override void BasicReject(
      System.UInt64 @deliveryTag,
      System.Boolean @requeue)
    {
      BasicReject __req = new BasicReject();
      __req.m_deliveryTag = @deliveryTag;
      __req.m_requeue = @requeue;
      ModelSend(__req,null,null);
    }
    public override void BasicRecover(
      System.Boolean @requeue)
    {
      BasicRecover __req = new BasicRecover();
      __req.m_requeue = @requeue;
      ModelSend(__req,null,null);
    }
    public override void TxSelect()
    {
      TxSelect __req = new TxSelect();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      TxSelectOk __rep = __repBase as TxSelectOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void TxCommit()
    {
      TxCommit __req = new TxCommit();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      TxCommitOk __rep = __repBase as TxCommitOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void TxRollback()
    {
      TxRollback __req = new TxRollback();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      TxRollbackOk __rep = __repBase as TxRollbackOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void DtxSelect()
    {
      DtxSelect __req = new DtxSelect();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      DtxSelectOk __rep = __repBase as DtxSelectOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void DtxStart(
      System.String @dtxIdentifier)
    {
      DtxStart __req = new DtxStart();
      __req.m_dtxIdentifier = @dtxIdentifier;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      DtxStartOk __rep = __repBase as DtxStartOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override bool DispatchAsynchronous(RabbitMQ.Client.Impl.Command cmd) {
      RabbitMQ.Client.Impl.MethodBase __method = (RabbitMQ.Client.Impl.MethodBase) cmd.Method;
      switch ((__method.ProtocolClassId << 16) | __method.ProtocolMethodId) {
        case 3932181: {
          BasicConsumeOk __impl = (BasicConsumeOk) __method;
          HandleBasicConsumeOk(
            __impl.m_consumerTag);
          return true;
        }
        case 3932191: {
          BasicCancelOk __impl = (BasicCancelOk) __method;
          HandleBasicCancelOk(
            __impl.m_consumerTag);
          return true;
        }
        case 3932231: {
          BasicGetOk __impl = (BasicGetOk) __method;
          HandleBasicGetOk(
            __impl.m_deliveryTag,
            __impl.m_redelivered,
            __impl.m_exchange,
            __impl.m_routingKey,
            __impl.m_messageCount,
            (RabbitMQ.Client.IBasicProperties) cmd.Header,
            cmd.Body);
          return true;
        }
        case 3932232: {
          HandleBasicGetEmpty();
          return true;
        }
        case 3932220: {
          BasicDeliver __impl = (BasicDeliver) __method;
          HandleBasicDeliver(
            __impl.m_consumerTag,
            __impl.m_deliveryTag,
            __impl.m_redelivered,
            __impl.m_exchange,
            __impl.m_routingKey,
            (RabbitMQ.Client.IBasicProperties) cmd.Header,
            cmd.Body);
          return true;
        }
        case 3932210: {
          BasicReturn __impl = (BasicReturn) __method;
          HandleBasicReturn(
            __impl.m_replyCode,
            __impl.m_replyText,
            __impl.m_exchange,
            __impl.m_routingKey,
            (RabbitMQ.Client.IBasicProperties) cmd.Header,
            cmd.Body);
          return true;
        }
        case 1310760: {
          ChannelClose __impl = (ChannelClose) __method;
          HandleChannelClose(
            __impl.m_replyCode,
            __impl.m_replyText,
            __impl.m_classId,
            __impl.m_methodId);
          return true;
        }
        case 1310761: {
          HandleChannelCloseOk();
          return true;
        }
        case 655370: {
          ConnectionStart __impl = (ConnectionStart) __method;
          HandleConnectionStart(
            __impl.m_versionMajor,
            __impl.m_versionMinor,
            __impl.m_serverProperties,
            __impl.m_mechanisms,
            __impl.m_locales);
          return true;
        }
        case 655401: {
          ConnectionOpenOk __impl = (ConnectionOpenOk) __method;
          HandleConnectionOpenOk(
            __impl.m_knownHosts);
          return true;
        }
        case 655410: {
          ConnectionRedirect __impl = (ConnectionRedirect) __method;
          HandleConnectionRedirect(
            __impl.m_host,
            __impl.m_knownHosts);
          return true;
        }
        case 655420: {
          ConnectionClose __impl = (ConnectionClose) __method;
          HandleConnectionClose(
            __impl.m_replyCode,
            __impl.m_replyText,
            __impl.m_classId,
            __impl.m_methodId);
          return true;
        }
        default: return false;
      }
    }
  }
}
