# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
Models specific to the Youtube plugin.
"""

from elisa.core.components.model import Model

from elisa.plugins.base.models.video import VideoModel


class YoutubeVideoModel(VideoModel):

    """
    A video model contains metadata associated to the video.

    @ivar youtube_id:     the id of the video
    @type youtube_id:     C{unicode}
    @ivar title:          the title of the video
    @type title:          C{unicode}
    @ivar description:    a short text description of the video
    @type description:    C{unicode}
    @ivar keywords:       a list of keywords associated to the video
    @type keywords:       C{list} of C{unicode}
    @ivar thumbnails:     a list of thumbnails for the video
    @type thumbnails:     C{list} of L{elisa.plugins.base.models.image.ImageModel}
    @ivar playable_model: a model containing the playable URI of the video
    @type playable_model: L{elisa.plugins.base.models.media.PlayableModel}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(YoutubeVideoModel, self).__init__()
        self.youtube_id = None
        self.title = None
        self.description = None
        self.keywords = []
        self.thumbnails = []
        self.playable_model = None


class YoutubeVideoListModel(Model):

    """
    A video list model contains a list of video models.

    @ivar videos: the list of videos
    @type videos: C{list} of L{elisa.plugins.youtube.models.YoutubeVideoModel}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(YoutubeVideoListModel, self).__init__()
        self.videos = []
