#include <QtGui/QLineEdit>
#include <QtGui/QGridLayout>
#include <QtGui/QRadioButton>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QTextBrowser>
#include "../../sources/gui/choosemountpointwidget.h"
#include "shareswizard.h"


SharesWizard::SharesWizard(QWidget *parent) : QWizard(parent) {
	
	finishButton = new QPushButton(tr("Finish"));
	connect(finishButton,SIGNAL(clicked()),this,SIGNAL(finished()));
	connect(finishButton,SIGNAL(clicked()),this,SLOT(restart()));
	
	cancelButton = new QPushButton(tr("Cancel"));
	connect(cancelButton,SIGNAL(clicked()),this,SIGNAL(canceled()));
	
	setButton(QWizard::FinishButton,finishButton);
	setButton(QWizard::CancelButton,cancelButton);
	//==========================TYPE PAGE==============================//
	typePage = new QWizardPage;
	typePage->setTitle(tr("Share's type"));
	
	QLabel *typeLabel = new QLabel;
	typeLabel->setWordWrap(true);
	typeLabel->setText(tr("MountManager support two types of the shares: NFS and Samba. About NFS shares you can read %1there%2. About Samba %3there%2. Please, choose kind of share and all next actions will be doing with this type.").arg("<a href='http://en.wikipedia.org/wiki/Network_file_system'>").arg("</a>").arg("<a href='http://en.wikipedia.org/wiki/SAMBA'>"));
	
	nfsTypeButton = new QRadioButton;
	nfsTypeButton->setText("NFS");
	nfsTypeButton->setChecked(true);
	
	sambaTypeButton = new QRadioButton;
	sambaTypeButton->setText("Samba");
	
	typeLayout = new QVBoxLayout;
	typeLayout->addWidget(typeLabel);
	typeLayout->addWidget(nfsTypeButton);
	typeLayout->addWidget(sambaTypeButton);
	typePage->setLayout(typeLayout);
	
	setPage(TypePage,typePage);
	
	//==========================SERVER PAGE==============================//
	serverPage = new QWizardPage;
	serverPage->setTitle(tr("Server settings"));
	
	serverLineEdit = new QLineEdit;
	remoteDirLineEdit = new QLineEdit;
	
	QLabel *serverLabel = new QLabel;
	serverLabel->setWordWrap(true);
	serverLabel->setText(tr("You have to point server. E.g. shadowman.example.com"));
	
	QLabel *remoteDirLabel = new QLabel;
	remoteDirLabel->setWordWrap(true);
	remoteDirLabel->setText(tr("Please, write the path of the server, which you want to mount. E.g. /usr/local/pub"));
	
	serverLayout = new QGridLayout;
	serverLayout->addWidget(serverLabel,0,0,1,2);
	serverLayout->addWidget(new QLabel(tr("Server") + ":"),1,0);
	serverLayout->addWidget(serverLineEdit,1,1);
	serverLayout->addWidget(remoteDirLabel,2,0,1,2);
	serverLayout->addWidget(new QLabel(tr("Server path") + ":"),3,0);
	serverLayout->addWidget(remoteDirLineEdit,3,1);
	serverPage->setLayout(serverLayout);
	
	setPage(ServerPage,serverPage);
	
	//==========================Mount point PAGE==============================//
	mountPointPage = new QWizardPage;
	mountPointPage->setTitle(tr("Mount point"));
	
	QLabel *mountPointLabel = new QLabel;
	mountPointLabel->setWordWrap(true);
	mountPointLabel->setText(tr("Please, choose a directory, where you want to see all files from the pointed server."));
	
	mountPoint = new ChooseMountPointWidget;
	
	mountPointLayout = new QVBoxLayout;
	mountPointLayout->addWidget(mountPointLabel);
	mountPointLayout->addWidget(mountPoint);
	mountPointPage->setLayout(mountPointLayout);
	
	setPage(MountPointPage,mountPointPage);
	
	//==========================Options PAGE==============================//
	optionsPage = new QWizardPage;
	optionsPage->setTitle(tr("Mount options"));
	
	QLabel *optionsLabel = new QLabel;
	optionsLabel->setWordWrap(true);
	optionsLabel->setText(tr("You can set different options of mounting. It's possible only for NFS shares. All supported options you can read %1there%2. E.g. rsize=8192,wsize=8192,timeo=14,intr. If options line is empty, options will be default.").arg("<a href='http://www.redhat.com/docs/manuals/enterprise/RHEL-5-manual/Deployment_Guide-en-US/s1-nfs-client-config-options.html'>").arg("</a>"));
	
	optionsLineEdit = new QLineEdit;
	
	optionsLayout = new QVBoxLayout;
	optionsLayout->addWidget(optionsLabel);
	optionsLayout->addWidget(optionsLineEdit);
	optionsPage->setLayout(optionsLayout);
	
	setPage(OptionsPage,optionsPage);
	
	//==========================User settings PAGE==============================//
	userSettingsPage = new QWizardPage;
	userSettingsPage->setTitle(tr("User settings"));
	
	nameLineEdit = new QLineEdit;
	passwordLineEdit = new QLineEdit;
	
	userSettingsLayout = new QGridLayout;
	userSettingsLayout->addWidget(new QLabel(tr("Name") + ":"),0,0);
	userSettingsLayout->addWidget(nameLineEdit,0,1);
	userSettingsLayout->addWidget(new QLabel(tr("Password") + ":"),1,0);
	userSettingsLayout->addWidget(passwordLineEdit,1,1);
	userSettingsPage->setLayout(userSettingsLayout);
	
	setPage(UserSettingsPage,userSettingsPage);
	
	//==========================Result PAGE==============================//
	resultPage = new QWizardPage;
	resultPage->setTitle(tr("Result"));
	
	result = new QTextBrowser;
	
	resultLayout = new QVBoxLayout;
	resultLayout->addWidget(result);
	resultPage->setLayout(resultLayout);
	
	setPage(ResultPage,resultPage);
	
	connect(this,SIGNAL(currentIdChanged(int)),this,SLOT(currentPageChanged(int)));
	setWindowTitle(tr("Shares Wizard"));
	setWindowIcon(QIcon(":/icons/share_mount.png"));
}

SharesWizard::~SharesWizard() {
	delete nfsTypeButton;
	delete sambaTypeButton;
	delete typeLayout;
	delete typePage;

	delete serverLineEdit;
	delete remoteDirLineEdit;
	delete serverLayout;
	delete serverPage;

	delete mountPoint;
	delete mountPointLayout;
	delete mountPointPage;

	delete optionsLineEdit;
	delete optionsLayout;
	delete optionsPage;

	delete nameLineEdit;
	delete passwordLineEdit;
	delete userSettingsLayout;
	delete userSettingsPage;
	
	delete cancelButton;
	delete finishButton;
	
	delete result;
	delete resultLayout;
	delete resultPage;
}

void SharesWizard::currentPageChanged(int id) {
	if (id == MountPointPage) {
		if (serverLineEdit->text().isEmpty()) {
			back();
			serverLineEdit->setFocus();
		} else if (remoteDirLineEdit->text().isEmpty()) {
			back();
			remoteDirLineEdit->setFocus();
		}
	} else if (id == OptionsPage || id == UserSettingsPage) {
		if (!mountPoint->isValid()) {
			back();
			mountPoint->chooseMountPoint();
		}
	} else if (id == ResultPage) {
		bool toBack = false;
		if (!nfsTypeButton->isChecked()) {
			if (nameLineEdit->text().isEmpty()) {
				back();
				nameLineEdit->setFocus();
				toBack = true;
			} else if (passwordLineEdit->text().isEmpty()) {
				back();
				passwordLineEdit->setFocus();
				toBack = true;
			}
		}
		if (!toBack) {
			QString resultText;
			resultText = tr("Are you sure, you want to add share with these settings:%1%2Type:%3 %4%1%2Server:%3 %5%1%2Server path:%3 %6%1%2Mount point: %3 %7%1").arg("<br>").arg("<b>").arg("</b>").arg(nfsTypeButton->isChecked() ? "NFS" : "Samba").arg(serverLineEdit->text()).arg(remoteDirLineEdit->text()).arg(mountPoint->mountPoint());
			if (nfsTypeButton->isChecked())
				resultText += QString("%1Mount options: %2 %3%4").arg("<b>").arg("</b>").arg(optionsLineEdit->text()).arg("<br>");
			else
				resultText += QString("%1Name: %2 %3%4%1Password:%2 %5").arg("<b>").arg("</b>").arg(nameLineEdit->text()).arg("<br>").arg(passwordLineEdit->text());
			result->setHtml(resultText);
		}
	}
}

int SharesWizard::nextId() const {
	switch (currentId()) {
		case MountPointPage:
			if (nfsTypeButton->isChecked())
				return OptionsPage;
			else
				return UserSettingsPage;
			break;
		case OptionsPage:
			if (nfsTypeButton->isChecked())
				return ResultPage;
			else
				return UserSettingsPage;
		default:
			if (currentId() < ResultPage)
				return currentId() + 1;
			else
				return -1;
	}
}

QString SharesWizard::getType() {
	return nfsTypeButton->isChecked() ? "NFS" : "Samba";
}

QString SharesWizard::getServer() {
	return SharesWizard::serverLineEdit->text();
}

QString SharesWizard::getServerPath() {
	return remoteDirLineEdit->text();
}

QString SharesWizard::getOptions() {
	return optionsLineEdit->text();
}

QString SharesWizard::getMountPoint() {
	return mountPoint->mountPoint();
}

QString SharesWizard::getName() {
	return nameLineEdit->text();
}

QString SharesWizard::getPassword() {
	return passwordLineEdit->text();
}
