#ifndef OPTIONSFORFSWIDGET_H
#define OPTIONSFORFSWIDGET_H

#include <QtGui/QWidget>

class QComboBox;
class QLineEdit;
class QToolButton;
class QVBoxLayout;

class Row : public QWidget
{
	public:
		Row(const QString& fileSystem = QString(),const QString& options = QString());
		~Row();
	
		void setFileSystem(const QString& fileSystem);
		void setOptions(const QString& options);
	
		QString getFileSystem() const;
		QString getOptions() const;
	
		QToolButton *removeRowButton;
	private:
		QComboBox *fileSystemView;
		QLineEdit *optionsView;
};

class OptionsForFSWidget : public QWidget
{
	Q_OBJECT
	private slots:
		// If user remove some row update list of rows
		void updateRows();
	public slots:
		void addRow();
		void addRow(const QString& fileSystem,const QString& options);
	public:
		OptionsForFSWidget();
		~OptionsForFSWidget();
	
		void clear();
	
		int count() const;
		QString getFileSystem(int rowIndex) const;
		QString getOptions(int rowIndex) const;
	private:
		QToolButton *addRowButton;
	
		QVBoxLayout *rowsLayout;
	
		QList<Row *> rows;
};

#endif
