/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgTabBox, mapTree, defTree, mgCatLen;
var sortByGesture = new Array();
var sortByName = new Array();
var sortBy = "byName";
var sortOrder = "ascending";
var wType;
var exportButton;

function initMappingsWindow(restart) {
  mgTabBox = document.getElementById("mgTabBox");
  mapTree = document.getElementById("mapTree");
  defTree = document.getElementById("defTree");
  mgCatLen = document.getElementById("mapTreeChildren").childNodes.length;
  exportButton = document.getElementById("exportButton");

  //from compassOverlay.xul
  initDirectionCodes();

  //fill _mgMS.actTemp
  for (component in _mgMS.activeMappings) {
     _mgMS.actTemp[component] = new Array();

     for (mapping in _mgMS.activeMappings[component])
       _mgMS.actTemp[component][mapping] = _mgMS.activeMappings[component][mapping];
  }

  //presort _mgMS.actTemp by Name and ascending
  sortTree("byName", "ascending");

  //fill _mgMS.defTemp
  for (component in _mgMS.removedDefaultMappings) {
     _mgMS.defTemp[component] = new Array();

     for (mapping in _mgMS.removedDefaultMappings[component])
       _mgMS.defTemp[component][mapping] = _mgMS.removedDefaultMappings[component][mapping];
  }

  //restart is only set to true by 'mgMappingsObserver' (import gesture set)
  if (!restart) {
    //get window types supported by the app
    var sW = document.getElementsByAttribute("mgWinType", "*");

    for (var y = 1; y < sW.length; y++) {
      if (!(sW[y].getAttribute("mgWinType") in _mgMS.supportedWindows))
        sW[y].setAttribute("mgDummyTab", true);
    }

    while (mgTabBox._tabs.getElementsByAttribute("mgDummyTab", "*").length)
      mgTabBox._tabs.removeChild(mgTabBox._tabs.getElementsByAttribute("mgDummyTab", "*")[0]);

    mgTabBox._tabs.firstChild.removeAttribute("afterselected");

    //select a window type
    if (("arguments" in window)) {
      if (window.arguments[0]) {
        var args = window.arguments[0];
        mgTabBox.selectedTab = document.getElementsByAttribute("mgWinType", args[1])[0];

        if (args[0] == "directEdit" || args[0] == "Import")
          setTimeout(handleArguments, 0, args[0], args[2]);
      }
    }
    else {
      var winEnum = mgCommon.winMediator.getZOrderDOMWindowEnumerator(null, true);
      var winFound = false;

      while (winEnum.hasMoreElements()) {
        var win = winEnum.getNext();
        if ("mgWindowType" in win) {
          mgTabBox.selectedTab = document.getElementsByAttribute("mgWinType", win.mgWindowType)[0];
          winFound = true;
          break;
        }
      }
      if (!winFound)
        mgTabBox.selectedTab = document.getElementsByAttribute("mgWinType", "window")[0];
    }
  }
}

function showMappingsFor(component) {
  wType = component;
  clearTrees();
  var acm = _mgMS.actTemp[component];

  for (mapping in acm) {
    var mName;
    if (acm[mapping].name)
      mName = acm[mapping].name;
    else
      mName = mgGetString(acm[mapping].func);

    var tc = document.getElementById("trcat" + acm[mapping].cat)
    mgCommon.addTreeRow(tc, new Array(mgMappingLocalizer.localize(mapping), decodeURIComponent(mName)), "act" + mapping);

  }

  setCount("trItemcatLabel", "trcat");
  showRemovedDefaults(component);
}

function setCount(label, item) {
  for (var x = 0; x < mgCatLen; x++) {
    var lbl = document.getElementById(label + x);
    var tCat = document.getElementById(item + x);
    var count = tCat.childNodes.length;

    tCat.parentNode.setAttribute("hidden", (count > 0) ? false : true);
    lbl.setAttribute("label", "(" + count + ")");
  }
}

function clearTrees() {
  for (var x=0; x < mgCatLen; x++) {
    var tc = document.getElementById("trcat" + x);

    while (tc.hasChildNodes())
      tc.removeChild(tc.firstChild);

    var tc1 = document.getElementById("deftrcat" + x);

    while (tc1.hasChildNodes())
      tc1.removeChild(tc1.firstChild);
  }
}

function sortTree(sortOrder, dir) {
  if (sortOrder == "byName") {
    sortByName = new Array();

    for (component in _mgMS.actTemp) {
      sortByName[component] = new Array();

      for (mapping in _mgMS.actTemp[component]) {
        var mName;

        if (_mgMS.actTemp[component][mapping].name)
          mName = decodeURIComponent(_mgMS.actTemp[component][mapping].name);
        else
          mName = mgGetString(_mgMS.actTemp[component][mapping].func);

        sortByName[component][sortByName[component].length] = [mName, mapping, _mgMS.actTemp[component][mapping].cat];
      }



      if (dir == "ascending")
        sortByName[component].sort(function(a, b) {return ((a[0].toLowerCase())>(b[0].toLowerCase()) ? 1 : -1)} );
      if (dir == "descending")
        sortByName[component].sort(function(a, b) {return ((a[0].toLowerCase())<(b[0].toLowerCase()) ? 1 : -1)} );

      sortByName[component].sort(function(a, b) {return ((a[2])>(b[2]) ? 1 : -1)} );
    }

    for (component in _mgMS.actTemp) {
      var temp = _mgMS.actTemp[component];
      _mgMS.actTemp[component] = new Array()

      for (var x=0; x < sortByName[component].length; x++) {
        var mapping = sortByName[component][x][1];
        _mgMS.actTemp[component][mapping] = temp[mapping];
      }
    }
  }

  if (sortOrder == "byGesture") {
    sortByGesture = new Array();

    for (component in _mgMS.actTemp) {
      sortByGesture[component] = new Array();

      for (mapping in _mgMS.actTemp[component])
        sortByGesture[component][sortByGesture[component].length] = mapping;

      if (dir == "ascending")
        sortByGesture[component].sort(function(a, b) {return ((a.toLowerCase())>(b.toLowerCase()) ? 1 : -1)} );

      if (dir == "descending")
        sortByGesture[component].sort(function(a, b) {return ((a.toLowerCase())<(b.toLowerCase()) ? 1 : -1)} );
    }

    for (component in _mgMS.actTemp) {
      var temp = _mgMS.actTemp[component];
      _mgMS.actTemp[component] = new Array()

      for (x=0; x < sortByGesture[component].length; x++)
        _mgMS.actTemp[component][sortByGesture[component][x]] = temp[sortByGesture[component][x]];
    }
  }
}

function changeSortOrder(order, target, oldTarget) {
  sortBy = order;
  oldTarget.removeAttribute("sortDirection");

  if (target.hasAttribute("sortDirection"))
    sortOrder = target.getAttribute("sortDirection");

  else if (target.hasAttribute("mgOldSortDirection"))
    sortOrder = target.getAttribute("mgOldSortDirection");

  if (sortOrder == "descending")
    target.setAttribute("sortDirection", "ascending");

  if (sortOrder == "ascending")
    target.setAttribute("sortDirection", "descending");

  target.setAttribute("mgOldSortDirection", sortOrder);
  sortTree(sortBy, target.getAttribute("sortDirection"));
  showMappingsFor(wType);
}

function showRemovedDefaults() {
  var rdm = _mgMS.defTemp[wType];

  for (var mapping in rdm) {
    var tc = document.getElementById("deftrcat" + rdm[mapping].cat);

    mgCommon.addTreeRow(tc, new Array(mgMappingLocalizer.localize(mapping),
                        mgGetString(rdm[mapping].func)), "def" + mapping);
  }

  setCount("deftrItemcatLabel", "deftrcat");
}

function removeMapping() {
  exportButton.disabled = true;
  var delArray = new Array();

  for (var x = 0; x < mapTree.view.rowCount; x++) {
    if (mapTree.view.selection.isSelected(x)) {
      var tc = mapTree.view.getItemAtIndex(x);

      if (tc.id.indexOf("trItemcat") != 0)
        delArray[delArray.length] = tc.id;
    }
  }

  mapTree.view.selection.clearSelection();
  var tempArray = new Array();

  for (x = 0; x < delArray.length; x++) {
    var map = delArray[x].substring(3);
    var item = document.getElementById(delArray[x]);
    tempArray[map] = "true";

    if (map in _mgMS.defaultMappings[wType]) {
      if (!_mgMS.actTemp[wType][map].name &&
          _mgMS.actTemp[wType][map].func == _mgMS.defaultMappings[wType][map].func)
      {
          _mgMS.defTemp[wType][map] = _mgMS.actTemp[wType][map];

          var deftrcat = document.getElementById("def" + item.parentNode.id);

          mgCommon.addTreeRow(deftrcat, new Array(mgMappingLocalizer.localize(map),
                              mgGetString(_mgMS.defaultMappings[wType][map].func)), "def" + map);

      }
    }
    item.parentNode.removeChild(item);
  }

  // rebuild _mgMS.actTemp
  var temp = _mgMS.actTemp[wType];
  _mgMS.actTemp[wType] = new Array();

  for (mapping1 in temp) {
    if (mapping1 in tempArray)
      continue;

    _mgMS.actTemp[wType][mapping1] = temp[mapping1];
  }

  sortTree(sortBy, sortOrder);
  showMappingsFor(wType);
}

function addDefault() {
  var index = defTree.view.selection.currentIndex;
  var defItem = defTree.view.getItemAtIndex(index);
  var defItemParent = defItem.parentNode;

  var mapping = defItem.id.substring(3);
  var mapItemID = "act" + defItem.id.substring(3);
  var mapItemParent = document.getElementById(defItemParent.id.substring(3));

  if (overWriteCheck(mapping)) {
    var mapItem = document.getElementById(mapItemID);

    if (mapItem)
      mapItem.parentNode.removeChild(mapItem);

    mgCommon.addTreeRow(mapItemParent, new Array(mgMappingLocalizer.localize(mapping),
                                       mgGetString(_mgMS.defaultMappings[wType][mapping].func)), "act" + mapping);


    // rebuild _mgMS.defTemp
    var temp = _mgMS.defTemp[wType];
    _mgMS.defTemp[wType] = new Array();

    for (mapping1 in temp) {
      if (mapping1 == mapping)
        continue;

      _mgMS.defTemp[wType][mapping1] = temp[mapping1];
    }

    _mgMS.actTemp[wType][mapping] = temp[mapping];

    if (!_mgMS.actTemp[wType][mapping].count)
      _mgMS.actTemp[wType][mapping].count = 0;

    temp = null;
    defTree.view.selection.clearSelection();
    defItemParent.removeChild(defItem);
    sortTree(sortBy, sortOrder);
    showMappingsFor(wType);
    exportButton.disabled = true;
  }
}

function overWriteCheck(mapping) {
  var conf = true;

  if (mapping in _mgMS.actTemp[wType]) {
    var msg = mgGetString("overwriteWarning");
    var xName;

    if (_mgMS.actTemp[wType][mapping].name)
      xName = decodeURIComponent(_mgMS.actTemp[wType][mapping].name);
    else
      xName = mgGetString(_mgMS.actTemp[wType][mapping].func);

    msg = msg.replace(/%MAPPINGNAME%/, xName);
    var dc = mgMappingLocalizer.localize(mapping);
    msg = msg.replace(/%CODE%/, dc);
    conf = confirm(msg)
  }
  return conf;
}

function handleArguments(editMode, eCode) {
  if (editMode == "directEdit") {
    var item = document.getElementById("act" + eCode);

    var cat = _mgMS.actTemp[wType][eCode].cat;
    document.getElementById("trItemcat" + cat).setAttribute("open", true);

    mapTree.view.selection.select(mapTree.view.getIndexOfItem(item));
    mapTree.boxObject.ensureRowIsVisible(mapTree.view.getIndexOfItem(item));

    mapTree.focus();
    editMapping("Edit");
  }
  else if (editMode == "Import")
    editMapping("Import");
  else
    editMapping("New");
}

function onAcceptMappings() {
  _mgMS.activeMappings = _mgMS.actTemp;
  _mgMS.removedDefaultMappings = _mgMS.defTemp;
  _mgMS.writeActiveMappingsToFile(false);
  _mgMS.cleanUp();
  mgCommon.notifyObservers("mappingsUpdated");
  return true;
}

function onCancel() {
  _mgMS.cleanUp();
  _mgMS.curBookmark = null;
  return true;
}

/*** mapping actions ***/

function editMapping(mode) {
  var mapping = null;

  if (mode == "Edit") {
    var index = mapTree.view.selection.currentIndex;
    var tc = mapTree.view.getItemAtIndex(index);
    mapping = tc.id.substring(3);
  }
  if (mode == "Import") {
    wType =_mgMS.importWinType;
    mapping = _mgMS.importCode;
  }
  openEditWindow(mode, mapping);
}

function openEditWindow(mode, mapping) {
  window.openDialog("chrome://mozgest/content/pref/edit-mapping.xul",
                    "mozgest:editmapping", "chrome,modal,resizable",
                    mode, wType, mapping);
}

function publishMapping() {
  var index = mapTree.view.selection.currentIndex;
  var tc = mapTree.view.getItemAtIndex(index);
  var mapping = tc.id.substring(3);

  window.openDialog("chrome://mozgest/content/pref/publishMapping.xul",
                    "mozgest:publishmapping", "chrome,centerscreen,modal",
                    wType, mapping);
}

function updateButtons(tree, buttons) {
  buttons.setAttribute("disabled", true);

  var sel = tree.view.selection;

  if (sel.count == 0)
    return;

  var index = sel.currentIndex;
  var tc = tree.view.getItemAtIndex(index)

  if (sel.isSelected(index) && tree.view.isContainer(index))
    sel.clearRange(index, index);

  if (buttons.id == "editButtons") {
    var pub = document.getElementById("publishButton");
    var ed = document.getElementById("editButton");

    if (sel.count == 0)
      buttons.setAttribute("disabled", true);
    else if (sel.count == 1) {
      buttons.setAttribute("disabled", false);

      index = sel.currentIndex;
      tc = tree.view.getItemAtIndex(index);

      if (!sel.isSelected(index)) {
        for (x = 0; x < tree.view.rowCount; x++) {
          if (sel.isSelected(x)) {
            tc = tree.view.getItemAtIndex(x);
            break;
          }
        }
      }

      var mapping = tc.id.substring(3)

      if (mapping in _mgMS.actTemp[wType]) {
        if (!_mgMS.actTemp[wType][mapping].type || _mgMS.actTemp[wType][mapping].type != 1)
          pub.setAttribute("disabled", true);
      }
    }
    else if (sel.count > 1) {
      buttons.setAttribute("disabled", false);
      pub.setAttribute("disabled", true);
      ed.setAttribute("disabled", true);
    }

    return;
  }

  if (sel.count > 0)
    buttons.setAttribute("disabled", false);
}

var mgMappingsObserver = {
  observe: function(subject, topic, data) {
    if (topic == "mozgestControl" && data == "tempMappingsUpdated") {
      exportButton.disabled = true;
      sortTree(sortBy, sortOrder);
      showMappingsFor(wType);
    }

    if (topic == "mozgestControl" && data == "mappingsUpdated") {
      exportButton.disabled = false;
      initMappingsWindow(true);
      showMappingsFor(wType);
    }
  }
}

function mgAddObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .addObserver(mgMappingsObserver, "mozgestControl", false);
}

function mgRemoveObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .removeObserver(mgMappingsObserver, "mozgestControl");
}