var sbMappings, sortOrder, mapArray;
var activeElt = null;
var canvasEnabled = true;
var tooltipEnabled = true;
var scrollX = {};
scrollX.value = 0;
var scrollY = {};
scrollY.value = 0;

function initSidebar() {
  mgComponentLoader.initMouseService(false);
  sbMappings = document.getElementById("sbMappings");
  document.getElementById(mgPrefs.prefs.getCharPref("sideBar.sort")).setAttribute("checked", true);
  tooltipEnabled = mgPrefs.prefs.getBoolPref("sideBar.toolTip");

  try {
    scrollY.value = sbMappings.getAttribute("mgScrollTop");
    setScrollPos();
  }
  catch (e) {}
  addEventListener("scroll", getScrollPos, true);
}

function addObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .addObserver(mgSidebarObserver, "mozgestControl", false);

  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
         .addObserver("", mgSidebarObserver, false);
}

function removeObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .removeObserver(mgSidebarObserver, "mozgestControl");

  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
         .removeObserver("", mgSidebarObserver);
}

var mgSidebarObserver = {
  observe: function(subject, topic, data) {
    if (topic == "mozgestControl") {
      if (data == "mappingsUpdated")
        document.location.reload();
    }

    if (topic.indexOf("nsPref") == 0) {
      if (data == "enableStrokes" ||
          data == "enableRockers" ||
          data == "enableWheelRockers" ||
          data == "sideBar.canvas")
        setTimeout("document.location.reload()", 0);

      if (data == "sideBar.toolTip")
        tooltipEnabled = mgPrefs.prefs.getBoolPref("sideBar.toolTip");
    }
  }
}

function reloadDoc(aID) {
  mgPrefs.prefs.setCharPref("sideBar.sort", aID)
  document.location.reload(0)
}

function fillIn() {
  var canvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
  try {
    canvas.getContext("2d");
    canvasEnabled = mgPrefs.prefs.getBoolPref("sideBar.canvas");
  }
  catch (e) {
    canvasEnabled = false;
  }

  prepareInject("window");

  for (component in _mgMS.supportedWindows)
    prepareInject(component);

  setTimeout("initSidebar()", 0);
}

function prepareInject(component) {
  var  mappingsSet = _mgMS.activeMappings[component];
  mapArray = new Array();

  for (var x = 1; x < 7; x++)
    mapArray[x] = new Array();

  mapArray[99] = new Array();

  var mapCount = 0;

  for (mapping in mappingsSet) {
    mapCount += 1;
    var mName = null;
    var mCount = null;
    var mCat = 0;

    if (mappingsSet[mapping].name)
      mName = decodeURIComponent(mappingsSet[mapping].name);
    else
      mName = mgGetString(mappingsSet[mapping].func);

    if (mappingsSet[mapping].count)
      mCount = mappingsSet[mapping].count;
    else
      mCount = 0;

    mCat = mappingsSet[mapping].cat;

    if (mCat == 0)
      mCat = 99;

    mapArray[mCat][mapArray[mCat].length] = { component : component,
                                              code : mapping,
                                              name : mName,
                                              count : mCount,
                                              cat : ((mCat == 99) ? 0 : mCat) };
  }

  if (mapCount < 1)
    return;

  for (cat in mapArray) {
    if (mgPrefs.prefs.getCharPref("sideBar.sort") == "sortByName") {
      mapArray[cat].sort(function(a, b) {return ((a.name.toLowerCase())>(b.name.toLowerCase()) ? 1 : -1)});
      sortOrder = "sortByName";
    }
    else {
      mapArray[cat].sort(function(a, b) {return ((a.count)>(b.count) ? 1 : -1)});
      sortOrder = "sortByUsage";
    }
  }

  inject(document.documentElement.getAttribute(component), component);
}

function inject(wType, component) {
  var counts = new Array();
  var gLength = 0;

  for (cat in mapArray) {
    counts = mapArray[cat];

    if (counts.length > 0) {
      for (var n = 0; n < counts.length; n++) {
        if (counts[n].code.indexOf(":") == 0) {
          var isWheel = isNaN(counts[n].code.substring(1));

          if ((isWheel && !mgPrefs.prefs.getBoolPref("enableWheelRockers")) ||
              (!isWheel && !mgPrefs.prefs.getBoolPref("enableRockers")))
            continue;
        }
        else if (!mgPrefs.prefs.getBoolPref("enableStrokes"))
          continue;

        gLength++;
      }
    }
  }

  if (gLength == 0)
    return;

  var rowEven = false;
  var mC = document.getElementById("sbMappings")

  //the header and container of the window type
  var cBox = document.createElement("vbox");
  cBox.style.paddingBottom = "15px";
  cBox.mgWindowType = component;
  var tb = document.createElement("tabbox");
  var tabs = document.createElement("tabs");
  var tab = document.createElement("tab");
  tab.setAttribute("label", wType);
  tab.setAttribute("flex", "1");
  tab.setAttribute("crop", "end");
  tabs.appendChild(tab);
  tb.appendChild(tabs);
  var tps = document.createElement("tabpanels");
  var tp = document.createElement("tabpanel");
  tp.setAttribute("orient", "vertical");
  tps.appendChild(tp);
  tb.appendChild(tps);
  cBox.appendChild(tb)
  mC.appendChild(cBox);

  //rL is the window box
  var rL = document.createElement("richlistbox");
  rL.mgWindowType = component;
  tp.appendChild(rL);

  for (cat in mapArray) {
    counts = mapArray[cat];

    for (var x=0; x < counts.length; x++) {
      if (counts[x].code.indexOf(":") == 0) {
        var isWheel = isNaN(counts[x].code.substring(1));

        if ((isWheel && !mgPrefs.prefs.getBoolPref("enableWheelRockers")) ||
            (!isWheel && !mgPrefs.prefs.getBoolPref("enableRockers")))
          continue;
      }
      else if (!mgPrefs.prefs.getBoolPref("enableStrokes"))
        continue;

      rowEven = !rowEven;

      //rI is the row within rL
      var rI = document.createElement("richlistitem");

      rI.mgWindowType = counts[x].component;
      rI.mgCode = counts[x].code;
      rI.mgTooltip = true;
      rI.mgCat = counts[x].cat;

      var catID = "mgCat_" + counts[x].component + "_" + counts[x].cat;

      if (!document.getElementById(catID)) {
        var newCat = document.createElement("checkbox");
        newCat.mgWindowType = counts[x].component;
        newCat.mgCat = rI.mgCat;
        newCat.id = catID;
        newCat.setAttribute("mgCategory", true);
        newCat.setAttribute("crop", "end");
        var lbl = document.documentElement.getAttribute("cat" + counts[x].cat);
        newCat.setAttribute("label", lbl);
        rowEven = false;
        rL.appendChild(newCat);

        try {
          newCat.labelElement.value = lbl;
        }
        catch (e) {}
      }

      rI.setAttribute("mgRowClass", (rowEven ? 'even' : 'odd'));

      var state = true;
      try {
        state = mgPrefs.prefs.getBoolPref("sideBar." + catID);
      }
      catch (e) {}

      rI.hidden = !state;
      newCat = document.getElementById(catID)
      newCat.checked = state;
      newCat.addEventListener("CheckboxStateChange", toggleCat, true);

      //rIH is the hbox of rI
      var rIH = document.createElement("hbox");
      rIH.setAttribute("flex", "1");
      rIH.setAttribute("align", "center");
      var rIHLabel = document.createElement("label");
      rIHLabel.setAttribute("flex", "1");
      rIHLabel.setAttribute("crop", "end");
      rIHLabel.setAttribute("value", counts[x].name);
      rIH.appendChild(rIHLabel);
      var rIHSpacer = document.createElement("spacer");
      rIHSpacer.setAttribute("flex", "1");
      rIH.appendChild(rIHSpacer);

      var gBox = document.createElement("hbox");
      gBox.setAttribute("tooltip", "mgSidebarToolTip");

      if (!canvasEnabled) {
        var label = document.createElement("label");
        label.setAttribute("value", mgMappingLocalizer.localize(counts[x].code));
        gBox.appendChild(label);
        rIH.appendChild(gBox)
        rI.appendChild(rIH);
        rL.appendChild(rI);
      }
      else {
        var canvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
        canvas.setAttribute("width", "32");
        canvas.setAttribute("height", "32");
        gBox.setAttribute("mgGestBox", "true");
        gBox.appendChild(canvas);
        rIH.appendChild(gBox)
        rI.appendChild(rIH);
        rL.appendChild(rI);
        draw(canvas, counts[x].code);
        canvas.style.height="32px";
        canvas.style.width="32px";
      }
    }
  }
}

function toggleCat(e) {
  var elt = e.target;
  mgPrefs.prefs.setBoolPref("sideBar." + elt.id, elt.checked);

  var x = document.getElementsByAttribute("mgRowClass", "*");

  for (var y = 0;y < x.length; y++) {
    if (x[y].mgWindowType == elt.mgWindowType && x[y].mgCat == elt.mgCat)
      x[y].hidden = !elt.checked;
  }
}

function setScrollPos() {
  var sI = sbMappings.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
  sI.scrollTo(0, scrollY.value);
}

function getScrollPos() {
  var sB = sbMappings.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
  sB.getPosition(scrollX, scrollY);
  sbMappings.setAttribute("mgScrollTop", scrollY.value)
}

function mgFillToolTip() {
  if (!tooltipEnabled)
    return false;

  var mgTNode = document.tooltipNode;
  var mgT2 = document.getElementById("mgToolTipLabel_2");
  var mgT4 = document.getElementById("mgToolTipLabel_4");

  var showToolTip = false;

  try {
    for (mgTNode; mgTNode; mgTNode = mgTNode.parentNode) {
      if (mgTNode.mgTooltip) {
        mgT2.value = mgMappingLocalizer.localize(mgTNode.mgCode);
        mgT4.value = _mgMS.activeMappings[mgTNode.mgWindowType][mgTNode.mgCode].count;

        showToolTip = true;
        break;
      }
      if (mgTNode == document)
        break;
    }
    return showToolTip;
  }
  catch (e) {return false}
}

function mgShowContext(e) {
  document.getElementById('mgEditThisGesture').hidden = true;
  window.mgWindowType = "window";
  var mgTNode = document.popupNode;

  for (mgTNode; mgTNode; mgTNode = mgTNode.parentNode) {
    if (mgTNode.mgWindowType) {
      window.mgWindowType = mgTNode.mgWindowType;
      break;
    }
    if (mgTNode == document)
      break;
  }

  mgTNode = document.popupNode;

  for (mgTNode; mgTNode; mgTNode = mgTNode.parentNode) {
    if (mgTNode.mgCode) {
      window.mgCode = mgTNode.mgCode;
      document.getElementById('mgEditThisGesture').hidden = false;
      break;
    }
    if (mgTNode == document)
      break;
  }
}